/*
 * Decompiled with CFR 0.152.
 */
package org.makagiga.console;

import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.StyledEditorKit;
import org.makagiga.commons.MAction;
import org.makagiga.commons.MActionInfo;
import org.makagiga.commons.MEditorPane;
import org.makagiga.commons.MLogger;
import org.makagiga.commons.MMenu;
import org.makagiga.commons.MText;
import org.makagiga.commons.UI;
import org.makagiga.console.Console;

final class ConsoleOutput
extends MEditorPane {
    ConsoleOutput() {
        this.setEditorKit(new StyledEditorKit());
        MText.uninstallUndoManager(this);
        this.setEditable(false);
        MText.setUserMenu(this, new MText.UserMenu<ConsoleOutput>(){

            @Override
            public void onUserMenu(ConsoleOutput consoleOutput, MMenu mMenu) {
                Console console = UI.getAncestorOfClass(Console.class, ConsoleOutput.this);
                if (console == null || console.getCommand("clear") == null) {
                    return;
                }
                mMenu.addTitle(UI._("Console"));
                MAction mAction = new MAction(MActionInfo.CLEAR_HISTORY){

                    @Override
                    public void onAction() {
                        Console console = UI.getAncestorOfClass(Console.class, ConsoleOutput.this);
                        if (console != null) {
                            console.executeCommand("clear", true);
                        }
                    }
                };
                mAction.setHTMLHelp(UI._("Clear the output history."));
                mMenu.add(mAction);
            }
        });
        MText.disableCaretUpdate(this);
    }

    void append(AttributeSet attributeSet, String string) {
        Document document = this.getDocument();
        try {
            if (document != null) {
                document.insertString(document.getLength(), string, attributeSet);
            }
        }
        catch (BadLocationException badLocationException) {
            MLogger.exception(badLocationException);
        }
    }

    void scrollToEnd() {
        this.setCaretPosition(this.getDocument().getLength());
    }
}

