/*
 * Decompiled with CFR 0.152.
 */
package org.makagiga.console;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import org.makagiga.commons.CommandOptions;
import org.makagiga.commons.Config;
import org.makagiga.commons.FS;
import org.makagiga.commons.HistoryManager;
import org.makagiga.commons.MAction;
import org.makagiga.commons.MDisposable;
import org.makagiga.commons.MLogger;
import org.makagiga.commons.MText;
import org.makagiga.commons.MTextField;
import org.makagiga.commons.TK;
import org.makagiga.console.Console;
import org.makagiga.console.ConsoleCommand;

final class HistoryCommand
extends ConsoleCommand
implements MDisposable {
    private boolean firstRun = true;
    private HistoryManager<String> historyManager;
    private int modCount;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object onCommand(Console console, String ... stringArray) {
        Console.IO iO = console.getIO();
        CommandOptions commandOptions = this.getCommandOptions();
        if (commandOptions.isEmpty()) {
            this.printHistory(console, iO, null);
            if (this.firstRun) {
                this.firstRun = false;
                HistoryCommand historyCommand = this;
                synchronized (historyCommand) {
                    if (!this.historyManager.isEmpty()) {
                        iO.printLine();
                    }
                }
                iO.printLine("Type \"history -h\" to show available options");
            }
            return null;
        }
        if (commandOptions.isSet("c") || commandOptions.isSet("clear")) {
            this.clearHistory();
        } else if (commandOptions.isSet("h") || commandOptions.isSet("help")) {
            iO.printLine("Usage: history [option|search query]");
            iO.printLine();
            iO.printLine("Options:");
            iO.print(commandOptions.toString());
            iO.printLine();
            iO.printLine("Examples:");
            iO.printLine("    Clear history: history -c");
            iO.printLine("  Disable history: h --off");
            iO.printLine("  Search for \"UI\": history UI");
            iO.printLine("        Set limit: h -limit 100");
        } else if (commandOptions.isSet("limit")) {
            this.initHistory();
            String string = commandOptions.getOption("limit");
            if (string == null) {
                HistoryCommand historyCommand = this;
                synchronized (historyCommand) {
                    iO.printLine("Current history limit: " + this.historyManager.getLimit());
                }
            }
            try {
                int n = Integer.parseInt(string);
                this.setHistoryLimit(n);
                if (n == -1) {
                    iO.printLine("Warning: Unlimited history may slow down the history system.");
                }
            }
            catch (RuntimeException runtimeException) {
                iO.printError(runtimeException.getLocalizedMessage());
            }
        } else if (commandOptions.isSet("off")) {
            this.setHistoryEnabled(false);
        } else if (commandOptions.isSet("on")) {
            this.setHistoryEnabled(true);
        } else if (!commandOptions.isEmpty()) {
            this.printHistory(console, iO, commandOptions.getRaw(0));
        }
        return null;
    }

    @Override
    public Object dispose(Object ... objectArray) {
        this.saveHistory();
        return null;
    }

    @Override
    protected CommandOptions createCommandOptions() {
        CommandOptions commandOptions = new CommandOptions();
        commandOptions.setErrorMode(CommandOptions.ErrorMode.WARNING);
        commandOptions.registerOption("c", "clear", "Clear history");
        commandOptions.registerOption("h", "help", "Show this help");
        commandOptions.registerOption(null, "limit", "Show or set the maximum number of commands stored in history (-1 - unlimited)");
        commandOptions.registerOption(null, "off", "Disable history");
        commandOptions.registerOption(null, "on", "Enable history");
        return commandOptions;
    }

    private File getHistoryFile() {
        return FS.makeConfigFile("console.history");
    }

    private void setHistoryEnabled(boolean bl) {
        Config config = Config.getDefault();
        config.write(this.getGlobalEntry("enabled"), bl);
        config.sync();
    }

    private synchronized void setHistoryLimit(int n) {
        this.historyManager.setLimit(n);
        Config config = Config.getDefault();
        config.write(this.getGlobalEntry("limit"), n);
        config.sync();
    }

    private void printHistory(Console console, Console.IO iO, String string) {
        this.initHistory();
        int n = 0;
        for (String string2 : this.historyManager) {
            if (string != null && !TK.containsIgnoreCase(string2, string)) continue;
            iO.printLine(console.getRowAttr(n++), string2);
        }
    }

    private synchronized void showHistory(MTextField mTextField, boolean bl) {
        if (!this.isHistoryEnabled()) {
            return;
        }
        this.initHistory();
        if (this.historyManager.isEmpty()) {
            return;
        }
        String string = null;
        if (bl) {
            if (mTextField.isEmpty()) {
                string = this.historyManager.getCurrent();
            } else if (this.historyManager.canBack()) {
                string = this.historyManager.back();
            }
        } else {
            string = this.historyManager.canForward() ? this.historyManager.forward() : "";
        }
        if (string != null) {
            MText.setText(mTextField, string);
        }
    }

    HistoryCommand() {
        super("history", "Show and manage command history");
        this.addAliasName("h");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addHistory(String string) {
        if (TK.isEmpty(string)) {
            return;
        }
        if (!this.isHistoryEnabled()) {
            return;
        }
        this.initHistory();
        HistoryCommand historyCommand = this;
        synchronized (historyCommand) {
            if (this.historyManager.add(string)) {
                ++this.modCount;
                if (this.modCount % 5 == 0) {
                    this.saveHistory();
                }
            }
        }
    }

    synchronized void clearHistory() {
        File file;
        if (this.historyManager != null) {
            this.historyManager.clear();
            this.historyManager = null;
            this.modCount = 0;
        }
        if (!(file = this.getHistoryFile()).delete()) {
            MLogger.error("core", "Could not delete history file: %s", file);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized void initHistory() {
        if (this.historyManager == null) {
            this.historyManager = new HistoryManager();
            Config config = Config.getDefault();
            this.historyManager.setLimit(config.readInt(this.getGlobalEntry("limit"), 1000, 1));
            this.modCount = 0;
            FS.TextReader textReader = null;
            try {
                textReader = FS.getUTF8Reader(this.getHistoryFile());
                this.historyManager.read(textReader);
            }
            catch (FileNotFoundException fileNotFoundException) {
            }
            catch (IOException iOException) {
                MLogger.exception(iOException);
            }
            finally {
                FS.close(textReader);
            }
        }
    }

    void installKeyboardHandler(final MTextField mTextField) {
        mTextField.getAutoCompletion().setShowPopupOnUpDownKeyPress(false);
        new MAction("Console.VK_UP"){

            @Override
            public void onAction() {
                HistoryCommand.this.showHistory(mTextField, true);
            }
        }.connect(mTextField, 0, 38);
        new MAction("Console.VK_DOWN"){

            @Override
            public void onAction() {
                HistoryCommand.this.showHistory(mTextField, false);
            }
        }.connect(mTextField, 0, 40);
    }

    boolean isHistoryEnabled() {
        Config config = Config.getDefault();
        return config.read(this.getGlobalEntry("enabled"), true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized void saveHistory() {
        if (this.modCount == 0) {
            return;
        }
        FS.TextWriter textWriter = null;
        try {
            textWriter = FS.getUTF8Writer(this.getHistoryFile());
            for (String string : this.historyManager) {
                textWriter.println(string);
            }
        }
        catch (IOException iOException) {
            MLogger.exception(iOException);
        }
        finally {
            FS.close(textWriter);
        }
    }
}

