/*
 * Decompiled with CFR 0.152.
 */
package org.makagiga.db;

import java.awt.Window;
import java.lang.ref.WeakReference;
import javax.swing.JComponent;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.AbstractTableModel;
import org.makagiga.commons.AbstractListTableModel;
import org.makagiga.commons.ActionGroup;
import org.makagiga.commons.Config;
import org.makagiga.commons.MAction;
import org.makagiga.commons.MActionInfo;
import org.makagiga.commons.MPanel;
import org.makagiga.commons.TK;
import org.makagiga.commons.UI;
import org.makagiga.commons.WTFError;
import org.makagiga.db.DBNavigationActionGroup;
import org.makagiga.db.DBRecord;
import org.makagiga.db.DBRecordPanel;
import org.makagiga.db.DBTable;
import org.makagiga.db.DBTableModel;

public class DBView<M extends DBTableModel>
extends MPanel {
    private final ActionGroup actionGroup;
    private final DBNavigationActionGroup navigationActionGroup;
    private M model;
    private final ModelView<M> modelView;
    private final StaticHandler<M> staticHandler = new StaticHandler(this);
    private final Type type;

    public DBView(Type type) {
        this.actionGroup = this.createActionGroup();
        this.navigationActionGroup = new DBNavigationActionGroup(this);
        this.type = TK.checkNull(type, "type");
        this.modelView = this.createModelView();
        this.addCenter((JComponent)((Object)this.modelView));
    }

    public ActionGroup getActionGroup() {
        return this.actionGroup;
    }

    public DBNavigationActionGroup getNavigationActionGroup() {
        return this.navigationActionGroup;
    }

    public void updateView(boolean bl) {
        ((AbstractListTableModel)this.model).setLocked(bl);
        boolean bl2 = this.modelView.getCurrentRecord() != null;
        this.actionGroup.setEnabled("add-record", !bl);
        this.actionGroup.setEnabled("delete-record", !bl && bl2);
        this.actionGroup.setEnabled("edit-record", !bl && bl2);
        this.navigationActionGroup.update();
    }

    public ModelView<M> getModelView() {
        return this.modelView;
    }

    @Deprecated
    public DBTable<M> getTableView() {
        if (this.modelView instanceof DBTable) {
            return (DBTable)this.modelView;
        }
        return null;
    }

    public Type getType() {
        return this.type;
    }

    public M getModel() {
        return this.model;
    }

    public void setModel(M m) {
        TableModelListener[] tableModelListenerArray;
        if (this.model != null) {
            ((AbstractTableModel)this.model).removeTableModelListener(this.staticHandler);
        }
        this.model = m;
        this.modelView.setModel(this.model, null);
        for (TableModelListener tableModelListener : tableModelListenerArray = ((AbstractTableModel)m).getTableModelListeners()) {
            ((AbstractTableModel)m).removeTableModelListener(tableModelListener);
        }
        ((AbstractTableModel)m).addTableModelListener(this.staticHandler);
        for (TableModelListener tableModelListener : tableModelListenerArray) {
            ((AbstractTableModel)m).addTableModelListener(tableModelListener);
        }
    }

    public void setValueAt(Object object, int n) {
        ((DBTableModel)this.getModel()).setValueAt(object, this.getModelView().getCurrentRecord().modelIndex, n);
    }

    protected ActionGroup createActionGroup() {
        ActionGroup actionGroup = new ActionGroup();
        actionGroup.add("add-record", new MAction(UI._("Add..."), "ui/plus", 155){

            @Override
            public void onAction() {
                DBView.this.addRecord(this.getSourceWindow());
            }
        }).setShowTextInToolBar(true);
        actionGroup.add("edit-record", new MAction(UI._("Edit..."), "ui/text", 10){

            @Override
            public void onAction() {
                DBView.this.model.editRecordUI(this.getSourceWindow(), DBView.this.modelView.getCurrentRecord());
            }
        });
        actionGroup.addSeparator();
        actionGroup.add("delete-record", new MAction(MActionInfo.DELETE){

            @Override
            public void onAction() {
                DBView.this.deleteRecord(this.getSourceWindow());
            }
        });
        return actionGroup;
    }

    protected ModelView<M> createModelView() {
        switch (this.type) {
            case PANEL: {
                return new DBRecordPanel();
            }
            case TABLE: {
                return this.createTableView();
            }
        }
        throw new WTFError(this.type);
    }

    @Deprecated
    protected DBTable<M> createTableView() {
        DBTable dBTable = new DBTable();
        dBTable.getSelectionModel().addListSelectionListener(this.staticHandler);
        this.actionGroup.installPopupMenu(dBTable);
        this.actionGroup.connect("edit-record", dBTable, 0);
        return dBTable;
    }

    private void addRecord(Window window) {
        DBTable dBTable;
        int n;
        if (((DBTableModel)this.model).addRecordUI(window) && this.modelView instanceof DBTable && (n = (dBTable = (DBTable)this.modelView).getRowCount()) > 0) {
            dBTable.selectRow(n - 1);
        }
    }

    private void deleteRecord(Window window) {
        DBRecord dBRecord = this.modelView.getCurrentRecord();
        if (((DBTableModel)this.model).deleteRecordUI(window, dBRecord) && this.modelView instanceof DBTable) {
            DBTable dBTable = (DBTable)this.modelView;
        }
    }

    static String getColumnDisplayName(String string) {
        boolean bl = false;
        StringBuilder stringBuilder = new StringBuilder();
        int n = string.length();
        for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            if (stringBuilder.length() == 0) {
                stringBuilder.append(Character.toUpperCase(c));
                continue;
            }
            if (c == '_') {
                stringBuilder.append(' ');
                bl = true;
                continue;
            }
            if (bl) {
                stringBuilder.append(Character.toUpperCase(c));
            } else {
                stringBuilder.append(Character.toLowerCase(c));
            }
            bl = false;
        }
        return stringBuilder.toString();
    }

    private static final class StaticHandler<M extends DBTableModel>
    implements ListSelectionListener,
    TableModelListener {
        private final WeakReference<DBView<M>> viewRef;

        @Override
        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            DBView dBView = (DBView)this.viewRef.get();
            dBView.updateView(dBView.model.isLocked());
        }

        @Override
        public void tableChanged(TableModelEvent tableModelEvent) {
            if (tableModelEvent.getFirstRow() == -1) {
                DBView dBView = (DBView)this.viewRef.get();
                switch (dBView.getType()) {
                    case PANEL: {
                        DBRecordPanel dBRecordPanel = (DBRecordPanel)dBView.getModelView();
                        Object m = dBView.getModel();
                        DBRecord dBRecord = ((AbstractListTableModel)m).isEmpty() ? null : (DBRecord)((AbstractListTableModel)dBView.getModel()).getRowAt(0);
                        dBRecordPanel.setModel(dBView.getModel(), dBRecord);
                        dBRecordPanel.alignLabels();
                        break;
                    }
                    case TABLE: {
                        DBTable dBTable = (DBTable)dBView.getModelView();
                        dBTable.getColumnManager().update();
                        break;
                    }
                    default: {
                        throw new WTFError(dBView.getType());
                    }
                }
            }
        }

        private StaticHandler(DBView<M> dBView) {
            this.viewRef = TK.newWeakRef(dBView);
        }
    }

    public static interface ModelView<M extends DBTableModel> {
        public DBRecord getCurrentRecord();

        public M getModel();

        public void setModel(M var1, DBRecord var2);

        public void readConfig(Config var1, Config var2, Config.GlobalEntry var3);

        public void writeConfig(Config var1, Config var2, Config.GlobalEntry var3);
    }

    public static enum Type {
        TABLE,
        PANEL;

    }
}

