/*
 * Decompiled with CFR 0.152.
 */
package org.makagiga.desktop.ui;

import java.awt.Color;
import java.awt.Composite;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentListener;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JInternalFrame;
import javax.swing.JMenu;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import javax.swing.plaf.basic.BasicInternalFrameTitlePane;
import javax.swing.plaf.basic.BasicInternalFrameUI;
import org.makagiga.commons.MActionInfo;
import org.makagiga.commons.MColor;
import org.makagiga.commons.MIcon;
import org.makagiga.commons.MInternalFrame;
import org.makagiga.commons.MMouseAdapter;
import org.makagiga.commons.MSmallButton;
import org.makagiga.commons.TK;
import org.makagiga.commons.UI;
import org.makagiga.commons.painters.Painter;
import org.makagiga.desktop.Pager;
import org.makagiga.desktop.Widget;
import org.makagiga.desktop.WidgetInternalFrame;
import org.makagiga.desktop.ui.WidgetDesktopPaneUI;

public final class WidgetInternalFrameUI
extends BasicInternalFrameUI {
    public static final int ICON_SIZE = 16;
    private Title title;

    public WidgetInternalFrameUI(JInternalFrame jInternalFrame) {
        super(jInternalFrame);
        jInternalFrame.setComponentPopupMenu(null);
        jInternalFrame.setOpaque(false);
    }

    @Override
    public void installUI(JComponent jComponent) {
        super.installUI(jComponent);
        if (this.isShaped(jComponent)) {
            jComponent.setOpaque(false);
        }
    }

    @Override
    protected ComponentListener createComponentListener() {
        return new ComponentAdapter(){};
    }

    @Override
    protected JComponent createNorthPane(JInternalFrame jInternalFrame) {
        if (this.isShaped(jInternalFrame)) {
            return null;
        }
        this.title = new Title(jInternalFrame);
        return this.title;
    }

    @Override
    protected void installDefaults() {
        UIManager.put("InternalFrame.border", UI.createEmptyBorder(5));
        super.installDefaults();
        if (this.isShaped(this.frame)) {
            Border border = null;
            if (this.isDropShadowSupported(this.frame) && (border = WidgetDesktopPaneUI.createBorder()) instanceof CompoundBorder) {
                border = ((CompoundBorder)CompoundBorder.class.cast(border)).getOutsideBorder();
            }
            if (border == null) {
                border = BorderFactory.createEmptyBorder();
            }
            this.frame.setBorder(border);
        } else {
            this.frame.setBorder(WidgetDesktopPaneUI.createBorder());
        }
    }

    @Override
    protected void uninstallDefaults() {
        super.uninstallDefaults();
        this.frame.setBorder(null);
    }

    private boolean isDropShadowSupported(JComponent jComponent) {
        if (jComponent instanceof WidgetInternalFrame) {
            Widget widget = ((WidgetInternalFrame)WidgetInternalFrame.class.cast(jComponent)).getWidget();
            return widget != null && widget.isDropShadowSupported();
        }
        return false;
    }

    private boolean isShaped(JComponent jComponent) {
        if (!(jComponent instanceof MInternalFrame)) {
            return false;
        }
        return ((MInternalFrame)MInternalFrame.class.cast(jComponent)).isShaped();
    }

    void flushPainterCache() {
        if (this.title != null) {
            this.title.activePainter = null;
            this.title.inactivePainter = null;
        }
    }

    private static final class Title
    extends BasicInternalFrameTitlePane {
        private boolean textPaint;
        private MMouseAdapter mouseAdapter;
        private Painter activePainter;
        private Painter inactivePainter;
        private PropertyChangeListener pcl;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void paintComponent(Graphics graphics) {
            Graphics2D graphics2D = (Graphics2D)graphics;
            this.paintTitleBackground(graphics2D);
            try {
                Color color = this.selectedTextColor = (this.notSelectedTextColor = WidgetDesktopPaneUI.getDesktopForeground());
                Color color2 = this.notSelectedTextColor;
                this.notSelectedTextColor = MColor.deriveAlpha(MColor.isDark(color2) ? MColor.WHITE : MColor.GRAY, 128);
                this.selectedTextColor = MColor.deriveAlpha(MColor.isDark(color) ? MColor.WHITE : MColor.GRAY, 128);
                graphics2D.translate(1, 1);
                this.textPaint = true;
                RenderingHints renderingHints = new RenderingHints(null);
                UI.setTextAntialiasing(graphics2D, renderingHints);
                super.paintComponent(graphics2D);
                graphics2D.translate(-1, -1);
                this.notSelectedTextColor = color2;
                this.selectedTextColor = color;
                UI.setTextAntialiasing(graphics2D, null);
                super.paintComponent(graphics2D);
                graphics2D.setRenderingHints(renderingHints);
            }
            finally {
                this.textPaint = false;
            }
        }

        @Override
        protected void addSubComponents() {
            this.add(this.closeButton);
            this.add(this.iconButton);
            this.add(this.maxButton);
        }

        @Override
        protected void addSystemMenuItems(JMenu jMenu) {
            super.addSystemMenuItems(jMenu);
            jMenu.addSeparator();
            Pager pager = Pager.getInstance();
            jMenu.add(pager.createMoveToDesktopMenu((WidgetInternalFrame)this.frame));
        }

        @Override
        protected void createButtons() {
            this.closeButton = this.createButton(MActionInfo.CLOSE.getText(), MActionInfo.CLOSE.getIconName(), this.closeAction);
            this.iconButton = this.createButton(UI._("Minimize"), "ui/down", this.iconifyAction);
            this.maxButton = this.createButton(UI._("Maximize"), "ui/up", this.maximizeAction);
        }

        @Override
        protected void installListeners() {
            super.installListeners();
            this.mouseAdapter = new MMouseAdapter(){

                @Override
                public void popupTrigger(MouseEvent mouseEvent) {
                    ((WidgetInternalFrame)WidgetInternalFrame.class.cast(Title.this.frame)).showContextMenu(mouseEvent);
                }
            };
            this.addMouseListener(this.mouseAdapter);
            if (this.pcl == null) {
                this.pcl = new PropertyChangeListener(){

                    @Override
                    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                        if (propertyChangeEvent.getPropertyName().equals("closable")) {
                            Title.this.closeButton.setEnabled((Boolean)propertyChangeEvent.getNewValue());
                        } else if (propertyChangeEvent.getPropertyName().equals("iconable")) {
                            Title.this.iconButton.setEnabled((Boolean)propertyChangeEvent.getNewValue());
                        } else if (propertyChangeEvent.getPropertyName().equals("title")) {
                            Title.this.updateToolTipText(propertyChangeEvent.getNewValue());
                        }
                    }
                };
                this.frame.addPropertyChangeListener(this.pcl);
            }
        }

        @Override
        protected void uninstallListeners() {
            super.uninstallListeners();
            if (this.mouseAdapter != null) {
                this.removeMouseListener(this.mouseAdapter);
                this.mouseAdapter = null;
            }
            if (this.pcl != null) {
                this.frame.removePropertyChangeListener(this.pcl);
                this.pcl = null;
            }
        }

        @Override
        protected void paintTitleBackground(Graphics graphics) {
            if (this.textPaint) {
                return;
            }
            Graphics2D graphics2D = (Graphics2D)graphics;
            Composite composite = WidgetDesktopPaneUI.setComposite(graphics2D, this.frame.isSelected());
            if (this.frame.isSelected()) {
                if (this.activePainter == null) {
                    this.activePainter = WidgetDesktopPaneUI.createPainter(true);
                }
                this.activePainter.paint(this, graphics2D);
            } else {
                if (this.inactivePainter == null) {
                    this.inactivePainter = WidgetDesktopPaneUI.createPainter(false);
                }
                this.inactivePainter.paint(this, graphics2D);
            }
            Icon icon = this.frame.getFrameIcon();
            if (icon != null) {
                if (UI.isRTL(this)) {
                    icon.paintIcon(this, graphics, this.getWidth() - icon.getIconWidth() - 1, 1);
                } else {
                    icon.paintIcon(this, graphics, 1, 1);
                }
            }
            if (composite != null) {
                graphics2D.setComposite(composite);
            }
        }

        @Override
        protected void setButtonIcons() {
        }

        private Title(JInternalFrame jInternalFrame) {
            super(jInternalFrame);
            this.updateToolTipText(jInternalFrame.getTitle());
        }

        private JButton createButton(String string, String string2, ActionListener actionListener) {
            MSmallButton mSmallButton = new MSmallButton(MIcon.stock(string2, 16), string);
            mSmallButton.addActionListener(actionListener);
            mSmallButton.setFocusable(false);
            mSmallButton.setStyle("margin: 0; padding: 0");
            return mSmallButton;
        }

        private void updateToolTipText(Object object) {
            this.setToolTipText(object == null ? null : TK.centerSqueeze(object.toString()));
        }
    }
}

