/*
 * Decompiled with CFR 0.152.
 */
package org.makagiga.editors;

import org.makagiga.commons.MAction;
import org.makagiga.commons.MActionInfo;
import org.makagiga.commons.MStatusBar;
import org.makagiga.commons.UI;
import org.makagiga.editors.Editor;

public final class Actions {
    private Actions() {
    }

    public static abstract class UnselectAll<E extends Editor<?>>
    extends Base<E> {
        public UnselectAll() {
            super(MActionInfo.UNSELECT_ALL);
            this.setHTMLHelp(UI._("Unselects all items in the active document."));
        }
    }

    public static abstract class SelectAll<E extends Editor<?>>
    extends Base<E> {
        public SelectAll() {
            super(MActionInfo.SELECT_ALL);
            this.setHTMLHelp(UI._("Selects all items in the active document."));
        }
    }

    public static abstract class Paste<E extends Editor<?>>
    extends Base<E> {
        public Paste() {
            super(MActionInfo.PASTE);
            this.setHTMLHelp(UI._("Pastes from the clipboard."));
        }

        public void showPasteError() {
            MStatusBar.error(UI._("Paste failed"));
        }
    }

    public static abstract class Cut<E extends Editor<?>>
    extends Base<E> {
        public Cut() {
            super(MActionInfo.CUT);
            this.setHTMLHelp(UI._("Copies to the clipboard and deletes it from the document."));
        }

        public void showCutError() {
            MStatusBar.error(UI._("Cut failed"));
        }
    }

    public static abstract class Copy<E extends Editor<?>>
    extends Base<E> {
        public Copy() {
            super(MActionInfo.COPY);
            this.setHTMLHelp(UI._("Copies to the clipboard."));
        }

        public void showCopyError() {
            MStatusBar.error(UI._("Copy failed"));
        }
    }

    public static abstract class Clear<E extends Editor<?>>
    extends Base<E> {
        public Clear() {
            super(MActionInfo.CLEAR);
            this.setHTMLHelp(UI._("Deletes all data from the document."));
        }
    }

    public static abstract class Base<E extends Editor<?>>
    extends MAction {
        public Base(MActionInfo mActionInfo) {
            super(mActionInfo);
            this.setEnabled(false);
        }

        public Base(String string, String string2, int n, int n2) {
            super(string, string2, n, n2);
            this.setEnabled(false);
        }

        public Base(String string, String string2) {
            this(string, string2, 0, 0);
        }

        public Base(String string, int n, int n2) {
            this(string, (String)null, n, n2);
        }

        public Base(String string, String string2, int n) {
            this(string, string2, n, 0);
        }

        public Base(String string) {
            this(string, (String)null, 0, 0);
        }

        @Override
        public void onAction() {
            if (!this.isEnabled()) {
                return;
            }
            Editor<?> editor = Editor.getCurrentEditor();
            if (editor != null) {
                this.onAction(editor);
            }
        }

        public abstract void onAction(E var1);
    }
}

