/*
 * Decompiled with CFR 0.152.
 */
package org.makagiga.editors;

import java.applet.Applet;
import java.awt.Dimension;
import java.net.URL;
import javax.swing.JComponent;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.makagiga.MainWindow;
import org.makagiga.Tabs;
import org.makagiga.commons.FS;
import org.makagiga.commons.Focusable;
import org.makagiga.commons.MFrame;
import org.makagiga.commons.TK;
import org.makagiga.commons.UI;
import org.makagiga.editors.Editor;
import org.makagiga.plugins.AppletPanel;
import org.makagiga.plugins.PluginInfo;

public class AppletTab
extends Editor<AppletPanel>
implements Focusable,
MFrame.FullScreenListener {
    private boolean initComplete;
    private boolean startStopOnTabChange;
    private ChangeListener changeListener;
    private final Dimension defaultSize;

    public AppletTab(PluginInfo pluginInfo, String[] stringArray, String string, Dimension dimension) throws Exception {
        this.setMetaInfo(pluginInfo.toString(), pluginInfo.getIcon());
        this.defaultSize = TK.checkNull(dimension, "defaultSize");
        URL[] uRLArray = new URL[stringArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            uRLArray[i] = new URL("jar:" + FS.toURL(stringArray[i]) + "!/");
        }
        this.setCore(new AppletPanel(uRLArray, pluginInfo.getConfig(), string));
        this.addCenter((JComponent)this.core);
        this.changeListener = new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                if (AppletTab.this.core != null) {
                    if (AppletTab.this.isCurrent()) {
                        if (AppletTab.this.startStopOnTabChange) {
                            ((AppletPanel)AppletTab.this.core).startApplet();
                        }
                    } else if (AppletTab.this.startStopOnTabChange) {
                        ((AppletPanel)AppletTab.this.core).stopApplet();
                    }
                }
            }
        };
        Tabs.getInstance().addChangeListener(this.changeListener);
        MainWindow.getInstance().addFullScreenListener(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addNotify() {
        super.addNotify();
        if (!this.initComplete) {
            this.initComplete = true;
            Applet applet = ((AppletPanel)this.core).getApplet();
            if (applet != null) {
                ((AppletPanel)this.core).setSize(this.defaultSize);
                applet.setSize(this.defaultSize);
            }
            try {
                UI.setWaitCursor(true);
                ((AppletPanel)this.core).initApplet();
                ((AppletPanel)this.core).startApplet();
            }
            finally {
                UI.setWaitCursor(false);
            }
        }
    }

    public boolean getStartStopOnTabChange() {
        return this.startStopOnTabChange;
    }

    public void setStartStopOnTabChange(boolean bl) {
        this.startStopOnTabChange = bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean onBeforeClose() {
        if (this.core != null) {
            try {
                UI.setWaitCursor(true);
                ((AppletPanel)this.core).shutDownApplet();
            }
            finally {
                UI.setWaitCursor(false);
            }
        }
        return true;
    }

    @Override
    public void onClose() {
        if (this.changeListener != null) {
            Tabs.getInstance().removeChangeListener(this.changeListener);
            this.changeListener = null;
        }
        MainWindow.getInstance().removeFullScreenListener(this);
    }

    @Override
    public void focus() {
    }

    @Override
    public boolean isFullScreenSupported(MFrame.FullScreenEvent fullScreenEvent) {
        return false;
    }

    @Override
    public void fullScreenChange(MFrame.FullScreenEvent fullScreenEvent) {
    }
}

