/*
 * Decompiled with CFR 0.152.
 */
package org.makagiga.editors;

import java.awt.LayoutManager;
import java.beans.PropertyChangeListener;
import java.lang.ref.WeakReference;
import java.util.List;
import javax.swing.Icon;
import org.makagiga.commons.Lockable;
import org.makagiga.commons.MArrayList;
import org.makagiga.commons.MMessage;
import org.makagiga.commons.MPanel;
import org.makagiga.commons.MSmallButton;
import org.makagiga.commons.MTogglePanel;
import org.makagiga.commons.Property;
import org.makagiga.commons.PropertyAccess;
import org.makagiga.form.PropertyPanel;

public abstract class Designer
extends MPanel
implements Lockable {
    private boolean locked;
    private List<WeakReference<PropertyPanel>> propertyPanels = new MArrayList<WeakReference<PropertyPanel>>();
    private String displayText;

    public Designer() {
        super(1);
    }

    public Designer(LayoutManager layoutManager) {
        super(layoutManager);
    }

    public MTogglePanel add(String string, PropertyPanel propertyPanel, String string2) {
        return this.add(string, null, propertyPanel, string2, true);
    }

    public MTogglePanel add(String string, PropertyPanel propertyPanel, String string2, boolean bl) {
        return this.add(string, null, propertyPanel, string2, bl);
    }

    public MTogglePanel add(String string, Icon icon, PropertyPanel propertyPanel, String string2, boolean bl) {
        MTogglePanel mTogglePanel = new MTogglePanel(string, icon, propertyPanel, string2, bl);
        MSmallButton mSmallButton = new MSmallButton(propertyPanel.createDefaultsAction(), false);
        mTogglePanel.getButton().addEast(mSmallButton);
        this.add(mTogglePanel);
        this.propertyPanels.add(new WeakReference<PropertyPanel>(propertyPanel));
        return mTogglePanel;
    }

    public String getDisplayText() {
        return this.displayText;
    }

    public void setDisplayText(String string) {
        this.displayText = string;
    }

    public List<PropertyPanel> getPropertyPanels() {
        MArrayList<PropertyPanel> mArrayList = new MArrayList<PropertyPanel>(this.propertyPanels.size());
        for (WeakReference<PropertyPanel> weakReference : this.propertyPanels) {
            PropertyPanel propertyPanel = (PropertyPanel)weakReference.get();
            if (propertyPanel == null) continue;
            mArrayList.add(propertyPanel);
        }
        return mArrayList;
    }

    @Override
    public boolean isLocked() {
        return this.locked;
    }

    @Override
    public void setLocked(boolean bl) {
        this.locked = bl;
        boolean bl2 = !this.locked;
        for (PropertyPanel propertyPanel : this.getPropertyPanels()) {
            propertyPanel.setAllEnabled(bl2);
        }
    }

    public void setPropertyChangeListener(Object object, PropertyChangeListener propertyChangeListener) {
        try {
            for (PropertyAccess<?> propertyAccess : Property.list(object).values()) {
                propertyAccess.addPropertyChangeListener(propertyChangeListener);
            }
        }
        catch (IllegalAccessException illegalAccessException) {
            MMessage.error(null, illegalAccessException);
        }
    }

    public void updateModel() {
        for (PropertyPanel propertyPanel : this.getPropertyPanels()) {
            propertyPanel.updateModel();
        }
    }

    public void updateView() {
        for (PropertyPanel propertyPanel : this.getPropertyPanels()) {
            propertyPanel.updateView();
        }
    }
}

