/*
 * Decompiled with CFR 0.152.
 */
package org.makagiga.editors.image;

import com.jhlabs.image.AverageFilter;
import com.jhlabs.image.BlockFilter;
import com.jhlabs.image.BumpFilter;
import com.jhlabs.image.ColorizeFilter;
import com.jhlabs.image.ContourFilter;
import com.jhlabs.image.ContrastFilter;
import com.jhlabs.image.CrystallizeFilter;
import com.jhlabs.image.DiffuseFilter;
import com.jhlabs.image.EdgeFilter;
import com.jhlabs.image.GammaFilter;
import com.jhlabs.image.GaussianFilter;
import com.jhlabs.image.GlowFilter;
import com.jhlabs.image.GrayscaleColorizeFilter;
import com.jhlabs.image.GrayscaleFilter;
import com.jhlabs.image.InvertFilter;
import com.jhlabs.image.MarbleFilter;
import com.jhlabs.image.OilFilter;
import com.jhlabs.image.PointillizeFilter;
import com.jhlabs.image.PosterizeFilter;
import com.jhlabs.image.QuantizeFilter;
import com.jhlabs.image.RaysFilter;
import com.jhlabs.image.ReduceNoiseFilter;
import com.jhlabs.image.ShadowFilter;
import com.jhlabs.image.SharpenFilter;
import com.jhlabs.image.SmartBlurFilter;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.BufferedImageOp;
import java.beans.IntrospectionException;
import java.util.Collection;
import java.util.EnumSet;
import javax.swing.AbstractButton;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import org.makagiga.commons.Config;
import org.makagiga.commons.Item;
import org.makagiga.commons.MActionInfo;
import org.makagiga.commons.MArrayList;
import org.makagiga.commons.MDialog;
import org.makagiga.commons.MDisposable;
import org.makagiga.commons.MIcon;
import org.makagiga.commons.MLabel;
import org.makagiga.commons.MList;
import org.makagiga.commons.MMessage;
import org.makagiga.commons.MPanel;
import org.makagiga.commons.MSearchPanel;
import org.makagiga.commons.MSlider;
import org.makagiga.commons.MSmallColorChooser;
import org.makagiga.commons.Property;
import org.makagiga.commons.PropertyAccess;
import org.makagiga.commons.Searchable;
import org.makagiga.commons.TK;
import org.makagiga.commons.UI;
import org.makagiga.commons.validator.ListSelectionValidator;
import org.makagiga.editors.image.ImageEditor;
import org.makagiga.editors.image.ImagePreviewPanel;
import org.makagiga.form.PropertyPanel;

public final class FilterDialog
extends MDialog {
    private boolean initDone;
    private BufferedImage originalImage;
    private ImageEditor editor;
    private ImagePreviewPanel imagePreviewPanel;
    private final MArrayList<Filter> allFilters = new MArrayList();
    private MList<Filter> filters;
    private PropertyPanel propertyPanel;

    public void addFilter(BufferedImageOp bufferedImageOp) {
        this.allFilters.add(new Filter(bufferedImageOp, (String[])null));
    }

    @Deprecated
    public void addFilter(BufferedImageOp bufferedImageOp, String string) {
        this.allFilters.add(new Filter(bufferedImageOp, string));
    }

    public void addFilterProperties(BufferedImageOp bufferedImageOp, String ... stringArray) {
        this.allFilters.add(new Filter(bufferedImageOp, stringArray));
    }

    public Image getFilteredImage() {
        return this.getFilter().filter(this.originalImage, null);
    }

    public MList<Filter> getFilters() {
        return this.filters;
    }

    @Deprecated
    public static Image show(ImageEditor imageEditor, BufferedImage bufferedImage) {
        FilterDialog filterDialog = new FilterDialog(imageEditor, bufferedImage);
        Image image = filterDialog.exec() ? filterDialog.getFilteredImage() : null;
        filterDialog.freeMemory();
        return image;
    }

    @Override
    protected void onClose() {
        Config config = Config.getDefault();
        config.write(this.editor.getGlobalEntry("Filters.last"), this.filters.getSelectedIndex());
        config.sync();
        this.initDone = false;
    }

    @Override
    protected void onUserClick() {
        if (this.propertyPanel != null) {
            this.propertyPanel.restoreDefaultValues();
            this.updatePreview();
        }
    }

    FilterDialog(ImageEditor imageEditor, BufferedImage bufferedImage) {
        super(imageEditor.getWindowAncestor(), UI._("Filters and Effects"), 15);
        this.editor = imageEditor;
        this.originalImage = bufferedImage;
        this.changeButton((AbstractButton)this.getUserButton(), MActionInfo.RESTORE_DEFAULT_VALUES);
        this.imagePreviewPanel = new ImagePreviewPanel();
        this.imagePreviewPanel.setOriginalImage(bufferedImage, 256, 256, false);
        this.addCenter(this.imagePreviewPanel);
        this.filters = new MList<Filter>(){

            @Override
            protected void onSelect() {
                if (!this.getValueIsAdjusting()) {
                    FilterDialog.this.updateControlPanel();
                }
            }
        };
        Filter filter = new Filter(null, "MMMMMMMMMMMMMMM");
        filter.setIcon(MIcon.stock("ui/ok"));
        this.filters.setCellRenderer(Filter.createListCellRenderer(), filter);
        this.filters.setSingleSelectionMode();
        this.addFilter(new AverageFilter());
        this.addFilterProperties(new BlockFilter(), "blockSize");
        this.addFilter(new BumpFilter());
        this.addFilterProperties(new ColorizeFilter(), "color");
        this.addFilter(new ContourFilter());
        this.addFilterProperties(new ContrastFilter(), "brightness", "contrast");
        this.addFilterProperties(new CrystallizeFilter(), "edgeThickness", "fadeEdges");
        this.addFilterProperties(new DiffuseFilter(), "scale");
        this.addFilter(new EdgeFilter());
        this.addFilterProperties(new GammaFilter(), "gamma");
        this.addFilterProperties(new GaussianFilter(), "radius");
        this.addFilterProperties(new GlowFilter(), "amount");
        this.addFilterProperties(new GrayscaleColorizeFilter(), "color");
        this.addFilter(new GrayscaleFilter());
        this.addFilter(new InvertFilter());
        this.addFilter(new MarbleFilter());
        this.addFilterProperties(new OilFilter(), "levels", "range");
        this.addFilterProperties(new PointillizeFilter(), "edgeThickness", "fadeEdges");
        this.addFilterProperties(new PosterizeFilter(), "numLevels");
        this.addFilterProperties(new QuantizeFilter(), "dither", "numColors", "serpentine");
        this.addFilter(new RaysFilter());
        this.addFilter(new ReduceNoiseFilter());
        this.addFilterProperties(new ShadowFilter(), "addMargins", "shadowOnly", "distance", "radius");
        this.addFilter(new SharpenFilter());
        this.addFilter(new SmartBlurFilter());
        this.allFilters.sort();
        this.filters.addAllItems((Collection<Filter>)this.allFilters);
        MPanel mPanel = MPanel.createVLabelPanel(this.filters, UI._("Filters:"));
        mPanel.addSouth(new MSearchPanel(false, MSearchPanel.Type.SEARCH){

            @Override
            protected void onChange(DocumentEvent documentEvent) {
                FilterDialog filterDialog = (FilterDialog)UI.windowFor(this);
                filterDialog.filters.filter(this, filterDialog.allFilters, new MList.SearchableFilter(this.getText()));
            }
        });
        this.addWest(mPanel);
        this.initDone = true;
        this.packFixed(UI.WindowSize.LARGE);
        int n = Config.getDefault().readInt(imageEditor.getGlobalEntry("Filters.last"), 0, this.filters);
        this.filters.setSelectedIndex(n, true);
        this.getValidatorSupport().add(new ListSelectionValidator(this.filters));
    }

    private BufferedImageOp getFilter() {
        Filter filter = this.filters.getSelectedItem();
        return filter == null ? null : (BufferedImageOp)filter.getValue();
    }

    private void updateControlPanel() {
        if (!this.initDone) {
            return;
        }
        Filter filter = this.filters.getSelectedItem();
        if (filter == null) {
            return;
        }
        PropertyPanel propertyPanel = this.propertyPanel;
        this.propertyPanel = filter.createPropertyPanel();
        UI.replaceComponent(this.getMainPanel(), propertyPanel, this.propertyPanel, "After", true);
        this.filters.setSelectedItem(filter, true);
        this.updatePreview();
        this.getUserButton().setEnabled(this.propertyPanel != null);
        if (this.propertyPanel != null) {
            this.propertyPanel.alignLabels();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updatePreview() {
        if (this.initDone) {
            BufferedImageOp bufferedImageOp = this.getFilter();
            if (bufferedImageOp == null) {
                return;
            }
            try {
                UI.setWaitCursor(this, true);
                this.imagePreviewPanel.setFilter(bufferedImageOp);
            }
            finally {
                UI.setWaitCursor(this, false);
            }
        }
    }

    void freeMemory() {
        this.originalImage = null;
        this.editor = null;
        this.imagePreviewPanel = TK.dispose(this.imagePreviewPanel);
        this.filters = null;
        this.propertyPanel = TK.dispose(this.propertyPanel);
        for (Filter filter : this.allFilters) {
            filter.dispose(new Object[0]);
        }
        this.allFilters.clear();
    }

    @Deprecated
    public abstract class NumberControlPanel
    extends ControlPanel<Number>
    implements MDisposable {
        protected MLabel value;
        protected MSlider slider;

        public NumberControlPanel(int n, int n2, int n3) {
            super(5, 0);
            this.slider = new MSlider(){

                @Override
                protected void onChange() {
                    Number number = (Number)NumberControlPanel.this.getValue();
                    NumberControlPanel.this.value.setNumber(number);
                    NumberControlPanel.this.onChange(this.getValueIsAdjusting(), number);
                    if (!this.getValueIsAdjusting()) {
                        FilterDialog.this.updatePreview();
                    }
                }
            };
            this.slider.setMinimum(n);
            this.slider.setMaximum(n2);
            this.slider.setValue(n3);
            this.slider.showSimpleLabels();
            this.slider.setEventsEnabled(true);
            this.addCenter(this.slider);
            this.value = new MLabel(){

                @Override
                public Dimension getMinimumSize() {
                    return this.getPreferredSize();
                }

                @Override
                public Dimension getPreferredSize() {
                    return new Dimension(50, super.getPreferredSize().height);
                }
            };
            this.value.setHorizontalAlignment(0);
            this.value.setNumber((Number)this.getValue());
            this.addEast(this.value);
            this.setDefaultValue(n3);
        }

        @Override
        public void setDefaults() {
            this.slider.setValue(((Number)this.defaultValue).intValue(), true);
            this.onChange(false, this.getValue());
            FilterDialog.this.updatePreview();
        }

        @Override
        public Object dispose(Object ... objectArray) {
            this.value = null;
            this.slider = null;
            return null;
        }
    }

    @Deprecated
    public abstract class IntegerControlPanel
    extends NumberControlPanel {
        public IntegerControlPanel(int n, int n2, int n3) {
            super(n, n2, n3);
        }

        @Override
        public Number getValue() {
            return this.slider.getValue();
        }
    }

    @Deprecated
    public abstract class FloatControlPanel
    extends NumberControlPanel {
        public FloatControlPanel() {
            this(100);
        }

        public FloatControlPanel(int n) {
            this(0, 300, n);
        }

        public FloatControlPanel(int n, int n2, int n3) {
            super(n, n2, n3);
        }

        @Override
        public Number getValue() {
            return Float.valueOf((float)this.slider.getValue() / 100.0f);
        }
    }

    public static class Filter
    extends Item<BufferedImageOp>
    implements Comparable<Filter>,
    MDisposable,
    Searchable<String> {
        private PropertyPanel propertyPanel;
        private final String[] properties;

        @Deprecated
        public Filter(BufferedImageOp bufferedImageOp, String string) {
            super(bufferedImageOp, string);
            this.properties = null;
        }

        public Filter(BufferedImageOp bufferedImageOp, String ... stringArray) {
            super(bufferedImageOp, bufferedImageOp.toString().replace("...", "").replace("/", " / "));
            this.properties = stringArray;
        }

        public PropertyPanel createPropertyPanel() {
            if (this.properties == null) {
                return null;
            }
            if (this.propertyPanel != null) {
                return this.propertyPanel;
            }
            this.propertyPanel = new PropertyPanel(){

                @Override
                public Dimension getPreferredSize() {
                    Dimension dimension = super.getPreferredSize();
                    return new Dimension(Math.max(200, dimension.width), dimension.height);
                }

                @Override
                protected Class<? extends JComponent> getPreferredEditorClass(PropertyAccess<?> propertyAccess) {
                    if (Property.isInteger(propertyAccess)) {
                        return MSlider.class;
                    }
                    return null;
                }

                @Override
                protected void onUserPropertyChange(PropertyAccess<?> propertyAccess) {
                    FilterDialog filterDialog = (FilterDialog)this.getWindowAncestor();
                    if (filterDialog != null) {
                        filterDialog.updatePreview();
                    }
                }
            };
            this.propertyPanel.setHighlightFocusedEditor(true);
            this.propertyPanel.addHeader(UI._("Properties"));
            try {
                this.propertyPanel.bindBean(this.getValue(), this.properties);
            }
            catch (IntrospectionException introspectionException) {
                MMessage.error(null, introspectionException);
            }
            return this.propertyPanel;
        }

        @Override
        public Icon getIcon() {
            if (this.icon == null) {
                MIcon mIcon = MIcon.stock("ui/ok");
                if (this.value instanceof BlockFilter) {
                    BlockFilter blockFilter = new BlockFilter();
                    blockFilter.setBlockSize(4);
                    this.icon = mIcon.getFilteredInstance(blockFilter);
                } else if (this.value instanceof ContrastFilter) {
                    ContrastFilter contrastFilter = new ContrastFilter();
                    contrastFilter.setBrightness(1.5f);
                    contrastFilter.setContrast(1.5f);
                    this.icon = mIcon.getFilteredInstance(contrastFilter);
                } else {
                    this.icon = this.value instanceof GammaFilter ? mIcon.getFilteredInstance(new GammaFilter(1.5f)) : mIcon.getFilteredInstance((BufferedImageOp)this.value);
                }
            }
            return this.icon;
        }

        @Override
        public int compareTo(Filter filter) {
            String string = this.toString();
            String string2 = filter.toString();
            boolean bl = string.startsWith("Colors /");
            boolean bl2 = string2.startsWith("Colors /");
            if (bl && !bl2) {
                return -1;
            }
            if (bl2 && !bl) {
                return 1;
            }
            return string.compareTo(string2);
        }

        @Override
        public Object dispose(Object ... objectArray) {
            this.propertyPanel = TK.dispose(this.propertyPanel);
            return null;
        }

        @Override
        public boolean matches(String string, EnumSet<Searchable.Matches> enumSet) {
            return TK.containsIgnoreCase(this.toString(), string);
        }
    }

    @Deprecated
    public static abstract class ControlPanel<T>
    extends MPanel {
        protected T defaultValue;

        public ControlPanel() {
        }

        public ControlPanel(int n, int n2) {
            super(n, n2);
        }

        public T getDefaultValue() {
            return this.defaultValue;
        }

        public void setDefaultValue(T t) {
            this.defaultValue = t;
        }

        public abstract T getValue();

        public abstract void onChange(boolean var1, T var2);

        public abstract void setDefaults();
    }

    @Deprecated
    public abstract class ColorControlPanel
    extends ControlPanel<Color>
    implements ChangeListener,
    MDisposable {
        private MSmallColorChooser chooser = new MSmallColorChooser();

        public ColorControlPanel(Color color) {
            this.chooser.setColor(color);
            this.chooser.setDefaultColor(color);
            this.chooser.addChangeListener(this);
            this.add(this.chooser);
        }

        @Override
        public Color getValue() {
            return this.chooser.getColor();
        }

        @Override
        public void setDefaults() {
            this.chooser.setColor(this.chooser.getDefaultColor());
            this.onChange(false, this.chooser.getColor());
            FilterDialog.this.updatePreview();
        }

        @Override
        public void stateChanged(ChangeEvent changeEvent) {
            this.onChange(false, this.chooser.getColor());
            FilterDialog.this.updatePreview();
        }

        @Override
        public Object dispose(Object ... objectArray) {
            this.chooser.removeChangeListener(this);
            this.chooser = null;
            return null;
        }
    }
}

