/*
 * Decompiled with CFR 0.152.
 */
package org.makagiga.editors.image;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.FlavorEvent;
import java.awt.datatransfer.FlavorListener;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import java.beans.IntrospectionException;
import java.io.InputStream;
import java.io.OutputStream;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.event.UndoableEditListener;
import org.makagiga.commons.ActionGroup;
import org.makagiga.commons.ClipboardException;
import org.makagiga.commons.Config;
import org.makagiga.commons.Flags;
import org.makagiga.commons.Focusable;
import org.makagiga.commons.Kiosk;
import org.makagiga.commons.MAction;
import org.makagiga.commons.MActionInfo;
import org.makagiga.commons.MClipboard;
import org.makagiga.commons.MDataAction;
import org.makagiga.commons.MDialog;
import org.makagiga.commons.MIcon;
import org.makagiga.commons.MLabel;
import org.makagiga.commons.MLogger;
import org.makagiga.commons.MMenu;
import org.makagiga.commons.MMessage;
import org.makagiga.commons.MMouseAdapter;
import org.makagiga.commons.MScrollPane;
import org.makagiga.commons.MToggleButton;
import org.makagiga.commons.MToolBar;
import org.makagiga.commons.MUndoManager;
import org.makagiga.commons.TK;
import org.makagiga.commons.UI;
import org.makagiga.commons.WTFError;
import org.makagiga.commons.fx.Reflection;
import org.makagiga.commons.print.ImagePrintInfo;
import org.makagiga.commons.print.PrintInfo;
import org.makagiga.commons.print.PrintableImage;
import org.makagiga.editors.Actions;
import org.makagiga.editors.AnnotationBar;
import org.makagiga.editors.AnnotationInfo;
import org.makagiga.editors.Editor;
import org.makagiga.editors.EditorAnnotation;
import org.makagiga.editors.EditorConfig;
import org.makagiga.editors.EditorDesigner;
import org.makagiga.editors.EditorExport;
import org.makagiga.editors.EditorIO;
import org.makagiga.editors.EditorPlugin;
import org.makagiga.editors.EditorPrint;
import org.makagiga.editors.EditorZoom;
import org.makagiga.editors.NavigationUtils;
import org.makagiga.editors.image.FilterDialog;
import org.makagiga.editors.image.ImageEditorCore;
import org.makagiga.editors.image.ImageEditorDesigner;
import org.makagiga.editors.image.ImageInfo;
import org.makagiga.editors.image.ImagePreloader;
import org.makagiga.editors.image.ResizeDialog;
import org.makagiga.editors.image.tools.BrushTool;
import org.makagiga.editors.image.tools.SelectionTool;
import org.makagiga.form.PropertyPanel;
import org.makagiga.plugins.PluginMenu;
import org.makagiga.tools.presentation.Presentation;

public final class ImageEditor
extends Editor<ImageEditorCore>
implements EditorAnnotation,
EditorConfig,
EditorDesigner<ImageEditorDesigner>,
EditorExport,
EditorIO,
EditorPrint,
EditorZoom,
FlavorListener,
Focusable,
PluginMenu,
Presentation.ToggleListener {
    protected ImageInfo imageInfo;
    private boolean isImageInClipboard;
    private JButton playButton;
    private final List<AnnotationInfo> annotations = new ArrayList<AnnotationInfo>();
    private MMouseAdapter menuMouseAdapter;
    private final MouseWheelFunctionAction mouseWheelFunctionScrollAction;
    private final MouseWheelFunctionAction mouseWheelFunctionNavigateAction;
    private final MouseWheelFunctionAction mouseWheelFunctionZoomAction;
    private final MScrollPane coreScrollPane;
    private final MUndoManager undoManager;
    private UndoableEditListener undoableEditListener;
    private final ZoomComponent zoomComponent;
    static boolean autoZoom;
    static MAction mouseWheelReversedAction;
    static MouseWheelFunction mouseWheelFunction;

    public ImageEditor() {
        this.setAsyncLoad(true);
        this.setCore(new ImageEditorCore(this));
        this.coreScrollPane = new MScrollPane((JComponent)this.core, 2){

            @Override
            public void updateUI() {
                this.putClientProperty("A03.ScrollPane.viewNavigator", true);
                super.updateUI();
            }
        };
        this.addCenter(this.coreScrollPane);
        this.imageInfo = new ImageInfo();
        this.undoManager = new MUndoManager((JComponent)this.core, 32){

            @Override
            public void updateUserActions() {
                ImageEditor.this.updateActions();
            }
        };
        this.undoableEditListener = this.undoManager.createUndoableEditListener();
        ((ImageEditorCore)this.core).addUndoableEditListener(this.undoableEditListener);
        this.mouseWheelFunctionScrollAction = new MouseWheelFunctionAction(UI._("Scroll"), MouseWheelFunction.SCROLL);
        this.mouseWheelFunctionNavigateAction = new MouseWheelFunctionAction(UI._("Show next/previous file"), MouseWheelFunction.NAVIGATE);
        this.mouseWheelFunctionZoomAction = new MouseWheelFunctionAction(UI._("Zoom"), MouseWheelFunction.ZOOM);
        if (mouseWheelReversedAction == null) {
            mouseWheelReversedAction = new MAction(UI._("Reversed")){

                @Override
                public void onAction() {
                    ImageEditor.this.syncConfig();
                }
            };
        }
        try {
            MClipboard.getDefault().addFlavorListener(this);
            this.isImageInClipboard = MClipboard.isDataFlavorAvailable(DataFlavor.imageFlavor);
        }
        catch (ClipboardException clipboardException) {
        }
        catch (NullPointerException nullPointerException) {
            MLogger.exception(nullPointerException);
        }
        Presentation.addToggleListener(this);
        this.menuMouseAdapter = new MMouseAdapter(){

            @Override
            public void popupTrigger(MouseEvent mouseEvent) {
                ImageEditor.this.showPopupMenu("EDIT_MENU", mouseEvent);
            }
        };
        ((ImageEditorCore)this.core).addMouseListener(this.menuMouseAdapter);
        this.zoomComponent = new ZoomComponent();
        new MAction("ImageEditor.next", 32){

            @Override
            public void onAction() {
                NavigationUtils.goToFile(true);
            }
        }.connect((JComponent)this.core, 1);
        new MAction("ImageEditor.previous", 8){

            @Override
            public void onAction() {
                NavigationUtils.goToFile(false);
            }
        }.connect((JComponent)this.core, 1);
    }

    @Override
    public void flavorsChanged(FlavorEvent flavorEvent) {
        try {
            this.isImageInClipboard = MClipboard.isDataFlavorAvailable(DataFlavor.imageFlavor);
        }
        catch (ClipboardException clipboardException) {
            this.isImageInClipboard = true;
        }
        this.updateActions();
    }

    @Override
    public void focus() {
        ((ImageEditorCore)this.core).requestFocusInWindow();
    }

    @Deprecated
    public static boolean getShowGrid() {
        return false;
    }

    @Override
    public boolean getSupportsToolBarUnderTabs() {
        return true;
    }

    @Override
    public void setLocked(boolean bl) {
        super.setLocked(bl);
        ((ImageEditorCore)this.core).setLocked(bl);
    }

    @Override
    public void onClose() {
        ((ImageEditorCore)this.core).getToolManager().unregisterAll();
        if (this.undoableEditListener != null) {
            ((ImageEditorCore)this.core).removeUndoableEditListener(this.undoableEditListener);
            this.undoableEditListener = null;
        }
        MClipboard.getDefault().removeFlavorListener(this);
        Presentation.removeToggleListener(this);
        if (this.menuMouseAdapter != null) {
            ((ImageEditorCore)this.core).removeMouseListener(this.menuMouseAdapter);
            this.menuMouseAdapter = null;
        }
        ActionGroup actionGroup = this.getSharedActionGroup();
        actionGroup.disconnect("copy", (JComponent)this.core, 0);
        actionGroup.disconnect("paste", (JComponent)this.core, 0);
        ((ImageEditorCore)this.core).deleteUndos();
        ((ImageEditorCore)this.core).shutDown();
    }

    @Override
    public void onLastClose() {
        mouseWheelReversedAction = null;
        ImagePreloader.delayedFree();
        BrushTool.getInstance().setContext(null, null);
        if (ImageEditorDesigner.isInstance()) {
            ImageEditorDesigner.getInstance().writeConfig(this);
        }
    }

    public void showSelectionMenu(MouseEvent mouseEvent, SelectionTool selectionTool) {
        ActionGroup actionGroup = this.getSharedActionGroup();
        MMenu mMenu = new MMenu();
        mMenu.addTitle(UI._("Selection - {0}", selectionTool));
        mMenu.add((Action)actionGroup.getAction("copy"));
        mMenu.addSeparator();
        mMenu.add((Action)actionGroup.getAction("crop"));
        mMenu.add((Action)actionGroup.getAction("filters"));
        mMenu.addSeparator();
        mMenu.add(new MAction(MActionInfo.CANCEL));
        mMenu.showPopup(mouseEvent);
    }

    @Override
    public void updateActions() {
        if (!this.isTabSelected()) {
            return;
        }
        boolean bl = ((ImageEditorCore)this.core).canDraw();
        boolean bl2 = ((ImageEditorCore)this.core).getCanvas() != null;
        boolean bl3 = ((ImageEditorCore)this.core).isSelection();
        ActionGroup actionGroup = this.getSharedActionGroup();
        actionGroup.setEnabled("clear", bl);
        actionGroup.setEnabled("copy", bl2);
        actionGroup.setEnabled("create-reflection", bl);
        actionGroup.setEnabled("crop", bl && bl3);
        actionGroup.setEnabled("filters", bl);
        actionGroup.setEnabled("paste", bl && this.isImageInClipboard);
        actionGroup.setEnabled("resize", bl);
        PlayAction playAction = (PlayAction)actionGroup.getAction("play");
        playAction.update();
        if (this.playButton != null) {
            this.playButton.setVisible(playAction.isEnabled());
        }
        actionGroup.setEnabled("unselect-all", bl3);
        this.undoManager.updateUndoRedoActions(bl);
        actionGroup.setEnabled("rotate-180", bl);
        actionGroup.setEnabled("rotate-270", bl);
        actionGroup.setEnabled("rotate-90", bl);
        actionGroup.setEnabled("flip-h", bl);
        actionGroup.setEnabled("flip-v", bl);
        this.zoomComponent.setAutoZoom(ImageEditor.autoZoom, false);
        ((ImageEditorCore)this.core).setScale(ImageEditorCore.getScale(), false);
    }

    @Override
    public void addAnnotation(AnnotationInfo annotationInfo) {
        this.annotations.add(annotationInfo);
    }

    @Override
    public void removeAnnotation(AnnotationInfo annotationInfo) {
        this.annotations.remove(annotationInfo);
    }

    @Override
    public void editAnnotation(AnnotationInfo annotationInfo) {
    }

    @Override
    public List<AnnotationInfo> getAnnotations() {
        return this.annotations;
    }

    @Override
    public int getAnnotationCapabilities() {
        return 1;
    }

    @Override
    public AnnotationInfo newAnnotation() {
        return null;
    }

    @Override
    public void paintAnnotations(JComponent jComponent, Graphics2D graphics2D, Rectangle rectangle) {
    }

    @Override
    public void updateAnnotationBar() {
        ((ImageEditorCore)this.core).getToolManager().update();
        AnnotationBar annotationBar = AnnotationBar.getInstance();
        annotationBar.addContentGap();
        ImageEditorDesigner imageEditorDesigner = this.getEditorDesigner();
        annotationBar.add(imageEditorDesigner.circleBrushType);
        annotationBar.add(imageEditorDesigner.squareBrushType);
    }

    @Override
    public void loadConfig(Config config) {
        Config config2 = Config.getDefault();
        this.zoomComponent.setAutoZoom(config2.read(this.getGlobalEntry("AutoZoom.enabled"), false), false);
        BrushTool brushTool = BrushTool.getInstance();
        brushTool.setColor(config2.readColor(this.getGlobalEntry("Brush.color"), Color.BLUE));
        brushTool.setOpacity(config2.readInt(this.getGlobalEntry("Brush.opacity"), 255, 0, 255));
        brushTool.setSize(config2.readInt(this.getGlobalEntry("Brush.size"), 3, 1, 50));
        brushTool.setType(config2.readEnum(this.getGlobalEntry("Brush.type"), BrushTool.Type.CIRCLE));
        ActionGroup actionGroup = this.getSharedActionGroup();
        actionGroup.setSelected("show-grid", config2.read(this.getGlobalEntry("Grid.visible"), false));
        mouseWheelFunction = config2.readEnum(this.getGlobalEntry("MouseWheel.function"), MouseWheelFunction.SCROLL);
        this.mouseWheelFunctionNavigateAction.update(ImageEditor.mouseWheelFunction);
        this.mouseWheelFunctionZoomAction.update(ImageEditor.mouseWheelFunction);
        this.mouseWheelFunctionScrollAction.update(ImageEditor.mouseWheelFunction);
        mouseWheelReversedAction.setSelected(config2.read(this.getGlobalEntry("MouseWheel.reversed"), false));
    }

    @Override
    public void saveConfig(Config config) {
        Config config2 = Config.getDefault();
        config2.write(this.getGlobalEntry("AutoZoom.enabled"), autoZoom);
        BrushTool brushTool = BrushTool.getInstance();
        config2.write(this.getGlobalEntry("Brush.color"), brushTool.getColor());
        config2.write(this.getGlobalEntry("Brush.opacity"), brushTool.getOpacity());
        config2.write(this.getGlobalEntry("Brush.size"), brushTool.getSize());
        config2.write(this.getGlobalEntry("Brush.type"), brushTool.getType());
        ActionGroup actionGroup = this.getSharedActionGroup();
        config2.write(this.getGlobalEntry("Grid.visible"), actionGroup.isSelected("show-grid"));
        config2.write(this.getGlobalEntry("MouseWheel.function"), mouseWheelFunction);
        config2.write(this.getGlobalEntry("MouseWheel.reversed"), mouseWheelReversedAction.isSelected());
    }

    @Override
    public ImageEditorDesigner getEditorDesigner() {
        boolean bl = !ImageEditorDesigner.isInstance();
        ImageEditorDesigner imageEditorDesigner = ImageEditorDesigner.getInstance();
        if (bl) {
            imageEditorDesigner.readConfig(this);
        }
        return imageEditorDesigner;
    }

    @Override
    public void updateEditorDesigner() {
        ((ImageEditorCore)this.core).getToolManager().setContext(this, (ImageEditorCore)this.core);
        ImageEditorDesigner imageEditorDesigner = this.getEditorDesigner();
        imageEditorDesigner.imageInfoTogglePanel.setComponent(this.imageInfo);
        imageEditorDesigner.update((ImageEditorCore)this.core, true);
    }

    @Override
    public void exportFile(EditorPlugin.FileType fileType, OutputStream outputStream) throws Exception {
        if (fileType.is("bmp")) {
            ((ImageEditorCore)this.core).saveToFileAs("bmp", outputStream);
        } else if (fileType.is("gif")) {
            ((ImageEditorCore)this.core).saveToFileAs("gif", outputStream);
        } else if (fileType.is("jpeg")) {
            ((ImageEditorCore)this.core).saveToFileAs("jpg", outputStream);
        } else if (fileType.is("png")) {
            ((ImageEditorCore)this.core).saveToFileAs("png", outputStream);
        } else {
            this.exportNotSupported(fileType);
        }
    }

    @Override
    public void loadFile(InputStream inputStream, boolean bl) throws Exception {
        ((ImageEditorCore)this.core).loadFromFile(inputStream, bl);
    }

    @Override
    public void saveFile(OutputStream outputStream) throws Exception {
        if (((ImageEditorCore)this.core).isLocked()) {
            return;
        }
        String string = this.getMetaInfo().getExtension();
        ((ImageEditorCore)this.core).saveToFileAs(string, outputStream, true);
        BufferedImage bufferedImage = ((ImageEditorCore)this.core).getCanvas();
        if (bufferedImage != null) {
            Object[] objectArray = new Object[]{"image-width:" + bufferedImage.getWidth(), "image-height:" + bufferedImage.getHeight()};
            if (!this.updateLocalIndex(objectArray)) {
                this.updateIndex(objectArray);
            }
            this.imageInfo.update(this.getMetaInfo(), bufferedImage);
        }
    }

    @Override
    public Printable getPrintable(Flags flags, MessageFormat messageFormat, MessageFormat messageFormat2) throws PrinterException {
        BufferedImage bufferedImage = ((ImageEditorCore)this.core).getCanvas();
        if (bufferedImage == null) {
            throw new PrinterException();
        }
        return new PrintableImage(bufferedImage);
    }

    @Override
    public int getPrintingCapabilities() {
        return 0;
    }

    @Override
    public PrintInfo.PrintResult printDocument(Flags flags, MessageFormat messageFormat, MessageFormat messageFormat2) throws PrinterException {
        BufferedImage bufferedImage = ((ImageEditorCore)this.core).getCanvas();
        if (bufferedImage == null) {
            throw new PrinterException();
        }
        PrintableImage printableImage = new PrintableImage(bufferedImage);
        printableImage.setUseDispose(true);
        return ImagePrintInfo.printDocument(printableImage, this.getMetaInfo().toString(), flags);
    }

    @Override
    public JComponent getZoomComponent() {
        return this.zoomComponent;
    }

    @Override
    public boolean isZoomEnabled(EditorZoom.ZoomType zoomType) {
        switch (zoomType) {
            case IN: {
                return ImageEditorCore.getScale() < 15.0;
            }
            case OUT: {
                return ImageEditorCore.getScale() > 1.0;
            }
        }
        throw new WTFError(zoomType);
    }

    @Override
    public void zoom(EditorZoom.ZoomType zoomType) {
        if (autoZoom) {
            this.zoomComponent.setAutoZoom(false, true);
        }
        switch (zoomType) {
            case IN: {
                ((ImageEditorCore)this.core).setScale(ImageEditorCore.getScale() + 0.5, true);
                break;
            }
            case OUT: {
                ((ImageEditorCore)this.core).setScale(ImageEditorCore.getScale() - 0.5, true);
                break;
            }
            default: {
                throw new WTFError(zoomType);
            }
        }
        ((ImageEditorCore)this.core).updateScrollPane();
        this.zoomComponent.updateText();
    }

    @Override
    public void updateMenu(String string, MMenu mMenu) {
        if (string.equals("EDIT_MENU")) {
            ActionGroup actionGroup = this.getSharedActionGroup();
            this.undoManager.updateMenu(mMenu);
            mMenu.addSeparator();
            mMenu.add((Action)actionGroup.getAction("copy"));
            mMenu.add((Action)actionGroup.getAction("paste"));
            mMenu.addSeparator();
            mMenu.add((Action)actionGroup.getAction("clear"));
            mMenu.addSeparator();
            mMenu.add((Action)actionGroup.getAction("unselect-all"));
            mMenu.addTitle(UI._("Image"));
            mMenu.add((Action)actionGroup.getAction("resize"));
            mMenu.add((Action)actionGroup.getAction("crop"));
            MMenu mMenu2 = new MMenu(UI._("Transform"));
            mMenu2.add((Action)actionGroup.getAction("rotate-270"));
            mMenu2.add((Action)actionGroup.getAction("rotate-90"));
            mMenu2.add((Action)actionGroup.getAction("rotate-180"));
            mMenu2.addSeparator();
            mMenu2.add((Action)actionGroup.getAction("flip-h"));
            mMenu2.add((Action)actionGroup.getAction("flip-v"));
            mMenu.add(mMenu2);
            mMenu.addTitle(UI._("Filters"));
            mMenu.add((Action)actionGroup.getAction("filters"));
            mMenu.add((Action)actionGroup.getAction("create-reflection"));
        } else if (string.equals("VIEW_MENU_EDITOR")) {
            mMenu.addSeparator();
            ActionGroup actionGroup = this.getSharedActionGroup();
            mMenu.add((Action)actionGroup.getAction("play"));
            mMenu.addCheckBox((Action)actionGroup.getAction("auto-zoom"));
            mMenu.addCheckBox((Action)actionGroup.getAction("show-grid"));
            MMenu mMenu3 = new MMenu(UI._("Mouse Wheel Action"));
            this.mouseWheelFunctionNavigateAction.update(ImageEditor.mouseWheelFunction);
            this.mouseWheelFunctionZoomAction.update(ImageEditor.mouseWheelFunction);
            this.mouseWheelFunctionScrollAction.update(ImageEditor.mouseWheelFunction);
            UI.group(mMenu3.addRadioButton(this.mouseWheelFunctionScrollAction), mMenu3.addRadioButton(this.mouseWheelFunctionNavigateAction), mMenu3.addRadioButton(this.mouseWheelFunctionZoomAction));
            mMenu3.addSeparator();
            mMenu3.addCheckBox(mouseWheelReversedAction);
            mMenu.add(mMenu3);
        }
    }

    @Override
    public void updateToolBar(String string, MToolBar mToolBar) {
        if (string.equals("EDITOR_TOOL_BAR")) {
            ActionGroup actionGroup = this.getSharedActionGroup();
            this.undoManager.updateToolBar(mToolBar);
            mToolBar.addSeparator();
            mToolBar.add((Action)actionGroup.getAction("copy"), 1);
            mToolBar.add((Action)actionGroup.getAction("paste"), 1);
            mToolBar.addSeparator();
            mToolBar.add((Action)actionGroup.getAction("rotate-270"));
            mToolBar.add((Action)actionGroup.getAction("rotate-90"));
            mToolBar.addSeparator();
            this.playButton = mToolBar.add((Action)actionGroup.getAction("play"));
        }
    }

    @Override
    public void toggle(Presentation.ToggleEvent toggleEvent) {
        ((ImageEditorCore)this.core).updateScrollPane();
    }

    @Override
    protected ActionGroup createSharedActionGroup() {
        ActionGroup actionGroup = new ActionGroup();
        actionGroup.add("auto-zoom", new AutoZoomAction());
        actionGroup.add("clear", new ClearAction());
        actionGroup.add("copy", new CopyAction());
        actionGroup.add("create-reflection", new CreateReflectionAction());
        actionGroup.add("crop", new CropAction());
        actionGroup.add("filters", new FiltersAction());
        actionGroup.add("flip-h", new FlipAction(1, UI._("Flip Horizontally"), "ui/fliphorizontal"));
        actionGroup.add("flip-v", new FlipAction(2, UI._("Flip Vertically"), "ui/flipvertical"));
        actionGroup.add("paste", new PasteAction());
        actionGroup.add("play", new PlayAction());
        actionGroup.add("resize", new ResizeAction());
        actionGroup.add("rotate-180", new FlipAction(6, UI._("Rotate Right (180 degrees)"), null, 56, 2));
        actionGroup.add("rotate-270", new FlipAction(5, UI._("Rotate Left"), "ui/rotateleft", 55, 2));
        actionGroup.add("rotate-90", new FlipAction(4, UI._("Rotate Right"), "ui/rotate", 57, 2));
        actionGroup.add("show-grid", new ShowGridAction());
        actionGroup.add("unselect-all", new UnselectAllAction());
        actionGroup.connect("copy", (JComponent)this.core, 0);
        actionGroup.connect("paste", (JComponent)this.core, 0);
        return actionGroup;
    }

    static {
        mouseWheelFunction = MouseWheelFunction.SCROLL;
    }

    private final class ZoomComponent
    extends MToggleButton {
        @Override
        public void updateUI() {
            if (UI.isSubstance()) {
                this.putClientProperty("substancelaf.buttonnominsize", true);
            }
            super.updateUI();
        }

        @Override
        protected void onClick() {
            this.setAutoZoom(this.isSelected(), true);
        }

        private ZoomComponent() {
            this.setRequestFocusEnabled(false);
            this.setToolTipText(UI._("Zoom - Click to toggle Auto Zoom"));
        }

        private void setAutoZoom(boolean bl, boolean bl2) {
            autoZoom = bl;
            this.setSelected(bl);
            ImageEditor.this.getSharedActionGroup().setSelected("auto-zoom", bl);
            if (bl) {
                this.setText(UI._("Fit to Window"));
                ImageEditor.this.coreScrollPane.setScrollBarVisible(false);
                MScrollPane.scrollToTop(ImageEditor.this.coreScrollPane, true);
            } else {
                ImageEditor.this.coreScrollPane.setScrollBarVisible(!Presentation.isActive());
                if (bl2) {
                    ((ImageEditorCore)ImageEditor.this.core).setScale(1.0, false);
                    ((ImageEditorCore)ImageEditor.this.core).updateScrollPane();
                }
                this.updateText();
            }
            ((ImageEditorCore)ImageEditor.this.core).repaint();
        }

        private void updateText() {
            this.setText(Math.round(ImageEditorCore.getScale() * 100.0) + "%");
        }
    }

    private static final class UnselectAllAction
    extends Actions.UnselectAll<ImageEditor> {
        @Override
        public void onAction(ImageEditor imageEditor) {
            ((ImageEditorCore)imageEditor.getCore()).getSelectionTool().clear();
            imageEditor.updateActions();
        }

        private UnselectAllAction() {
        }
    }

    private static final class ShowGridAction
    extends Actions.Base<ImageEditor> {
        @Override
        public void onAction(ImageEditor imageEditor) {
            ((ImageEditorCore)imageEditor.getCore()).repaint();
            imageEditor.syncConfig();
        }

        private ShowGridAction() {
            super(MActionInfo.SHOW_GRID);
            this.setEnabled(true);
        }
    }

    private static final class ResizeAction
    extends Actions.Base<ImageEditor> {
        @Override
        public void onAction(ImageEditor imageEditor) {
            Image image = ResizeDialog.show(imageEditor, ((ImageEditorCore)imageEditor.getCore()).getCanvas(), ImageEditorCore.getScale());
            if (image != null) {
                ((ImageEditorCore)imageEditor.getCore()).modifyCanvas(image);
            }
        }

        private ResizeAction() {
            super(UI._("Scale Image..."), "ui/scale", 82, 2);
        }
    }

    private static final class PlayAction
    extends Actions.Base<ImageEditor> {
        @Override
        public void onAction(ImageEditor imageEditor) {
            MDialog mDialog = new MDialog(null, UI._("Play"), 36);
            MLabel mLabel = new MLabel();
            mLabel.setIcon(new MIcon(imageEditor.getMetaInfo().getFile()));
            mLabel.setStyle("background-color: white");
            mDialog.addCenter(mLabel);
            mDialog.packFixed();
            mDialog.exec();
        }

        private PlayAction() {
            super(UI._("Play"), "player/start");
        }

        private void update() {
            Editor<?> editor = Editor.getCurrentEditor();
            if (editor == null) {
                this.setEnabled(false);
            } else {
                String string = editor.getMetaInfo().getExtension();
                this.setEnabled(string != null && TK.toUpperCase(string).equals("GIF"));
            }
        }
    }

    private static final class PasteAction
    extends Actions.Paste<ImageEditor> {
        @Override
        public void onAction(ImageEditor imageEditor) {
            if (!((ImageEditorCore)imageEditor.getCore()).paste()) {
                this.showPasteError();
            }
        }

        private PasteAction() {
            this.setAlternateAcceleratorKey(155, 1);
        }
    }

    private final class MouseWheelFunctionAction
    extends MDataAction<MouseWheelFunction> {
        @Override
        public void onAction() {
            mouseWheelFunction = (MouseWheelFunction)((Object)this.getData());
            ImageEditor.this.syncConfig();
        }

        private MouseWheelFunctionAction(String string, MouseWheelFunction mouseWheelFunction) {
            super(mouseWheelFunction, string);
        }

        private void update(MouseWheelFunction mouseWheelFunction) {
            this.setSelected(this.getData() == mouseWheelFunction);
        }
    }

    private static final class FlipAction
    extends Actions.Base<ImageEditor> {
        private final int operation;

        @Override
        public void onAction(ImageEditor imageEditor) {
            ((ImageEditorCore)imageEditor.getCore()).flip(this.operation);
        }

        private FlipAction(int n, String string, String string2) {
            this(n, string, string2, 0, 0);
        }

        private FlipAction(int n, String string, String string2, int n2, int n3) {
            super(string, string2, n2, n3);
            this.operation = n;
        }
    }

    private static final class FiltersAction
    extends Actions.Base<ImageEditor> {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onAction(ImageEditor imageEditor) {
            ImageEditorCore imageEditorCore = (ImageEditorCore)imageEditor.getCore();
            FilterDialog filterDialog = new FilterDialog(imageEditor, imageEditorCore.getSelectedImage());
            if (filterDialog.exec()) {
                UI.setWaitCursor(imageEditorCore, true);
                imageEditorCore.setMessageText(UI._("Please Wait..."));
                imageEditorCore.paintImmediately(imageEditorCore.getBounds());
                try {
                    Image image = filterDialog.getFilteredImage();
                    imageEditorCore.insertImage(image);
                }
                finally {
                    UI.setWaitCursor(imageEditorCore, false);
                    imageEditorCore.setMessageText(null);
                }
                filterDialog.freeMemory();
            } else {
                filterDialog.freeMemory();
            }
        }

        private FiltersAction() {
            super(UI._("Filters and Effects..."), 69, 2);
        }
    }

    private static final class CropAction
    extends Actions.Base<ImageEditor> {
        @Override
        public void onAction(ImageEditor imageEditor) {
            ((ImageEditorCore)imageEditor.getCore()).crop();
        }

        private CropAction() {
            super(UI._("Crop"), "crop", 77, 2);
            this.setHTMLHelp(UI._("Set selection as image."));
        }
    }

    private static final class CreateReflectionAction
    extends Actions.Base<ImageEditor> {
        @Override
        public void onAction(ImageEditor imageEditor) {
            Reflection reflection = new Reflection();
            PropertyPanel propertyPanel = new PropertyPanel();
            try {
                propertyPanel.bindBean(reflection, "reflectionSize", "blur", "gap");
            }
            catch (IntrospectionException introspectionException) {
                MMessage.error(this.getSourceWindow(), introspectionException);
            }
            MDialog mDialog = new MDialog(imageEditor.getWindowAncestor(), this.getName(), 7);
            mDialog.addCenter(propertyPanel);
            mDialog.packFixed();
            propertyPanel.alignLabels();
            if (mDialog.exec()) {
                ImageEditorCore imageEditorCore = (ImageEditorCore)imageEditor.getCore();
                imageEditorCore.modifyCanvas(reflection.createImage(imageEditorCore.getCanvas()));
            }
        }

        private CreateReflectionAction() {
            super(UI._("Create Reflection"));
        }
    }

    private static final class CopyAction
    extends Actions.Copy<ImageEditor> {
        @Override
        public void onAction(ImageEditor imageEditor) {
            if (!((ImageEditorCore)imageEditor.getCore()).copy()) {
                this.showCopyError();
            }
        }

        private CopyAction() {
            this.setAlternateAcceleratorKey(155, 2);
        }
    }

    private static final class ClearAction
    extends Actions.Clear<ImageEditor> {
        @Override
        public void onAction(ImageEditor imageEditor) {
            if (MMessage.simpleConfirm(this.getSourceWindow(), MActionInfo.CLEAR)) {
                ((ImageEditorCore)imageEditor.getCore()).clear();
            }
        }

        private ClearAction() {
        }
    }

    private static final class AutoZoomAction
    extends Actions.Base<ImageEditor> {
        @Override
        public void onAction(ImageEditor imageEditor) {
            imageEditor.zoomComponent.setAutoZoom(this.isSelected(), true);
            imageEditor.syncConfig();
        }

        private AutoZoomAction() {
            super(UI._("Auto Zoom"), 48, 2);
            this.setAuthorizationProperty(Kiosk.actionZoom);
            this.setEnabled(true);
        }
    }

    static enum MouseWheelFunction {
        NAVIGATE,
        SCROLL,
        ZOOM;

    }
}

