/*
 * Decompiled with CFR 0.152.
 */
package org.makagiga.editors.image;

import com.jhlabs.image.FlipFilter;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.lang.ref.WeakReference;
import java.util.Iterator;
import java.util.concurrent.locks.ReentrantLock;
import javax.imageio.ImageIO;
import javax.imageio.ImageReader;
import javax.imageio.event.IIOReadProgressListener;
import javax.imageio.metadata.IIOMetadata;
import javax.imageio.stream.ImageInputStream;
import javax.swing.JViewport;
import javax.swing.KeyStroke;
import javax.swing.event.MouseInputListener;
import javax.swing.event.UndoableEditListener;
import javax.swing.undo.AbstractUndoableEdit;
import javax.swing.undo.UndoableEdit;
import javax.swing.undo.UndoableEditSupport;
import org.makagiga.Tabs;
import org.makagiga.Vars;
import org.makagiga.commons.FS;
import org.makagiga.commons.Flags;
import org.makagiga.commons.Lockable;
import org.makagiga.commons.MClipboard;
import org.makagiga.commons.MColor;
import org.makagiga.commons.MGraphics;
import org.makagiga.commons.MGraphics2D;
import org.makagiga.commons.MHighlighter;
import org.makagiga.commons.MIcon;
import org.makagiga.commons.MLogger;
import org.makagiga.commons.MMouseAdapter;
import org.makagiga.commons.MScrollPane;
import org.makagiga.commons.MStatusBar;
import org.makagiga.commons.MSwingWorker;
import org.makagiga.commons.MTimeline;
import org.makagiga.commons.MUndoManager;
import org.makagiga.commons.StringList;
import org.makagiga.commons.TK;
import org.makagiga.commons.UI;
import org.makagiga.editors.EditorZoom;
import org.makagiga.editors.NavigationUtils;
import org.makagiga.editors.image.ImageEditor;
import org.makagiga.editors.image.ImagePreloader;
import org.makagiga.editors.image.tools.BrushTool;
import org.makagiga.editors.image.tools.EraserTool;
import org.makagiga.editors.image.tools.LineTool;
import org.makagiga.editors.image.tools.RectangleTool;
import org.makagiga.editors.image.tools.RedRectangleTool;
import org.makagiga.editors.image.tools.SelectionTool;
import org.makagiga.editors.image.tools.Tool;
import org.makagiga.editors.image.tools.ToolManager;
import org.makagiga.fs.MetaInfo;
import org.makagiga.tools.presentation.Presentation;
import org.pushingpixels.trident.TimelinePropertyBuilder;

public final class ImageEditorCore
extends MGraphics
implements IIOReadProgressListener,
Lockable,
MouseInputListener,
MouseWheelListener {
    public static final int INSERT = 1;
    public static final int USE_SELECTION = 2;
    @Deprecated
    public static final double MIN_SCALE = 0.2;
    private boolean newFile;
    private BufferedImage canvas;
    private final Color gridColor = MColor.SKY_BLUE.deriveAlpha(80);
    private double currentScale;
    private static double scale = 1.0;
    private IIOMetadata metaData;
    private int loadProgress;
    private int modificationLevel;
    private transient MSwingWorker<BufferedImage> loader;
    private MTimeline<ImageEditorCore> scaleAnimation;
    private final ReentrantLock canvasLock = new ReentrantLock();
    private String messageText;
    private final StringList undos = new StringList();
    private Throwable loadError;
    private Undo undo;
    private UndoableEditSupport undoSupport;
    private final WeakReference<ImageEditor> editorRef;
    private final SelectionTool selectionTool;
    private final ToolManager toolManager;

    public ImageEditorCore(ImageEditor imageEditor) {
        this.currentScale = scale;
        this.setFocusable(true);
        this.editorRef = new WeakReference<ImageEditor>(imageEditor);
        this.toolManager = new ToolManager();
        this.selectionTool = this.toolManager.register(new SelectionTool());
        this.toolManager.register(BrushTool.getInstance());
        this.toolManager.register(new LineTool());
        this.toolManager.register(new RectangleTool());
        this.toolManager.register(new RedRectangleTool());
        this.toolManager.register(new EraserTool());
        this.toolManager.setCurrent(this.selectionTool);
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
        this.addMouseWheelListener(this);
    }

    public void addUndoableEditListener(UndoableEditListener undoableEditListener) {
        if (this.undoSupport == null) {
            this.undoSupport = new UndoableEditSupport();
        }
        this.undoSupport.addUndoableEditListener(undoableEditListener);
    }

    public UndoableEditListener[] getUndoableEditListeners() {
        if (this.undoSupport != null) {
            return this.undoSupport.getUndoableEditListeners();
        }
        return MUndoManager.EMPTY_UNDOABLE_EDIT_LISTENER_ARRAY;
    }

    public void removeUndoableEditListener(UndoableEditListener undoableEditListener) {
        if (this.undoSupport != null) {
            this.undoSupport.removeUndoableEditListener(undoableEditListener);
        }
    }

    public void afterModification() {
        this.afterModification(null);
    }

    public void afterModification(Rectangle rectangle) {
        if (rectangle == null) {
            this.repaint();
        } else {
            this.repaint(rectangle);
        }
        if (this.undo != null) {
            this.undo.redo = new Undo(this.canvas);
            this.fireUndoableEditHappened(this.undo);
            this.undo = null;
        }
        this.setModificationLevel(this.modificationLevel);
        this.getEditor().updateActions();
    }

    public void beforeModification() {
        this.undo = new Undo(this.canvas);
        this.setModificationLevel(this.modificationLevel + 1);
    }

    public boolean canDraw() {
        return this.canvas != null && !this.isLocked() && !this.getEditor().isLocked() && !Presentation.isActive();
    }

    public void clear() {
        this.modifyCanvas(UI.createCompatibleImage(this.canvas.getWidth(), this.canvas.getHeight(), true));
    }

    public boolean copy() {
        return this.selectionTool.copy(this.canvas);
    }

    public void crop() {
        if (this.selectionTool.isSelection()) {
            this.modifyCanvas(this.getSelectedImage());
            this.getEditor().updateActions();
        }
    }

    public void deleteUndos() {
        for (String string : this.undos) {
            FS.deleteFile(string);
        }
    }

    public void flip(int n) {
        this.modifyCanvas(new FlipFilter(n).filter(this.canvas, null));
    }

    @Deprecated
    public BrushTool getBrushTool() {
        return BrushTool.getInstance();
    }

    public synchronized BufferedImage getCanvas() {
        return this.canvas;
    }

    public SelectionTool getSelectionTool() {
        return this.selectionTool;
    }

    public void setCanvas(Image image) {
        this.setCanvas(image, true);
    }

    public synchronized void setCanvas(Image image, boolean bl) {
        if (this.isLocked()) {
            return;
        }
        if (bl) {
            this.metaData = null;
        }
        if (image != null) {
            this.canvas = UI.toBufferedImage(image, false);
        }
        this.updateScrollPane();
        ImageEditor imageEditor = this.getEditor();
        imageEditor.imageInfo.update(imageEditor.getMetaInfo(), this.canvas);
        this.selectionTool.clear();
    }

    public ImageEditor getEditor() {
        return (ImageEditor)this.editorRef.get();
    }

    public IIOMetadata getMetaData() {
        return this.metaData;
    }

    public BufferedImage getSelectedImage() {
        return this.selectionTool.getImage(this.canvas);
    }

    public ToolManager getToolManager() {
        return this.toolManager;
    }

    public void insertImage(Image image) {
        this.modifyCanvas(image, 3);
    }

    @Override
    public synchronized boolean isLocked() {
        return this.canvasLock.isLocked();
    }

    @Override
    public void setLocked(boolean bl) {
        if (bl && this.toolManager.getCurrent() != this.selectionTool) {
            this.setTool(this.selectionTool);
        } else {
            this.updateCursor();
        }
    }

    public boolean isSelection() {
        return this.selectionTool.isSelection();
    }

    public void loadFromFile(final InputStream inputStream, final boolean bl) throws Exception {
        this.newFile = bl;
        ImageEditor imageEditor = this.getEditor();
        MetaInfo metaInfo = imageEditor.getMetaInfo();
        imageEditor.imageInfo.update(metaInfo, null);
        imageEditor.updateActions();
        if (imageEditor.isAsyncLoad() && !Presentation.isActive()) {
            this.loader = new MSwingWorker<BufferedImage>((Object)this, metaInfo.toString()){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public BufferedImage doInBackground() throws Exception {
                    ImageEditorCore.this.canvasLock.lock();
                    try {
                        ImagePreloader.Data data;
                        if (bl) {
                            BufferedImage bufferedImage = null;
                            return bufferedImage;
                        }
                        BufferedImage bufferedImage = null;
                        if (ImagePreloader.isMetaInfo(ImageEditorCore.this.getEditor().getMetaInfo()) && (data = ImagePreloader.getData()) != null) {
                            bufferedImage = data.getImage();
                        }
                        if (bufferedImage == null) {
                            bufferedImage = ImageEditorCore.this.readImage(inputStream);
                        }
                        data = bufferedImage;
                        return data;
                    }
                    finally {
                        ImageEditorCore.this.canvasLock.unlock();
                        FS.close(inputStream);
                    }
                }

                @Override
                protected void onError(Throwable throwable, boolean bl2) {
                    ImageEditorCore.this.loadError = throwable;
                    ImageEditorCore.this.repaint();
                    if (throwable instanceof OutOfMemoryError) {
                        MStatusBar.error(throwable);
                        ImagePreloader.stop();
                        if (!MLogger.isDeveloper()) {
                            MLogger.exception(throwable);
                        }
                    } else {
                        super.onError(throwable, bl2);
                    }
                }

                @Override
                protected void onSuccess(BufferedImage bufferedImage) {
                    try {
                        ImageEditorCore.this.setNewImage(bufferedImage);
                        MetaInfo metaInfo = NavigationUtils.getNextFile(ImageEditorCore.this.getEditor().getMetaInfo());
                        if (metaInfo != null && ((Boolean)Vars.preloaderImage.get()).booleanValue() && !metaInfo.isEncrypted() && Tabs.getInstance().findEditor(metaInfo) == -1) {
                            ImagePreloader.start(metaInfo);
                        }
                    }
                    catch (OutOfMemoryError outOfMemoryError) {
                        MStatusBar.error(outOfMemoryError);
                        ImagePreloader.stop();
                    }
                }
            };
            this.loader.start();
        } else {
            this.setNewImage(this.readImage(inputStream));
        }
    }

    public void modifyCanvas(Image image) {
        this.modifyCanvas(image, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void modifyCanvas(Image image, int n) {
        try {
            Flags flags = new Flags(n);
            UI.setWaitCursor(true);
            this.beforeModification();
            if (flags.isSet(1L)) {
                Graphics2D graphics2D = this.canvas.createGraphics();
                if (flags.isSet(2L) && this.selectionTool.isSelection()) {
                    Rectangle rectangle = this.selectionTool.getBounds();
                    graphics2D.drawImage(image, rectangle.x, rectangle.y, null);
                } else {
                    graphics2D.drawImage(image, 0, 0, null);
                }
                graphics2D.dispose();
            } else {
                this.setCanvas(image);
            }
            this.afterModification();
        }
        finally {
            UI.setWaitCursor(false);
        }
    }

    public boolean paste() {
        try {
            Image image = MClipboard.getImage();
            if (image == null) {
                return false;
            }
            this.modifyCanvas(image);
            this.setTool(this.selectionTool);
            return true;
        }
        catch (Exception exception) {
            MLogger.exception(exception);
            return false;
        }
    }

    public void saveToFileAs(String string, OutputStream outputStream) throws Exception {
        this.saveToFileAs(string, outputStream, false);
    }

    public void saveToFileAs(String string, OutputStream outputStream, boolean bl) throws Exception {
        if (this.isLocked() || this.canvas == null) {
            return;
        }
        if (bl) {
            this.modificationLevel = 0;
        }
        this.newFile = false;
        BufferedImage bufferedImage = new BufferedImage(this.canvas.getWidth(), this.canvas.getHeight(), UI.getTypeForImageFormat(string));
        Graphics2D graphics2D = bufferedImage.createGraphics();
        if (this.getEditor().isExportMode()) {
            graphics2D.setColor(Color.WHITE);
            graphics2D.fillRect(0, 0, bufferedImage.getWidth(), bufferedImage.getHeight());
        }
        graphics2D.drawImage(this.canvas, 0, 0, null, null);
        graphics2D.dispose();
        ImageIO.write((RenderedImage)bufferedImage, string, outputStream);
    }

    public static double getScale() {
        return scale;
    }

    public void setScale(double d, boolean bl) {
        if (this.scaleAnimation != null) {
            this.scaleAnimation.setEnabled(false);
            this.scaleAnimation.cancel();
            this.scaleAnimation = null;
            this.repaint();
        }
        scale = Math.max(d, 1.0);
        if (!bl || this.canvas != null && this.canvas.getWidth() > 1024) {
            this.currentScale = scale;
            this.repaint();
            return;
        }
        this.scaleAnimation = new MTimeline<ImageEditorCore>(this, 100L);
        this.scaleAnimation.addPropertyToInterpolate(MTimeline.property("currentScale").from(this.currentScale).to(scale).getWith(new TimelinePropertyBuilder.PropertyGetter<Double>(){

            @Override
            public Double get(Object object, String string) {
                return ImageEditorCore.this.currentScale;
            }
        }).setWith(new TimelinePropertyBuilder.PropertySetter<Double>(){

            @Override
            public void set(Object object, String string, Double d) {
                ImageEditorCore.this.currentScale = d;
                ImageEditorCore.this.repaint();
            }
        }));
        this.scaleAnimation.play();
    }

    public void setTool(Tool tool) {
        Tool tool2 = this.toolManager.getCurrent();
        if (tool != tool2) {
            this.toolManager.setCurrent(tool);
            tool.activate();
            this.getEditor().getEditorDesigner().update(this, true);
            this.repaint();
        }
    }

    public void shutDown() {
        this.scaleAnimation = TK.dispose(this.scaleAnimation);
        this.loader = TK.dispose(this.loader);
        this.canvas = null;
        this.removeMouseListener(this);
        this.removeMouseMotionListener(this);
        this.removeMouseWheelListener(this);
    }

    public void updateCursor() {
        if (!this.toolManager.getCurrent().isLocked() && !this.canDraw()) {
            this.setCursor(0);
        } else {
            this.setCursor(this.toolManager.getCurrent().getCursor());
        }
    }

    @Override
    public void imageComplete(ImageReader imageReader) {
    }

    @Override
    public void imageProgress(ImageReader imageReader, final float f) {
        UI.invokeLater(new Runnable(){

            @Override
            public void run() {
                ImageEditorCore.this.loadProgress = (int)f;
                ImageEditorCore.this.repaint();
            }
        });
    }

    @Override
    public void imageStarted(ImageReader imageReader, int n) {
    }

    @Override
    public void readAborted(ImageReader imageReader) {
    }

    @Override
    public void sequenceComplete(ImageReader imageReader) {
    }

    @Override
    public void sequenceStarted(ImageReader imageReader, int n) {
    }

    @Override
    public void thumbnailComplete(ImageReader imageReader) {
    }

    @Override
    public void thumbnailProgress(ImageReader imageReader, float f) {
    }

    @Override
    public void thumbnailStarted(ImageReader imageReader, int n, int n2) {
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
        if (!MMouseAdapter.isLeft(mouseEvent)) {
            return;
        }
        if (this.toolManager.getCurrent() == this.selectionTool && MMouseAdapter.isDoubleClick(mouseEvent) && ((Boolean)Vars.actionPresentation.get()).booleanValue()) {
            mouseEvent.consume();
            Presentation.setActive(!Presentation.isActive());
            return;
        }
        this.getEditor().focus();
        this.toolManager.getCurrent().mouseClicked(mouseEvent);
        mouseEvent.consume();
    }

    @Override
    public void mouseDragged(MouseEvent mouseEvent) {
        if (!MMouseAdapter.isLeft(mouseEvent)) {
            return;
        }
        if (!this.toolManager.getCurrent().isLocked() && !this.canDraw()) {
            return;
        }
        this.toolManager.getCurrent().mouseDragged(mouseEvent);
        MScrollPane.autoScroll(this, mouseEvent.getX(), mouseEvent.getY());
        mouseEvent.consume();
    }

    @Override
    public void mouseEntered(MouseEvent mouseEvent) {
        this.toolManager.getCurrent().mouseEntered(mouseEvent);
        mouseEvent.consume();
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
        this.toolManager.getCurrent().mouseExited(mouseEvent);
        mouseEvent.consume();
    }

    @Override
    public void mouseMoved(MouseEvent mouseEvent) {
        this.toolManager.getCurrent().mouseMoved(mouseEvent);
        mouseEvent.consume();
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
        if (!this.toolManager.getCurrent().isLocked()) {
            if (MMouseAdapter.isLeft(mouseEvent)) {
                this.getEditor().showLockInfo();
            }
            if (!this.canDraw()) {
                return;
            }
        }
        if (!MMouseAdapter.isLeft(mouseEvent)) {
            return;
        }
        this.toolManager.getCurrent().mousePressed(mouseEvent);
        mouseEvent.consume();
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
        if (!MMouseAdapter.isLeft(mouseEvent)) {
            return;
        }
        if (!this.toolManager.getCurrent().isLocked() && !this.canDraw()) {
            return;
        }
        this.toolManager.getCurrent().mouseReleased(mouseEvent);
        mouseEvent.consume();
    }

    @Override
    public void mouseWheelMoved(MouseWheelEvent mouseWheelEvent) {
        boolean bl;
        boolean bl2 = bl = mouseWheelEvent.getWheelRotation() < 0;
        if (ImageEditor.mouseWheelReversedAction.isSelected()) {
            boolean bl3 = bl = !bl;
        }
        if (mouseWheelEvent.isControlDown()) {
            this.getEditor().zoom(bl ? EditorZoom.ZoomType.IN : EditorZoom.ZoomType.OUT);
            mouseWheelEvent.consume();
            return;
        }
        if (mouseWheelEvent.isConsumed()) {
            return;
        }
        switch (ImageEditor.mouseWheelFunction) {
            case NAVIGATE: {
                NavigationUtils.goToFile(bl);
                mouseWheelEvent.consume();
                break;
            }
            case ZOOM: {
                this.getEditor().zoom(bl ? EditorZoom.ZoomType.IN : EditorZoom.ZoomType.OUT);
                mouseWheelEvent.consume();
                break;
            }
            default: {
                this.toolManager.getCurrent().mouseWheelMoved(mouseWheelEvent);
                if (ImageEditor.autoZoom) break;
                MScrollPane.mouseWheelScroll(this, mouseWheelEvent);
                mouseWheelEvent.consume();
            }
        }
    }

    @Override
    protected void onPaint(Graphics2D graphics2D) {
        double d;
        if (this.canvas == null || this.isLocked()) {
            Color color;
            String string;
            this.fillBackground(graphics2D, Presentation.isActive() ? Color.BLACK : Color.GRAY);
            if (this.loadError != null) {
                string = UI._("Error: {0}", this.loadError);
                color = MHighlighter.ERROR_COLOR;
            } else {
                string = UI._("Loading... {0}", this.loadProgress + "%");
                color = null;
            }
            this.paintStatusText(graphics2D, string, color, false);
            return;
        }
        int n = this.canvas.getWidth();
        int n2 = this.canvas.getHeight();
        if (ImageEditor.autoZoom || Presentation.isActive()) {
            this.currentScale = d = UI.getAutoScale(new Dimension(this.canvas.getWidth(), this.canvas.getHeight()), this.getParent().getSize());
            scale = d;
        } else {
            d = this.currentScale;
        }
        graphics2D.scale(d, d);
        if (Presentation.isActive()) {
            this.fillBackground(graphics2D, Color.BLACK);
        } else {
            graphics2D.setColor(Color.WHITE);
            graphics2D.fillRect(0, 0, n, n2);
        }
        graphics2D.setRenderingHint(RenderingHints.KEY_RENDERING, d < 1.0 ? RenderingHints.VALUE_RENDER_QUALITY : RenderingHints.VALUE_RENDER_DEFAULT);
        int n3 = 0;
        int n4 = 0;
        if (Presentation.isActive()) {
            int n5 = (int)((double)n / d);
            int n6 = (int)((double)n2 / d);
            n3 = this.getWidth() / 2 - n5 / 2;
            n4 = this.getHeight() / 2 - n6 / 2;
        }
        graphics2D.drawImage((Image)this.canvas, n3, n4, null);
        if (!this.getEditor().isExportMode()) {
            ImageEditor imageEditor;
            Tool tool = this.toolManager.getCurrent();
            if (tool instanceof SelectionTool || this.canDraw()) {
                if (tool.getUseBrushTool()) {
                    BrushTool.getInstance().setup(graphics2D);
                }
                tool.draw(graphics2D, n, n2);
            }
            if ((imageEditor = (ImageEditor)this.editorRef.get()) != null && imageEditor.getSharedActionGroup().isSelected("show-grid")) {
                graphics2D.setColor(this.gridColor);
                graphics2D.setStroke(new BasicStroke(1.0f));
                for (int i = 0; i < n2; ++i) {
                    if (i % 15 != 0) continue;
                    graphics2D.drawLine(0, i, n - 1, i);
                }
            }
            if (this.messageText != null) {
                this.paintStatusText(graphics2D, this.messageText, MHighlighter.WARNING_COLOR, true);
            }
        }
    }

    @Override
    protected boolean processKeyBinding(KeyStroke keyStroke, KeyEvent keyEvent, int n, boolean bl) {
        if (bl && n == 1 && this.toolManager.processKeyBinding(keyStroke)) {
            return true;
        }
        return super.processKeyBinding(keyStroke, keyEvent, n, bl);
    }

    protected void updateScrollPane() {
        if (this.canvas == null) {
            return;
        }
        boolean bl = Presentation.isActive();
        Dimension dimension = new Dimension(this.canvas.getWidth(), this.canvas.getHeight());
        if (!bl) {
            dimension.width = (int)((double)dimension.width * scale);
            dimension.height = (int)((double)dimension.height * scale);
        }
        this.setPreferredSize(dimension);
        this.setSize(dimension);
        MScrollPane mScrollPane = MScrollPane.getScrollPane(this);
        mScrollPane.setScrollBarVisible(!Presentation.isActive());
        JViewport jViewport = mScrollPane.getViewport();
        Point point = jViewport.getViewPosition();
        jViewport.reshape(0, 0, dimension.width, dimension.height);
        if (!bl) {
            jViewport.setViewPosition(point);
        }
    }

    private void fireUndoableEditHappened(UndoableEdit undoableEdit) {
        if (this.undoSupport != null) {
            this.undoSupport.postEdit(undoableEdit);
        }
    }

    private void paintStatusText(Graphics2D graphics2D, String string, Color color, boolean bl) {
        UI.setTextAntialiasing(graphics2D, null);
        graphics2D.setColor(color == null ? MColor.getContrast(graphics2D.getColor()) : color);
        if (bl) {
            graphics2D.setFont(new Font("Dialog", 1, UI.getDefaultFontSize() * 2));
            MGraphics2D mGraphics2D = new MGraphics2D(graphics2D);
            JViewport jViewport = MScrollPane.getViewport(this);
            Point point = jViewport.getViewPosition();
            mGraphics2D.drawStringCentered(string, point.x, point.y, jViewport.getWidth(), jViewport.getHeight());
        } else {
            graphics2D.setFont(new Font("Dialog", 1, UI.getDefaultFontSize()));
            graphics2D.drawString(string, 10, graphics2D.getFontMetrics().getAscent() + 10);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private BufferedImage readImage(InputStream inputStream) throws IOException {
        this.metaData = null;
        String string = this.getEditor().getMetaInfo().getExtension();
        Iterator<ImageReader> iterator = ImageIO.getImageReadersBySuffix(string);
        if (!iterator.hasNext()) {
            return null;
        }
        BufferedImage bufferedImage = null;
        ImageInputStream imageInputStream = ImageIO.createImageInputStream(inputStream);
        ImageReader imageReader = null;
        try {
            imageReader = iterator.next();
            imageReader.addIIOReadProgressListener(this);
            imageReader.setInput(imageInputStream, false, false);
            bufferedImage = imageReader.read(0, imageReader.getDefaultReadParam());
            this.metaData = imageReader.getImageMetadata(0);
            imageReader.dispose();
        }
        finally {
            if (imageReader != null) {
                imageReader.removeIIOReadProgressListener(this);
            }
            if (imageInputStream != null) {
                imageInputStream.close();
            }
        }
        return bufferedImage;
    }

    private void setModificationLevel(int n) {
        MLogger.debug("image", "Modification level: %d", n);
        this.modificationLevel = n;
        this.getEditor().setModified(this.newFile || this.modificationLevel != 0);
    }

    private void setNewImage(BufferedImage bufferedImage) {
        if (bufferedImage == null) {
            this.setCanvas(UI.createCompatibleImage(800, 600, true));
            this.toolManager.setActive(BrushTool.getInstance());
        } else {
            this.setCanvas(bufferedImage, false);
            this.setTool(this.selectionTool);
        }
        this.getEditor().updateActions();
    }

    void doUpdateDesigner(boolean bl) {
        if (this.toolManager.getCurrent() instanceof SelectionTool) {
            this.setTool(BrushTool.getInstance());
        }
        this.getEditor().getEditorDesigner().update(this, bl);
    }

    void setMessageText(String string) {
        if (TK.isChange(string, this.messageText)) {
            this.messageText = string;
            this.repaint();
        }
    }

    private final class Undo
    extends AbstractUndoableEdit {
        private Point scrollPosition;
        private Rectangle selection;
        private String fileBuf;
        private Undo redo;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Undo(BufferedImage bufferedImage) {
            ObjectOutputStream objectOutputStream = null;
            try {
                File file = File.createTempFile("undo", null);
                file.deleteOnExit();
                this.fileBuf = file.getPath();
                ImageEditorCore.this.undos.add(this.fileBuf);
                JViewport jViewport = MScrollPane.getViewport(ImageEditorCore.this);
                this.scrollPosition = jViewport == null ? null : jViewport.getViewPosition();
                this.selection = ImageEditorCore.this.getSelectionTool().isSelection() ? new Rectangle(ImageEditorCore.this.getSelectionTool().getBounds()) : null;
                objectOutputStream = new ObjectOutputStream(new FS.BufferedFileOutput(this.fileBuf));
                objectOutputStream.writeObject(new MIcon(bufferedImage));
                FS.close(objectOutputStream);
            }
            catch (IOException iOException) {
                MLogger.exception(iOException);
            }
            finally {
                FS.close(objectOutputStream);
            }
        }

        @Override
        public void redo() {
            super.redo();
            if (this.redo != null) {
                this.redo.restoreImage();
                ImageEditorCore.this.setModificationLevel(ImageEditorCore.this.modificationLevel + 1);
            }
        }

        @Override
        public void undo() {
            super.undo();
            ImageEditorCore.this.setModificationLevel(ImageEditorCore.this.modificationLevel - 1);
            this.restoreImage();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Loose catch block
         */
        private void restoreImage() {
            block9: {
                ObjectInputStream objectInputStream = null;
                try {
                    JViewport jViewport;
                    objectInputStream = new ObjectInputStream(new FS.BufferedFileInput(this.fileBuf));
                    MIcon mIcon = (MIcon)objectInputStream.readObject();
                    ImageEditorCore.this.setCanvas(mIcon.getImage());
                    ImageEditorCore.this.afterModification();
                    if (this.selection != null) {
                        ImageEditorCore.this.getSelectionTool().setBounds(this.selection);
                    }
                    if (this.scrollPosition != null && (jViewport = MScrollPane.getViewport(ImageEditorCore.this)) != null) {
                        jViewport.setViewPosition(this.scrollPosition);
                    }
                    FS.close(objectInputStream);
                }
                catch (ClassNotFoundException classNotFoundException) {
                    MLogger.exception(classNotFoundException);
                }
                catch (IOException iOException) {
                    MLogger.exception(iOException);
                    break block9;
                    {
                        catch (Throwable throwable) {
                            throw throwable;
                        }
                    }
                }
                finally {
                    FS.close(objectInputStream);
                }
            }
        }
    }
}

