/*
 * Decompiled with CFR 0.152.
 */
package org.makagiga.editors.image.tools;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.Stroke;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import org.makagiga.commons.MColor;
import org.makagiga.commons.MGraphics2D;
import org.makagiga.commons.TK;
import org.makagiga.commons.UI;
import org.makagiga.editors.image.tools.Tool;

public class BrushTool
extends Tool {
    public static final int DEFAULT_OPACITY = 255;
    public static final int DEFAULT_SIZE = 3;
    public static final int MAX_OPACITY = 255;
    public static final int MIN_OPACITY = 0;
    public static final int MAX_SIZE = 50;
    public static final int MIN_SIZE = 1;
    public static final int MEDIUM_SIZE = 24;
    private static BrushTool _instance = new BrushTool();
    private Color color = Color.BLUE;
    private int size = 3;
    private final Polygon polygon = new Polygon();
    private Type type = Type.CIRCLE;

    @Deprecated
    public BrushTool() {
        super(UI._("Brush"), "brush");
        this.setKeyStroke(80);
        this.setUpdateOnMouseRelease(true);
        this.setVisiblePanel("brush-color", true);
        this.setVisiblePanel("brush-properties", true);
    }

    @Override
    public void draw(Graphics2D graphics2D, int n, int n2) {
        if (this.polygon.npoints == 0) {
            return;
        }
        if (this.polygon.npoints == 1) {
            this.drawPoint(graphics2D, this.polygon.xpoints[0], this.polygon.ypoints[0]);
        } else {
            graphics2D.drawPolyline(this.polygon.xpoints, this.polygon.ypoints, this.polygon.npoints);
        }
    }

    public Color getColor() {
        return this.color;
    }

    public void setColor(Color color) {
        this.color = MColor.deriveAlpha(color, this.getOpacity());
    }

    public static BrushTool getInstance() {
        return _instance;
    }

    public int getOpacity() {
        return this.color.getAlpha();
    }

    public void setOpacity(int n) {
        int n2 = TK.range(n, 255, 0, 255);
        this.color = MColor.deriveAlpha(this.color, n2);
    }

    public Image getPreview() {
        return this.getPreview(0);
    }

    @Deprecated
    public Image getPreview(int n) {
        int n2 = 50;
        int n3 = 50;
        BufferedImage bufferedImage = UI.createCompatibleImage(n2, n3, true);
        Graphics2D graphics2D = bufferedImage.createGraphics();
        if (this.getOpacity() < 255) {
            graphics2D.setColor(Color.WHITE);
            graphics2D.fillRect(0, 0, n2, n3);
            graphics2D.setColor(Color.LIGHT_GRAY);
            Rectangle rectangle = new Rectangle(0, 0, n2 / 2, n3 / 2);
            graphics2D.fill(rectangle);
            rectangle.translate(rectangle.width, rectangle.height);
            graphics2D.fill(rectangle);
        }
        this.setup(graphics2D);
        this.drawPoint(graphics2D, n2 / 2, n3 / 2);
        graphics2D.dispose();
        return bufferedImage;
    }

    public int getSize() {
        return this.size;
    }

    public void setSize(int n) {
        this.size = n < 1 ? 1 : (n > 50 ? 50 : n);
    }

    public Type getType() {
        return this.type;
    }

    public void setType(Type type) {
        this.type = type;
    }

    public Stroke getStroke() {
        if (this.type == Type.CIRCLE) {
            return new BasicStroke(this.size, 1, 1);
        }
        return new BasicStroke(this.size, 2, 0);
    }

    public void setup(Graphics2D graphics2D) {
        UI.setAntialiasing(graphics2D, true);
        graphics2D.setColor(this.color);
        graphics2D.setStroke(this.getStroke());
    }

    @Override
    public void mouseDragged(MouseEvent mouseEvent) {
        Point point = this.convertPoint(mouseEvent);
        this.polygon.addPoint(point.x, point.y);
        this.core.repaint();
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
        Point point = this.convertPoint(mouseEvent);
        this.polygon.addPoint(point.x, point.y);
        this.core.repaint();
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
        super.mouseReleased(mouseEvent);
        this.polygon.reset();
    }

    private void drawPoint(Graphics2D graphics2D, int n, int n2) {
        if (this.type == Type.SQUARE) {
            int n3 = this.size / 2;
            graphics2D.fillRect(n - n3, n2 - n3, this.size, this.size);
        } else {
            MGraphics2D.drawPoint(graphics2D, n, n2);
        }
    }

    BrushTool(String string, String string2) {
        super(string, string2);
        this.setUpdateOnMouseRelease(true);
        this.setVisiblePanel("brush-color", true);
        this.setVisiblePanel("brush-properties", true);
    }

    public static enum Type {
        CIRCLE,
        SQUARE;

    }
}

