/*
 * Decompiled with CFR 0.152.
 */
package org.makagiga.editors.image.tools;

import javax.swing.KeyStroke;
import org.makagiga.commons.MToggleButton;
import org.makagiga.commons.TK;
import org.makagiga.editors.Editor;
import org.makagiga.editors.image.ImageEditorCore;
import org.makagiga.editors.image.tools.Tool;

public final class ToolButton
extends MToggleButton {
    private final Tool tool;

    public ToolButton(Tool tool) {
        this.setIcon(tool.getIcon());
        this.setRequestFocusEnabled(false);
        if (this.getIcon() == null) {
            this.setText(tool.getName());
        } else {
            StringBuilder stringBuilder = new StringBuilder(tool.getName());
            KeyStroke keyStroke = tool.getKeyStroke();
            if (keyStroke != null) {
                stringBuilder.append(" (").append(TK.toString(keyStroke)).append(')');
            }
            this.setToolTipText(stringBuilder.toString());
        }
        this.tool = tool;
    }

    public Tool getTool() {
        return this.tool;
    }

    @Override
    protected void onClick() {
        ImageEditorCore imageEditorCore = Editor.getCurrentCore(ImageEditorCore.class);
        if (imageEditorCore != null) {
            imageEditorCore.getToolManager().setActive(this.tool);
        }
    }
}

