/*
 * Decompiled with CFR 0.152.
 */
package org.makagiga.editors.text;

import java.awt.Cursor;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.ref.WeakReference;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Element;
import javax.swing.text.MutableAttributeSet;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.html.HTML;
import javax.swing.text.html.HTMLDocument;
import org.makagiga.commons.ActionGroup;
import org.makagiga.commons.Config;
import org.makagiga.commons.HTMLBuilder;
import org.makagiga.commons.MAction;
import org.makagiga.commons.MArrayList;
import org.makagiga.commons.MDialog;
import org.makagiga.commons.MLinkAction;
import org.makagiga.commons.MLogger;
import org.makagiga.commons.MMenu;
import org.makagiga.commons.MText;
import org.makagiga.commons.MToolBar;
import org.makagiga.commons.TK;
import org.makagiga.commons.UI;
import org.makagiga.editors.AbstractTextEditor;
import org.makagiga.editors.Actions;
import org.makagiga.editors.AnnotationBar;
import org.makagiga.editors.AnnotationInfo;
import org.makagiga.editors.Editor;
import org.makagiga.editors.EditorAnnotation;
import org.makagiga.editors.EditorConfig;
import org.makagiga.editors.EditorDesigner;
import org.makagiga.editors.EditorExport;
import org.makagiga.editors.EditorIO;
import org.makagiga.editors.EditorPlugin;
import org.makagiga.editors.text.TextEditorCore;
import org.makagiga.editors.text.TextEditorDesigner;
import org.makagiga.editors.text.TextEditorDocument;
import org.makagiga.editors.text.TextEditorKit;
import org.makagiga.form.Default;
import org.makagiga.form.Field;
import org.makagiga.form.Form;
import org.makagiga.form.FormPanel;
import org.makagiga.richtext.RichText;
import org.makagiga.tools.EditorQuickFind;

public final class TextEditor
extends AbstractTextEditor<TextEditorCore>
implements CaretListener,
EditorAnnotation,
EditorConfig,
EditorDesigner<TextEditorDesigner>,
EditorExport,
EditorIO {
    private RichText richText;

    public TextEditor() {
        super(new TextEditorCore());
        this.richText = new RichText((JEditorPane)this.core);
        ((TextEditorCore)this.core).editorRef = new WeakReference<TextEditor>(this);
        ((TextEditorCore)this.core).addCaretListener(this);
    }

    @Override
    public void caretUpdate(CaretEvent caretEvent) {
        TextEditorDesigner.getInstance().update((TextEditorCore)this.core);
    }

    @Override
    public Collection<MLinkAction> getDocumentLinks() {
        HTMLDocument.Iterator iterator = ((TextEditorCore)this.core).getDoc().getIterator(HTML.Tag.A);
        if (iterator == null) {
            return Collections.emptyList();
        }
        MArrayList<MLinkAction> mArrayList = null;
        while (iterator.isValid()) {
            AttributeSet attributeSet = iterator.getAttributes();
            Object object = attributeSet.getAttribute(HTML.Attribute.HREF);
            if (object != null) {
                try {
                    MLinkAction mLinkAction = new MLinkAction(new URI(object.toString()));
                    try {
                        String string = ((TextEditorDocument)((TextEditorCore)this.core).getDocument()).getText(iterator.getStartOffset(), iterator.getEndOffset() - iterator.getStartOffset());
                        if (!TK.isEmpty(string)) {
                            mLinkAction.setName(string);
                        }
                    }
                    catch (BadLocationException badLocationException) {
                        // empty catch block
                    }
                    if (mArrayList == null) {
                        mArrayList = new MArrayList<MLinkAction>();
                    }
                    mArrayList.add(mLinkAction);
                }
                catch (URISyntaxException uRISyntaxException) {
                    MLogger.exception(uRISyntaxException);
                }
            }
            iterator.next();
        }
        return mArrayList == null ? Collections.emptyList() : mArrayList;
    }

    @Override
    public void onClose() {
        super.onClose();
        ((TextEditorCore)this.core).removeCaretListener(this);
        this.richText = TK.dispose(this.richText);
    }

    @Override
    public void onLastClose() {
        TextEditorDesigner.freeInstance();
    }

    @Override
    public void updateActions() {
        super.updateActions();
        if (this.isCurrent()) {
            ActionGroup actionGroup = this.getSharedActionGroup();
            actionGroup.setEnabled("insert-line", !this.isLocked());
            actionGroup.setEnabled("insert-link", !this.isLocked());
        }
    }

    @Override
    public void addAnnotation(AnnotationInfo annotationInfo) {
    }

    @Override
    public void removeAnnotation(AnnotationInfo annotationInfo) {
    }

    @Override
    public void editAnnotation(AnnotationInfo annotationInfo) {
    }

    @Override
    public List<AnnotationInfo> getAnnotations() {
        return Collections.emptyList();
    }

    @Override
    public int getAnnotationCapabilities() {
        return 0;
    }

    @Override
    public AnnotationInfo newAnnotation() {
        return null;
    }

    @Override
    public void paintAnnotations(JComponent jComponent, Graphics2D graphics2D, Rectangle rectangle) {
    }

    @Override
    public void updateAnnotationBar() {
        TextEditorDesigner textEditorDesigner = this.getEditorDesigner();
        textEditorDesigner.getHighlightActionGroup().updateToolBar(AnnotationBar.getInstance());
    }

    @Override
    public void loadConfig(Config config) {
        this.restorePosition(config);
    }

    @Override
    public void saveConfig(Config config) {
        this.writePosition(config);
    }

    @Override
    public TextEditorDesigner getEditorDesigner() {
        return TextEditorDesigner.getInstance();
    }

    @Override
    public void updateEditorDesigner() {
    }

    @Override
    public void exportFile(EditorPlugin.FileType fileType, OutputStream outputStream) throws Exception {
        if (fileType.is("html")) {
            ((TextEditorCore)this.core).saveToFileAsHTML(outputStream, this.getMetaInfo().toString());
        } else if (fileType.is("txt")) {
            ((TextEditorCore)this.core).saveToFileAsText(outputStream);
        } else {
            this.exportNotSupported(fileType);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void loadFile(InputStream inputStream, boolean bl) throws Exception {
        if (bl && this.getMetaInfo().isWriteable()) {
            HTMLBuilder hTMLBuilder = new HTMLBuilder();
            hTMLBuilder.beginHTML(this.getMetaInfo().toString(), "UTF-8");
            hTMLBuilder.beginDoc();
            hTMLBuilder.doubleTag("p", null, new Object[0]);
            hTMLBuilder.endDoc();
            hTMLBuilder.save(this.getMetaInfo().getFilePath());
        }
        ((TextEditorCore)this.core).setContentType("text/html; charset=UTF-8");
        ((TextEditorCore)this.core).setEditorKit(new TextEditorKit());
        try {
            MText.loadHTML((JEditorPane)this.core, inputStream);
        }
        finally {
            ((TextEditorKit)((TextEditorCore)this.core).getEditorKit()).setDefaultCursor(Cursor.getPredefinedCursor(2));
            MAction.fire("caret-begin", (JComponent)this.core);
        }
        EditorQuickFind.autoSearch();
    }

    @Override
    public void saveFile(OutputStream outputStream) throws Exception {
        ((TextEditorCore)this.core).saveToFileAsHTML(outputStream, this.getMetaInfo().toString());
        this.updateIndex(((TextEditorCore)this.core).getPlainText());
    }

    @Override
    public void updateMenu(String string, MMenu mMenu) {
        super.updateMenu(string, mMenu);
        if (string.equals("EDIT_MENU")) {
            mMenu.addSeparator();
            ActionGroup actionGroup = this.getSharedActionGroup();
            mMenu.add((Action)actionGroup.getAction("insert-line"));
            mMenu.add((Action)actionGroup.getAction("insert-link"));
            mMenu.addSeparator();
            TextEditorDesigner textEditorDesigner = this.getEditorDesigner();
            mMenu.add(textEditorDesigner.getStyleActionGroup().createMenu(UI._("Style")));
            mMenu.add(textEditorDesigner.getHighlightActionGroup().createMenu(UI._("Highlight")));
        } else if (string.equals("VIEW_MENU_EDITOR")) {
            ActionGroup actionGroup = this.getSharedActionGroup();
            mMenu.add((Action)actionGroup.getAction("show-html"));
        }
    }

    @Override
    @Deprecated
    public void updateToolBar(String string, MToolBar mToolBar) {
        super.updateToolBar(string, mToolBar);
    }

    @Override
    protected ActionGroup createSharedActionGroup() {
        ActionGroup actionGroup = new ActionGroup();
        actionGroup.add("insert-line", new InsertLineAction());
        actionGroup.add("insert-link", new InsertLinkAction());
        actionGroup.add("show-html", new ShowHTMLAction());
        return actionGroup;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void insertEditLink() {
        Object object2;
        TextEditorDocument textEditorDocument = (TextEditorDocument)((TextEditorCore)this.core).getDocument();
        TextEditorKit textEditorKit = (TextEditorKit)((TextEditorCore)this.core).getEditorKit();
        boolean bl = false;
        LinkForm linkForm = new LinkForm();
        SimpleAttributeSet simpleAttributeSet = null;
        MutableAttributeSet mutableAttributeSet = ((TextEditorCore)this.core).getInputAttributes();
        for (Object object2 : TK.iterable(mutableAttributeSet.getAttributeNames())) {
            if (!object2.equals(HTML.Tag.A)) continue;
            object2 = mutableAttributeSet.getAttribute(HTML.Tag.A);
            if (!(object2 instanceof SimpleAttributeSet)) break;
            bl = true;
            simpleAttributeSet = (SimpleAttributeSet)object2;
            linkForm.url = (object2 = simpleAttributeSet.getAttribute(HTML.Attribute.HREF)) == null ? null : object2.toString();
            break;
        }
        Object object3 = null;
        if (bl) {
            object3 = textEditorKit.getCharacterAttributeRun();
            linkForm.name = ((TextEditorCore)this.core).getText((Element)object3);
        }
        object2 = new FormPanel<LinkForm>(linkForm);
        ((FormPanel)object2).setLabel("name", UI._("Link Name:"));
        ((FormPanel)object2).setLabel("url", UI._("Link Address:"));
        if (!((FormPanel)object2).createDialog(this.getWindowAncestor(), bl ? UI._("Change Link") : UI._("Insert Link")).exec()) {
            return;
        }
        if (linkForm.name.isEmpty()) {
            linkForm.name = linkForm.url;
        }
        if (bl && object3 != null) {
            try {
                textEditorDocument.setWriteLock(true);
                int n = object3.getStartOffset();
                int n2 = object3.getEndOffset();
                SimpleAttributeSet simpleAttributeSet2 = new SimpleAttributeSet();
                simpleAttributeSet2.addAttributes(simpleAttributeSet.copyAttributes());
                simpleAttributeSet2.addAttribute(HTML.Attribute.HREF, linkForm.url);
                SimpleAttributeSet simpleAttributeSet3 = new SimpleAttributeSet();
                simpleAttributeSet3.addAttributes(mutableAttributeSet.copyAttributes());
                simpleAttributeSet3.addAttribute(HTML.Tag.A, simpleAttributeSet2);
                textEditorDocument.replace(n, n2 - n, linkForm.name, simpleAttributeSet3);
            }
            catch (BadLocationException badLocationException) {
                MLogger.exception(badLocationException);
            }
            finally {
                textEditorDocument.setWriteLock(false);
            }
        } else {
            ((TextEditorCore)this.getCore()).insertHTML(HTMLBuilder.createLink(linkForm.url, linkForm.name));
        }
    }

    @Form(order={"url", "name"}, pack=480)
    private static final class LinkForm {
        @Default
        @Field(autoCompletion="linkurl", required=true)
        private String url;
        @Field(autoCompletion="linkname")
        private String name;

        private LinkForm() {
        }
    }

    private static final class InsertLinkAction
    extends Actions.Base<TextEditor> {
        public InsertLinkAction() {
            super(UI._("Insert/Change Link"), 76, 3);
            this.setHTMLHelp(UI._("Inserts a new link or changes an existing selected link."));
        }

        @Override
        public void onAction(TextEditor textEditor) {
            textEditor.insertEditLink();
        }
    }

    private static final class InsertLineAction
    extends Actions.Base<TextEditor> {
        public InsertLineAction() {
            super(UI._("Insert Horizontal Line"), 82, 3);
            this.setHTMLHelp(UI._("Inserts a horizontal line."));
        }

        @Override
        public void onAction(TextEditor textEditor) {
            ((TextEditorCore)textEditor.getCore()).insertHTML("<hr>");
        }
    }

    @Form(pack=0)
    public static final class ShowHTMLAction
    extends Actions.Base<TextEditor> {
        @Field(label="HTML", readOnly=true, type=2)
        private String html;

        public String getHtml() {
            return Editor.getCurrentCore(TextEditorCore.class).getText();
        }

        @Override
        public void onAction(TextEditor textEditor) {
            FormPanel<ShowHTMLAction> formPanel = new FormPanel<ShowHTMLAction>(this);
            int n = 100;
            MDialog mDialog = formPanel.createDialog(this.getSourceWindow(), this.getName(), this.getIconName(), n);
            mDialog.setSize(UI.WindowSize.LARGE);
            mDialog.exec();
        }

        private ShowHTMLAction() {
            super(UI._("Show HTML"), 72, 3);
            this.setEnabled(true);
            this.setHTMLHelp(UI._("Shows HTML code for the active document."));
        }
    }
}

