/*
 * Decompiled with CFR 0.152.
 */
package org.makagiga.editors.todo;

import java.awt.BorderLayout;
import org.makagiga.commons.HTMLBuilder;
import org.makagiga.commons.Linkify;
import org.makagiga.commons.MButton;
import org.makagiga.commons.MColor;
import org.makagiga.commons.MDisposable;
import org.makagiga.commons.MHTMLViewer;
import org.makagiga.commons.MTimer;
import org.makagiga.commons.UI;
import org.makagiga.editors.Designer;
import org.makagiga.editors.Editor;
import org.makagiga.editors.todo.TodoEditor;
import org.makagiga.editors.todo.TodoEditorCore;
import org.makagiga.todo.Column;
import org.makagiga.todo.SummaryEditor;
import org.makagiga.todo.Task;
import org.makagiga.todo.TaskModel;

public final class TodoEditorDesigner
extends Designer
implements MDisposable {
    private boolean hasValidSelection;
    private MButton summaryEditButton;
    private MHTMLViewer summaryViewer;
    private MTimer updateTimer;

    public TodoEditorDesigner() {
        super(new BorderLayout(5, 5));
        this.setDisplayText(UI._("Properties"));
        this.summaryViewer = new MHTMLViewer();
        this.summaryEditButton = new MButton(UI._("Edit Summary...")){

            @Override
            protected void onClick() {
                Editor<?> editor = Editor.getCurrentEditor();
                if (editor instanceof TodoEditor) {
                    ((TodoEditor)TodoEditor.class.cast(editor)).getEditorDesigner().editSummary();
                }
            }
        };
        this.addCenter(this.summaryViewer);
        this.addNorth(this.summaryEditButton);
    }

    @Override
    public void setLocked(boolean bl) {
        super.setLocked(bl);
        this.summaryEditButton.setEnabled(!bl && this.hasValidSelection);
    }

    @Override
    public final Object dispose(Object ... objectArray) {
        this.summaryEditButton = null;
        if (this.updateTimer != null) {
            this.updateTimer.stop();
            this.updateTimer = null;
        }
        return null;
    }

    private void editSummary() {
        TodoEditorCore todoEditorCore = Editor.getCurrentCore(TodoEditorCore.class);
        if (todoEditorCore == null) {
            return;
        }
        int n = todoEditorCore.convertRowIndexToModel(todoEditorCore.getSelectedRow());
        int n2 = Column.SUMMARY.ordinal();
        Task task = (Task)((TaskModel)todoEditorCore.getModel()).getRowAt(n);
        String string = SummaryEditor.edit(this.getWindowAncestor(), task.getSummary());
        if (string != null) {
            ((TaskModel)todoEditorCore.getModel()).setValueAt(string, n, n2);
            this.updateComponents(todoEditorCore);
        }
    }

    private void updateComponents(TodoEditorCore todoEditorCore) {
        HTMLBuilder hTMLBuilder = new HTMLBuilder();
        hTMLBuilder.beginHTML();
        hTMLBuilder.beginStyle();
        hTMLBuilder.beginRule("a");
        hTMLBuilder.addAttr("color", MColor.getLinkForeground(this.summaryViewer.getBackground()));
        hTMLBuilder.endRule();
        hTMLBuilder.beginRule("p, pre");
        hTMLBuilder.addAttr("margin-left", "0px");
        hTMLBuilder.addAttr("margin-right", "0px");
        hTMLBuilder.addAttr("margin-top", "5px");
        hTMLBuilder.addAttr("margin-bottom", "5px");
        hTMLBuilder.addAttr("padding", "0px");
        hTMLBuilder.endRule();
        hTMLBuilder.endStyle();
        hTMLBuilder.beginDoc();
        hTMLBuilder.addHeader(2, HTMLBuilder.escape(todoEditorCore.getSelectionText()));
        int n = todoEditorCore.getSelectedRowCount();
        boolean bl = this.hasValidSelection = n == 1;
        if (this.hasValidSelection) {
            this.summaryEditButton.setEnabled(!this.isLocked());
            Task task = (Task)((TaskModel)todoEditorCore.getModel()).getRowAt(todoEditorCore.convertRowIndexToModel(todoEditorCore.getSelectedRow()));
            hTMLBuilder.singleTag("hr", new Object[0]);
            hTMLBuilder.appendLine(task.getToolTipTable(false));
            hTMLBuilder.singleTag("hr", new Object[0]);
            String string = task.getSummary();
            hTMLBuilder.beginTag("p");
            Linkify linkify = Linkify.getInstance();
            string = linkify.apply(HTMLBuilder.escape(string));
            hTMLBuilder.appendLine(string.replace("\n", "<br>"));
            hTMLBuilder.endTag("p");
        } else {
            this.summaryEditButton.setEnabled(false);
        }
        hTMLBuilder.endDoc();
        this.summaryViewer.setHTML(hTMLBuilder);
    }

    void updateComponentsLater(final TodoEditorCore todoEditorCore) {
        if (this.updateTimer == null) {
            this.updateTimer = new MTimer(500){

                @Override
                protected boolean onTimeout() {
                    TodoEditorDesigner.this.updateComponents(todoEditorCore);
                    return false;
                }
            };
        }
        this.updateTimer.restart();
    }
}

