/*
 * Decompiled with CFR 0.152.
 */
package org.makagiga.fs;

import org.makagiga.commons.MMenu;
import org.makagiga.commons.MMenuAdapter;
import org.makagiga.commons.MV;
import org.makagiga.commons.UI;
import org.makagiga.fs.MetaInfo;
import org.makagiga.fs.MetaInfoAction;

public class MetaInfoMenu
extends MMenu {
    private MetaInfo root;

    public MetaInfoMenu(MetaInfo metaInfo) {
        super(metaInfo.toString(), metaInfo.getSmallIcon());
        this.root = metaInfo;
        this.setSplitMenu(true);
        if (metaInfo.isAnyFolder() || metaInfo.isFSRoot()) {
            this.addMenuListener(new MMenuAdapter(true){

                @Override
                protected void onSelect(MMenu mMenu) {
                    mMenu.removeAll();
                    mMenu.setSplitMenu(true);
                    MetaInfoMenu metaInfoMenu = (MetaInfoMenu)mMenu;
                    int n = metaInfoMenu.updateFolderItems();
                    for (MetaInfo metaInfo : metaInfoMenu.root.list(MV.MODEL)) {
                        if (!MetaInfoMenu.this.canAdd(metaInfo)) continue;
                        if (metaInfo.isAnyFolder() || metaInfo.isFSRoot()) {
                            mMenu.add(new MetaInfoMenu(metaInfo){

                                @Override
                                protected boolean canAdd(MetaInfo metaInfo) {
                                    return MetaInfoMenu.this.canAdd(metaInfo);
                                }

                                @Override
                                protected void onAction(MetaInfo metaInfo) {
                                    MetaInfoMenu.this.onAction(metaInfo);
                                }
                            });
                            continue;
                        }
                        mMenu.add(new Action(metaInfo));
                    }
                    if (metaInfoMenu.getItemCount() == n) {
                        metaInfoMenu.addTitle(UI._("No Items"));
                    }
                }
            });
        }
        this.updateItems(this.updateFolderItems());
    }

    protected boolean canAdd(MetaInfo metaInfo) {
        return true;
    }

    protected void onAction(MetaInfo metaInfo) {
    }

    private int updateFolderItems() {
        if (!this.root.isFSRoot()) {
            this.add(new Action(this.root, UI._("This Folder")));
            this.addSeparator();
            return 2;
        }
        return 0;
    }

    private void updateItems(int n) {
        for (MetaInfo metaInfo : this.root.list(MV.MODEL)) {
            if (!this.canAdd(metaInfo)) continue;
            this.add(new Action(metaInfo));
        }
        if (this.getItemCount() == n) {
            this.addTitle(UI._("No Items"));
        }
    }

    private final class Action
    extends MetaInfoAction {
        @Override
        public void onAction() {
            MetaInfoMenu.this.onAction((MetaInfo)this.getData());
        }

        private Action(MetaInfo metaInfo) {
            this(metaInfo, (String)null);
        }

        private Action(MetaInfo metaInfo, String string) {
            super(metaInfo, false);
            if (string != null) {
                this.setName(string);
            }
        }
    }
}

