/*
 * Decompiled with CFR 0.152.
 */
package org.makagiga.fs.dnd;

import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JTree;
import javax.swing.TransferHandler;
import javax.swing.tree.TreePath;
import org.makagiga.Vars;
import org.makagiga.commons.FS;
import org.makagiga.commons.FileSelection;
import org.makagiga.commons.MLogger;
import org.makagiga.commons.MMessage;
import org.makagiga.commons.MStatusBar;
import org.makagiga.commons.Net;
import org.makagiga.commons.TK;
import org.makagiga.commons.UI;
import org.makagiga.editors.EditorPlugin;
import org.makagiga.fs.FSException;
import org.makagiga.fs.FSHelper;
import org.makagiga.fs.MetaInfo;
import org.makagiga.fs.dnd.MetaInfoSelection;
import org.makagiga.fs.tree.TreeFS;
import org.makagiga.plugins.PluginInfo;
import org.makagiga.tags.TagsUtils;
import org.makagiga.tree.ImportExport;
import org.makagiga.tree.Tree;

public final class DnDTransferHandler
extends TransferHandler {
    private Object files;

    @Override
    public boolean canImport(TransferHandler.TransferSupport transferSupport) {
        if (((Boolean)Vars.treeReadOnly.get()).booleanValue()) {
            return false;
        }
        if (!transferSupport.isDrop()) {
            return false;
        }
        MetaInfo metaInfo = this.getMetaInfoUnderMouse(transferSupport);
        if (metaInfo == null) {
            return false;
        }
        if (this.files == null) {
            this.files = this.getFiles(transferSupport);
        }
        if (!(this.files instanceof ArrayList)) {
            return metaInfo.getFS() instanceof TreeFS && (metaInfo.isFSRoot() || metaInfo.isFolder()) && metaInfo.canModify();
        }
        MetaInfoSelection.MetaInfoList metaInfoList = null;
        if (this.files instanceof MetaInfoSelection.MetaInfoList) {
            metaInfoList = (MetaInfoSelection.MetaInfoList)this.files;
            if (!FSHelper.isSameFS(metaInfoList)) {
                return false;
            }
            if (!this.isValidFolder(metaInfo, false)) {
                return false;
            }
            boolean bl = transferSupport.getDropAction() == 2;
            for (MetaInfo metaInfo2 : metaInfoList) {
                if (metaInfo2.isFSRoot()) {
                    return false;
                }
                if (metaInfo2 == metaInfo) {
                    return false;
                }
                if (bl && !metaInfo2.canModify()) {
                    return false;
                }
                if (!metaInfo.getFS().canImport(metaInfo2)) {
                    return false;
                }
                if (bl && metaInfo2.getParentFolder() == metaInfo) {
                    return false;
                }
                if (!metaInfo.isNodeAncestor(metaInfo2)) continue;
                return false;
            }
            return true;
        }
        return true;
    }

    @Override
    public int getSourceActions(JComponent jComponent) {
        return 3;
    }

    @Override
    public Icon getVisualRepresentation(Transferable transferable) {
        return super.getVisualRepresentation(transferable);
    }

    @Override
    public boolean importData(TransferHandler.TransferSupport transferSupport) {
        if (!transferSupport.isDrop()) {
            return false;
        }
        MetaInfo metaInfo = this.getMetaInfoUnderMouse(transferSupport);
        if (metaInfo == null) {
            return false;
        }
        if (this.files instanceof MetaInfoSelection.MetaInfoList) {
            MetaInfoSelection.MetaInfoList metaInfoList = (MetaInfoSelection.MetaInfoList)this.files;
            if (metaInfoList.isEmpty()) {
                return false;
            }
            return metaInfo.getFS().importMetaInfos(metaInfo, transferSupport.getDropAction() == 2, metaInfoList);
        }
        if (this.files instanceof FileSelection.URIList) {
            if (this.isImportFailed(metaInfo)) {
                return false;
            }
            FileSelection.URIList uRIList = (FileSelection.URIList)this.files;
            boolean bl = transferSupport.getDropAction() == 0x40000000;
            boolean bl2 = false;
            for (URI uRI : uRIList) {
                String string = uRI.toString();
                if (bl || Net.isHTTP(string)) {
                    try {
                        String string2 = TK.centerSqueeze(TK.unescapeURL(string), 64);
                        MetaInfo metaInfo2 = ImportExport.createLinkFile(metaInfo, string2, null, string);
                        TagsUtils.addTag(metaInfo2, TagsUtils.AutoTag.IMPORTED);
                        metaInfo2.sync();
                    }
                    catch (FSException fSException) {
                        MMessage.error(null, fSException);
                    }
                    catch (IOException iOException) {
                        MMessage.error(null, iOException);
                    }
                    continue;
                }
                File file = new File(uRI);
                if (file.isDirectory()) {
                    bl2 = true;
                    continue;
                }
                if (!file.isFile()) continue;
                String string3 = FS.getExtension(file);
                PluginInfo pluginInfo = EditorPlugin.findPluginForExtension(string3);
                try {
                    if (pluginInfo == null) {
                        ImportExport.importFile(metaInfo, null, string3, file);
                        continue;
                    }
                    ImportExport.importFile(metaInfo, (EditorPlugin)pluginInfo.getPluggable(), string3, file);
                }
                catch (Exception exception) {
                    MMessage.error(null, exception, file);
                    break;
                }
            }
            if (bl2) {
                MStatusBar.warning(UI._("Folder import is not supported"));
            }
            return true;
        }
        if (this.files == null) {
            if (this.isImportFailed(metaInfo)) {
                return false;
            }
            Transferable transferable = transferSupport.getTransferable();
            DataFlavor[] dataFlavorArray = transferable.getTransferDataFlavors();
            ImportExport.importTransferable(transferable, dataFlavorArray, metaInfo, transferSupport.isDrop());
            return true;
        }
        return false;
    }

    public void reset() {
        this.files = null;
    }

    @Override
    protected Transferable createTransferable(JComponent jComponent) {
        if (((Boolean)Vars.treeReadOnly.get()).booleanValue()) {
            return null;
        }
        MetaInfo[] metaInfoArray = Tree.getInstance().getSelectedItems();
        return metaInfoArray.length == 0 ? null : new MetaInfoSelection(metaInfoArray);
    }

    private Object getFiles(TransferHandler.TransferSupport transferSupport) {
        try {
            Object object;
            Transferable transferable = transferSupport.getTransferable();
            if (transferable.isDataFlavorSupported(MetaInfoSelection.META_INFO_LIST) && (object = transferable.getTransferData(MetaInfoSelection.META_INFO_LIST)) instanceof MetaInfoSelection.MetaInfoList) {
                return object;
            }
            return FileSelection.getURIList(transferable);
        }
        catch (Exception exception) {
            MLogger.exception(exception);
            return null;
        }
    }

    private MetaInfo getMetaInfoUnderMouse(TransferHandler.TransferSupport transferSupport) {
        JTree.DropLocation dropLocation = (JTree.DropLocation)transferSupport.getDropLocation();
        TreePath treePath = dropLocation.getPath();
        if (treePath == null) {
            return null;
        }
        MetaInfo metaInfo = (MetaInfo)treePath.getLastPathComponent();
        if (metaInfo.isFile()) {
            metaInfo = metaInfo.getParentFolder();
        }
        return metaInfo;
    }

    private boolean isImportFailed(MetaInfo metaInfo) {
        if (this.isValidFolder(metaInfo, true)) {
            return false;
        }
        MStatusBar.warning(UI._("Import failed"));
        return true;
    }

    private boolean isValidFolder(MetaInfo metaInfo, boolean bl) {
        if (bl && !(metaInfo.getFS() instanceof TreeFS)) {
            return false;
        }
        if (!metaInfo.isFolder() && !metaInfo.isFSRoot()) {
            return false;
        }
        return metaInfo.canModify();
    }
}

