/*
 * Decompiled with CFR 0.152.
 */
package org.makagiga.fs.tree;

import java.io.File;
import java.io.Serializable;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.ListCellRenderer;
import org.makagiga.Tabs;
import org.makagiga.commons.Config;
import org.makagiga.commons.MGuardedObject;
import org.makagiga.commons.MIcon;
import org.makagiga.commons.MMessage;
import org.makagiga.commons.MPanel;
import org.makagiga.commons.PermissionInfo;
import org.makagiga.commons.UI;
import org.makagiga.editors.EditorPlugin;
import org.makagiga.fs.AbstractFS;
import org.makagiga.fs.FSException;
import org.makagiga.fs.FSNewFile;
import org.makagiga.fs.FSNewFolder;
import org.makagiga.fs.MetaInfo;
import org.makagiga.plugins.PluginComboBox;
import org.makagiga.plugins.PluginDownloader;
import org.makagiga.plugins.PluginInfo;
import org.makagiga.plugins.PluginManager;
import org.makagiga.plugins.PluginRenderer;
import org.makagiga.plugins.PluginType;
import org.makagiga.tree.NewFileDialog;

public final class TreeFS
extends AbstractFS
implements FSNewFile,
FSNewFolder {
    private static boolean initError;
    private String defaultFileType;

    public static TreeFS getInstance() {
        return (TreeFS)LazyTreeFSHolder.INSTANCE.get();
    }

    public void setDefaultFileType(String string) {
        this.defaultFileType = string;
    }

    @Override
    public Action getNewFileAction() {
        return null;
    }

    @Override
    public String getNewFileActionText() {
        return UI._("New File");
    }

    @Override
    public String getNewFileDefaultName() {
        return UI._("New File");
    }

    @Override
    public int getNewFileOptions() {
        return 0;
    }

    @Override
    public MetaInfo newFile(MetaInfo metaInfo) throws FSException {
        Serializable serializable2;
        PluginComboBox pluginComboBox = new PluginComboBox(PluginType.EDITOR){

            @Override
            protected ListCellRenderer createRenderer() {
                return new PluginRenderer(false){

                    @Override
                    protected String getDisplayName(PluginInfo pluginInfo) {
                        if (pluginInfo.getPluggable() instanceof EditorPlugin) {
                            EditorPlugin editorPlugin = (EditorPlugin)pluginInfo.getPluggable();
                            return editorPlugin.getDocumentDisplayName();
                        }
                        return pluginInfo.toString();
                    }
                };
            }
        };
        for (Serializable serializable2 : PluginType.EDITOR.get()) {
            if (!((EditorPlugin)EditorPlugin.class.cast(((PluginInfo)serializable2).getPluggable())).isReadOnly()) continue;
            pluginComboBox.removeItem(serializable2);
        }
        MPanel mPanel = MPanel.createVLabelPanel(pluginComboBox, UI._("File Type:"));
        serializable2 = Config.getDefault();
        if (this.defaultFileType == null) {
            this.defaultFileType = ((Config)serializable2).read("NewFile.last", "{0f04e3a2-05a8-4c41-9d66-a6619479eafd}");
        }
        pluginComboBox.selectByID(this.defaultFileType);
        NewFileDialog newFileDialog = new NewFileDialog(this, mPanel){

            @Override
            protected void onURLClick() {
                PluginDownloader.getMorePlugins(this, PluginType.EDITOR);
            }
        };
        newFileDialog.changeButton((AbstractButton)newFileDialog.getURLButton(), PluginManager.GET_MORE_PLUGINS_ACTION_INFO);
        newFileDialog.getURLButton().setVisible(true);
        this.defaultFileType = null;
        if (!newFileDialog.exec()) {
            return null;
        }
        PluginInfo pluginInfo = (PluginInfo)pluginComboBox.getSelectedItem();
        MetaInfo metaInfo2 = this.createUniqueFile(metaInfo, newFileDialog.getFileName(), pluginInfo);
        if (metaInfo2 != null) {
            metaInfo2.sync();
            Tabs.getInstance().openEditor(metaInfo2);
        }
        ((Config)serializable2).write("NewFile.last", pluginInfo.getID());
        ((Config)serializable2).sync();
        return metaInfo2;
    }

    @Override
    protected void processFile(MetaInfo metaInfo, File file) {
        this.processTreeFile(metaInfo, file);
    }

    private TreeFS() throws FSException {
        super(null, "data", UI._("Files and Folders"), MIcon.stock("ui/folder"));
        this.scan();
    }

    private static TreeFS newInstance() {
        try {
            return new TreeFS();
        }
        catch (Exception exception) {
            if (!initError) {
                initError = true;
                MMessage.error(null, new Exception("Could not initialize Tree file system", exception));
            }
            return null;
        }
    }

    static /* synthetic */ TreeFS access$100() {
        return TreeFS.newInstance();
    }

    private static final class LazyTreeFSHolder {
        private static final MGuardedObject<TreeFS> INSTANCE = new MGuardedObject<TreeFS>(TreeFS.access$100(), "org.makagiga.fs.tree.TreeFS", PermissionInfo.ThreatLevel.HIGH, "Tree");

        private LazyTreeFSHolder() {
        }
    }
}

