/*
 * Decompiled with CFR 0.152.
 */
package org.makagiga.ghns;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Image;
import java.awt.Window;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URL;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import java.util.concurrent.TimeUnit;
import javax.imageio.ImageIO;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.ListCellRenderer;
import javax.swing.RowFilter;
import javax.swing.event.DocumentEvent;
import org.makagiga.commons.Config;
import org.makagiga.commons.CoolHeader;
import org.makagiga.commons.MAction;
import org.makagiga.commons.MActionInfo;
import org.makagiga.commons.MArrayList;
import org.makagiga.commons.MComboBox;
import org.makagiga.commons.MDate;
import org.makagiga.commons.MDialog;
import org.makagiga.commons.MDownloadDialog;
import org.makagiga.commons.MIcon;
import org.makagiga.commons.MList;
import org.makagiga.commons.MLogger;
import org.makagiga.commons.MMenu;
import org.makagiga.commons.MMessage;
import org.makagiga.commons.MPanel;
import org.makagiga.commons.MRenderer;
import org.makagiga.commons.MSearchPanel;
import org.makagiga.commons.MTaskPanel;
import org.makagiga.commons.Net;
import org.makagiga.commons.TK;
import org.makagiga.commons.UI;
import org.makagiga.commons.XMLHelper;
import org.makagiga.commons.request.AbstractRequestManager;
import org.makagiga.commons.request.RequestInfo;
import org.makagiga.commons.request.RequestProperties;
import org.makagiga.commons.request.RequestSource;
import org.makagiga.ghns.GHNSDownload;
import org.makagiga.ghns.Stuff;
import org.makagiga.ghns.StuffRenderer;

public class GHNSDialog
extends MDialog
implements RequestSource<Image> {
    protected CoolHeader message;
    protected List<Stuff> allStuff = MArrayList.create();
    protected MComboBox<String> category;
    protected MList<Stuff> stuffList;
    protected MPanel extraPanel;
    protected MSearchPanel searchPanel;
    protected MTaskPanel<GHNSDownload> taskPanel;
    protected PreviewReader previewReader;
    private boolean showScreenshots;
    private static GHNSDownload cache;
    private static long lastRefresh;
    private final Map<String, Icon> categoryIcon = TK.newHashMap();
    private final Map<String, String> categoryShortDescription = TK.newHashMap();
    private final Map<String, String> categoryText = TK.newHashMap();
    private final MComboBox<URI> sourceList;
    private static final String ALL = "org.makagiga.ghns.GHNSDialog.ALL";
    private String defaultCategory = "org.makagiga.ghns.GHNSDialog.ALL";
    private static URI cachedURI;
    private URI source;

    public GHNSDialog(Window window, String string, Icon icon, int n, Dimension dimension) {
        super(window, string, icon, n | 8);
        this.changeButton((AbstractButton)this.getUserButton(), MActionInfo.INSTALL);
        this.setSize(UI.WindowSize.LARGE);
        this.setCategoryIcon(ALL, MIcon.small("ui/misc"));
        this.setCategoryText(ALL, UI._("All"));
        Config config = Config.getDefault();
        this.showScreenshots = config.read("Plugin.showScreenshots", false);
        this.previewReader = new PreviewReader();
        this.category = new MComboBox<String>(){

            @Override
            protected void onSelect() {
                GHNSDialog.this.updateStuffList();
            }
        };
        this.category.setRenderer((ListCellRenderer<String>)new MRenderer<String>(){

            @Override
            protected void onRender(String string) {
                this.setIcon(GHNSDialog.this.getCategoryIcon(string));
                this.setText(GHNSDialog.this.getCategoryText(string));
                this.setToolTipText(GHNSDialog.this.getCategoryShortDescription(string));
            }
        });
        this.category.setToolTipText(UI._("Category"));
        this.searchPanel = new MSearchPanel(true, MSearchPanel.Type.FILTER){

            @Override
            protected void onChange(DocumentEvent documentEvent) {
                GHNSDialog.this.doSearch();
            }
        };
        this.extraPanel = MPanel.createHBoxPanel();
        this.extraPanel.setVisible(false);
        this.stuffList = new MList<Stuff>(){

            @Override
            protected void onAction() {
                if (this.getActionType() == MList.ActionType.TRIGGER) {
                    GHNSDialog.this.doInstall();
                }
            }

            @Override
            protected void onSelect() {
                GHNSDialog.this.updateSelectionState();
            }
        };
        this.stuffList.setText(UI._("No Items"));
        StuffRenderer<Stuff> stuffRenderer = new StuffRenderer<Stuff>(dimension){

            @Override
            protected void onRenderStuff(Stuff stuff) {
                MDate mDate = stuff.getReleaseDateValue();
                if (mDate != null && mDate.isValid()) {
                    this.setExtra(UI._("Release date: {0}", stuff.formatReleaseDate()), null, "font-style: italic; font-weight: normal");
                } else {
                    this.setExtra(null, null, null);
                }
                if (GHNSDialog.this.showScreenshots) {
                    this.getImageLabel().setVisible(true);
                    Image image = stuff.getPreviewCache();
                    if (image == null) {
                        stuff.setPreviewCache(GHNSDialog.this.getNoPreviewIcon());
                        this.setImage(stuff.getPreviewCache());
                        String string = stuff.getLocalizedPreview();
                        if (string != null) {
                            RequestProperties requestProperties = new RequestProperties();
                            requestProperties.put("stuff", stuff);
                            requestProperties.put("url", string);
                            GHNSDialog.this.previewReader.startRequest(GHNSDialog.this, requestProperties);
                        }
                    } else {
                        this.setImage(image);
                    }
                } else {
                    this.getImageLabel().setVisible(false);
                    this.setImage((Image)null);
                }
                this.setName(stuff.getLocalizedName());
                this.setRating(stuff.getRating());
                this.setSummary(stuff.getLocalizedSummary());
                this.setVersion(stuff.getVersion());
                GHNSDialog.this.onRender(this, stuff);
            }
        };
        stuffRenderer.getImageLabel().setBorder(BorderFactory.createLineBorder(Color.BLACK));
        this.stuffList.setCellRenderer((ListCellRenderer<Stuff>)stuffRenderer);
        this.stuffList.setSingleSelectionMode();
        this.sourceList = new MComboBox();
        this.taskPanel = new MTaskPanel<GHNSDownload>((JComponent)MPanel.createVLabelPanel(this.stuffList, UI._("Items:"))){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            protected GHNSDownload doInBackground() throws Exception {
                long l = MDate.currentTime();
                URI uRI = GHNSDialog.this.getSource();
                Class<GHNSDialog> clazz = GHNSDialog.class;
                synchronized (GHNSDialog.class) {
                    if (!uRI.equals(cachedURI)) {
                        MLogger.debug("ghns", "Cached URL changed");
                        cache = null;
                    }
                    boolean bl = cache == null || cachedURI == null || lastRefresh == -1L || l - lastRefresh > TimeUnit.MINUTES.toMillis(5L);
                    // ** MonitorExit[var5_3] (shouldn't be in output)
                    if (bl) {
                        try {
                            clazz = GHNSDialog.class;
                            synchronized (GHNSDialog.class) {
                                cachedURI = uRI;
                                cache = XMLHelper.unmarshal(GHNSDownload.class, uRI.toURL());
                                lastRefresh = l;
                                // ** MonitorExit[var5_3] (shouldn't be in output)
                            }
                        }
                        catch (Exception exception) {
                            GHNSDialog.invalidateCache();
                            throw exception;
                        }
                    } else {
                        MLogger.debug("ghns", "Using cached data");
                    }
                    {
                        clazz = GHNSDialog.class;
                        synchronized (GHNSDialog.class) {
                            // ** MonitorExit[var5_3] (shouldn't be in output)
                            return cache;
                        }
                    }
                }
            }

            @Override
            protected void done() {
                if (this.isCancelled()) {
                    return;
                }
                try {
                    GHNSDialog.this.updateComponents((GHNSDownload)this.getResult());
                }
                catch (Exception exception) {
                    MMessage.error((Window)GHNSDialog.this, exception);
                }
            }
        };
        this.taskPanel.setTransitionEffect(null);
        this.message = new CoolHeader();
        this.message.setVisible(false);
        MPanel mPanel = MPanel.createGroupPanel(true);
        mPanel.getGroupLayout().beginRows().beginColumns().addComponent(this.category).addComponent(this.searchPanel).addComponent((Component)this.extraPanel, true).end().beginColumns().addComponent(this.sourceList, UI._("Source:")).end().addComponent(this.taskPanel).addComponent(this.message).end();
        this.addCenter(mPanel);
        this.updateSelectionState();
    }

    public void cancel() {
        this.taskPanel.cancel(true);
    }

    public Icon getCategoryIcon(String string) {
        if (string == null) {
            return null;
        }
        return this.categoryIcon.get(string);
    }

    public final void setCategoryIcon(String string, Icon icon) {
        if (icon == null) {
            this.categoryIcon.remove(string);
        } else {
            this.categoryIcon.put(string, icon);
        }
    }

    public String getCategoryShortDescription(String string) {
        return string == null ? null : this.categoryShortDescription.get(string);
    }

    public void setCategoryShortDescription(String string, String string2) {
        if (string2 == null) {
            this.categoryShortDescription.remove(string);
        } else {
            this.categoryShortDescription.put(string, string2);
        }
    }

    public String getCategoryText(String string) {
        if (string == null) {
            return null;
        }
        String string2 = this.categoryText.get(string);
        return string2 == null ? string : string2;
    }

    public final void setCategoryText(String string, String string2) {
        if (string2 == null) {
            this.categoryText.remove(string);
        } else {
            this.categoryText.put(string, string2);
        }
    }

    public URI getSource() {
        return this.source;
    }

    public void setSource(URI uRI) {
        if (TK.isChange(cachedURI, uRI)) {
            GHNSDialog.invalidateCache();
        }
        this.source = TK.checkNull(uRI, "value");
        this.sourceList.removeAllItems();
        this.sourceList.addItem((URI)uRI);
        this.sourceList.setEnabled(this.sourceList.getItemCount() > 1);
    }

    public void refresh(String string) {
        this.defaultCategory = string == null ? ALL : string;
        this.category.setEnabled(false);
        this.searchPanel.getTextField().setEnabled(false);
        this.cancel();
        this.taskPanel.start();
    }

    @Override
    public void requestDone(RequestInfo<Image> requestInfo, Image image) {
        if (image != null) {
            Stuff stuff = requestInfo.getProperty("stuff", null);
            stuff.setPreviewCache(image);
            this.stuffList.repaintItem(stuff);
        }
    }

    protected boolean filter(Stuff stuff) {
        return true;
    }

    protected String getDownloadURL(Stuff stuff) {
        return stuff.getLocalizedPayload();
    }

    protected Image getNoPreviewIcon() {
        return MIcon.stock("ui/question").getGrayscaleInstance().getImage();
    }

    protected void install(Stuff stuff) throws IOException {
        Net.DownloadInfo downloadInfo = new Net.DownloadInfo(new URL(this.getDownloadURL(stuff)), ".ghns", 4);
        MDownloadDialog.download(this, downloadInfo);
        this.onInstall(stuff, downloadInfo.getFile());
    }

    @Override
    protected void onClose() {
        this.previewReader.cancelAll();
        this.cancel();
        Config config = Config.getDefault();
        config.write("Plugin.showScreenshots", this.showScreenshots);
        config.sync();
    }

    protected boolean onConfirmInstall(Stuff stuff) {
        return true;
    }

    protected void onInstall(Stuff stuff, File file) {
    }

    protected void onRender(StuffRenderer<Stuff> stuffRenderer, Stuff stuff) {
    }

    protected MMenu onSettingsMenu() {
        MMenu mMenu = new MMenu();
        MAction mAction = new MAction(UI._("Show Screenshots"), "ui/image"){

            @Override
            public void onAction() {
                GHNSDialog.this.showScreenshots = this.isSelected();
                GHNSDialog.this.invalidateListView();
            }
        };
        mAction.setSelected(this.showScreenshots);
        mMenu.addCheckBox(mAction);
        return mMenu;
    }

    @Override
    protected void onUserClick() {
        this.doInstall();
    }

    protected void updateStuffList() {
        String string = this.searchPanel.getText();
        if (TK.isEmpty(string)) {
            this.stuffList.filter(this.searchPanel, this.allStuff, (RowFilter<List<Stuff>, Integer>)new MList.Filter<Stuff, String>(this.category.getSelectedItem()){

                @Override
                public boolean include(Stuff stuff) {
                    return (((String)this.filter).equals(GHNSDialog.ALL) || ((String)this.filter).equals(stuff.getCategory())) && GHNSDialog.this.filter(stuff);
                }
            });
        } else {
            this.stuffList.filter(this.searchPanel, this.allStuff, (RowFilter<List<Stuff>, Integer>)new MList.SearchableFilter<Stuff, String>(string){

                @Override
                public boolean include(Stuff stuff) {
                    return super.include(stuff) && GHNSDialog.this.filter(stuff);
                }
            });
        }
        if (!this.stuffList.isEmpty()) {
            this.stuffList.setPrototypeCellValue((Stuff)this.stuffList.getItemAt(0));
            this.stuffList.setSelectedIndex(0, true);
        }
        this.updateSelectionState();
    }

    private void doInstall() {
        Stuff stuff = this.stuffList.getSelectedItem();
        if (!this.onConfirmInstall(stuff)) {
            return;
        }
        if (!MMessage.customConfirm(this, MIcon.stock("ui/question"), MActionInfo.INSTALL, null, UI.makeHTML(UI._("Install selected item?<br><br><b>{0}</b>", stuff.getLocalizedName())))) {
            return;
        }
        try {
            this.install(stuff);
            this.stuffList.repaintItem(stuff);
        }
        catch (MDownloadDialog.CancelException cancelException) {
            MLogger.exception(cancelException);
        }
        catch (IOException iOException) {
            MMessage.error((Window)this, iOException);
        }
    }

    private void doSearch() {
        if (!this.searchPanel.getTextField().isEnabled()) {
            return;
        }
        this.category.setEnabled(this.searchPanel.isEmpty());
        this.category.setEventsEnabled(false);
        this.category.setSelectedItem(ALL);
        this.category.setEventsEnabled(true);
        this.updateStuffList();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void invalidateCache() {
        MLogger.debug("ghns", "Invalidate cache");
        Class<GHNSDialog> clazz = GHNSDialog.class;
        synchronized (GHNSDialog.class) {
            cache = null;
            cachedURI = null;
            lastRefresh = -1L;
            // ** MonitorExit[var0] (shouldn't be in output)
            return;
        }
    }

    private void invalidateListView() {
        this.stuffList.setPrototypeCellValue(null);
        Stuff stuff = this.stuffList.getSelectedItem();
        this.updateStuffList();
        if (stuff != null) {
            this.stuffList.setSelectedItem(stuff, true);
        }
        this.stuffList.repaint();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateComponents(GHNSDownload gHNSDownload) {
        if (gHNSDownload == null) {
            return;
        }
        this.allStuff.clear();
        TreeSet<String> treeSet = new TreeSet<String>();
        if (!TK.isEmpty(gHNSDownload.getStuff())) {
            for (Stuff stuff : gHNSDownload.getStuff()) {
                this.allStuff.add(stuff);
                if (TK.isEmpty(stuff.getCategory())) continue;
                treeSet.add(stuff.getCategory());
            }
        }
        ((MArrayList)MArrayList.class.cast(this.allStuff)).sort();
        try {
            this.category.setEventsEnabled(false);
            this.category.removeAllItems();
            this.category.addItem((String)ALL);
            this.category.addAllItems((Collection<String>)treeSet);
            this.category.setSelectedItem(this.defaultCategory);
            this.category.setEnabled(this.category.getItemCount() > 1);
            this.searchPanel.getTextField().setEnabled(true);
        }
        finally {
            this.category.setEventsEnabled(true);
        }
        this.updateStuffList();
        this.stuffList.requestFocusInWindow();
    }

    private void updateSelectionState() {
        if (this.getUserButton() != null) {
            Stuff stuff = this.stuffList.getSelectedItem();
            this.getUserButton().setEnabled(stuff != null);
        }
    }

    static {
        lastRefresh = -1L;
    }

    public static final class PreviewReader
    extends AbstractRequestManager<Image> {
        public PreviewReader() {
            super(1, 0L);
        }

        @Override
        protected Image getResult(RequestInfo<Image> requestInfo) throws Exception {
            String string = requestInfo.getProperty("url", null);
            Net.DownloadInfo downloadInfo = new Net.DownloadInfo(new URL(string), ".png", 2);
            downloadInfo.startDownload();
            return ImageIO.read(downloadInfo.getFile());
        }
    }
}

