/*
 * Decompiled with CFR 0.152.
 */
package org.makagiga.pim;

import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.io.Writer;
import java.util.Iterator;
import org.makagiga.commons.MArrayList;
import org.makagiga.commons.MLogger;
import org.makagiga.commons.TK;
import org.makagiga.pim.PIMEntry;
import org.makagiga.pim.PIMUtils;

public abstract class PIMData<I extends PIMEntry>
implements Closeable,
Iterable<I>,
Serializable {
    private final MArrayList<I> itemList = new MArrayList();
    private transient MLogger log;
    private final String name;
    protected Writer writer;

    public void add(I i) {
        this.itemList.add(i);
    }

    public String getName() {
        return this.name;
    }

    public abstract String getVersion();

    public void read(InputStream inputStream) throws IOException {
        throw new UnsupportedOperationException();
    }

    public abstract void write(OutputStream var1) throws IOException;

    @Override
    public void close() throws IOException {
        if (this.writer != null) {
            this.writer.close();
            this.writer = null;
        }
    }

    @Override
    public Iterator<I> iterator() {
        return this.itemList.iterator();
    }

    protected PIMData(String string) {
        this.name = TK.checkNullOrEmpty(string);
        this.log = MLogger.get(string);
    }

    protected Writer createWriter(OutputStream outputStream) throws IOException {
        return new PIMUtils.FoldedWriter(outputStream);
    }

    protected String getEOL() {
        return "\r\n";
    }

    protected MLogger getLog() {
        return this.log;
    }

    protected void writeLine(String string) throws IOException {
        this.writer.write(string + this.getEOL());
    }

    private void readObject(ObjectInputStream objectInputStream) throws ClassNotFoundException, IOException {
        objectInputStream.defaultReadObject();
        this.log = MLogger.get(this.name);
    }
}

