/*
 * Decompiled with CFR 0.152.
 */
package org.makagiga.plugins;

import java.applet.Applet;
import java.applet.AppletContext;
import java.applet.AppletStub;
import java.applet.AudioClip;
import java.awt.Color;
import java.awt.Image;
import java.awt.Toolkit;
import java.io.IOException;
import java.io.InputStream;
import java.lang.ref.WeakReference;
import java.net.URL;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.Clip;
import javax.sound.sampled.LineUnavailableException;
import javax.sound.sampled.UnsupportedAudioFileException;
import org.makagiga.commons.Config;
import org.makagiga.commons.MLabel;
import org.makagiga.commons.MLogger;
import org.makagiga.commons.MMainWindow;
import org.makagiga.commons.MMessage;
import org.makagiga.commons.MPanel;
import org.makagiga.commons.TK;
import org.makagiga.commons.UI;
import org.makagiga.plugins.PluginClassLoader;

public class AppletPanel
extends MPanel {
    private boolean started;
    private MLabel statusBar;
    private WeakReference<Applet> appletRef;

    @Deprecated
    public AppletPanel(Applet applet) {
        this(applet, Color.WHITE);
    }

    @Deprecated
    public AppletPanel(Applet applet, Color color) {
        this.appletRef = TK.newWeakRef(applet);
        this.setBackground(color);
        if (applet.getParent() != this) {
            this.add(applet);
        }
        this.init();
    }

    public AppletPanel(URL[] uRLArray, Config config, String string) throws Exception {
        Applet applet = AppletPanel.load(this, uRLArray, config, string);
        this.appletRef = TK.newWeakRef(applet);
        this.init();
    }

    public Applet getApplet() {
        return this.appletRef == null ? null : (Applet)this.appletRef.get();
    }

    public void initApplet() {
        Applet applet = this.getApplet();
        if (applet != null) {
            try {
                applet.init();
            }
            catch (ThreadDeath threadDeath) {
                throw threadDeath;
            }
            catch (Throwable throwable) {
                MMessage.error(this.getWindowAncestor(), throwable);
            }
        }
    }

    public boolean isSoundEnabled() {
        Applet applet = this.getApplet();
        if (applet != null) {
            return ((Context)Context.class.cast(applet.getAppletContext())).soundEnabled;
        }
        return false;
    }

    public void setSoundEnabled(boolean bl) {
        Applet applet = this.getApplet();
        if (applet != null) {
            ((Context)Context.class.cast(applet.getAppletContext())).soundEnabled = bl;
        }
    }

    @Deprecated
    public static Applet load(URL uRL, Config config, String string) throws Exception {
        return AppletPanel.load(null, new URL[]{uRL}, config, string);
    }

    public static Applet load(AppletPanel appletPanel, URL[] uRLArray, Config config, String string) throws Exception {
        PluginClassLoader pluginClassLoader = PluginClassLoader.create(null, uRLArray);
        Class<?> clazz = Class.forName(string, true, pluginClassLoader);
        Applet applet = (Applet)clazz.newInstance();
        if (appletPanel != null) {
            appletPanel.add(applet);
            applet.setSize(appletPanel.getSize());
        }
        Stub stub = new Stub(uRLArray[0], config);
        stub.appletPanelRef = new WeakReference<AppletPanel>(appletPanel);
        applet.setStub(stub);
        if (appletPanel == null) {
            applet.init();
        }
        return applet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutDownApplet() {
        try {
            this.stopApplet();
        }
        finally {
            Applet applet = this.getApplet();
            try {
                if (applet != null) {
                    applet.destroy();
                }
            }
            finally {
                if (this.appletRef != null) {
                    this.appletRef.clear();
                    this.appletRef = null;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startApplet() {
        Applet applet = this.getApplet();
        if (applet == null) {
            return;
        }
        if (!this.started) {
            AppletContext appletContext = applet.getAppletContext();
            if (appletContext instanceof Context) {
                ((Context)Context.class.cast(appletContext)).setActive(true);
            }
            try {
                applet.start();
            }
            finally {
                this.started = true;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stopApplet() {
        Applet applet = this.getApplet();
        if (applet == null) {
            return;
        }
        if (this.started) {
            AppletContext appletContext = applet.getAppletContext();
            if (appletContext instanceof Context) {
                ((Context)Context.class.cast(appletContext)).setActive(false);
            }
            try {
                applet.stop();
            }
            finally {
                this.started = false;
            }
        }
    }

    private void init() {
        this.statusBar = new MLabel();
        this.statusBar.setOpaque(true);
        this.statusBar.setToolTipText(UI._("Status Bar"));
        this.statusBar.setVisible(false);
        this.addSouth(this.statusBar);
    }

    public static class Stub
    implements AppletStub {
        private final AppletContext context;
        private boolean active;
        private final Config config;
        private final URL base;
        private WeakReference<AppletPanel> appletPanelRef;

        @Deprecated
        public Stub(URL uRL, Config config) {
            this.base = TK.checkNull(uRL, "base");
            this.config = TK.checkNull(config, "config");
            this.context = new Context(this);
        }

        @Override
        public void appletResize(int n, int n2) {
            MLogger.warning("stub", "appletResize( %d, %d ) not implemented", n, n2);
        }

        @Override
        public AppletContext getAppletContext() {
            return this.context;
        }

        @Override
        public URL getCodeBase() {
            return this.base;
        }

        @Override
        public URL getDocumentBase() {
            MLogger.warning("stub", "getDocumentBase() not fully implemented");
            return this.base;
        }

        @Override
        public String getParameter(String string) {
            return this.config.read("Applet." + string, null);
        }

        @Override
        public synchronized boolean isActive() {
            return this.active;
        }

        @Deprecated
        public synchronized void setActive(boolean bl) {
            this.active = bl;
        }
    }

    public static class Context
    implements AppletContext {
        private boolean soundEnabled;
        private final Map<String, InputStream> streams = new HashMap<String, InputStream>();
        private final Stub stub;

        @Deprecated
        public Context(Stub stub) {
            this.stub = TK.checkNull(stub, "stub");
        }

        @Override
        public Applet getApplet(String string) {
            MLogger.warning("stub", "getApplet( %s ) not implemented", string);
            return null;
        }

        @Override
        public Enumeration<Applet> getApplets() {
            MLogger.warning("stub", "getApplets() not implemented");
            List list = Collections.emptyList();
            return Collections.enumeration(list);
        }

        @Override
        public AudioClip getAudioClip(URL uRL) {
            return new Audio(uRL, this.soundEnabled);
        }

        @Override
        public Image getImage(URL uRL) {
            return Toolkit.getDefaultToolkit().getImage(uRL);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public InputStream getStream(String string) {
            if (string == null) {
                return null;
            }
            Map<String, InputStream> map = this.streams;
            synchronized (map) {
                return this.streams.get(string);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Iterator<String> getStreamKeys() {
            Map<String, InputStream> map = this.streams;
            synchronized (map) {
                return this.streams.keySet().iterator();
            }
        }

        @Override
        public void showDocument(final URL uRL) {
            UI.invokeLater(new Runnable(){

                @Override
                public void run() {
                    MMainWindow.openURI(uRL);
                }
            });
        }

        @Override
        public void showDocument(URL uRL, String string) {
            MLogger.warning("stub", "showDocument( %s, %s ) partially implemented", uRL, string);
            this.showDocument(uRL);
        }

        @Override
        public void showStatus(final String string) {
            UI.invokeLater(new Runnable(){

                @Override
                public void run() {
                    if (Context.this.stub == null) {
                        return;
                    }
                    AppletPanel appletPanel = (AppletPanel)Context.this.stub.appletPanelRef.get();
                    if (appletPanel != null && appletPanel.statusBar != null) {
                        appletPanel.statusBar.setText(string);
                        appletPanel.statusBar.setVisible(!TK.isEmpty(string));
                    }
                }
            });
        }

        @Deprecated
        public void setActive(boolean bl) {
            this.stub.setActive(bl);
        }

        @Deprecated
        public void setCanShowStatus(boolean bl) {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void setStream(String string, InputStream inputStream) throws IOException {
            if (inputStream == null) {
                Map<String, InputStream> map = this.streams;
                synchronized (map) {
                    this.streams.remove(string);
                }
            }
            Map<String, InputStream> map = this.streams;
            synchronized (map) {
                this.streams.put(string, inputStream);
            }
        }
    }

    public static class Audio
    implements AudioClip {
        private boolean noClip;
        private final boolean soundEnabled;
        private Clip clip;
        private final URL url;

        @Deprecated
        public Audio(URL uRL) throws IOException, LineUnavailableException, UnsupportedAudioFileException {
            this(uRL, true);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void loop() {
            this.initClip();
            Audio audio = this;
            synchronized (audio) {
                if (this.clip != null) {
                    this.clip.setFramePosition(0);
                    this.clip.loop(-1);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void play() {
            this.initClip();
            Audio audio = this;
            synchronized (audio) {
                if (this.clip != null) {
                    this.clip.setFramePosition(0);
                    this.clip.loop(0);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void stop() {
            Audio audio = this;
            synchronized (audio) {
                if (this.clip != null) {
                    this.clip.stop();
                }
            }
        }

        private Audio(URL uRL, boolean bl) {
            this.url = uRL;
            this.soundEnabled = bl;
        }

        private synchronized void initClip() {
            if (this.noClip || !this.soundEnabled) {
                return;
            }
            if (this.clip == null) {
                try {
                    AudioInputStream audioInputStream = AudioSystem.getAudioInputStream(this.url);
                    this.clip = AudioSystem.getClip();
                    this.clip.open(audioInputStream);
                }
                catch (IOException iOException) {
                    MLogger.exception(iOException);
                    this.noClip = true;
                }
                catch (LineUnavailableException lineUnavailableException) {
                    this.noClip = true;
                }
                catch (UnsupportedAudioFileException unsupportedAudioFileException) {
                    MLogger.exception(unsupportedAudioFileException);
                    this.noClip = true;
                }
            }
        }
    }
}

