/*
 * Decompiled with CFR 0.152.
 */
package org.makagiga.plugins;

import java.awt.Image;
import java.awt.Window;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.util.EnumSet;
import java.util.regex.Pattern;
import javax.imageio.ImageIO;
import org.makagiga.commons.BooleanProperty;
import org.makagiga.commons.Config;
import org.makagiga.commons.FS;
import org.makagiga.commons.IntegerProperty;
import org.makagiga.commons.MAboutDialog;
import org.makagiga.commons.MActionInfo;
import org.makagiga.commons.MApplication;
import org.makagiga.commons.MIcon;
import org.makagiga.commons.MLogger;
import org.makagiga.commons.MObject;
import org.makagiga.commons.Searchable;
import org.makagiga.commons.StringProperty;
import org.makagiga.commons.TK;
import org.makagiga.commons.UI;
import org.makagiga.commons.VersionProperty;
import org.makagiga.commons.WTFError;
import org.makagiga.plugins.AbstractPlugin;
import org.makagiga.plugins.Pluggable;
import org.makagiga.plugins.PluginType;

public final class PluginInfo
implements Comparable<PluginInfo>,
Searchable<String>,
Serializable {
    private static final long serialVersionUID = -6405296417339995301L;
    public final BooleanProperty enabled = new BooleanProperty(true);
    public final BooleanProperty loaded = new BooleanProperty();
    public final BooleanProperty test = new BooleanProperty();
    public final IntegerProperty priority = new IntegerProperty();
    public final StringProperty copyright = new StringProperty();
    public final StringProperty bugs = new StringProperty();
    public final StringProperty homePageURL = new StringProperty();
    public final StringProperty iconName = new StringProperty();
    public final StringProperty licenseName = new StringProperty();
    public final StringProperty licenseURL = new StringProperty();
    public final StringProperty longDescription = new StringProperty();
    public final StringProperty name = new StringProperty();
    public final StringProperty shortDescription = new StringProperty();
    public final StringProperty type = new StringProperty();
    public final VersionProperty requires = new VersionProperty();
    public final VersionProperty version = new VersionProperty();
    private final boolean internal;
    private transient MActionInfo whereInfo;
    private MIcon icon;
    private MIcon smallIcon;
    private Pluggable pluggable;
    private final String className;
    private final String id;
    private String path;
    boolean compatible;

    public PluginInfo(String string, String string2, boolean bl) {
        this.id = string;
        this.className = string2;
        this.internal = bl;
    }

    public void about(Window window) {
        String string = this.shortDescription.isNull() ? "" : (String)this.shortDescription.get();
        MActionInfo mActionInfo = this.getWhereInfo();
        if (!"?".equals(mActionInfo.getText())) {
            if (!string.isEmpty()) {
                string = string + "\n\n";
            }
            string = string + UI._("See: {0}", mActionInfo.getText());
        }
        MAboutDialog mAboutDialog = new MAboutDialog(window, this.getIcon(), this.name + " " + this.version, string);
        mAboutDialog.setBugs((String)this.bugs.get());
        mAboutDialog.setCopyright((String)this.copyright.get());
        mAboutDialog.setHomePage((String)this.homePageURL.get());
        File file = new File(this.getPath(), "LICENSE.txt");
        if (file.exists()) {
            mAboutDialog.setLicenseURI(file.toURI());
        } else {
            MLogger.warning("plugin", "License file not found: %s", file);
        }
        mAboutDialog.setLicense((String)this.licenseName.get(), (String)this.licenseURL.get());
        mAboutDialog.exec();
    }

    public boolean canRemove() {
        return !this.internal && (Boolean)this.test.get() == false;
    }

    @Override
    public int compareTo(PluginInfo pluginInfo) {
        int n = this.priority.compareTo(pluginInfo.priority);
        return n == 0 ? this.id.compareTo(pluginInfo.id) : n * -1;
    }

    public boolean equals(Object object) {
        switch (MObject.maybeEquals(this, object)) {
            case YES: {
                return true;
            }
            case NO: {
                return false;
            }
        }
        return this.id.equals(((PluginInfo)PluginInfo.class.cast((Object)object)).id);
    }

    public String getClassName() {
        return this.className;
    }

    public Config getConfig() {
        if (this.pluggable instanceof AbstractPlugin) {
            return ((AbstractPlugin)AbstractPlugin.class.cast(this.pluggable)).getConfig();
        }
        return null;
    }

    public synchronized MIcon getIcon() {
        if (this.icon == null) {
            this.icon = this.iconName.isEmpty() ? this.getPluginIcon(false) : MIcon.stock((String)this.iconName.get());
            if (this.icon == null) {
                this.icon = MIcon.stock("ui/misc");
            }
        }
        return this.icon;
    }

    public synchronized void setIcon(MIcon mIcon) {
        this.icon = mIcon;
    }

    public String getID() {
        return this.id;
    }

    public String getPath() {
        return this.path;
    }

    public void setPath(String string) {
        if (this.path != null) {
            throw new IllegalStateException("Path already set");
        }
        this.path = string;
    }

    public Pluggable getPluggable() {
        return this.pluggable;
    }

    public void setPluggable(Pluggable pluggable) {
        this.pluggable = pluggable;
    }

    public AbstractPlugin<?> getPlugin() {
        return (AbstractPlugin)this.pluggable;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Image getPreviewImage() {
        if (this.isInternal()) {
            InputStream inputStream = this.getPluggable().getClass().getResourceAsStream("preview.png");
            if (inputStream != null) {
                try {
                    BufferedImage bufferedImage = ImageIO.read(inputStream);
                    return bufferedImage;
                }
                catch (IOException iOException) {
                    MLogger.exception(iOException);
                }
                finally {
                    FS.close(inputStream);
                }
            }
        } else {
            File file = new File(this.getPath(), "preview.png");
            if (file.exists()) {
                try {
                    return ImageIO.read(file);
                }
                catch (IOException iOException) {
                    MLogger.exception(iOException);
                }
            }
        }
        return null;
    }

    public synchronized MIcon getSmallIcon() {
        if (this.smallIcon == null) {
            this.smallIcon = this.iconName.isEmpty() ? this.getPluginIcon(true) : MIcon.small((String)this.iconName.get());
            if (this.smallIcon == null) {
                this.smallIcon = MIcon.small("ui/misc");
            }
        }
        return this.smallIcon;
    }

    public synchronized void setSmallIcon(MIcon mIcon) {
        this.smallIcon = mIcon;
    }

    public synchronized MActionInfo getWhereInfo() {
        if (this.whereInfo != null) {
            return this.whereInfo;
        }
        if (!(this.pluggable instanceof AbstractPlugin)) {
            this.whereInfo = new MActionInfo("?", null);
            return this.whereInfo;
        }
        Config config = ((AbstractPlugin)AbstractPlugin.class.cast(this.pluggable)).getConfig();
        String string = config.read("where.text", "${default}");
        if ("${default}".equals(string)) {
            PluginType pluginType = PluginType.fromType((String)this.type.get());
            switch (pluginType) {
                case EDITOR: {
                    string = this.makeWhereText(UI._("Tree"), UI._("New"));
                    break;
                }
                case WIDGET: {
                    string = this.makeWhereText(UI._("Widgets"), UI._("Add Widget"), "${name}");
                    break;
                }
                case LOOK_AND_FEEL: {
                    string = this.makeWhereText(UI._("Menu Bar"), UI._("Tools"), UI._("Settings"), UI._("Look And Feel"));
                    break;
                }
                case INTERNET_SEARCH: {
                    string = this.makeWhereText(UI._("Widgets"), UI._("Add Widget"), UI._("Internet Search"));
                    break;
                }
                case GENERAL: 
                case LOCALE: {
                    string = "?";
                    break;
                }
                case FILE_SYSTEM: {
                    string = this.makeWhereText(UI._("Sidebar"), UI._("Tree"));
                    break;
                }
                case CONSOLE: {
                    string = this.makeWhereText(UI._("Menu Bar"), UI._("Tools"), UI._("Console"));
                    break;
                }
                default: {
                    throw new WTFError(pluginType);
                }
            }
        } else {
            string = this.makeWhereText(string.split(Pattern.quote(" -> ")));
        }
        this.whereInfo = new MActionInfo(string, null);
        return this.whereInfo;
    }

    public int hashCode() {
        return this.id.hashCode();
    }

    public boolean isCompatible() {
        return this.compatible;
    }

    public static boolean isCompatible(VersionProperty versionProperty) {
        if ((Integer)versionProperty.get() <= 132096) {
            return false;
        }
        return (Integer)versionProperty.get() <= (Integer)MApplication.getInternalVersion().get();
    }

    public boolean isInternal() {
        return this.internal;
    }

    public String toString() {
        return (String)this.name.get();
    }

    @Override
    public boolean matches(String string, EnumSet<Searchable.Matches> enumSet) {
        boolean bl;
        boolean bl2 = bl = TK.containsIgnoreCase((String)this.copyright.get(), string) || TK.containsIgnoreCase((String)this.homePageURL.get(), string) || TK.containsIgnoreCase((String)this.licenseName.get(), string) || TK.containsIgnoreCase((String)this.licenseURL.get(), string) || TK.containsIgnoreCase((String)this.longDescription.get(), string) || TK.containsIgnoreCase((String)this.name.get(), string) || TK.containsIgnoreCase((String)this.shortDescription.get(), string) || TK.containsIgnoreCase((String)this.type.get(), string) || TK.containsIgnoreCase(this.version.toString(), string);
        if (!bl) {
            PluginType pluginType = PluginType.fromType((String)this.type.get());
            bl = pluginType != null && TK.containsIgnoreCase(pluginType.getText(), string);
        }
        return bl;
    }

    private MIcon getPluginIcon(boolean bl) {
        try {
            int n;
            int n2 = MIcon.getUISize();
            int n3 = MIcon.getSmallSize();
            if (bl || n3 == n2) {
                n = n3;
            } else {
                boolean bl2 = PluginType.INTERNET_SEARCH.getType().equals(this.type.get());
                int n4 = n = bl2 ? -1 : n2;
            }
            MIcon mIcon = this.internal ? (this.isSimple() ? MIcon.get(this.pluggable.getClass(), "/" + this.path + "/icon.png", n) : MIcon.get(this.pluggable.getClass(), "icon.png", n)) : MIcon.get(new File(this.path, "icon.png"), n);
            if (n == -1) {
                if (mIcon.getIconWidth() == n3) {
                    Image image = mIcon.getImage();
                    if (image != null) {
                        MIcon mIcon2 = MIcon.stock(PluginType.INTERNET_SEARCH.getIconName());
                        mIcon2.setOverlay(image);
                        mIcon = mIcon2;
                    }
                } else {
                    mIcon = mIcon.scaleUI();
                }
            }
            return mIcon;
        }
        catch (Exception exception) {
            return null;
        }
    }

    private String makeWhereText(String ... stringArray) {
        for (int i = 0; i < stringArray.length; ++i) {
            stringArray[i] = stringArray[i].replace("${name}", this.toString());
        }
        return TK.toString(stringArray, " -> ");
    }

    boolean isSimple() {
        return "org.makagiga.internetsearch.InternetSearchPlugin".equals(this.className) || "org.makagiga.plugins.LookAndFeelPlugin".equals(this.className);
    }
}

