/*
 * Decompiled with CFR 0.152.
 */
package org.makagiga.search;

import java.io.File;
import java.io.IOException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import javax.imageio.ImageIO;
import javax.imageio.ImageReader;
import org.makagiga.commons.AbstractFileCache;
import org.makagiga.commons.Config;
import org.makagiga.commons.FS;
import org.makagiga.commons.MGuardedObject;
import org.makagiga.commons.MLogger;
import org.makagiga.commons.MProperties;
import org.makagiga.commons.PermissionInfo;
import org.makagiga.commons.SimpleXMLReader;
import org.makagiga.commons.TK;
import org.makagiga.fs.MetaInfo;
import org.makagiga.tree.Tree;
import org.makagiga.tree.tracker.Tracker;
import org.makagiga.tree.tracker.TrackerEvent;
import org.makagiga.tree.tracker.TrackerListener;

public final class Index
extends AbstractFileCache<String, Item>
implements TrackerListener {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean containsIgnoreCase(MetaInfo metaInfo, final String string) {
        File file;
        if (metaInfo.isLink()) {
            return this.containsIgnoreCase(metaInfo.getLink(), string);
        }
        if (!metaInfo.isFile()) {
            return false;
        }
        Config config = metaInfo.getConfig();
        String string2 = config.read("index", null);
        if (string2 != null) {
            return TK.containsIgnoreCase(string2, string);
        }
        String string3 = metaInfo.getFilePath();
        Item item = (Item)this.getItem(string3);
        if (item == null) {
            this.log.debugFormat("\"%s\" not indexed. Indexing...", metaInfo);
            file = this.indexFile(string3, metaInfo);
            if (file == null) {
                return false;
            }
        } else {
            file = this.getItemFile(item);
        }
        FS.TextReader textReader = null;
        try {
            final FS.TextReader textReader2 = textReader = FS.getUTF8Reader(file);
            boolean bl = AccessController.doPrivileged(new PrivilegedExceptionAction<Boolean>(){

                @Override
                public Boolean run() throws PrivilegedActionException {
                    for (String string2 : textReader2) {
                        if (!TK.containsIgnoreCase(string2, string)) continue;
                        return true;
                    }
                    return false;
                }
            });
            return bl;
        }
        catch (IOException iOException) {
            MLogger.exception(iOException);
            boolean bl = false;
            return bl;
        }
        catch (PrivilegedActionException privilegedActionException) {
            MLogger.exception(privilegedActionException);
            boolean bl = false;
            return bl;
        }
        finally {
            FS.close(textReader);
        }
    }

    public static Index getInstance() {
        return (Index)LazyIndexHolder.INSTANCE.get();
    }

    public void itemChanged(MetaInfo metaInfo) {
        if (metaInfo.isFile()) {
            this.removeItem(metaInfo.getFilePath());
        }
    }

    @Override
    public void itemChanged(TrackerEvent trackerEvent) {
        MetaInfo metaInfo = trackerEvent.getMetaInfo();
        if (metaInfo == null) {
            return;
        }
        switch (trackerEvent.getID()) {
            case ITEM_REMOVED: {
                if (!metaInfo.isFile()) break;
                this.removeItem(metaInfo.getFilePath());
                break;
            }
            case ITEM_RENAMED: {
                final String string = trackerEvent.getData().toString();
                final String string2 = metaInfo.getFilePath();
                if (metaInfo.isFolder()) {
                    new Tree.Scanner(metaInfo, false){

                        @Override
                        public void processItem(MetaInfo metaInfo) {
                            String string3;
                            if (metaInfo.isFile() && (string3 = metaInfo.getFilePath()).startsWith(string2 + File.separator)) {
                                Index.this.updatePath(string + string3.substring(string2.length()), string2 + string3.substring(string2.length()));
                            }
                        }
                    };
                    break;
                }
                if (!metaInfo.isFile()) break;
                this.updatePath(string, string2);
            }
        }
    }

    private void updatePath(String string, String string2) {
        Item item = (Item)this.getItem(string);
        if (item != null) {
            this.removeItem(string, false);
            this.putItem(string2, item);
        }
    }

    public synchronized void shutDown() {
        boolean bl = false;
        Iterator iterator = this.iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            File file = new File((String)entry.getKey());
            File file2 = this.getItemFile((AbstractFileCache.Item)entry.getValue());
            if (file.exists() && file2.exists()) continue;
            bl = true;
            iterator.remove();
            this.log.debugFormat("Removing index file: %s", file2);
            if (file2.delete()) continue;
            this.log.warningFormat("Could not delete old index file: %s", file2);
        }
        if (bl) {
            this.doWriteIndex();
        }
    }

    public static synchronized void update(MetaInfo metaInfo, Object ... objectArray) {
        Index index = Index.getInstancePrivileged();
        if (metaInfo.isLink()) {
            index.doUpdate(metaInfo.getLink(), false, objectArray);
        } else {
            index.doUpdate(metaInfo, false, objectArray);
        }
    }

    public static synchronized boolean updateLocal(MetaInfo metaInfo, Object ... objectArray) {
        if (!metaInfo.isWriteable()) {
            return false;
        }
        Index index = Index.getInstancePrivileged();
        if (metaInfo.isLink()) {
            index.doUpdate(metaInfo.getLink(), true, objectArray);
        } else {
            index.doUpdate(metaInfo, true, objectArray);
        }
        return true;
    }

    @Override
    protected void readIndex() throws IOException {
        MProperties mProperties = new MProperties();
        mProperties.loadUTF8(this.getIndexFile());
        for (Map.Entry<Object, Object> entry : mProperties.entrySet()) {
            File file = new File(entry.getKey().toString());
            if (!file.isAbsolute()) {
                file = new File(FS.getPlatformConfigPath(file.getPath()));
            }
            if (!file.exists()) continue;
            this.putItem(file.getPath(), new Item(entry.getValue().toString()), false);
        }
    }

    @Override
    protected void writeIndex() throws IOException {
        MProperties mProperties = new MProperties();
        for (Map.Entry entry : this) {
            mProperties.setProperty(FS.getPortableConfigPath((String)entry.getKey()), ((Item)entry.getValue()).getFileName());
        }
        mProperties.storeUTF8(this.getIndexFile());
    }

    private Index() {
        super("index", null, "index.properties");
        Tracker.addTrackerListener(this);
    }

    private File createEntry(String string) throws IOException {
        File file = this.createItemFile(null);
        this.putItem(string, new Item(file.getName()));
        return file;
    }

    private void doUpdate(MetaInfo metaInfo, boolean bl, Object ... objectArray) {
        Object object;
        Object object2;
        if (!metaInfo.isFile()) {
            return;
        }
        Keywords keywords = new Keywords();
        if (!metaInfo.isEncrypted()) {
            keywords.addObjects(objectArray);
        }
        if (bl) {
            object2 = metaInfo.getConfig();
            object = keywords.toString();
            ((Config)object2).write("index", (String)(((String)object).isEmpty() ? null : object));
            ((Config)object2).sync();
        }
        object2 = metaInfo.getFilePath();
        object = (Item)this.getItem(object2);
        try {
            String string = bl ? "" : keywords.toString();
            SecurityManager securityManager = System.getSecurityManager();
            if (securityManager == null) {
                File file = object == null ? this.createEntry((String)object2) : this.getItemFile(object);
                FS.write(file, string);
            } else {
                AccessController.doPrivileged(new PrivilegedExceptionAction<Void>((Item)object, (String)object2, string){
                    final /* synthetic */ Item val$entry;
                    final /* synthetic */ String val$key;
                    final /* synthetic */ String val$data;
                    {
                        this.val$entry = item;
                        this.val$key = string;
                        this.val$data = string2;
                    }

                    @Override
                    public Void run() throws IOException {
                        File file = this.val$entry == null ? Index.this.createEntry(this.val$key) : Index.this.getItemFile(this.val$entry);
                        FS.write(file, this.val$data);
                        return null;
                    }
                });
            }
        }
        catch (IOException iOException) {
            MLogger.exception(iOException);
        }
        catch (PrivilegedActionException privilegedActionException) {
            MLogger.exception(privilegedActionException.getCause());
        }
    }

    private static Index getInstancePrivileged() {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager == null) {
            return Index.getInstance();
        }
        return AccessController.doPrivileged(new PrivilegedAction<Index>(){

            @Override
            public Index run() {
                return Index.getInstance();
            }
        });
    }

    private File indexFile(String string, MetaInfo metaInfo) {
        String string2;
        if (metaInfo.isEncrypted()) {
            return null;
        }
        String string3 = metaInfo.getExtension();
        if (string3 == null) {
            return null;
        }
        string3 = TK.toUpperCase(string3);
        File file = null;
        Keywords keywords = null;
        try {
            file = this.createEntry(string);
            if ("HTM".equals(string3) || "HTML".equals(string3) || "TXT".equals(string3)) {
                keywords = this.indexPlainText(metaInfo);
            } else if ("MGLINK".equals(string3) || "MGTODO".equals(string3)) {
                keywords = this.indexXML(metaInfo);
            } else if ("BMP".equals(string3) || "GIF".equals(string3) || "JPG".equals(string3) || "JPEG".equals(string3) || "PNG".equals(string3)) {
                keywords = this.indexImage(metaInfo, string3);
            }
        }
        catch (Exception exception) {
            MLogger.exception(exception);
        }
        if (keywords != null && !(string2 = keywords.toString()).isEmpty()) {
            try {
                FS.write(file, string2);
            }
            catch (IOException iOException) {
                MLogger.exception(iOException);
                return null;
            }
        }
        return file;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Keywords indexImage(MetaInfo metaInfo, String string) throws IOException {
        Iterator<ImageReader> iterator = ImageIO.getImageReadersBySuffix(string);
        if (!iterator.hasNext()) {
            return null;
        }
        ImageReader imageReader = iterator.next();
        try {
            int n = imageReader.getMinIndex();
            imageReader.setInput(ImageIO.createImageInputStream(new FS.BufferedFileInput(metaInfo.getFile())), false, false);
            Keywords keywords = new Keywords(2);
            keywords.addObjects(new Object[]{imageReader.getWidth(n), imageReader.getHeight(n)});
            Keywords keywords2 = keywords;
            return keywords2;
        }
        finally {
            imageReader.dispose();
        }
    }

    private Keywords indexPlainText(MetaInfo metaInfo) throws IOException {
        Keywords keywords = new Keywords();
        keywords.addText(FS.read(metaInfo.getFile(), "UTF8"));
        return keywords;
    }

    private Keywords indexXML(MetaInfo metaInfo) throws IOException {
        final Keywords keywords = new Keywords();
        SimpleXMLReader simpleXMLReader = new SimpleXMLReader(){

            @Override
            protected void onStart(String string) {
                for (String string2 : this.getAttributes().values()) {
                    keywords.addText(string2);
                }
            }

            @Override
            protected void onText() {
                keywords.addText(this.getValue());
            }
        };
        simpleXMLReader.read(metaInfo.getFile());
        return keywords;
    }

    private static final class LazyIndexHolder {
        private static final MGuardedObject<Index> INSTANCE = new MGuardedObject<Index>(new Index(), "org.makagiga.search.Index", PermissionInfo.ThreatLevel.MEDIUM, "Search Index");

        private LazyIndexHolder() {
        }
    }

    private static final class Keywords
    extends HashSet<String> {
        @Override
        public String toString() {
            return TK.toString(this, " ");
        }

        private Keywords() {
            super(512);
        }

        private Keywords(int n) {
            super(n);
        }

        private void addObjects(Object ... objectArray) {
            if (TK.isEmpty(objectArray)) {
                return;
            }
            for (Object object : objectArray) {
                if (object == null) continue;
                if (object instanceof String) {
                    this.addText(object.toString());
                    continue;
                }
                this.add(object.toString());
            }
        }

        private void addText(String string) {
            if (TK.isEmpty(string)) {
                return;
            }
            for (String string2 : TK.fastSplit(string.replace('\n', ' '), ' ')) {
                if (string2.length() <= 2) continue;
                this.add(string2);
            }
        }
    }

    public static final class Item
    extends AbstractFileCache.Item {
        public Item(String string) {
            super(string);
        }
    }
}

