/*
 * Decompiled with CFR 0.152.
 */
package org.makagiga.search;

import java.io.Serializable;
import java.util.Comparator;
import org.makagiga.commons.WTFError;
import org.makagiga.fs.MetaInfo;
import org.makagiga.fs.MetaInfoComparator;
import org.makagiga.search.Hit;
import org.makagiga.search.SortMethod;

public final class SortComparator {
    public static Comparator<Hit> create(SortMethod sortMethod) {
        return new HitComparator(SortComparator.createMetaInfoComparator(sortMethod));
    }

    public static MetaInfoComparator createMetaInfoComparator(SortMethod sortMethod) {
        switch (sortMethod) {
            case AGE: {
                return MetaInfoComparator.BY_AGE;
            }
            case COLOR: {
                return MetaInfoComparator.BY_COLOR;
            }
            case DATE: {
                return MetaInfoComparator.BY_DATE;
            }
            case LABEL: {
                return MetaInfoComparator.BY_LABEL;
            }
            case NAME: {
                return MetaInfoComparator.BY_NAME;
            }
            case PATH: {
                return MetaInfoComparator.BY_PATH;
            }
            case RATING: {
                return MetaInfoComparator.BY_RATING;
            }
            case RATIO: {
                return MetaInfoComparator.BY_RATIO;
            }
            case USAGE: {
                return MetaInfoComparator.BY_USAGE;
            }
        }
        throw new WTFError(sortMethod);
    }

    private SortComparator() {
    }

    private static final class HitComparator
    implements Comparator<Hit>,
    Serializable {
        private MetaInfoComparator metaInfoComparator;

        @Override
        public int compare(Hit hit, Hit hit2) {
            MetaInfo metaInfo = (MetaInfo)hit.get();
            MetaInfo metaInfo2 = (MetaInfo)hit2.get();
            return this.metaInfoComparator.compare(metaInfo, metaInfo2);
        }

        private HitComparator(MetaInfoComparator metaInfoComparator) {
            this.metaInfoComparator = metaInfoComparator;
        }
    }
}

