/*
 * Decompiled with CFR 0.152.
 */
package org.makagiga.tabs;

import javax.swing.JComponent;
import org.makagiga.commons.CoolHeader;
import org.makagiga.commons.Focusable;
import org.makagiga.commons.MButton;
import org.makagiga.commons.MIcon;
import org.makagiga.commons.MMenu;
import org.makagiga.commons.MTip;
import org.makagiga.commons.MToolBar;
import org.makagiga.commons.MWhatsThis;
import org.makagiga.commons.UI;
import org.makagiga.desktop.Desktop;
import org.makagiga.desktop.DesktopPanel;
import org.makagiga.desktop.Pager;
import org.makagiga.editors.Editor;
import org.makagiga.plugins.PluginMenu;

public class DesktopTab
extends Editor<Desktop>
implements Focusable,
PluginMenu {
    private final MButton addWidgetButton;
    private final MTip tip;

    public DesktopTab(Desktop desktop) {
        super(UI._("Widgets"), MIcon.small("ui/desktop"));
        this.setCore(desktop);
        MWhatsThis.set((JComponent)this.core, UI._("Widgets")).setKeyStroke(116);
        DesktopPanel desktopPanel = new DesktopPanel((Desktop)this.core);
        this.tip = desktopPanel.getTip();
        desktopPanel.getBottomPanel().setVisible(false);
        this.addCenter(desktopPanel);
        this.addWidgetButton = desktopPanel.getAddWidgetButton();
    }

    @Override
    public MToolBar.TextPosition getPreferredToolBarTextPosition() {
        return MToolBar.TextPosition.ALONGSIDE_ICONS;
    }

    @Override
    public boolean getSupportsToolBarUnderTabs() {
        return true;
    }

    @Override
    public boolean isCloseable() {
        return false;
    }

    @Override
    public void focus() {
        ((Desktop)this.core).focus();
    }

    @Override
    public void updateMenu(String string, MMenu mMenu) {
        if ("EDIT_MENU".equals(string) && !((Desktop)this.core).isLocked()) {
            mMenu.addTitle(UI._("Add Widget"), "ui/newfile");
            ((Desktop)this.core).createNewWidgetMenu(mMenu, null);
        } else if ("VIEW_MENU_EDITOR".equals(string)) {
            ((Desktop)this.core).updateViewMenu(mMenu, false);
        }
    }

    @Override
    public void updateToolBar(String string, MToolBar mToolBar) {
        if ("EDITOR_TOOL_BAR".equals(string)) {
            mToolBar.addButton(this.addWidgetButton, 1);
            mToolBar.addGap();
            mToolBar.add(Pager.getInstance());
            if (this.tip.isVisible()) {
                this.tip.setDirection(CoolHeader.Direction.BOTTOM);
                mToolBar.addGap();
                mToolBar.add(this.tip);
            }
        }
    }
}

