/*
 * Decompiled with CFR 0.152.
 */
package org.makagiga.tags;

import java.util.Comparator;
import org.makagiga.Vars;
import org.makagiga.commons.BooleanProperty;
import org.makagiga.commons.TK;
import org.makagiga.commons.UI;
import org.makagiga.fs.MetaInfo;
import org.makagiga.tags.Tags;

public final class TagsUtils {
    public static final Comparator<String> COMPARATOR = String.CASE_INSENSITIVE_ORDER;

    @Deprecated
    public static Tags addRemoveTag(MetaInfo metaInfo, String string, boolean bl) {
        Tags tags = TagsUtils.removeDuplicates(metaInfo.getTags());
        if (bl) {
            tags.add(TagsUtils.escapeTag(string));
        } else if (string == null) {
            tags.clear();
        } else {
            tags.remove(string);
        }
        metaInfo.setTags(tags);
        return tags;
    }

    public static void addTag(MetaInfo metaInfo, AutoTag autoTag) {
        if (autoTag.isEnabled()) {
            TagsUtils.addTag(metaInfo, autoTag.getTag());
        }
    }

    public static void addTag(MetaInfo metaInfo, String string) {
        TagsUtils.addRemoveTag(metaInfo, string, true);
    }

    public static String escapeTag(String string) {
        String string2 = string.replace(' ', '_');
        string2 = string2.replace('|', '_');
        return string2;
    }

    public static String getLocalizedTags(String string) {
        Tags tags = new Tags();
        for (String string2 : TK.fastSplit(string, ' ')) {
            tags.add(TagsUtils.getLocalizedText(string2));
        }
        return tags.toString();
    }

    public static String getLocalizedText(String string) {
        for (AutoTag autoTag : AutoTag.values()) {
            if (!string.equals(autoTag.getTag()) && !string.equals(autoTag.getText())) continue;
            return autoTag.getLocalizedText();
        }
        return string;
    }

    public static Tags merge(MetaInfo ... metaInfoArray) {
        StringBuilder stringBuilder = new StringBuilder(1024);
        for (MetaInfo metaInfo : metaInfoArray) {
            if (TK.isEmpty(metaInfo.getTags())) continue;
            if (stringBuilder.length() > 0) {
                stringBuilder.append(' ');
            }
            stringBuilder.append(metaInfo.getTags());
        }
        return TagsUtils.removeDuplicates(stringBuilder.toString());
    }

    public static Tags removeDuplicates(String string) {
        String[] stringArray;
        Tags tags = new Tags();
        if (TK.isEmpty(string)) {
            return tags;
        }
        for (String string2 : stringArray = string.split("\\ |\\,")) {
            if (TK.isEmpty(string2)) continue;
            for (AutoTag autoTag : AutoTag.values()) {
                if (!string2.equals(autoTag.getText()) && !string2.equals(autoTag.getLocalizedText())) continue;
                string2 = autoTag.getTag();
                break;
            }
            tags.add(string2);
        }
        return tags;
    }

    private TagsUtils() {
    }

    public static enum AutoTag {
        EXPORTED("Exported", UI._("Exported"), Vars.tagsAutoExported),
        IMPORTED("Imported", UI._("Imported"), Vars.tagsAutoImported),
        PASTED("Pasted", UI._("Pasted"), Vars.tagsAutoPasted),
        PRINTED("Printed", UI._("Printed"), Vars.tagsAutoPrinted);

        private BooleanProperty property;
        private String localizedText;
        private String tag;
        private String text;

        public String getLocalizedText() {
            return this.localizedText;
        }

        public BooleanProperty getProperty() {
            return this.property;
        }

        public String getTag() {
            return this.tag;
        }

        public String getText() {
            return this.text;
        }

        public boolean isEnabled() {
            return (Boolean)this.property.get();
        }

        public String toString() {
            return this.localizedText;
        }

        private AutoTag(String string2, String string3, BooleanProperty booleanProperty) {
            this.text = string2;
            this.localizedText = string3;
            this.property = booleanProperty;
            this.tag = "SYSTEM:" + string2;
        }
    }
}

