/*
 * Decompiled with CFR 0.152.
 */
package org.makagiga.todo;

import java.util.List;
import org.makagiga.commons.HTMLBuilder;
import org.makagiga.commons.MArrayList;
import org.makagiga.commons.TK;
import org.makagiga.commons.UI;
import org.makagiga.todo.Task;
import org.makagiga.todo.TaskComparator;

public final class TaskList
extends MArrayList<Task> {
    public TaskList() {
        this(50);
    }

    public TaskList(int n) {
        super(n);
    }

    public static int findMaxSummaryLength(List<Task> list) {
        int n = 0;
        for (Task task : list) {
            n = Math.max(n, task.getSummary().length());
        }
        return n;
    }

    public TaskList getImportant() {
        TaskList taskList = new TaskList();
        for (Task task : this) {
            if (task.isDone() || !task.getDateTimeState().isImportant()) continue;
            taskList.add(task);
        }
        return taskList;
    }

    public String getToolTipText(int n) {
        if (this.isEmpty()) {
            return "";
        }
        int n2 = 0;
        HTMLBuilder hTMLBuilder = new HTMLBuilder();
        hTMLBuilder.beginTag("span", "style", "font-family: Dialog");
        for (Task task : this) {
            if (task.isDone()) continue;
            if (n2 == n) {
                hTMLBuilder.doubleTag("i", HTMLBuilder.escape(UI._("More...")), new Object[0]);
                hTMLBuilder.emit("<br>");
                break;
            }
            hTMLBuilder.emit("\u27a4 ");
            hTMLBuilder.appendLine(HTMLBuilder.escape(TK.centerSqueeze(task.getSummary(), 80)));
            hTMLBuilder.emit("<br>");
            ++n2;
        }
        hTMLBuilder.endTag("span");
        return hTMLBuilder.toString();
    }

    @Override
    public void sort() {
        this.sort(TaskComparator.BY_DATE_TIME);
    }
}

