/*
 * Decompiled with CFR 0.152.
 */
package org.makagiga.todo;

import java.awt.Color;
import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import org.makagiga.chart.ChartModel;
import org.makagiga.commons.AbstractListTableModel;
import org.makagiga.commons.FS;
import org.makagiga.commons.MColor;
import org.makagiga.commons.MDate;
import org.makagiga.commons.SimpleXMLReader;
import org.makagiga.commons.TK;
import org.makagiga.commons.UI;
import org.makagiga.commons.XMLBuilder;
import org.makagiga.todo.Column;
import org.makagiga.todo.Priority;
import org.makagiga.todo.Task;

public class TaskModel
extends AbstractListTableModel<Task> {
    public TaskModel() {
        super(Column.getColumnInfo());
    }

    public ChartModel createChartModel() {
        return TaskModel.createChartModel(this.getRows());
    }

    public static ChartModel createChartModel(List<Task> list) {
        ChartModel chartModel = new ChartModel();
        if (TK.isEmpty(list)) {
            chartModel.addEmptyInfo(Color.BLACK);
        } else {
            chartModel.setFormat("${text} (${percent-float})");
            long l = 0L;
            long l2 = list.size();
            long l3 = 0L;
            long l4 = l2 * 100L;
            for (Task task : list) {
                if (task.isDone()) {
                    ++l;
                }
                l3 += (long)task.getComplete();
            }
            if (l3 > 0L) {
                chartModel.addItem(UI._("Done - {0}", l), l3, MColor.getDarker(Color.GREEN), "ui/complete");
            }
            if ((l4 -= l3) > 0L) {
                chartModel.addItem(UI._("To-Do - {0}", l2 - l), l4, Color.BLACK);
            }
        }
        return chartModel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadFromXML(File file, boolean bl) throws Exception {
        FS.BufferedFileInput bufferedFileInput = null;
        try {
            bufferedFileInput = new FS.BufferedFileInput(file);
            this.loadFromXML(bufferedFileInput, bl);
        }
        catch (Throwable throwable) {
            FS.close(bufferedFileInput);
            throw throwable;
        }
        FS.close(bufferedFileInput);
    }

    public void loadFromXML(String string, boolean bl) throws Exception {
        this.loadFromXML(new File(string), bl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadFromXML(InputStream inputStream, boolean bl) throws Exception {
        if (bl) {
            this.setEventsEnabled(true);
            return;
        }
        try {
            this.setEventsEnabled(false);
            this.clear();
            SimpleXMLReader simpleXMLReader = new SimpleXMLReader(){
                private Task task;

                @Override
                protected void onEnd(String string) {
                    if (string.equals("item")) {
                        TaskModel.this.addRow(this.task);
                    }
                }

                @Override
                protected void onStart(String string) {
                    if (string.equals("item")) {
                        this.task = new Task();
                        this.task.setComplete(this.getIntegerAttribute("complete", 0));
                        String string2 = this.getStringAttribute("priority");
                        this.task.setPriority(string2 == null ? Priority.DEFAULT : Priority.fromString(string2));
                    } else if (string.equals("category")) {
                        this.task.setCategory(this.getValue(""));
                    } else if (string.equals("completedatetime")) {
                        this.task.setCompleteDateTime(Task.parseDateTime(this.getStringAttribute("value")));
                    } else if (string.equals("datetime")) {
                        this.task.setDateTime(Task.parseDateTime(this.getStringAttribute("value")));
                    } else if (string.equals("startdatetime")) {
                        this.task.setStartDateTime(Task.parseDateTime(this.getStringAttribute("value")));
                    } else if (string.equals("summary")) {
                        this.task.setSummary(this.getValue(""));
                    }
                }
            };
            simpleXMLReader.read(inputStream);
        }
        finally {
            this.fireTableDataChanged();
            this.setEventsEnabled(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveToXML(File file) throws Exception {
        FS.BufferedFileOutput bufferedFileOutput = null;
        try {
            bufferedFileOutput = new FS.BufferedFileOutput(file);
            this.saveToXML(bufferedFileOutput);
        }
        catch (Throwable throwable) {
            FS.close(bufferedFileOutput);
            throw throwable;
        }
        FS.close(bufferedFileOutput);
    }

    public void saveToXML(String string) throws Exception {
        this.saveToXML(new File(string));
    }

    public void saveToXML(OutputStream outputStream) throws Exception {
        XMLBuilder xMLBuilder = new XMLBuilder();
        xMLBuilder.beginTag("todo", "version", 3);
        for (Task task : this) {
            this.writeItemAsXML(xMLBuilder, task);
        }
        xMLBuilder.endTag("todo");
        xMLBuilder.save(outputStream);
    }

    @Override
    public Object getValueAt(int n, int n2) {
        if (this.isEmpty() || n < 0 || n > this.getRowCount() - 1) {
            return null;
        }
        Task task = (Task)this.getRowAt(n);
        if (n2 == Column.DONE.ordinal()) {
            return task.isDone();
        }
        if (n2 == Column.SUMMARY.ordinal()) {
            return task.getSummary();
        }
        if (n2 == Column.PRIORITY.ordinal()) {
            return task.getPriority();
        }
        if (n2 == Column.COMPLETE.ordinal()) {
            return task.getComplete();
        }
        if (n2 == Column.DATE_TIME.ordinal()) {
            return task.getDateTime();
        }
        if (n2 == Column.START_DATE_TIME.ordinal()) {
            return task.getStartDateTime();
        }
        if (n2 == Column.COMPLETE_DATE_TIME.ordinal()) {
            return task.getCompleteDateTime();
        }
        if (n2 == Column.CATEGORY.ordinal()) {
            return task.getCategory();
        }
        if (n2 == Column.CIRCLE.ordinal()) {
            return task;
        }
        return null;
    }

    @Override
    public void setValueAt(Object object, int n, int n2) {
        Task task = (Task)this.getRowAt(n);
        Task task2 = this.createCopyForUndo(task);
        if (n2 == Column.DONE.ordinal()) {
            task.setComplete(Boolean.TRUE.equals(object) ? 100 : 0);
            this.updateCompleteDateTime(task);
        } else if (n2 == Column.SUMMARY.ordinal()) {
            task.setSummary((String)object);
        } else if (n2 == Column.PRIORITY.ordinal()) {
            task.setPriority((Priority)((Object)object));
        } else if (n2 == Column.COMPLETE.ordinal()) {
            task.setComplete((Integer)object);
            this.updateCompleteDateTime(task);
        } else if (n2 == Column.DATE_TIME.ordinal()) {
            task.setDateTime((MDate)object);
        } else if (n2 == Column.START_DATE_TIME.ordinal()) {
            task.setStartDateTime((MDate)object);
        } else if (n2 == Column.COMPLETE_DATE_TIME.ordinal()) {
            task.setCompleteDateTime((MDate)object);
        } else if (n2 == Column.CATEGORY.ordinal()) {
            task.setCategory((String)object);
        } else if (n2 != Column.CIRCLE.ordinal()) {
            return;
        }
        this.fireTableRowsUpdated(n, n);
        if (!task.equals(task2)) {
            this.fireUndoableEditHappened(new AbstractListTableModel.ChangeUndo(task2, this.createCopyForUndo(task), n));
        }
    }

    @Override
    public Task createCopyForUndo(Task task) {
        return (Task)task.clone();
    }

    private void updateCompleteDateTime(Task task) {
        if (task.isDone()) {
            task.setCompleteDateTime(MDate.now());
        } else {
            task.setCompleteDateTime(MDate.invalid());
        }
    }

    private void writeItemAsXML(XMLBuilder xMLBuilder, Task task) {
        xMLBuilder.beginTag("item", "priority", task.getPriority().ordinal(), "complete", task.getComplete());
        xMLBuilder.doubleTag("summary", XMLBuilder.escape(task.getSummary()), new Object[0]);
        xMLBuilder.doubleTag("category", XMLBuilder.escape(task.getCategory()), new Object[0]);
        this.writeItemDate(xMLBuilder, task.getDateTime(), "datetime");
        this.writeItemDate(xMLBuilder, task.getStartDateTime(), "startdatetime");
        this.writeItemDate(xMLBuilder, task.getCompleteDateTime(), "completedatetime");
        xMLBuilder.endTag("item");
    }

    private void writeItemDate(XMLBuilder xMLBuilder, MDate mDate, String string) {
        if (mDate != null) {
            xMLBuilder.singleTag(string, "value", mDate.isValid() ? mDate.formatRFC3339() : Integer.valueOf(0));
        } else {
            xMLBuilder.singleTag(string, "value", 0);
        }
    }
}

