/*
 * Decompiled with CFR 0.152.
 */
package org.makagiga.tools;

import java.awt.Color;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.util.Collection;
import java.util.Locale;
import java.util.Map;
import javax.swing.Action;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.KeyStroke;
import org.makagiga.MainWindow;
import org.makagiga.commons.Args;
import org.makagiga.commons.ColorProperty;
import org.makagiga.commons.FS;
import org.makagiga.commons.HTMLBuilder;
import org.makagiga.commons.MAction;
import org.makagiga.commons.MApplication;
import org.makagiga.commons.MArrayList;
import org.makagiga.commons.MColor;
import org.makagiga.commons.MLogger;
import org.makagiga.commons.MMainWindow;
import org.makagiga.commons.MMenu;
import org.makagiga.commons.MMenuBar;
import org.makagiga.commons.MMenuItem;
import org.makagiga.commons.MObject;
import org.makagiga.commons.MWhatsThis;
import org.makagiga.commons.MainView;
import org.makagiga.commons.Mnemonic;
import org.makagiga.commons.MouseGestures;
import org.makagiga.commons.OS;
import org.makagiga.commons.TK;
import org.makagiga.commons.UI;
import org.makagiga.commons.util.CollectionMap;
import org.makagiga.tools.Browser;

public final class Help {
    private static boolean cached;
    private boolean highlightRow;
    private final CollectionMap<String, Shortcut> shortcutInfo = new CollectionMap(CollectionMap.MapType.LINKED_HASH_MAP, CollectionMap.CollectionType.TREE_SET);
    private HTMLBuilder builder;
    private final MArrayList<MMenu> excludeMenus = MArrayList.create();
    private MMenuBar menuBar;
    private final String menuBackground;
    private final String menuForeground;
    private final String menuItemBackground1;
    private final String menuItemBackground2;
    private final String menuItemForeground;
    private String outputDir;
    private String shortcutGroup = "";
    private String title = "";

    public Help() {
        Color color = MApplication.getLightBrandColor();
        color = MColor.getBrighter(color);
        this.menuBackground = ColorProperty.toString(color);
        this.menuForeground = ColorProperty.toString(MColor.BLACK);
        Color color2 = MColor.WHITE;
        this.menuItemBackground1 = ColorProperty.toString(color2);
        this.menuItemBackground2 = ColorProperty.toString(UI.getDarker(color2, Color.WHITE));
        this.menuItemForeground = ColorProperty.toString(MColor.BLACK);
    }

    public void addExcludeMenu(MMenu mMenu) {
        this.excludeMenus.add(mMenu);
    }

    public void addShortcut(String string) {
        this.shortcutGroup = string;
    }

    public void addShortcut(String string, int n) {
        this.addShortcut(string, n, 0);
    }

    public void addShortcut(String string, int n, int n2) {
        this.shortcutInfo.add(this.shortcutGroup, new Shortcut(string, n, n2));
    }

    public boolean generate() {
        try {
            this.processActions();
            if (cached) {
                return true;
            }
            this.builder = new HTMLBuilder("<!DOCTYPE HTML PUBLIC \"-//W3C//DTD HTML 4.01 Transitional//EN\" \"http://www.w3.org/TR/html4/loose.dtd\">");
            this.beginDocument(this.title);
            if (!this.shortcutInfo.isEmpty()) {
                this.addIndexLink("shortcuts.html", UI._("Keyboard Shortcuts"));
            }
            if (this.menuBar != null) {
                this.addIndexLink("actions.html", UI._("Menu"));
            }
            this.addIndexLink("mousegestures.html", UI._("Mouse Gestures"));
            this.addIndexLink("cli.html", UI._("Command Line Options"));
            this.addSeparator();
            this.addIndexLink(this.getReadmeURL(), UI._("README"));
            this.addIndexLink("http://sourceforge.net/apps/mediawiki/makagiga/index.php?title=Main_Page", UI._("Documentation"));
            this.addSeparator();
            this.addIndexLink(MApplication.getBugs(), UI._("Report Bug..."));
            this.builder.endDoc();
            this.builder.save(FS.makePath(this.outputDir, "index.html"));
            this.processShortcuts();
            this.processCommandLineOptions();
            this.processMouseGestures();
            cached = true;
            return true;
        }
        catch (IOException iOException) {
            MLogger.exception(iOException);
            return false;
        }
    }

    public static void show() {
        KeyStroke keyStroke;
        MainWindow mainWindow = MainWindow.getInstance();
        String string = FS.makeConfigPath("help", 1);
        Help help = new Help();
        help.addExcludeMenu((MMenu)mainWindow.getElementById("bookmarks-menu"));
        help.addExcludeMenu((MMenu)mainWindow.getElementById("export-menu"));
        help.addExcludeMenu((MMenu)mainWindow.getElementById("import-menu"));
        help.addExcludeMenu((MMenu)mainWindow.getElementById("tags-menu"));
        help.setMenuBar(mainWindow.getMMenuBar());
        help.setOutputDir(string);
        help.setTitle(MApplication.getTitle());
        help.addShortcut(UI._("Common Keyboard Shortcuts"));
        for (Action object : MainView.getBindList()) {
            if (!(object instanceof MAction)) continue;
            MAction mAction = (MAction)object;
            keyStroke = mAction.getAcceleratorKey();
            if (keyStroke != null) {
                help.addShortcut(mAction.getName(), keyStroke.getKeyCode(), keyStroke.getModifiers());
            }
            if ((keyStroke = mAction.getAlternateAcceleratorKey()) == null) continue;
            help.addShortcut(mAction.getName(), keyStroke.getKeyCode(), keyStroke.getModifiers());
        }
        Object object = Mnemonic.getTabKeys();
        help.addShortcut(UI._("Change active tab ({0}..{1})", TK.toString((int)object[0], 8), TK.toString((int)object[((Object)object).length - 1], 8)), 49, 8);
        help.addShortcut(UI._("Open selected link"), 32, 2);
        help.addShortcut(UI._("Rename selected item"), 113);
        help.addShortcut(UI._("Move between the Tree and Tabs"), 117);
        help.addShortcut(UI._("Move to the splitter bar (press Tab to cancel)"), 119);
        help.addShortcut(UI._("Activate context menu"), 121, 1);
        help.addShortcut(UI._("Show tool tip text"), 112, 2);
        help.addShortcut(UI._("Change layout (right-to-left)"), 79, 3);
        for (MWhatsThis.Info info : MWhatsThis.getAll(MainView.getWindow())) {
            keyStroke = info.getKeyStroke();
            if (keyStroke == null) continue;
            help.addShortcut(info.getText(), keyStroke.getKeyCode(), keyStroke.getModifiers());
        }
        help.addShortcut(UI._("Image Viewer"));
        help.addShortcut(UI._("Next"), 32);
        help.addShortcut(UI._("Previous"), 8);
        help.addShortcut(UI._("Todo List/Table"));
        help.addShortcut(UI._("Edit cell"), 113);
        help.addShortcut(UI._("Focus header"), 119);
        help.addShortcut(UI._("Move to the previous panel"), 9, 3);
        help.addShortcut(UI._("Widgets"));
        help.addShortcut(UI._("Close active widget"), 115, 2);
        help.addShortcut(UI._("Activate next widget"), 117, 2);
        help.addShortcut(UI._("Minimize active widget"), 120, 2);
        help.generate();
        Browser.openURL(FS.toURL(string + "/index.html").toString());
    }

    public void setMenuBar(MMenuBar mMenuBar) {
        this.menuBar = mMenuBar;
    }

    public void setOutputDir(String string) {
        this.outputDir = string;
    }

    public void setTitle(String string) {
        this.title = string;
    }

    private void addIndexLink(String string, String string2) {
        this.builder.doubleTag("p", HTMLBuilder.createLink(string, string2), "class", "indexitem");
    }

    private void addSeparator() {
        this.builder.singleTag("hr", new Object[0]);
    }

    private void beginDocument(String string) {
        this.builder.beginHTML(string, "UTF-8");
        this.builder.beginStyle();
        this.builder.setDefaultStyle();
        this.builder.beginRule("body");
        this.builder.addAttr("margin", "0px");
        this.builder.addAttr("padding", "0px");
        this.builder.endRule();
        this.builder.beginRule("p.indexitem");
        this.builder.addAttr("font-size", "larger");
        this.builder.addAttr("font-weight", "bold");
        this.builder.addAttr("margin", "5px");
        this.builder.addAttr("padding", "0px");
        this.builder.endRule();
        this.builder.beginRule("table");
        this.builder.addAttr("border", "0px solid black");
        this.builder.addAttr("border-spacing", "0px");
        this.builder.addAttr("margin", "0px");
        this.builder.addAttr("width", "100%");
        this.builder.endRule();
        this.builder.beginRule("td.header");
        this.builder.addAttr("font-size", "larger");
        this.builder.addAttr("font-weight", "bold");
        this.builder.endRule();
        this.builder.endStyle();
        this.builder.beginDoc();
    }

    private File findReadmeFile(String string, Locale locale) {
        File file;
        String string2 = "README";
        if (locale != null) {
            string2 = string2 + "_" + locale.getLanguage();
        }
        return (file = new File(string, string2 = string2 + ".html")).exists() ? file : null;
    }

    private String getMenuItemStyle() {
        return String.format("background-color: %s; color: %s", this.highlightRow ? this.menuItemBackground1 : this.menuItemBackground2, this.menuItemForeground);
    }

    private String getMenuStyle() {
        return String.format("background-color: %s; color: %s", this.menuBackground, this.menuForeground);
    }

    private String getReadmeURL() {
        File file;
        Object object;
        File file2 = this.findReadmeFile(FS.getBaseDir(), null);
        if (file2 == null && OS.isLinux()) {
            object = FS.getInstallPrefix("/usr");
            file2 = this.findReadmeFile((String)object + "/share/doc/makagiga-" + MApplication.getFileVersion(), null);
        }
        if (file2 != null && (object = file2.getParent()) != null && (file = this.findReadmeFile((String)object, OS.getLocale())) != null) {
            file2 = file;
        }
        if (file2 != null) {
            MLogger.debug("browser", "Using local README file: %s", file2);
            return FS.toURL(file2).toString();
        }
        object = URI.create(MApplication.getHomePage() + "/README.html");
        MLogger.debug("browser", "Using online README file: %s", object);
        return ((URI)object).toString();
    }

    private void processActions() throws IOException {
        if (this.menuBar == null) {
            return;
        }
        this.builder = new HTMLBuilder("<!DOCTYPE HTML PUBLIC \"-//W3C//DTD HTML 4.01 Transitional//EN\" \"http://www.w3.org/TR/html4/loose.dtd\">");
        this.beginDocument(UI._("Actions"));
        this.builder.beginTag("table");
        for (JMenu jMenu : this.menuBar) {
            if (!(jMenu instanceof MMenu) || this.excludeMenus.contains((MMenu)jMenu)) continue;
            this.processMenu((MMenu)jMenu);
        }
        this.builder.endTag("table");
        this.builder.endDoc();
        this.builder.save(FS.makePath(this.outputDir, "actions.html"));
    }

    private void processCommandLineOptions() throws IOException {
        this.builder = new HTMLBuilder("<!DOCTYPE HTML PUBLIC \"-//W3C//DTD HTML 4.01 Transitional//EN\" \"http://www.w3.org/TR/html4/loose.dtd\">");
        this.beginDocument(UI._("Command Line Options"));
        this.builder.beginTag("table");
        this.builder.beginTag("tr", "style", this.getMenuStyle());
        this.builder.doubleTag("td", HTMLBuilder.escape(UI._("Command Line Options")), "class", "header", "colspan", 2);
        this.builder.endTag("tr");
        this.highlightRow = false;
        for (Map.Entry<String, String> entry : Args.getAdded().entrySet()) {
            this.builder.beginTag("tr");
            this.builder.doubleTag("td", HTMLBuilder.escape("--" + entry.getKey()), "style", this.getMenuItemStyle() + "; font-family: " + "Dialog");
            this.builder.doubleTag("td", HTMLBuilder.escape(entry.getValue()), "style", this.getMenuItemStyle());
            this.builder.endTag("tr");
            this.highlightRow = !this.highlightRow;
        }
        this.builder.endTag("table");
        this.builder.endDoc();
        this.builder.save(FS.makePath(this.outputDir, "cli.html"));
    }

    private void processMenu(MMenu mMenu) throws IOException {
        if (mMenu == null || mMenu.isEmpty()) {
            return;
        }
        this.builder.beginTag("tr", "style", this.getMenuStyle());
        this.builder.doubleTag("td", HTMLBuilder.escape(mMenu.getText()), "class", "header", "colspan", 2);
        this.builder.endTag("tr");
        this.highlightRow = false;
        for (JMenuItem jMenuItem : mMenu) {
            if (jMenuItem instanceof MMenu) {
                if (this.excludeMenus.contains((MMenu)jMenuItem)) continue;
                this.processMenu((MMenu)jMenuItem);
                continue;
            }
            if (!(jMenuItem instanceof MMenuItem)) continue;
            this.processMenuItem((MMenuItem)jMenuItem);
        }
    }

    private void processMenuItem(MMenuItem mMenuItem) throws IOException {
        if (mMenuItem == null) {
            return;
        }
        String string = mMenuItem.getText();
        if (TK.isEmpty(string)) {
            return;
        }
        MAction mAction = mMenuItem.getAction();
        KeyStroke keyStroke = null;
        String string2 = null;
        if (mAction != null) {
            string2 = mAction.getLongDescription();
            if (string2 != null) {
                string2 = string2.replace("<html><body>", "");
                string2 = string2.replace("</body></html>", "");
            }
            keyStroke = mAction.getAcceleratorKey();
        }
        this.builder.beginTag("tr", "style", this.getMenuItemStyle());
        String string3 = keyStroke == null ? "" : "<br><br>" + HTMLBuilder.escape(TK.toString(keyStroke));
        this.builder.doubleTag("td", HTMLBuilder.escape(string) + string3, new Object[0]);
        this.builder.doubleTag("td", string2, new Object[0]);
        this.builder.endTag("tr");
        this.highlightRow = !this.highlightRow;
    }

    private void processMouseGestures() throws IOException {
        MMainWindow mMainWindow = (MMainWindow)MainView.getWindow();
        MouseGestures mouseGestures = mMainWindow.getMouseGestures();
        mouseGestures.initOnDemand();
        this.highlightRow = false;
        this.builder = new HTMLBuilder("<!DOCTYPE HTML PUBLIC \"-//W3C//DTD HTML 4.01 Transitional//EN\" \"http://www.w3.org/TR/html4/loose.dtd\">");
        this.beginDocument(UI._("Keyboard Shortcuts"));
        this.builder.beginTag("table");
        this.builder.beginTag("tr", "style", this.getMenuStyle());
        this.builder.doubleTag("td", HTMLBuilder.escape(UI._("Mouse Gestures (hold middle or right mouse button, move...)")), "class", "header", "colspan", 2);
        this.builder.endTag("tr");
        this.builder.beginTag("tr");
        this.builder.doubleTag("td", String.format("<b>%s</b>", HTMLBuilder.escape(UI._("Gesture"))), "style", this.getMenuItemStyle());
        this.builder.doubleTag("td", String.format("<b>%s</b>", HTMLBuilder.escape(UI._("Description"))), "style", this.getMenuItemStyle());
        this.builder.endTag("tr");
        this.highlightRow = true;
        for (Map.Entry<String, MouseGestures.Gesture> entry : mouseGestures.getGestures().entrySet()) {
            this.builder.beginTag("tr");
            this.builder.doubleTag("td", HTMLBuilder.escape(mouseGestures.getGesturePath(entry.getKey(), true)).replace(" ", "&nbsp;"), "style", this.getMenuItemStyle() + "; font-family: " + "Dialog");
            this.builder.doubleTag("td", HTMLBuilder.escape(entry.getValue().getDescription()), "style", this.getMenuItemStyle());
            this.builder.endTag("tr");
            this.highlightRow = !this.highlightRow;
        }
        this.builder.endTag("table");
        this.builder.endDoc();
        this.builder.save(FS.makePath(this.outputDir, "mousegestures.html"));
    }

    private void processShortcuts() throws IOException {
        if (this.shortcutInfo.isEmpty()) {
            return;
        }
        this.highlightRow = false;
        this.builder = new HTMLBuilder("<!DOCTYPE HTML PUBLIC \"-//W3C//DTD HTML 4.01 Transitional//EN\" \"http://www.w3.org/TR/html4/loose.dtd\">");
        this.beginDocument(UI._("Keyboard Shortcuts"));
        this.builder.beginTag("table");
        for (Map.Entry<String, Collection<Shortcut>> entry : this.shortcutInfo) {
            String string = entry.getKey();
            if (!string.isEmpty()) {
                this.highlightRow = false;
                this.builder.beginTag("tr", "style", this.getMenuStyle());
                this.builder.doubleTag("td", HTMLBuilder.escape(string), "class", "header", "colspan", 2);
                this.builder.endTag("tr");
            }
            for (Shortcut shortcut : entry.getValue()) {
                if (!shortcut.isValid()) continue;
                this.builder.beginTag("tr");
                this.builder.doubleTag("td", HTMLBuilder.escape(shortcut.toString()), "style", this.getMenuItemStyle());
                this.builder.doubleTag("td", HTMLBuilder.escape(shortcut.description), "style", this.getMenuItemStyle());
                this.builder.endTag("tr");
                this.highlightRow = !this.highlightRow;
            }
        }
        this.builder.endTag("table");
        this.builder.endDoc();
        this.builder.save(FS.makePath(this.outputDir, "shortcuts.html"));
    }

    private static final class Shortcut
    implements Comparable<Shortcut> {
        private final int hash;
        private final int keyCode;
        private final int modifiers;
        private final String description;
        private final String keyStrokeString;

        public boolean equals(Object object) {
            switch (MObject.maybeEquals(this, object)) {
                case YES: {
                    return true;
                }
                case NO: {
                    return false;
                }
            }
            Shortcut shortcut = (Shortcut)object;
            return this.keyCode == shortcut.keyCode && this.modifiers == shortcut.modifiers;
        }

        public int hashCode() {
            return this.hash;
        }

        public String toString() {
            return this.keyStrokeString;
        }

        @Override
        public int compareTo(Shortcut shortcut) {
            return this.keyStrokeString.compareTo(shortcut.keyStrokeString);
        }

        private Shortcut(String string, int n, int n2) {
            this.description = string;
            this.keyCode = n;
            this.modifiers = n2;
            this.hash = MObject.hashCode(n, n2);
            this.keyStrokeString = this.isValid() ? TK.toString(n, n2) : "";
        }

        private boolean isValid() {
            return this.keyCode != 0 || this.modifiers != 0;
        }
    }
}

