/*
 * Decompiled with CFR 0.152.
 */
package org.makagiga.tools.summary;

import java.awt.Color;
import java.awt.Component;
import java.io.File;
import java.io.Serializable;
import java.util.Calendar;
import java.util.Collections;
import java.util.Comparator;
import java.util.EnumMap;
import java.util.GregorianCalendar;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Observable;
import java.util.Observer;
import javax.swing.Icon;
import javax.swing.tree.MutableTreeNode;
import org.makagiga.MainWindow;
import org.makagiga.Sidebar;
import org.makagiga.Tabs;
import org.makagiga.Vars;
import org.makagiga.chart.ChartModel;
import org.makagiga.chart.ChartPainter;
import org.makagiga.commons.MApplication;
import org.makagiga.commons.MArrayList;
import org.makagiga.commons.MCalendar;
import org.makagiga.commons.MCalendarPanel;
import org.makagiga.commons.MDate;
import org.makagiga.commons.MGuardedObject;
import org.makagiga.commons.MIcon;
import org.makagiga.commons.MLogger;
import org.makagiga.commons.MObject;
import org.makagiga.commons.MSystemTray;
import org.makagiga.commons.MTimer;
import org.makagiga.commons.MTreeItem;
import org.makagiga.commons.MTreeModel;
import org.makagiga.commons.MV;
import org.makagiga.commons.PermissionInfo;
import org.makagiga.commons.ReferenceCount;
import org.makagiga.commons.TK;
import org.makagiga.commons.TriBoolean;
import org.makagiga.commons.Tuple;
import org.makagiga.commons.UI;
import org.makagiga.commons.request.AbstractRequestManager;
import org.makagiga.commons.request.RequestInfo;
import org.makagiga.commons.request.RequestProperties;
import org.makagiga.commons.request.RequestSource;
import org.makagiga.desktop.Widget;
import org.makagiga.desktop.WidgetInternalFrame;
import org.makagiga.editors.Editor;
import org.makagiga.editors.todo.TodoEditor;
import org.makagiga.fs.MetaInfo;
import org.makagiga.fs.MetaInfoComparator;
import org.makagiga.plugins.PluginInfo;
import org.makagiga.todo.Column;
import org.makagiga.todo.Task;
import org.makagiga.todo.TaskComparator;
import org.makagiga.todo.TaskList;
import org.makagiga.todo.TaskModel;
import org.makagiga.todo.TaskState;
import org.makagiga.tools.summary.Reminder;
import org.makagiga.tools.summary.SummaryPanel;
import org.makagiga.tools.summary.SummaryTree;
import org.makagiga.tree.tracker.Tracker;
import org.makagiga.tree.tracker.TrackerEvent;
import org.makagiga.tree.tracker.TrackerListener;

public final class SummaryData
extends MTreeModel<Node>
implements RequestSource<List<Task>>,
TrackerListener {
    private boolean firstRefresh = true;
    private boolean idle;
    private final Events events = new Events();
    private final Map<DayKey, TaskList> dayMap = TK.newHashMap();
    private final Map<TaskState, Node> taskStateMap = new EnumMap<TaskState, Node>(TaskState.class);
    private final MetaInfoNodeComparator metaInfoNodeComparator = new MetaInfoNodeComparator(MetaInfoComparator.BY_NAME);
    private final MTimer notifyTimer;
    private final TaskReader taskReader = new TaskReader();

    public void addObserver(Observer observer) {
        this.events.addObserver(observer);
    }

    public void removeObserver(Observer observer) {
        this.events.deleteObserver(observer);
    }

    public Chart getChart() {
        MDate mDate = MDate.now();
        ReferenceCount<TaskState> referenceCount = new ReferenceCount<TaskState>();
        for (Map.Entry<TaskState, Node> object : this.taskStateMap.entrySet()) {
            for (Node node : object.getValue().list(MV.MODEL)) {
                for (Node node2 : node.list(MV.MODEL)) {
                    referenceCount.addReference(node2.getTask().getDateTimeStateNow(mDate));
                }
            }
        }
        ChartModel chartModel = new ChartModel();
        if (referenceCount.isEmpty()) {
            chartModel.addEmptyInfo(MApplication.getLightBrandColor());
        } else {
            chartModel.setFormat("${text} - ${number}");
            for (Map.Entry entry : TK.sortByKey(referenceCount, null).entrySet()) {
                TaskState taskState = (TaskState)((Object)entry.getKey());
                Color color = taskState.getColorForPaint();
                ChartModel.Item item = chartModel.addItem(taskState.toString(), (long)((Integer)entry.getValue()).intValue(), color, taskState.getIcon());
                item.setProperty("state", (Object)taskState);
            }
        }
        return new Chart(chartModel);
    }

    public Comparator<MutableTreeNode> getComparator() {
        return this.getComparator((Column)((Object)Vars.summarySortMethod.get()));
    }

    public Comparator<MutableTreeNode> getComparator(Column column) {
        return new NodeComparator(TaskComparator.get(column));
    }

    public static SummaryData getInstance() {
        return (SummaryData)LazySummaryDataHolder.INSTANCE.get();
    }

    public Map<TaskState, Node> getTaskStateMap() {
        return this.taskStateMap;
    }

    public boolean isIdle() {
        return this.idle;
    }

    public void updateAlarms() {
        int n = 0;
        MArrayList<Tuple.Two<MetaInfo, Task>> mArrayList = MArrayList.create(50);
        MDate mDate = MDate.now();
        for (Map.Entry<TaskState, Node> entry : this.taskStateMap.entrySet()) {
            for (Node node : entry.getValue().list(MV.MODEL)) {
                for (Node node2 : node.list(MV.MODEL)) {
                    Task task = node2.getTask();
                    TaskState taskState = task.getDateTimeStateNow(mDate);
                    if (!taskState.isImportant() || task.isDone()) continue;
                    ++n;
                    mArrayList.add(Tuple.of(node.getMetaInfo(), task));
                }
            }
        }
        this.updateAlarms(n, mArrayList);
    }

    public void updateCalendar(MCalendarPanel mCalendarPanel) {
        Calendar calendar = mCalendarPanel.getCalendar();
        int n = calendar.get(2);
        int n2 = calendar.get(1);
        this.dayMap.clear();
        for (Map.Entry<TaskState, Node> entry : this.taskStateMap.entrySet()) {
            TaskState taskState = entry.getKey();
            if (taskState == TaskState.UNKNOWN) continue;
            for (Node node : entry.getValue().list(MV.MODEL)) {
                this.updateCalendar(node, n2, n);
            }
        }
        mCalendarPanel.updateRenderer(n2, n);
    }

    @Override
    public void requestDone(RequestInfo<List<Task>> requestInfo, List<Task> list) {
        if (!TK.isEmpty(list)) {
            MetaInfo metaInfo = requestInfo.getProperty("metaInfo", null);
            this.todoAdded(metaInfo, null, list, false);
            this.expandImportantNodes();
            this.notifyObserversLater();
        }
    }

    @Override
    public void itemChanged(TrackerEvent trackerEvent) {
        if (!trackerEvent.isTodo()) {
            return;
        }
        MetaInfo metaInfo = trackerEvent.getMetaInfo();
        if (metaInfo.isEncrypted()) {
            return;
        }
        MLogger.debug("summary", "%s: %s", new Object[]{trackerEvent.getID(), metaInfo});
        switch (trackerEvent.getID()) {
            case ITEM_ADDED: {
                this.readTaskListAsync(metaInfo);
                break;
            }
            case ITEM_REMOVED: {
                block8: for (Node node : this.taskStateMap.values()) {
                    for (Node node2 : node.list(MV.MODEL)) {
                        if (node2.getMetaInfo() != metaInfo) continue;
                        node2.removeFromParent();
                        this.reload(node);
                        continue block8;
                    }
                }
                Reminder.hideNotifications(metaInfo, null);
                break;
            }
            case ITEM_ICON_CHANGED: 
            case ITEM_RENAMED: {
                for (Node node : this.taskStateMap.values()) {
                    for (Node node3 : node.list(MV.MODEL)) {
                        if (node3.getMetaInfo() != metaInfo) continue;
                        this.reload(node3);
                    }
                }
                if (!((Boolean)Vars.alarmEnabled.get()).booleanValue()) break;
                Reminder.updateNotifications(metaInfo);
                break;
            }
            case ITEM_SAVED: {
                return;
            }
            case TODO_ADDED: {
                Reload reload = new Reload();
                this.todoAdded(metaInfo, reload, (TaskList)trackerEvent.getData(), true);
                reload.reload();
                this.expandImportantNodes();
                break;
            }
            case TODO_CHANGED: 
            case TODO_REMOVED: {
                Reload reload = new Reload();
                for (Node node : this.taskStateMap.values()) {
                    for (Node node4 : node.list(MV.MODEL)) {
                        if (trackerEvent.getMetaInfo() != node4.getMetaInfo()) continue;
                        reload.add(node4);
                        node4.removeAllChildren();
                    }
                }
                this.todoAdded(metaInfo, reload, (List)trackerEvent.getData(), true);
                for (Node node : this.taskStateMap.values()) {
                    for (Node node4 : node.list(MV.MODEL)) {
                        if (!node4.isEmpty(MV.MODEL)) continue;
                        reload.add((Node)node4.getParent());
                        node4.removeFromParent();
                    }
                }
                reload.reload();
                this.expandImportantNodes();
                break;
            }
            default: {
                return;
            }
        }
        this.notifyObserversLater();
    }

    private SummaryData() {
        MCalendarPanel.setGlobalRenderer(new MCalendarPanel.Renderer(){

            @Override
            public void onRender() {
                DayKey dayKey = new DayKey(this.getYear(), this.getMonth(), this.getDay());
                SummaryData summaryData = SummaryData.getInstance();
                TaskList taskList = (TaskList)summaryData.dayMap.get(dayKey);
                if (TK.isEmpty(taskList)) {
                    this.setSpecialColor(null, null);
                    this.setToolTipText(null);
                } else {
                    Color color = ((Task)taskList.getFirst()).getDateTimeState().getColor();
                    this.setSpecialColor(color, Color.BLACK);
                    this.setToolTipText(UI.makeHTML(taskList.getToolTipText(15)));
                }
            }
        });
        MCalendarPanel.setGlobalUpdater(new MCalendarPanel.Updater(){

            @Override
            protected void onUpdate(MCalendarPanel mCalendarPanel) {
                SummaryData.this.updateCalendar(mCalendarPanel);
            }
        });
        this.notifyTimer = new MTimer(MTimer.Format.SECONDS, 2){

            @Override
            protected boolean onTimeout() {
                SummaryData.this.events.setChanged(true);
                SummaryData.this.events.notifyObservers();
                for (MCalendarPanel mCalendarPanel : MCalendarPanel.getCalendarPanelList()) {
                    SummaryData.this.updateCalendar(mCalendarPanel);
                }
                return false;
            }
        };
        Node node = new Node();
        this.setRootItem(node);
        for (TaskState taskState : TaskState.values()) {
            Node node2 = new Node(taskState);
            node.add(node2);
            this.taskStateMap.put(taskState, node2);
        }
        MTimer mTimer = new MTimer(MTimer.Format.SECONDS, 5){

            @Override
            protected boolean onTimeout() {
                if (SummaryData.this.firstRefresh) {
                    if (SummaryData.this.taskReader.getCount() == 0 && !Tracker.containsFileType("mgtodo")) {
                        MLogger.debug("summary", "First refresh...");
                        SummaryData.this.firstRefresh = false;
                        SummaryData.this.idle = true;
                        SummaryData.this.updateAlarms();
                        SummaryData.this.events.setChanged(true);
                        SummaryData.this.events.notifyObservers();
                        this.setDelay(MTimer.Format.SECONDS, 15);
                    }
                } else {
                    SummaryData.this.refresh();
                    SummaryData.this.refreshTaskTables();
                }
                SummaryData.this.updateCount();
                return true;
            }
        };
        mTimer.start();
    }

    private Node createMetaInfoNode(TaskState taskState, MetaInfo metaInfo) {
        Node node = this.taskStateMap.get((Object)taskState);
        for (Node node2 : node.list(MV.MODEL)) {
            if (node2.getMetaInfo() != metaInfo) continue;
            return node2;
        }
        Node node3 = new Node(metaInfo);
        node.add(node3);
        this.sort(node, this.metaInfoNodeComparator);
        return node3;
    }

    private void notifyObserversLater() {
        this.notifyTimer.restart();
    }

    private void readTaskListAsync(MetaInfo metaInfo) {
        if (metaInfo.isEncrypted()) {
            return;
        }
        try {
            File file = metaInfo.getFile();
            if (file.length() == 0L) {
                return;
            }
            RequestProperties requestProperties = new RequestProperties();
            requestProperties.put("file", file);
            requestProperties.put("metaInfo", metaInfo);
            this.taskReader.startRequest(this, requestProperties);
        }
        catch (Exception exception) {
            MLogger.exception(exception);
        }
    }

    private void refresh() {
        int n = 0;
        MDate mDate = MDate.now();
        Reload reload = new Reload();
        TaskList taskList = new TaskList();
        for (Map.Entry<TaskState, Node> entry : this.taskStateMap.entrySet()) {
            Node node = entry.getValue();
            TaskState taskState = entry.getKey();
            for (Node node2 : node.list(MV.MODEL)) {
                taskList.clear();
                for (Node node3 : node2.list(MV.MODEL)) {
                    Task task = node3.getTask();
                    TaskState taskState2 = task.getDateTimeStateNow(mDate);
                    if (taskState2.isImportant() && !task.isDone()) {
                        ++n;
                    }
                    if (taskState2 == taskState) continue;
                    taskList.add(task);
                    node3.removeFromParent();
                    reload.add(node2);
                }
                this.todoAdded(node2.getMetaInfo(), reload, taskList, true);
                this.expandImportantNodes();
            }
        }
        reload.reload();
        this.updateAlarms(n, null);
    }

    private void refreshTaskTables() {
        MainWindow mainWindow = MainWindow.getInstance();
        if (mainWindow.isDesktopVisible()) {
            for (WidgetInternalFrame widgetInternalFrame : mainWindow.getDesktop()) {
                Widget widget = widgetInternalFrame.getWidget();
                PluginInfo pluginInfo = widget == null || widget.getWidgetPeer() == null ? null : widget.getPluginInfo();
                if (pluginInfo == null || !"{9afcf313-d31d-4d23-ba63-24451a691552}".equals(pluginInfo.getID())) continue;
                widget.repaint();
            }
        } else {
            Editor editor = (Editor)Tabs.getInstance().getSelectedTab();
            if (editor instanceof TodoEditor) {
                ((Component)editor.getCore()).repaint();
            }
        }
    }

    private void todoAdded(MetaInfo metaInfo, Reload reload, List<Task> list, boolean bl) {
        Collections.sort(list, TaskComparator.get((Column)((Object)Vars.summarySortMethod.get())));
        MDate mDate = MDate.now();
        for (Task task : list) {
            TaskState taskState = task.getDateTimeStateNow(mDate);
            Node node = this.createMetaInfoNode(taskState, metaInfo);
            node.add(new Node(task));
            if (reload != null) {
                reload.add(node);
            }
            if (!bl || !((Boolean)Vars.alarmEnabled.get()).booleanValue()) continue;
            if (taskState.isImportant() && !task.isDone()) {
                Reminder.showNotification(metaInfo, task);
                continue;
            }
            Reminder.hideNotifications(metaInfo, task);
        }
    }

    private void updateAlarms(int n, List<Tuple.Two<MetaInfo, Task>> list) {
        Sidebar sidebar = Sidebar.getInstance();
        Sidebar.Button button = sidebar.getButtonFor(Sidebar.Tab.SUMMARY);
        if (n == 0) {
            Reminder.hideAllNotifications();
            button.setIcon(MIcon.small(Sidebar.Tab.SUMMARY.getIconName()));
            button.setText(Sidebar.Tab.SUMMARY.getTitle());
            MSystemTray.setToolTip(null);
        } else {
            if (list != null && ((Boolean)Vars.alarmEnabled.get()).booleanValue()) {
                for (Tuple.Two two : list) {
                    Reminder.showNotification((MetaInfo)two.get1(), (Task)two.get2());
                }
            }
            String string = UI._("Tasks: {0}", n);
            button.setIcon(MIcon.small("ui/warning"));
            button.setText((String)string + " - " + Sidebar.Tab.SUMMARY.getTitle());
            MSystemTray.setToolTip(string);
        }
    }

    private void updateCalendar(Node node, int n, int n2) {
        for (Node node2 : node.list(MV.MODEL)) {
            Task task = node2.getTask();
            MCalendar mCalendar = task.getDateTime().toCalendar();
            if (mCalendar.getYear() != n || mCalendar.get(2) != n2) continue;
            DayKey dayKey = new DayKey(n, n2 + 1, mCalendar.getDay());
            TaskList taskList = this.dayMap.get(dayKey);
            if (taskList == null) {
                taskList = new TaskList();
                this.dayMap.put(dayKey, taskList);
            }
            taskList.add(task);
        }
    }

    public void updateCount() {
        Reload reload = new Reload();
        for (Node node : this.taskStateMap.values()) {
            int n = 0;
            for (Node node2 : node.list(MV.MODEL)) {
                int n2 = node2.getChildCount(MV.MODEL);
                n += n2;
                if (!node2.setCount(n2)) continue;
                reload.add(node2);
            }
            if (!node.setCount(n)) continue;
            reload.add(node);
        }
        reload.reload();
        this.expandImportantNodes();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void expandImportantNodes() {
        SummaryTree summaryTree = SummaryPanel.getInstance().getTree();
        try {
            summaryTree.autoExpandMode = true;
            for (Map.Entry<TaskState, Node> entry : this.taskStateMap.entrySet()) {
                summaryTree.setExpanded((MTreeItem)entry.getValue(), true);
                if (!entry.getKey().isImportant()) continue;
                for (Node node : entry.getValue().list(MV.VIEW)) {
                    if (node.isEmpty(MV.VIEW)) continue;
                    summaryTree.setExpanded(node, true);
                }
            }
        }
        finally {
            summaryTree.autoExpandMode = false;
        }
    }

    private static final class TaskReader
    extends AbstractRequestManager<List<Task>> {
        @Override
        protected List<Task> getResult(RequestInfo<List<Task>> requestInfo) throws Exception {
            long l = System.currentTimeMillis();
            File file = requestInfo.getProperty("file", null);
            TaskModel taskModel = new TaskModel();
            taskModel.loadFromXML(file, false);
            long l2 = System.currentTimeMillis();
            long l3 = l2 - l;
            if (l3 > 0L) {
                TK.sleep(l3);
            }
            return taskModel.getRows();
        }

        private TaskReader() {
            super(1, 0L);
        }
    }

    private final class Reload
    extends HashSet<Node> {
        private Reload() {
        }

        private void reload() {
            for (Node node : this) {
                SummaryData.this.reload(node);
            }
        }
    }

    private static final class NodeComparator
    implements Comparator<MutableTreeNode>,
    Serializable {
        private final TaskComparator taskComparator;

        @Override
        public int compare(MutableTreeNode mutableTreeNode, MutableTreeNode mutableTreeNode2) {
            Node node = (Node)mutableTreeNode;
            Node node2 = (Node)mutableTreeNode2;
            return this.taskComparator.compare(node.getTask(), node2.getTask());
        }

        private NodeComparator(TaskComparator taskComparator) {
            this.taskComparator = taskComparator;
        }
    }

    private static final class MetaInfoNodeComparator
    implements Comparator<MutableTreeNode>,
    Serializable {
        private final MetaInfoComparator metaInfoComparator;

        @Override
        public int compare(MutableTreeNode mutableTreeNode, MutableTreeNode mutableTreeNode2) {
            Node node = (Node)mutableTreeNode;
            Node node2 = (Node)mutableTreeNode2;
            return this.metaInfoComparator.compare(node.getMetaInfo(), node2.getMetaInfo());
        }

        private MetaInfoNodeComparator(MetaInfoComparator metaInfoComparator) {
            this.metaInfoComparator = metaInfoComparator;
        }
    }

    private static final class LazySummaryDataHolder {
        private static final MGuardedObject<SummaryData> INSTANCE = new MGuardedObject<SummaryData>(new SummaryData(), "org.makagiga.tools.summary.SummaryData", PermissionInfo.ThreatLevel.MEDIUM, "Task Summary");

        private LazySummaryDataHolder() {
        }
    }

    private static final class Events
    extends Observable {
        private Events() {
        }

        private void setChanged(boolean bl) {
            if (bl) {
                this.setChanged();
            } else {
                this.clearChanged();
            }
        }
    }

    public static final class Node
    extends MTreeItem {
        private Color color;
        private Icon icon;
        private int count;
        private Object data;
        TriBoolean userExpanded = TriBoolean.UNDEFINED;

        public Node(String string, Icon icon, Object object) {
            this.icon = icon;
            this.setText(string);
            this.setUserObject(object);
        }

        public Color getColor() {
            if (this.data instanceof MetaInfo) {
                return ((MetaInfo)MetaInfo.class.cast(this.data)).getColor();
            }
            return this.color;
        }

        public void setColor(Color color) {
            this.color = color;
        }

        public Icon getIcon() {
            return this.icon;
        }

        public void setIcon(Icon icon) {
            this.icon = icon;
        }

        public MetaInfo getMetaInfo() {
            return this.data instanceof MetaInfo ? (MetaInfo)this.data : null;
        }

        public Task getTask() {
            return this.data instanceof Task ? (Task)this.data : null;
        }

        public String getText() {
            if (this.data instanceof MetaInfo) {
                return ((MetaInfo)MetaInfo.class.cast(this.data)).getOverrideName();
            }
            return this.toString();
        }

        public void setText(String string) {
            this.data = string;
        }

        @Override
        public boolean isVisible() {
            boolean bl = super.isVisible();
            if (bl && this.data instanceof Task && ((Task)Task.class.cast(this.data)).isDone() && !((Boolean)Vars.summaryShowAllTasks.get()).booleanValue()) {
                bl = false;
            }
            return bl;
        }

        public List<Node> list(MV mV) {
            return this.listChildren(Node.class, mV);
        }

        public String toString() {
            if (this.data instanceof MetaInfo) {
                return ((MetaInfo)MetaInfo.class.cast(this.data)).toString();
            }
            if (this.data instanceof Task) {
                return ((Task)Task.class.cast(this.data)).getSummary();
            }
            return String.valueOf(this.data);
        }

        private Node() {
        }

        private Node(MetaInfo metaInfo) {
            this.data = metaInfo;
        }

        private Node(Task task) {
            this.data = task;
        }

        private Node(TaskState taskState) {
            this(taskState.toString(), taskState.getSmallIcon(), (Object)taskState);
            this.color = taskState.getColorForPaint();
        }

        private boolean setCount(int n) {
            if (n != this.count) {
                this.count = n;
                return true;
            }
            return false;
        }

        int getCount() {
            return this.count;
        }
    }

    public static final class DayKey {
        private final int day;
        private final int hash;
        private final int month;
        private final int year;
        private String string;

        public DayKey(Calendar calendar) {
            this(calendar.get(1), calendar.get(2) + 1, calendar.get(5));
        }

        public boolean equals(Object object) {
            switch (MObject.maybeEquals(this, object)) {
                case YES: {
                    return true;
                }
                case NO: {
                    return false;
                }
            }
            DayKey dayKey = (DayKey)object;
            return this.year == dayKey.year && this.month == dayKey.month && this.day == dayKey.day;
        }

        public int hashCode() {
            return this.hash;
        }

        public synchronized String toString() {
            if (this.string == null) {
                MDate mDate = new MDate(new GregorianCalendar(this.year, this.month - 1, this.day));
                this.string = mDate.format("yyyy-MM-dd", Locale.ENGLISH);
            }
            return this.string;
        }

        private DayKey(int n, int n2, int n3) {
            this.year = n;
            this.month = n2;
            this.day = n3;
            this.hash = MObject.hashCode(n, n2, n3);
        }
    }

    public static final class Chart
    extends ChartPainter<ChartModel> {
        private Chart(ChartModel chartModel) {
            super(chartModel);
        }
    }
}

