/*
 * Decompiled with CFR 0.152.
 */
package org.makagiga.tree;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JComponent;
import org.makagiga.Vars;
import org.makagiga.commons.ItemStatus;
import org.makagiga.commons.MApplication;
import org.makagiga.commons.MColor;
import org.makagiga.commons.MComponent;
import org.makagiga.commons.MIcon;
import org.makagiga.commons.MLabel;
import org.makagiga.commons.MPanel;
import org.makagiga.commons.MProperties;
import org.makagiga.commons.MRenderer;
import org.makagiga.commons.MV;
import org.makagiga.commons.TK;
import org.makagiga.commons.UI;
import org.makagiga.commons.category.CategoryList;
import org.makagiga.commons.category.CategoryListRenderer;
import org.makagiga.commons.painters.AbstractPainter;
import org.makagiga.commons.painters.GlassPainter;
import org.makagiga.commons.painters.Painter;
import org.makagiga.commons.preview.DefaultPreview;
import org.makagiga.commons.request.RequestInfo;
import org.makagiga.fs.AbstractFS;
import org.makagiga.fs.FSRenderer;
import org.makagiga.fs.MetaInfo;
import org.makagiga.tags.TagsUtils;

public final class ItemRenderer
extends MRenderer<MetaInfo> {
    private CategoriesPanel categories;
    private ItemStatus extra;
    private MLabel iconAndText;
    private MLabel meta;
    private MLabel preview;
    private MLabel tags;
    private RatingPanel rating;

    public ItemRenderer() {
        super(1);
    }

    @Override
    protected JComponent createView() {
        this.iconAndText = new MLabel();
        this.iconAndText.setForeground(null);
        UI.setHTMLEnabled(this.iconAndText, false);
        this.extra = new ItemStatus(this.iconAndText.getFont());
        this.rating = new RatingPanel();
        this.categories = new CategoriesPanel();
        this.tags = MLabel.createSmall(null, null);
        UI.setHTMLEnabled(this.tags, false);
        this.meta = MLabel.createSmall(null, null);
        UI.setHTMLEnabled(this.meta, false);
        this.preview = new MLabel();
        this.preview.setBackground(Color.WHITE);
        Color color = MColor.deriveColor(Color.WHITE, 0.6f);
        this.preview.setBorder(BorderFactory.createLineBorder(color));
        this.preview.setForeground(color);
        this.preview.setHorizontalAlignment(0);
        this.preview.setOpaque(true);
        MRenderer.OptimizedPanel optimizedPanel = new MRenderer.OptimizedPanel(false);
        optimizedPanel.getGroupLayout().addComponent(this.preview).addGap(2).beginRows().beginColumnsInRow().addComponent(this.iconAndText).addGap(4).addComponent((Component)this.extra, true).addGap(2).endColumnsInRow().addComponent(this.rating).addComponent(this.categories).addComponent(this.tags).addComponent(this.meta).end();
        return optimizedPanel;
    }

    @Override
    protected Color getRowColor(MetaInfo metaInfo) {
        return metaInfo.getColor();
    }

    @Override
    protected void onRender(MetaInfo metaInfo) {
        Object object;
        Color color;
        if (metaInfo.isLink()) {
            this.onRender(metaInfo.getLink());
            return;
        }
        Color color2 = this.getView().getBackground();
        if (color2 == null) {
            color2 = Color.WHITE;
        }
        if ((color = this.getView().getForeground()) == null) {
            color = Color.BLACK;
        }
        this.iconAndText.setBackground(this.getView().getBackground());
        MPanel mPanel = (MPanel)this.getView();
        if (!this.isSelected() && this.getView().isBackgroundSet()) {
            object = new GlassPainter(this.getView().getBackground());
            ((AbstractPainter)object).setCached(false);
            mPanel.setPainter((Painter)object);
        } else {
            mPanel.setPainter(null);
        }
        Object object2 = metaInfo.getProperty("metaInfo.override.icon", null);
        object = object2 instanceof Icon ? (Icon)object2 : (object2 instanceof String ? (Vars.treeSmallIcons.booleanValue() ? MIcon.small(object2.toString()) : MIcon.stock(object2.toString())) : (Vars.treeSmallIcons.booleanValue() ? metaInfo.getSmallIcon() : metaInfo.getIcon()));
        this.iconAndText.setIcon((Icon)object);
        this.setupText(metaInfo);
        this.setupExtraText(metaInfo, color2);
        this.setupRating(metaInfo);
        Color color3 = MColor.getBrighter(color, 40);
        boolean bl = (Boolean)Vars.treePreview.get() != false && !MApplication.isSafeMode();
        this.setupCategories(metaInfo);
        this.setupTags(metaInfo, color3);
        this.setupMeta(metaInfo, bl, color3);
        this.setupPreview(metaInfo, bl);
        AbstractFS abstractFS = metaInfo.getFS();
        if (abstractFS instanceof FSRenderer) {
            ((FSRenderer)FSRenderer.class.cast(abstractFS)).setupItemRenderer(this, metaInfo, this.isSelected(), this.isExpanded(), this.getRow(), this.isFocused());
        }
    }

    private void setupCategories(MetaInfo metaInfo) {
        if (((Boolean)Vars.treeShowCategories.get()).booleanValue()) {
            this.categories.value = metaInfo.getCategoryList();
            this.categories.setVisible(!TK.isEmpty(this.categories.value));
        } else {
            this.categories.value = null;
            this.categories.setVisible(false);
        }
    }

    private void setupExtraText(MetaInfo metaInfo, Color color) {
        String string = metaInfo.getProperty("metaInfo.extra.text", null);
        if (string == null) {
            this.extra.setVisible(false);
            if (metaInfo.isFolder()) {
                if (metaInfo.isFilter()) {
                    this.extra.setText(UI._("{0}, filtered", metaInfo.getChildCount(MV.VIEW)), (Color)MColor.HOT_ORANGE);
                    this.extra.setVisible(true);
                } else if (((Boolean)Vars.treeItemCount.get()).booleanValue()) {
                    this.extra.setText(metaInfo.getChildCount(MV.MODEL), metaInfo.getColor());
                    this.extra.setVisible(true);
                }
            } else if (metaInfo.isFSRoot()) {
                if (metaInfo.isFilter()) {
                    this.extra.setText(UI._("Filtered"), (Color)MColor.HOT_ORANGE);
                    this.extra.setVisible(true);
                } else if (!this.isExpanded() && !metaInfo.isEmpty(MV.VIEW)) {
                    this.extra.setText(UI._("Click to expand"), null);
                    this.extra.setVisible(true);
                }
            }
        } else {
            Color color2 = metaInfo.getProperty("metaInfo.extra.color", color);
            this.extra.setText(string, color2);
            this.extra.setVisible(true);
        }
    }

    private void setupMeta(MetaInfo metaInfo, boolean bl, Color color) {
        MProperties mProperties = metaInfo.getProperty("metaInfo.previewProperties", null);
        if (bl && ((Boolean)Vars.treeShowMetaInfo.get()).booleanValue() && mProperties != null && !mProperties.isEmpty()) {
            String string;
            String string2 = "";
            String string3 = mProperties.getProperty("image-type-property", "");
            if (!TK.isEmpty(string3)) {
                string2 = string2 + String.format("%s x %s, %s, %s bpp", mProperties.getProperty("image-width-property", "?"), mProperties.getProperty("image-height-property", "?"), string3, mProperties.getProperty("image-width-bpp", "?"));
            }
            if ((string = mProperties.getProperty("url-property", null)) != null) {
                if (!string2.isEmpty()) {
                    string2 = string2 + " ";
                }
                string2 = string2 + string;
            }
            if (!TK.isEmpty(string2)) {
                this.meta.setForeground(color);
                this.meta.setText(string2);
                this.meta.setVisible(true);
            } else {
                this.meta.setText(null);
                this.meta.setVisible(false);
            }
        } else {
            this.meta.setText(null);
            this.meta.setVisible(false);
        }
    }

    private void setupPreview(MetaInfo metaInfo, boolean bl) {
        this.preview.setIcon(null);
        this.preview.setText(null);
        if (metaInfo.isFile() && !metaInfo.isEncrypted()) {
            if (bl) {
                Image image = metaInfo.getProperty("metaInfo.previewImage", null);
                int n = Vars.treePreviewSize.normalize(25, 250);
                UI.setFixedSize(this.preview, n, n);
                if (image == null) {
                    RequestInfo<DefaultPreview.Result> requestInfo = metaInfo.getProperty("metaInfo.previewInfo", null);
                    if (requestInfo == null) {
                        requestInfo = DefaultPreview.getInstance().requestPreview(metaInfo, metaInfo.getFile(), n);
                        metaInfo.setProperty("metaInfo.previewInfo", requestInfo);
                    }
                    this.preview.setText(metaInfo.getProperty("metaInfo.noImagePreview", false) != false ? "?" : UI._("Wait..."));
                } else {
                    this.preview.setImage(image);
                }
                this.preview.setVisible(true);
            } else {
                RequestInfo requestInfo = (RequestInfo)metaInfo.clearProperty("metaInfo.previewInfo");
                if (requestInfo != null) {
                    requestInfo.setCancelled(true);
                }
                this.preview.setVisible(false);
            }
        } else {
            this.preview.setVisible(false);
        }
    }

    private void setupRating(MetaInfo metaInfo) {
        if (((Boolean)Vars.treeShowRating.get()).booleanValue()) {
            float f = metaInfo.getRating();
            if (f > 0.0f) {
                int n = -1;
                if (f <= 0.2f) {
                    n = 1;
                } else if (f <= 0.4f) {
                    n = 2;
                } else if (f <= 0.6f) {
                    n = 3;
                } else if (f <= 0.8f) {
                    n = 4;
                } else if (f <= 1.0f) {
                    n = 5;
                }
                this.rating.setValue(n);
                this.rating.setVisible(true);
            } else {
                this.rating.setValue(-1);
                this.rating.setVisible(false);
            }
        } else {
            this.rating.setValue(-1);
            this.rating.setVisible(false);
        }
    }

    private void setupTags(MetaInfo metaInfo, Color color) {
        if (((Boolean)Vars.treeShowTags.get()).booleanValue()) {
            String string = metaInfo.getTags();
            if (TK.isEmpty(string)) {
                this.tags.setText(null);
                this.tags.setVisible(false);
            } else {
                this.tags.setForeground(color);
                this.tags.setText(TagsUtils.getLocalizedTags(string));
                this.tags.setVisible(true);
            }
        } else {
            this.tags.setText(null);
            this.tags.setVisible(false);
        }
    }

    private void setupText(MetaInfo metaInfo) {
        String string;
        String string2;
        Font font = this.iconAndText.getFont();
        if (font != null) {
            int n = 0;
            if (metaInfo.isOpen()) {
                ++n;
            }
            if (metaInfo.isMount()) {
                n += 2;
            }
            if (font.getStyle() != n) {
                this.iconAndText.setFont(font.deriveFont(n));
            }
        }
        if ((string2 = (String)metaInfo.getProperty("metaInfo.override.name", null)) == null) {
            string = metaInfo.toString();
            if (metaInfo.isMount()) {
                string = string + " -> " + metaInfo.getMount();
            }
        } else {
            string = metaInfo.getOverrideName();
        }
        this.iconAndText.setText(string);
    }

    private static final class RatingPanel
    extends MComponent {
        private final int iconSize;
        private int value = -1;
        private final MIcon grayStarIcon;
        private MIcon starIcon;

        @Override
        public Dimension getPreferredSize() {
            if (this.value == -1) {
                return new Dimension(0, 0);
            }
            return new Dimension(5 * this.iconSize, this.iconSize);
        }

        @Override
        public void paintComponent(Graphics graphics) {
            if (this.value == -1) {
                return;
            }
            int n = 2;
            for (int i = 0; i < 5; ++i) {
                if (i < this.value) {
                    this.starIcon.paintIcon(this, graphics, n, 0);
                } else {
                    this.grayStarIcon.paintIcon(this, graphics, n, 0);
                }
                n += this.iconSize;
            }
        }

        private RatingPanel() {
            this.setOpaque(false);
            this.starIcon = MIcon.small("ui/star");
            this.grayStarIcon = this.starIcon.getDisabledInstance();
            this.iconSize = this.starIcon.getIconWidth() + 4;
        }

        private void setValue(int n) {
            this.value = n;
        }
    }

    private static final class CategoriesPanel
    extends MComponent {
        private CategoryList value;

        @Override
        public Dimension getPreferredSize() {
            return CategoryListRenderer.getPreferredSize(this, this.value);
        }

        @Override
        public void paintComponent(Graphics graphics) {
            CategoryListRenderer.paint(this, (Graphics2D)graphics, this.value, Color.WHITE, Color.BLACK);
        }

        private CategoriesPanel() {
            this.setOpaque(false);
        }
    }
}

