/*
 * Decompiled with CFR 0.152.
 */
package org.makagiga.web;

import java.util.LinkedHashSet;
import java.util.Locale;
import java.util.Set;
import javax.swing.JComponent;
import org.makagiga.commons.TK;
import org.makagiga.web.WebException;
import org.makagiga.web.WebProperties;
import org.makagiga.web.WebResult;

public abstract class WebService {
    public static final Locale POLISH_LOCALE = new Locale("pl", "PL");
    private boolean active;
    private final Set<Locale> supportedLocales = new LinkedHashSet<Locale>();
    private final String displayName;
    private String homePage;
    private final String shortDescription;

    public WebService(String string, String string2) {
        this.displayName = TK.checkNullOrEmpty(string, "displayName");
        this.shortDescription = TK.checkNullOrEmpty(string2, "shortDescription");
    }

    public abstract JComponent createMainComponent(WebProperties var1);

    public JComponent createResultComponent(WebProperties webProperties) {
        return null;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public String getHomePage() {
        return this.homePage;
    }

    public String getShortDescription() {
        return this.shortDescription;
    }

    public synchronized boolean isActive() {
        return this.active;
    }

    public synchronized boolean isLocaleSupported(Locale locale) {
        return this.supportedLocales.contains(locale);
    }

    public void logout(WebProperties webProperties) throws WebException {
    }

    public abstract WebResult submit(WebProperties var1) throws WebException;

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder(this.displayName);
        if (this.homePage != null) {
            stringBuilder.append(" @ ").append(this.homePage);
        }
        return stringBuilder.toString();
    }

    public abstract void updateWebProperties(WebProperties var1);

    protected synchronized void addSupportedLocale(Locale locale) {
        this.supportedLocales.add(locale);
    }

    protected void setHomePage(String string) {
        this.homePage = TK.checkNullOrEmpty(string, "homePage");
    }

    synchronized void setActive(boolean bl) {
        this.active = bl;
    }
}

