/*
 * Decompiled with CFR 0.152.
 */
package org.makagiga.web.wiki;

import java.awt.BorderLayout;
import java.awt.Window;
import java.beans.ConstructorProperties;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.net.URI;
import java.net.URL;
import java.text.ParseException;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.regex.Pattern;
import javax.swing.Action;
import javax.swing.event.HyperlinkEvent;
import org.makagiga.commons.ActionGroup;
import org.makagiga.commons.FS;
import org.makagiga.commons.HTMLBuilder;
import org.makagiga.commons.HistoryManager;
import org.makagiga.commons.MColor;
import org.makagiga.commons.MComboBox;
import org.makagiga.commons.MDialog;
import org.makagiga.commons.MDisposable;
import org.makagiga.commons.MHTMLViewer;
import org.makagiga.commons.MLinkButton;
import org.makagiga.commons.MLogger;
import org.makagiga.commons.MMessage;
import org.makagiga.commons.MPanel;
import org.makagiga.commons.MSwingWorker;
import org.makagiga.commons.MTimer;
import org.makagiga.commons.MToolBar;
import org.makagiga.commons.Net;
import org.makagiga.commons.TK;
import org.makagiga.commons.UI;
import org.makagiga.commons.mods.Mods;

public class WikiPanel
extends MPanel
implements MDisposable {
    public static final String PAGE_TITLE_PROPERTY = "pageTitle";
    private ActionGroup actionGroup;
    private MComboBox<Locale> language = new MComboBox<Locale>(){

        @Override
        protected void onSelect() {
        }
    };
    private MLinkButton address;
    private transient MSwingWorker<String> downloader;
    private MToolBar toolBar;
    private URI pageURI;
    private static URICache _cache;
    private Viewer viewer;

    public WikiPanel() {
        super(5, 5);
        this.language.setToolTipText(UI._("Language"));
        this.actionGroup = new ActionGroup(){

            @Override
            public void update() {
                WikiPanel.this.viewer.history.updateActions((Action)this.getAction("back"), (Action)this.getAction("forward"));
            }
        };
        this.viewer = new Viewer();
        this.addCenter(this.viewer);
        this.actionGroup.add("back", new HistoryManager.BackAction<URI>(this.viewer.history){

            @Override
            protected void onAction(URI uRI) {
                WikiPanel.this.loadPage(uRI);
            }
        }).setShowTextInToolBar(true);
        this.actionGroup.add("forward", new HistoryManager.ForwardAction<URI>(this.viewer.history){

            @Override
            protected void onAction(URI uRI) {
                WikiPanel.this.loadPage(uRI);
            }
        });
        this.updateComponents();
        this.address = new MLinkButton();
        this.toolBar = new MToolBar();
        this.toolBar.setTextPosition(MToolBar.TextPosition.ALONGSIDE_ICONS);
        this.actionGroup.updateToolBar(this.toolBar);
        this.toolBar.addGap();
        this.toolBar.add(this.address);
        this.addNorth(this.toolBar);
    }

    @ConstructorProperties(value={"pageURI"})
    public WikiPanel(URI uRI) {
        this();
        this.setPageURI(uRI);
    }

    public MDialog createDialog(Window window, String string) {
        MDialog mDialog = new MDialog(window, string, 100);
        mDialog.setToolBar(this.getToolBar());
        mDialog.getCenterPanel().setLayout(new BorderLayout());
        mDialog.getCenterPanel().setMargin(0);
        mDialog.addCenter(this);
        mDialog.setSize(UI.WindowSize.MEDIUM);
        return mDialog;
    }

    public ActionGroup getActionGroup() {
        return this.actionGroup;
    }

    public URI getPageURI() {
        return this.pageURI;
    }

    public void setPageURI(URI uRI) {
        this.setPageURI(uRI, true);
    }

    private void setPageURI(URI uRI, boolean bl) {
        this.pageURI = TK.checkNull(uRI);
        MLogger.debug("wiki", "Set page URI: %s (update history = %s)", uRI, bl);
        if (bl) {
            this.viewer.history.add(this.pageURI);
        }
        this.address.setURL(uRI.toString());
        this.address.setText(uRI.getHost());
        this.viewer.uninstallCache();
        if (this.downloader != null) {
            this.downloader.abort();
        }
        this.downloader = new MSwingWorker<String>((Object)this, "Wiki", EnumSet.of(MSwingWorker.Option.WAIT_CURSOR)){

            @Override
            protected String doInBackground() throws Exception {
                return WikiPanel.this.downloadPage();
            }

            @Override
            protected void onSuccess(String string) {
                WikiPanel.this.viewer.setHTML(string, WikiPanel.this.pageURI);
                WikiPanel.this.updateComponents();
            }
        };
        this.downloader.start();
    }

    public MToolBar getToolBar() {
        return this.toolBar;
    }

    public MHTMLViewer getViewer() {
        return this.viewer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void openURI(Window window, String string, String string2) {
        URI uRI = URI.create(string);
        if (Boolean.TRUE.equals(Mods.exec(window, "showPanel@org.makagiga.web.wiki.WikiPanel", uRI))) {
            return;
        }
        WikiPanel wikiPanel = new WikiPanel();
        try {
            wikiPanel.setPageURI(uRI);
            wikiPanel.showDialog(window, string2);
        }
        finally {
            wikiPanel.dispose(new Object[0]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void showDialog(Window window, String string) {
        final MDialog mDialog = this.createDialog(window, string);
        PropertyChangeListener propertyChangeListener = new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                if (WikiPanel.PAGE_TITLE_PROPERTY.equals(propertyChangeEvent.getPropertyName())) {
                    mDialog.setTitle((String)propertyChangeEvent.getNewValue());
                }
            }
        };
        this.addPropertyChangeListener(propertyChangeListener);
        try {
            mDialog.exec(this.viewer);
        }
        finally {
            this.removePropertyChangeListener(propertyChangeListener);
        }
    }

    @Override
    public Object dispose(Object ... objectArray) {
        this.actionGroup = TK.dispose(this.actionGroup);
        this.language = null;
        this.address = null;
        this.downloader = TK.dispose(this.downloader);
        this.toolBar = null;
        this.pageURI = null;
        if (this.viewer != null) {
            this.viewer.uninstallCache();
            this.viewer = null;
        }
        return null;
    }

    private String downloadPage() throws IOException {
        String string;
        URL uRL = this.pageURI.toURL();
        Net.DownloadInfo downloadInfo = new Net.DownloadInfo(uRL, ".html", 6);
        downloadInfo.startDownload();
        String string2 = FS.read(downloadInfo.getFile(), "UTF8");
        try {
            string = TK.substring(string2, "<title>", "</title>", true);
        }
        catch (ParseException parseException) {
            string = "";
        }
        try {
            string2 = TK.substring(string2, "<!-- bodytext -->", "<!-- /bodytext -->", false);
        }
        catch (ParseException parseException) {
            try {
                MLogger.warning("wiki", "Unknown body content: %s", parseException);
                string2 = TK.substring(string2, "<div id=\"bodyContent\">", "</body>", false);
            }
            catch (ParseException parseException2) {
                throw new IOException(UI._("Download failed"), parseException2);
            }
        }
        string2 = string2.replaceAll(Pattern.quote("<span class=\"editsection\">[<a href=") + ".+" + Pattern.quote("</a>]</span>"), "");
        StringBuilder stringBuilder = new StringBuilder(string2);
        TK.fastReplace(stringBuilder, "//<![CDATA[", "");
        TK.fastReplace(stringBuilder, "//]]>", "");
        TK.fastReplace(stringBuilder, " class=\"external text\" ", " class=\"external\" ");
        TK.fastReplace(stringBuilder, "font-size: x-small;", "font-size:normal;");
        TK.fastReplace(stringBuilder, "font-size: 85%;", "font-size: normal;");
        TK.fastReplace(stringBuilder, "font-size: 90%;", "font-size: normal;");
        TK.fastReplace(stringBuilder, "font-size:x-small;", "font-size:normal;");
        TK.fastReplace(stringBuilder, "font-size:85%;", "font-size:normal;");
        TK.fastReplace(stringBuilder, "font-size:90%;", "font-size:normal;");
        TK.fastReplace(stringBuilder, "font-size:0.9em;", "font-size:normal;");
        stringBuilder.insert(0, "<html><head>" + string + "</head><body>");
        stringBuilder.append("</body></html>");
        return stringBuilder.toString();
    }

    private static synchronized URICache getCache() {
        if (_cache == null) {
            _cache = new URICache();
        }
        return _cache;
    }

    private void loadPage(URI uRI) {
        CacheItem cacheItem = (CacheItem)WikiPanel.getCache().get(uRI);
        try {
            if (cacheItem != null && cacheItem.parsedHTML != null) {
                cacheItem.time = System.currentTimeMillis();
                this.pageURI = uRI;
                this.viewer.history.add(this.pageURI);
                this.viewer.setParsedHTML(cacheItem.parsedHTML, uRI);
                this.updateComponents();
            } else {
                this.setPageURI(uRI, false);
            }
        }
        catch (Exception exception) {
            MMessage.error(this.getWindowAncestor(), exception);
        }
    }

    private void updateComponents() {
        this.actionGroup.update();
    }

    private final class Viewer
    extends MHTMLViewer {
        private final HistoryManager<URI> history = new HistoryManager();

        @Override
        public String getTitle() {
            String string = super.getTitle();
            return TK.isEmpty(string) ? "Wiki" : string;
        }

        @Override
        protected synchronized boolean onHyperlinkClick(HyperlinkEvent hyperlinkEvent) {
            if (hyperlinkEvent.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
                String string = hyperlinkEvent.getDescription();
                if (string == null) {
                    return false;
                }
                if (TK.startsWith(string, '#')) {
                    return true;
                }
                if (string.startsWith("/wiki/")) {
                    String string2 = WikiPanel.this.pageURI.toString();
                    string2 = string2.substring(0, string2.indexOf("/wiki/")) + string;
                    WikiPanel.this.loadPage(URI.create(string2));
                    return true;
                }
            }
            return false;
        }

        private Viewer() {
        }

        private void setHTML(String string, URI uRI) {
            try {
                WikiPanel.getCache().put(uRI, new CacheItem(string));
                this.history.add(uRI);
                this.setParsedHTML(string, uRI);
            }
            catch (Exception exception) {
                MMessage.error(WikiPanel.this.getWindowAncestor(), exception);
            }
        }

        private void setParsedHTML(String string, URI uRI) throws Exception {
            this.installCache(3);
            HTMLBuilder hTMLBuilder = new HTMLBuilder();
            hTMLBuilder.beginStyle();
            hTMLBuilder.beginRule("body");
            hTMLBuilder.addAttr("margin", "0px");
            hTMLBuilder.addAttr("padding", "5px");
            hTMLBuilder.endRule();
            hTMLBuilder.beginRule("a.external");
            hTMLBuilder.addAttr("color", MColor.DARK_GREEN);
            hTMLBuilder.endRule();
            hTMLBuilder.beginRule("a.new");
            hTMLBuilder.addAttr("color", MColor.RED);
            hTMLBuilder.endRule();
            hTMLBuilder.beginRule("code");
            hTMLBuilder.addAttr("font-size", "larger");
            hTMLBuilder.endRule();
            hTMLBuilder.beginRule("small");
            hTMLBuilder.addAttr("font-size", "normal");
            hTMLBuilder.endRule();
            hTMLBuilder.endStyle();
            hTMLBuilder.emit(string);
            String string2 = this.getTitle();
            this.setHTML(hTMLBuilder.toString(), uRI.toURL());
            String string3 = this.getTitle();
            WikiPanel.this.firePropertyChange(WikiPanel.PAGE_TITLE_PROPERTY, string2, string3);
        }
    }

    private static final class URICache
    extends HashMap<URI, CacheItem> {
        private final long maxTime = TimeUnit.MINUTES.toMillis(5L);

        private URICache() {
            new MTimer(TimeUnit.MINUTES, 5L){

                @Override
                protected boolean onTimeout() {
                    if (URICache.this.isEmpty()) {
                        return true;
                    }
                    Iterator iterator = URICache.this.entrySet().iterator();
                    long l = System.currentTimeMillis();
                    while (iterator.hasNext()) {
                        Map.Entry entry = iterator.next();
                        if (l - ((CacheItem)entry.getValue()).time < URICache.this.maxTime) continue;
                        iterator.remove();
                    }
                    return true;
                }
            }.start();
        }
    }

    private static final class CacheItem {
        private long time = System.currentTimeMillis();
        private final String parsedHTML;

        private CacheItem(String string) {
            this.parsedHTML = string;
        }
    }
}

