/*
 * Decompiled with CFR 0.152.
 */
package borland.jbcl.control;

import COM.objectspace.jgl.Array;
import borland.jbcl.control.BevelPanel;
import borland.jbcl.control.ButtonControl;
import borland.jbcl.control.Res;
import borland.jbcl.util.ActionMulticaster;
import borland.jbcl.util.BlackBox;
import borland.jbcl.util.ImageLoader;
import borland.jbcl.util.MouseMotionMulticaster;
import borland.jbcl.util.MouseMulticaster;
import borland.jbcl.view.BorderItemPainter;
import java.awt.Canvas;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.MediaTracker;
import java.awt.SystemColor;
import java.awt.event.ActionListener;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;

public class ButtonBar
extends BevelPanel
implements BlackBox {
    public static final int TEXT_ONLY = 1;
    public static final int IMAGE_ONLY = 2;
    public static final int TEXT_AND_IMAGE = 3;
    private int buttonType = 3;
    private int buttonOrient = 0;
    private int buttonAlign = 34;
    private boolean imageFirst = true;
    private boolean showRollover = false;
    private String imageBase;
    private String[] labels = new String[0];
    private String[] imageNames = new String[0];
    private Array buttons = new Array();
    private boolean[] enabledState = new boolean[0];
    private boolean[] visibleState = new boolean[0];
    private Image[] images;
    private MediaTracker mt;
    protected transient ActionMulticaster actionMulticaster = new ActionMulticaster();
    protected transient MouseMulticaster mouseMulticaster = new MouseMulticaster();
    protected transient MouseMotionMulticaster mouseMotionMulticaster = new MouseMotionMulticaster();
    private BorderItemPainter border = new BorderItemPainter(2);
    private boolean needsRebuild;

    public ButtonBar() {
        super.setLayout(new FlowLayout(0, 0, 0));
        super.setBackground(SystemColor.control);
        this.setMargins(new Insets(2, 2, 2, 2));
    }

    public void setLabels(String[] stringArray) {
        int n;
        boolean[] blArray;
        if (stringArray == null) {
            stringArray = new String[]{};
        }
        String[] stringArray2 = new String[stringArray.length];
        System.arraycopy(stringArray, 0, stringArray2, 0, stringArray2.length);
        if (stringArray.length != this.enabledState.length) {
            blArray = new boolean[stringArray.length];
            for (n = 0; n < stringArray.length; ++n) {
                blArray[n] = true;
            }
            this.enabledState = blArray;
        }
        if (stringArray.length != this.visibleState.length) {
            blArray = new boolean[stringArray.length];
            for (n = 0; n < stringArray.length; ++n) {
                blArray[n] = true;
            }
            this.visibleState = blArray;
        }
        this.labels = stringArray2;
        this.invalidateButtons();
    }

    public String[] getLabels() {
        String[] stringArray = new String[this.labels.length];
        System.arraycopy(this.labels, 0, stringArray, 0, stringArray.length);
        return stringArray;
    }

    public void setImageBase(String string) {
        this.imageBase = string;
        if (this.buttonType == 2 || this.buttonType == 3) {
            this.invalidateImages();
            this.invalidateButtons();
        }
    }

    public String getImageBase() {
        return this.imageBase;
    }

    public void setImageNames(String[] stringArray) {
        if (stringArray != null) {
            String[] stringArray2 = new String[stringArray.length];
            System.arraycopy(stringArray, 0, stringArray2, 0, stringArray2.length);
            this.imageNames = stringArray2;
            if (this.buttonType == 2 || this.buttonType == 3) {
                this.invalidateImages();
                this.invalidateButtons();
            }
        }
    }

    public String[] getImageNames() {
        String[] stringArray = new String[this.imageNames.length];
        System.arraycopy(this.imageNames, 0, stringArray, 0, stringArray.length);
        return stringArray;
    }

    public void setButtonType(int n) {
        if (n == 1 || n == 2 || n == 3) {
            if (n != this.buttonType) {
                this.buttonType = n;
                this.invalidateButtons();
            }
        } else {
            throw new IllegalArgumentException(Res.format(34, String.valueOf(n)));
        }
    }

    public int getButtonType() {
        return this.buttonType;
    }

    public void setButtonOrientation(int n) {
        this.buttonOrient = n;
        for (int i = 0; i < this.getComponentCount(); ++i) {
            ((ButtonControl)this.getComponent(i)).setOrientation(this.buttonOrient);
            this.getComponent(i).invalidate();
        }
    }

    public int getButtonOrientation() {
        return this.buttonOrient;
    }

    public void setButtonAlignment(int n) {
        this.buttonAlign = n;
        for (int i = 0; i < this.getComponentCount(); ++i) {
            ((ButtonControl)this.getComponent(i)).setAlignment(this.buttonAlign);
            this.getComponent(i).invalidate();
        }
    }

    public int getButtonAlignment() {
        return this.buttonAlign;
    }

    public void setImageFirst(boolean bl) {
        this.imageFirst = bl;
        for (int i = 0; i < this.getComponentCount(); ++i) {
            ((ButtonControl)this.getComponent(i)).setImageFirst(this.imageFirst);
        }
    }

    public boolean isImageFirst() {
        return this.imageFirst;
    }

    public void setShowRollover(boolean bl) {
        this.showRollover = bl;
        for (int i = 0; i < this.getComponentCount(); ++i) {
            ((ButtonControl)this.getComponent(i)).setShowRollover(bl);
        }
    }

    public boolean isShowRollover() {
        return this.showRollover;
    }

    public int getAlignment() {
        LayoutManager layoutManager = this.getLayout();
        if (layoutManager instanceof FlowLayout) {
            return ((FlowLayout)layoutManager).getAlignment();
        }
        return 0;
    }

    public void setAlignment(int n) {
        LayoutManager layoutManager = this.getLayout();
        if (layoutManager instanceof FlowLayout) {
            ((FlowLayout)layoutManager).setAlignment(n);
        }
    }

    public int getHgap() {
        LayoutManager layoutManager = this.getLayout();
        if (layoutManager instanceof FlowLayout) {
            return ((FlowLayout)layoutManager).getHgap();
        }
        if (layoutManager instanceof GridLayout) {
            return ((GridLayout)layoutManager).getHgap();
        }
        return 0;
    }

    public void setHgap(int n) {
        LayoutManager layoutManager = this.getLayout();
        if (layoutManager instanceof FlowLayout) {
            ((FlowLayout)layoutManager).setHgap(n);
        } else if (layoutManager instanceof GridLayout) {
            ((GridLayout)layoutManager).setHgap(n);
        }
    }

    public int getVgap() {
        LayoutManager layoutManager = this.getLayout();
        if (layoutManager instanceof FlowLayout) {
            return ((FlowLayout)layoutManager).getVgap();
        }
        if (layoutManager instanceof GridLayout) {
            return ((GridLayout)layoutManager).getVgap();
        }
        return 0;
    }

    public void setVgap(int n) {
        LayoutManager layoutManager = this.getLayout();
        if (layoutManager instanceof FlowLayout) {
            ((FlowLayout)layoutManager).setVgap(n);
        } else if (layoutManager instanceof GridLayout) {
            ((GridLayout)layoutManager).setVgap(n);
        }
    }

    public void setButtonEnabled(int n, boolean bl) {
        Object object;
        if (n < 0 || n >= this.enabledState.length) {
            throw new IllegalArgumentException();
        }
        if (!this.needsRebuild && this.isEnabled() && (object = this.buttons.at(n)) instanceof ButtonControl) {
            ((ButtonControl)object).setEnabled(bl);
        }
        this.enabledState[n] = bl;
    }

    public boolean isButtonEnabled(int n) {
        Object object;
        if (n < 0 || n >= this.enabledState.length) {
            throw new IllegalArgumentException();
        }
        if (!this.needsRebuild && (object = this.buttons.at(n)) instanceof ButtonControl) {
            return ((ButtonControl)object).isEnabled();
        }
        return false;
    }

    public void setButtonVisible(int n, boolean bl) {
        Object object;
        if (n < 0 || n >= this.visibleState.length) {
            throw new IllegalArgumentException();
        }
        if (!this.needsRebuild && (object = this.buttons.at(n)) instanceof ButtonControl) {
            ((ButtonControl)object).setVisible(bl);
        }
        this.visibleState[n] = bl;
    }

    public boolean isButtonVisible(int n) {
        Object object;
        if (n < 0 || n >= this.visibleState.length) {
            throw new IllegalArgumentException();
        }
        if (!this.needsRebuild && (object = this.buttons.at(n)) instanceof ButtonControl) {
            return ((ButtonControl)object).isVisible();
        }
        return false;
    }

    public void setButtonEnabled(String string, boolean bl) {
        for (int i = 0; i < this.labels.length; ++i) {
            if (!this.labels[i].equals(string)) continue;
            this.setButtonEnabled(i, bl);
            return;
        }
    }

    public boolean isButtonEnabled(String string) {
        for (int i = 0; i < this.labels.length; ++i) {
            if (!this.labels[i].equals(string)) continue;
            return this.isButtonEnabled(i);
        }
        return false;
    }

    public void setButtonVisible(String string, boolean bl) {
        for (int i = 0; i < this.labels.length; ++i) {
            if (!this.labels[i].equals(string)) continue;
            this.setButtonVisible(i, bl);
            return;
        }
    }

    public boolean isButtonVisible(String string) {
        for (int i = 0; i < this.labels.length; ++i) {
            if (!this.labels[i].equals(string)) continue;
            return this.isButtonVisible(i);
        }
        return false;
    }

    public synchronized void addActionListener(ActionListener actionListener) {
        this.actionMulticaster.add(actionListener);
    }

    public synchronized void removeActionListener(ActionListener actionListener) {
        this.actionMulticaster.remove(actionListener);
    }

    protected void invalidateButtons() {
        this.needsRebuild = true;
        this.invalidate();
    }

    protected void invalidateImages() {
        if (this.images != null) {
            this.images = null;
        }
        if (this.imageNames.length > 0) {
            this.images = new Image[this.imageNames.length];
            this.mt = new MediaTracker(this);
            String string = this.imageBase;
            if (string != null && string.length() > 0 && !string.endsWith("/") && !string.endsWith(File.separator)) {
                string = String.valueOf(string).concat(String.valueOf("/"));
            }
            for (int i = 0; i < this.imageNames.length; ++i) {
                String string2 = string != null ? String.valueOf(string).concat(String.valueOf(this.imageNames[i])) : this.imageNames[i];
                this.images[i] = ImageLoader.loadFromResource(string2, this);
                if (this.images[i] != null) continue;
                try {
                    this.images[i] = ImageLoader.load(new URL(string2), (Component)this);
                }
                catch (MalformedURLException malformedURLException) {
                    this.images[i] = ImageLoader.load(string2, (Component)this);
                }
                if (this.images[i] == null) continue;
                this.mt.addImage(this.images[i], i);
            }
            this.mt.checkAll(true);
        }
    }

    protected void assureImages() {
        if (this.mt != null) {
            try {
                this.mt.waitForAll(0L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            this.mt = null;
        }
    }

    protected void rebuild() {
        if (this.needsRebuild) {
            this.removeAll();
            this.assureImages();
            this.buttons.clear();
            for (int i = 0; i < this.labels.length; ++i) {
                if (this.labels[i] != null && this.labels[i].length() > 0) {
                    if (this.buttonType == 1 || this.imageNames == null || i >= this.imageNames.length) {
                        this.addTextButton(this.labels[i], this.labels[i]);
                    } else if (this.buttonType == 3) {
                        this.addImageButton(this.images[i], this.labels[i], this.labels[i]);
                    } else {
                        this.addImageButton(this.images[i], null, this.labels[i]);
                    }
                    if (this.isEnabled()) {
                        ((ButtonControl)this.buttons.at(i)).setEnabled(this.enabledState[i]);
                    } else {
                        ((ButtonControl)this.buttons.at(i)).setEnabled(false);
                    }
                    ((ButtonControl)this.buttons.at(i)).setVisible(this.visibleState[i]);
                    continue;
                }
                this.addSpace();
            }
            this.needsRebuild = false;
        }
    }

    public void setEnabled(boolean bl) {
        super.setEnabled(bl);
        this.needsRebuild = true;
        this.doLayout();
    }

    public void doLayout() {
        this.rebuild();
        super.doLayout();
    }

    public Dimension getPreferredSize() {
        this.rebuild();
        Dimension dimension = super.getPreferredSize();
        if (dimension.height == 150) {
            dimension.height = 32;
        }
        return dimension;
    }

    public void addMouseListener(MouseListener mouseListener) {
        super.addMouseListener(mouseListener);
        this.mouseMulticaster.add(mouseListener);
    }

    public void removeMouseListener(MouseListener mouseListener) {
        super.removeMouseListener(mouseListener);
        this.mouseMulticaster.remove(mouseListener);
    }

    public void addMouseMotionListener(MouseMotionListener mouseMotionListener) {
        super.addMouseMotionListener(mouseMotionListener);
        this.mouseMotionMulticaster.add(mouseMotionListener);
    }

    public void removeMouseMotionListener(MouseMotionListener mouseMotionListener) {
        super.removeMouseMotionListener(mouseMotionListener);
        this.mouseMotionMulticaster.remove(mouseMotionListener);
    }

    protected Component addImageButton(Image image, String string, String string2) {
        ButtonControl buttonControl = new ButtonControl(image);
        if (string != null) {
            buttonControl.setLabel(string);
        }
        buttonControl.setActionCommand(string2);
        buttonControl.addActionListener(this.actionMulticaster);
        buttonControl.addMouseListener(this.mouseMulticaster);
        buttonControl.addMouseMotionListener(this.mouseMotionMulticaster);
        buttonControl.setFocusAware(false);
        buttonControl.setShowRollover(this.showRollover);
        buttonControl.setOrientation(this.buttonOrient);
        buttonControl.setAlignment(this.buttonAlign);
        buttonControl.setImageFirst(this.imageFirst);
        this.buttons.add(buttonControl);
        return this.add(buttonControl);
    }

    protected Component addTextButton(String string, String string2) {
        ButtonControl buttonControl = new ButtonControl();
        buttonControl.setLabel(string);
        buttonControl.setActionCommand(string2);
        buttonControl.addActionListener(this.actionMulticaster);
        buttonControl.addMouseListener(this.mouseMulticaster);
        buttonControl.addMouseMotionListener(this.mouseMotionMulticaster);
        buttonControl.setFocusAware(false);
        buttonControl.setShowRollover(this.showRollover);
        buttonControl.setOrientation(this.buttonOrient);
        buttonControl.setAlignment(this.buttonAlign);
        buttonControl.setImageFirst(this.imageFirst);
        this.buttons.add(buttonControl);
        return this.add(buttonControl);
    }

    protected Component addSpace() {
        return this.addSpace(5);
    }

    protected Component addSpace(int n) {
        Canvas canvas = new Canvas();
        canvas.setSize(n, 1);
        this.repaint(100L);
        this.buttons.add(canvas);
        return super.add(canvas);
    }
}

