/*
 * Decompiled with CFR 0.152.
 */
package org.castor.jdo.engine;

import java.util.Hashtable;
import javax.sql.DataSource;
import javax.transaction.TransactionManager;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.castor.jdo.engine.AbstractConnectionFactory;
import org.castor.jdo.engine.DataSourceConnectionFactory;
import org.castor.jdo.engine.DriverConnectionFactory;
import org.castor.jdo.engine.JNDIConnectionFactory;
import org.exolab.castor.jdo.conf.Database;
import org.exolab.castor.jdo.conf.DatabaseChoice;
import org.exolab.castor.jdo.conf.JdoConf;
import org.exolab.castor.mapping.Mapping;
import org.exolab.castor.mapping.MappingException;
import org.exolab.castor.util.DTDResolver;
import org.exolab.castor.util.LocalConfiguration;
import org.exolab.castor.util.Messages;
import org.exolab.castor.xml.MarshalException;
import org.exolab.castor.xml.Unmarshaller;
import org.exolab.castor.xml.ValidationException;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;

public final class DatabaseRegistry {
    private static final String NOTE_096 = "NOTE: JDO configuration syntax has changed with castor 0.9.6, please see http://castor.codehaus.org/release-notes.html for details";
    private static final String INITIALIZE_AT_LOAD = "org.exolab.castor.jdo.DatabaseInitializeAtLoad";
    private static final Log LOG = LogFactory.getLog((Class)(class$org$castor$jdo$engine$DatabaseRegistry == null ? (class$org$castor$jdo$engine$DatabaseRegistry = DatabaseRegistry.class$("org.castor.jdo.engine.DatabaseRegistry")) : class$org$castor$jdo$engine$DatabaseRegistry));
    private static final Hashtable FACTORIES = new Hashtable();
    static /* synthetic */ Class class$org$castor$jdo$engine$DatabaseRegistry;
    static /* synthetic */ Class class$org$exolab$castor$jdo$conf$JdoConf;

    public static synchronized void loadDatabase(String name, String engine, DataSource datasource, Mapping mapping, TransactionManager txManager) throws MappingException {
        DataSourceConnectionFactory factory = new DataSourceConnectionFactory(name, engine, datasource, mapping, txManager);
        if (FACTORIES.put(name, factory) != null) {
            LOG.warn((Object)Messages.format("jdo.configLoadedTwice", name));
        }
    }

    public static synchronized void loadDatabase(JdoConf jdoConf, EntityResolver resolver, ClassLoader loader) throws MappingException {
        DatabaseRegistry.loadDatabase(jdoConf, resolver, loader, null);
    }

    public static synchronized void loadDatabase(InputSource source, EntityResolver resolver, ClassLoader loader) throws MappingException {
        JdoConf jdoConf = null;
        Unmarshaller unmarshaller = new Unmarshaller(class$org$exolab$castor$jdo$conf$JdoConf == null ? (class$org$exolab$castor$jdo$conf$JdoConf = DatabaseRegistry.class$("org.exolab.castor.jdo.conf.JdoConf")) : class$org$exolab$castor$jdo$conf$JdoConf);
        try {
            unmarshaller.setEntityResolver(new DTDResolver(resolver));
            jdoConf = (JdoConf)unmarshaller.unmarshal(source);
        }
        catch (MarshalException e) {
            LOG.info((Object)NOTE_096);
            throw new MappingException(e);
        }
        catch (ValidationException e) {
            throw new MappingException(e);
        }
        LOG.debug((Object)"Loaded jdo conf successfully");
        DatabaseRegistry.loadDatabase(jdoConf, resolver, loader, source.getSystemId());
    }

    private static synchronized void loadDatabase(JdoConf jdoConf, EntityResolver resolver, ClassLoader loader, String baseURI) throws MappingException {
        LocalConfiguration cfg = LocalConfiguration.getInstance();
        String property = cfg.getProperty(INITIALIZE_AT_LOAD, "true");
        boolean init = Boolean.valueOf(property);
        Database[] databases = jdoConf.getDatabase();
        for (int i = 0; i < databases.length; ++i) {
            String name;
            Mapping mapping = new Mapping(loader);
            if (resolver != null) {
                mapping.setEntityResolver(resolver);
            }
            if (baseURI != null) {
                mapping.setBaseURL(baseURI);
            }
            AbstractConnectionFactory factory = DatabaseRegistry.createFactory(jdoConf, i, mapping);
            if (init) {
                factory.initialize();
            }
            if (FACTORIES.put(name = databases[i].getName(), factory) == null) continue;
            LOG.warn((Object)Messages.format("jdo.configLoadedTwice", name));
        }
    }

    /*
     * WARNING - void declaration
     */
    private static AbstractConnectionFactory createFactory(JdoConf jdoConf, int index, Mapping mapping) throws MappingException {
        void var3_8;
        AbstractConnectionFactory factory;
        DatabaseChoice choice = jdoConf.getDatabase(index).getDatabaseChoice();
        if (choice == null) {
            String name = jdoConf.getDatabase(index).getName();
            String msg = Messages.format("jdo.missingDataSource", name);
            LOG.error((Object)msg);
            throw new MappingException(msg);
        }
        if (choice.getDriver() != null) {
            factory = new DriverConnectionFactory(jdoConf, index, mapping);
        } else if (choice.getDataSource() != null) {
            factory = new DataSourceConnectionFactory(jdoConf, index, mapping);
        } else if (choice.getJndi() != null) {
            factory = new JNDIConnectionFactory(jdoConf, index, mapping);
        } else {
            String name = jdoConf.getDatabase(index).getName();
            String msg = Messages.format("jdo.missingDataSource", name);
            LOG.error((Object)msg);
            throw new MappingException(msg);
        }
        return var3_8;
    }

    public static boolean hasDatabaseRegistries() {
        return !FACTORIES.isEmpty();
    }

    public static boolean isDatabaseRegistred(String name) {
        return FACTORIES.containsKey(name);
    }

    public static AbstractConnectionFactory getConnectionFactory(String name) throws MappingException {
        AbstractConnectionFactory factory;
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Fetching ConnectionFactory: " + name));
        }
        if ((factory = (AbstractConnectionFactory)FACTORIES.get(name)) == null) {
            String msg = Messages.format("jdo.missingDataSource", name);
            LOG.error((Object)msg);
            throw new MappingException(msg);
        }
        factory.initialize();
        return factory;
    }

    public static void clear() {
        FACTORIES.clear();
    }

    private DatabaseRegistry() {
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

