/*
 * Decompiled with CFR 0.152.
 */
package org.castor.jdo.util;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.exolab.castor.jdo.Database;
import org.exolab.castor.jdo.PersistenceException;
import org.exolab.castor.jdo.TransactionNotInProgressException;
import org.exolab.castor.util.Messages;

public final class JDOUtils {
    private static final Log LOG = LogFactory.getLog((Class)(class$org$castor$jdo$util$JDOUtils == null ? (class$org$castor$jdo$util$JDOUtils = JDOUtils.class$("org.castor.jdo.util.JDOUtils")) : class$org$castor$jdo$util$JDOUtils));
    static /* synthetic */ Class class$org$castor$jdo$util$JDOUtils;

    public static void closeConnection(Connection conn) {
        if (conn != null) {
            try {
                if (!conn.isClosed()) {
                    conn.close();
                }
            }
            catch (SQLException e) {
                LOG.warn((Object)Messages.message("persist.connClosingFailed"), (Throwable)e);
            }
        }
    }

    public static void closeResultSet(ResultSet rs) {
        if (rs != null) {
            try {
                rs.close();
            }
            catch (SQLException e) {
                LOG.warn((Object)Messages.message("persist.rsClosingFailed"), (Throwable)e);
            }
        }
    }

    public static void closeStatement(Statement stmt) {
        if (stmt != null) {
            try {
                stmt.close();
            }
            catch (SQLException e) {
                LOG.warn((Object)Messages.message("persist.stClosingFailed"), (Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void closeDatabase(Database db) {
        if (db != null && !db.isClosed()) {
            Database database = db;
            synchronized (database) {
                if (db.isActive()) {
                    try {
                        db.rollback();
                    }
                    catch (TransactionNotInProgressException e) {
                        LOG.warn((Object)"Failed to rollback an active transaction.", (Throwable)e);
                    }
                }
                if (!db.isClosed()) {
                    try {
                        db.close();
                    }
                    catch (PersistenceException e) {
                        LOG.warn((Object)"Failed to close an open database.", (Throwable)e);
                    }
                }
            }
        }
    }

    private JDOUtils() {
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

