/*
 * Decompiled with CFR 0.152.
 */
package org.castor.persist;

import java.sql.Connection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import javax.transaction.xa.Xid;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.castor.persist.ObjectTracker;
import org.castor.persist.ProposedObject;
import org.exolab.castor.jdo.ClassNotPersistenceCapableException;
import org.exolab.castor.jdo.Database;
import org.exolab.castor.jdo.DbMetaInfo;
import org.exolab.castor.jdo.DuplicateIdentityException;
import org.exolab.castor.jdo.LockNotGrantedException;
import org.exolab.castor.jdo.ObjectDeletedException;
import org.exolab.castor.jdo.ObjectModifiedException;
import org.exolab.castor.jdo.ObjectNotFoundException;
import org.exolab.castor.jdo.ObjectNotPersistentException;
import org.exolab.castor.jdo.PersistenceException;
import org.exolab.castor.jdo.QueryException;
import org.exolab.castor.jdo.TransactionAbortedException;
import org.exolab.castor.mapping.AccessMode;
import org.exolab.castor.persist.ClassMolder;
import org.exolab.castor.persist.LockEngine;
import org.exolab.castor.persist.OID;
import org.exolab.castor.persist.ObjectDeletedWaitingForLockException;
import org.exolab.castor.persist.ObjectLock;
import org.exolab.castor.persist.PersistenceInfoGroup;
import org.exolab.castor.persist.QueryResults;
import org.exolab.castor.persist.TxSynchronizable;
import org.exolab.castor.persist.spi.CallbackInterceptor;
import org.exolab.castor.persist.spi.InstanceFactory;
import org.exolab.castor.persist.spi.PersistenceQuery;
import org.exolab.castor.util.Messages;

public abstract class TransactionContext {
    private static Log _log = LogFactory.getFactory().getInstance(class$org$castor$persist$TransactionContext == null ? (class$org$castor$persist$TransactionContext = TransactionContext.class$("org.castor.persist.TransactionContext")) : class$org$castor$persist$TransactionContext);
    private static final int OBJECT_STATE_TRANSIENT = 0;
    private static final int OBJECT_STATE_HOLLOW = 1;
    private static final int OBJECT_STATE_READ_ONLY = 2;
    private static final int OBJECT_STATE_PERSISTENT = 3;
    private static final int OBJECT_STATE_PERSISTENT_NEW = 4;
    private static final int OBJECT_STATE_PERSISTENT_DELETED = 5;
    private static final int OBJECT_STATE_PERSISTENT_NEW_DELETED = 6;
    private final ObjectTracker _tracker = new ObjectTracker();
    private ObjectLock _waitOnLock;
    private int _status;
    private int _lockTimeout = 30;
    private final Xid _xid = null;
    private int _txTimeout = 30;
    private Database _db;
    private boolean _autoStore;
    private CallbackInterceptor _callback;
    private InstanceFactory _instanceFactory;
    private ArrayList _synchronizeList = new ArrayList();
    static /* synthetic */ Class class$org$castor$persist$TransactionContext;

    public TransactionContext(Database db) {
        this._status = -1;
        this._db = db;
    }

    public TransactionContext(Database db, Transaction transaction) throws SystemException {
        this._db = db;
        this._status = transaction.getStatus();
    }

    public void addTxSynchronizable(TxSynchronizable synchronizable) {
        this._synchronizeList.add(synchronizable);
    }

    public void removeTxSynchronizable(TxSynchronizable synchronizable) {
        this._synchronizeList.remove(synchronizable);
    }

    protected void txcommitted() {
        for (int i = 0; i < this._synchronizeList.size(); ++i) {
            TxSynchronizable sync = (TxSynchronizable)this._synchronizeList.get(i);
            try {
                sync.committed(this);
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    protected void txrolledback() {
        for (int i = 0; i < this._synchronizeList.size(); ++i) {
            TxSynchronizable sync = (TxSynchronizable)this._synchronizeList.get(i);
            try {
                sync.rolledback(this);
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public void setAutoStore(boolean autoStore) {
        this._autoStore = autoStore;
    }

    public boolean isAutoStore() {
        return this._autoStore;
    }

    public void setCallback(CallbackInterceptor callback) {
        this._callback = callback;
    }

    public void setInstanceFactory(InstanceFactory factory) {
        this._instanceFactory = factory;
    }

    public PersistenceInfoGroup getScope() {
        return this._db.getScope();
    }

    public void setTransactionTimeout(int timeout) {
        this._txTimeout = timeout;
    }

    public int getTransactionTimeout() {
        return this._txTimeout;
    }

    public int getLockTimeout() {
        return this._lockTimeout;
    }

    public void setLockTimeout(int timeout) {
        this._lockTimeout = timeout >= 0 ? timeout : 0;
    }

    public void setStatusActive() {
        this._status = 0;
    }

    public abstract Connection getConnection(LockEngine var1) throws PersistenceException;

    public abstract DbMetaInfo getConnectionInfo(LockEngine var1) throws PersistenceException;

    protected abstract void commitConnections() throws TransactionAbortedException;

    protected abstract void closeConnections() throws TransactionAbortedException;

    protected abstract void rollbackConnections();

    public synchronized Object fetch(LockEngine engine, ClassMolder molder, Object identity, AccessMode suggestedAccessMode) throws ObjectNotFoundException, LockNotGrantedException, PersistenceException {
        if (identity == null) {
            throw new PersistenceException("Identities can't be null!");
        }
        OID oid = new OID(engine, molder, identity);
        AccessMode accessMode = molder.getAccessMode(suggestedAccessMode);
        Object objectInTransaction = accessMode == AccessMode.ReadOnly ? this._tracker.getObjectForOID(engine, oid, true) : this._tracker.getObjectForOID(engine, oid, false);
        if (objectInTransaction != null) {
            if (engine != this._tracker.getLockEngineForObject(objectInTransaction)) {
                throw new PersistenceException(Messages.format("persist.multipleLoad", molder.getName(), identity));
            }
            if (this._tracker.isDeleted(objectInTransaction)) {
                return null;
            }
            if (!molder.isAssignableFrom(objectInTransaction.getClass())) {
                throw new PersistenceException(Messages.format("persist.typeMismatch", molder.getName(), identity));
            }
            if (this._tracker.isCreated(objectInTransaction)) {
                return objectInTransaction;
            }
            if (!(accessMode != AccessMode.Exclusive && accessMode != AccessMode.DbLocked || this._tracker.getOIDForObject(objectInTransaction).isDbLock())) {
                throw new PersistenceException(Messages.format("persist.lockConflict", molder.getName(), identity));
            }
            return objectInTransaction;
        }
        return null;
    }

    public synchronized Object load(LockEngine engine, ClassMolder molder, Object identity, ProposedObject proposedObject, AccessMode suggestedAccessMode) throws ObjectNotFoundException, LockNotGrantedException, PersistenceException {
        return this.load(engine, molder, identity, proposedObject, suggestedAccessMode, null);
    }

    public synchronized Object load(LockEngine engine, ClassMolder molder, Object identity, ProposedObject proposedObject, AccessMode suggestedAccessMode, QueryResults results) throws ObjectNotFoundException, LockNotGrantedException, PersistenceException {
        Object objectInTransaction;
        AccessMode accessMode;
        OID oid;
        block30: {
            if (identity == null) {
                throw new PersistenceException("Identities can't be null!");
            }
            if (proposedObject.getObject() != null && !molder.getJavaClass(this._db.getClassLoader()).isAssignableFrom(proposedObject.getProposedClass())) {
                throw new PersistenceException(Messages.format("persist.typeMismatch", molder.getName(), proposedObject.getProposedClass()));
            }
            oid = new OID(engine, molder, identity);
            accessMode = molder.getAccessMode(suggestedAccessMode);
            objectInTransaction = accessMode == AccessMode.ReadOnly ? this._tracker.getObjectForOID(engine, oid, true) : this._tracker.getObjectForOID(engine, oid, false);
            if (objectInTransaction != null) {
                if (proposedObject.getObject() != null && proposedObject.getObject() != objectInTransaction) {
                    throw new PersistenceException(Messages.format("persist.multipleLoad", molder.getName(), identity));
                }
                if (engine != this._tracker.getLockEngineForObject(objectInTransaction)) {
                    throw new PersistenceException(Messages.format("persist.multipleLoad", molder.getName(), identity));
                }
                if (this._tracker.isDeleted(objectInTransaction)) {
                    throw new ObjectNotFoundException(Messages.format("persist.objectNotFound", molder.getName(), identity));
                }
                if (!molder.getJavaClass(this._db.getClassLoader()).isAssignableFrom(objectInTransaction.getClass())) {
                    throw new PersistenceException(Messages.format("persist.typeMismatch", molder.getName(), objectInTransaction.getClass()));
                }
                if (this._tracker.isCreated(objectInTransaction)) {
                    return objectInTransaction;
                }
                if (!(accessMode != AccessMode.Exclusive && accessMode != AccessMode.DbLocked || this._tracker.getOIDForObject(objectInTransaction).isDbLock())) {
                    throw new PersistenceException(Messages.format("persist.lockConflict", molder.getName(), identity));
                }
                return objectInTransaction;
            }
            try {
                if (proposedObject.getObject() != null) {
                    objectInTransaction = proposedObject.getObject();
                } else {
                    objectInTransaction = this._instanceFactory != null ? this._instanceFactory.newInstance(molder.getName(), this._db.getClassLoader()) : molder.newInstance(this._db.getClassLoader());
                    proposedObject.setProposedClass(objectInTransaction.getClass());
                    proposedObject.setActualClass(objectInTransaction.getClass());
                    proposedObject.setObject(objectInTransaction);
                }
                molder.setIdentity(this, objectInTransaction, identity);
                this._tracker.trackObject(engine, molder, oid, objectInTransaction);
                OID newoid = engine.load(this, oid, proposedObject, suggestedAccessMode, this._lockTimeout, results);
                if (proposedObject.isExpanded()) {
                    this._tracker.untrackObject(objectInTransaction);
                    ClassMolder actualClassMolder = engine.getClassMolder(proposedObject.getActualClass());
                    OID actualOID = new OID(engine, actualClassMolder, identity);
                    actualClassMolder.setIdentity(this, proposedObject.getObject(), identity);
                    Object expandedObject = null;
                    try {
                        expandedObject = actualClassMolder.newInstance(this.getClassLoader());
                    }
                    catch (InstantiationException e) {
                        _log.error((Object)("Cannot create instance of " + molder.getName()));
                        throw new PersistenceException("Cannot craete instance of " + molder.getName());
                    }
                    catch (IllegalAccessException e) {
                        _log.error((Object)("Cannot create instance of " + molder.getName()));
                        throw new PersistenceException("Cannot craete instance of " + molder.getName());
                    }
                    catch (ClassNotFoundException e) {
                        _log.error((Object)("Cannot create instance of " + molder.getName()));
                        throw new PersistenceException("Cannot craete instance of " + molder.getName());
                    }
                    this._tracker.trackObject(engine, molder, actualOID, expandedObject);
                    ProposedObject proposedExpanded = new ProposedObject();
                    proposedExpanded.setProposedClass(proposedObject.getActualClass());
                    proposedExpanded.setActualClass(proposedObject.getActualClass());
                    proposedExpanded.setObject(expandedObject);
                    proposedExpanded.setFields(proposedObject.getFields());
                    proposedExpanded.setObjectLockObjectToBeIgnored(true);
                    OID onceAgainOID = engine.load(this, actualOID, proposedExpanded, suggestedAccessMode, this._lockTimeout, results);
                    objectInTransaction = proposedExpanded.getObject();
                    break block30;
                }
                this._tracker.trackOIDChange(objectInTransaction, engine, oid, newoid);
            }
            catch (ClassCastException except) {
                this._tracker.untrackObject(objectInTransaction);
                throw except;
            }
            catch (ObjectNotFoundException except) {
                this._tracker.untrackObject(objectInTransaction);
                throw except;
            }
            catch (LockNotGrantedException except) {
                this._tracker.untrackObject(objectInTransaction);
                throw except;
            }
            catch (ClassNotPersistenceCapableException except) {
                this._tracker.untrackObject(objectInTransaction);
                throw new PersistenceException(Messages.format("persist.nested", except));
            }
            catch (InstantiationException e) {
                this._tracker.untrackObject(objectInTransaction);
                throw new PersistenceException(e.getMessage(), e);
            }
            catch (IllegalAccessException e) {
                this._tracker.untrackObject(objectInTransaction);
                throw new PersistenceException(e.getMessage(), e);
            }
            catch (ClassNotFoundException e) {
                this._tracker.untrackObject(objectInTransaction);
                throw new PersistenceException(e.getMessage(), e);
            }
        }
        try {
            if (this._callback != null) {
                this._callback.using(objectInTransaction, this._db);
                this._callback.loaded(objectInTransaction, accessMode);
            } else if (molder.getCallback() != null) {
                molder.getCallback().using(objectInTransaction, this._db);
                molder.getCallback().loaded(objectInTransaction, accessMode);
            }
        }
        catch (Exception except) {
            this.release(objectInTransaction);
            throw new PersistenceException(Messages.format("persist.nested", except));
        }
        if (accessMode == AccessMode.ReadOnly) {
            this._tracker.markReadOnly(objectInTransaction);
            engine.releaseLock(this, oid);
        }
        return objectInTransaction;
    }

    public synchronized QueryResults query(LockEngine engine, PersistenceQuery query, AccessMode accessMode, boolean scrollable) throws QueryException, PersistenceException {
        query.execute(this.getConnection(engine), accessMode, scrollable);
        return new QueryResults(this, engine, query, accessMode, this._db);
    }

    public synchronized QueryResults query(LockEngine engine, PersistenceQuery query, AccessMode accessMode) throws QueryException, PersistenceException {
        return this.query(engine, query, accessMode, false);
    }

    public synchronized void markCreate(LockEngine engine, ClassMolder molder, Object object, OID rootObjectOID) throws DuplicateIdentityException, PersistenceException {
        if (object == null) {
            throw new PersistenceException("Attempted to mark a null object as created.");
        }
        Object identity = molder.getIdentity(this, object);
        if (this._autoStore && this._tracker.isTracking(object)) {
            return;
        }
        if (this._tracker.isDeleted(object)) {
            OID deletedoid = this._tracker.getOIDForObject(object);
            throw new PersistenceException(Messages.format("persist.objectAlreadyPersistent", object.getClass().getName(), deletedoid != null ? deletedoid.getIdentity() : null));
        }
        OID oid = new OID(engine, molder, rootObjectOID, identity);
        Object trackedObject = this._tracker.getObjectForOID(engine, oid, false);
        if (identity != null && trackedObject != null) {
            if (trackedObject != object) {
                throw new DuplicateIdentityException("Object being tracked with the OID created for a dependent object does not match the object to be marked for creation. Fundamental Tracking Error.");
            }
            if (this._tracker.isDeleted(object)) {
                this._tracker.unmarkDeleted(object);
            }
        }
        try {
            this._tracker.trackObject(engine, molder, oid, object);
            this._tracker.markCreating(object);
            if (this._callback != null) {
                this._callback.creating(object, this._db);
            } else if (molder.getCallback() != null) {
                molder.getCallback().creating(object, this._db);
            }
            engine.markCreate(this, oid, object);
        }
        catch (LockNotGrantedException lneg) {
            this._tracker.untrackObject(object);
            throw lneg;
        }
        catch (PersistenceException pe) {
            this._tracker.untrackObject(object);
            throw pe;
        }
        catch (Exception e) {
            this._tracker.untrackObject(object);
            throw new PersistenceException(Messages.format("persist.nested", e));
        }
    }

    public synchronized void create(LockEngine engine, ClassMolder molder, Object object, OID depended) throws DuplicateIdentityException, PersistenceException {
        this.markCreate(engine, molder, object, depended);
        this.walkObjectsToBeCreated();
        this.walkObjectsWhichNeedCacheUpdate();
    }

    private synchronized void walkObjectsToBeCreated() throws DuplicateIdentityException, PersistenceException {
        Collection createableObjects = this._tracker.getObjectsWithCreatingStateSortedByLowestMolderPriority();
        Iterator creatableIterator = createableObjects.iterator();
        while (creatableIterator.hasNext()) {
            Object toBeCreated = creatableIterator.next();
            LockEngine toBeCreatedLockEngine = this._tracker.getLockEngineForObject(toBeCreated);
            OID toBeCreatedOID = this._tracker.getOIDForObject(toBeCreated);
            ClassMolder toBeCreatedMolder = this._tracker.getMolderForObject(toBeCreated);
            try {
                if (!this._tracker.isCreating(toBeCreated)) continue;
                if (this._callback != null) {
                    this._callback.creating(toBeCreated, this._db);
                } else if (toBeCreatedMolder.getCallback() != null) {
                    toBeCreatedMolder.getCallback().creating(toBeCreated, this._db);
                }
                OID oid = toBeCreatedLockEngine.create(this, toBeCreatedOID, toBeCreated);
                if (oid.getIdentity() == null) {
                    throw new IllegalStateException("oid.getIdentity() is null after create!");
                }
                this._tracker.trackOIDChange(toBeCreated, toBeCreatedLockEngine, toBeCreatedOID, oid);
                this._tracker.markCreated(toBeCreated);
                if (this._callback != null) {
                    this._callback.using(toBeCreated, this._db);
                    this._callback.created(toBeCreated);
                    continue;
                }
                if (toBeCreatedMolder.getCallback() == null) continue;
                toBeCreatedMolder.getCallback().using(toBeCreated, this._db);
                toBeCreatedMolder.getCallback().created(toBeCreated);
            }
            catch (Exception except) {
                if (this._callback != null) {
                    this._callback.releasing(toBeCreated, false);
                } else if (toBeCreatedMolder.getCallback() != null) {
                    toBeCreatedMolder.getCallback().releasing(toBeCreated, false);
                }
                this._tracker.untrackObject(toBeCreated);
                if (except instanceof DuplicateIdentityException) {
                    throw (DuplicateIdentityException)except;
                }
                if (except instanceof PersistenceException) {
                    throw (PersistenceException)except;
                }
                throw new PersistenceException(Messages.format("persist.nested", except));
            }
        }
    }

    private void walkObjectsWhichNeedCacheUpdate() {
        Collection objectsMarkedForUpdate = this._tracker.getObjectsWithUpdateCacheNeededState();
        Iterator it = objectsMarkedForUpdate.iterator();
        while (it.hasNext()) {
            Object toCacheUpdate = it.next();
            if (!this._tracker.isCreated(toCacheUpdate)) continue;
            OID toCacheUpdateOID = this._tracker.getOIDForObject(toCacheUpdate);
            LockEngine toCacheUpdateLockEngine = this._tracker.getLockEngineForObject(toCacheUpdate);
            toCacheUpdateLockEngine.updateCache(this, toCacheUpdateOID, toCacheUpdate);
            this._tracker.unmarkUpdateCacheNeeded(toCacheUpdate);
        }
    }

    public boolean markUpdate(LockEngine engine, ClassMolder molder, Object object, OID depended) throws DuplicateIdentityException, ObjectModifiedException, ClassNotPersistenceCapableException, PersistenceException {
        if (object == null) {
            throw new NullPointerException();
        }
        Object identity = molder.getActualIdentity(this, object);
        if (molder.isDefaultIdentity(identity)) {
            identity = null;
        }
        OID oid = new OID(engine, molder, depended, identity);
        Object foundInTransaction = this._tracker.getObjectForOID(engine, oid, false);
        if (this._autoStore && foundInTransaction != null && foundInTransaction == object) {
            return false;
        }
        if (foundInTransaction != null) {
            if (this._tracker.isDeleted(foundInTransaction)) {
                throw new ObjectDeletedException(Messages.format("persist.objectDeleted", object.getClass(), identity));
            }
            throw new DuplicateIdentityException("update object which is already in the transaction");
        }
        try {
            this._tracker.trackObject(engine, molder, oid, object);
            if (engine.update(this, oid, object, null, 0)) {
                this._tracker.markCreating(object);
            }
        }
        catch (DuplicateIdentityException lneg) {
            this._tracker.untrackObject(object);
            throw lneg;
        }
        catch (PersistenceException pe) {
            this._tracker.untrackObject(object);
            throw pe;
        }
        catch (Exception e) {
            this._tracker.untrackObject(object);
            throw new PersistenceException(Messages.format("persist.nested", e));
        }
        if (!this._tracker.isCreating(object)) {
            try {
                if (this._callback != null) {
                    this._callback.using(object, this._db);
                    this._callback.updated(object);
                } else if (molder.getCallback() != null) {
                    molder.getCallback().using(object, this._db);
                    molder.getCallback().updated(object);
                }
            }
            catch (Exception except) {
                this.release(object);
                if (except instanceof PersistenceException) {
                    throw (PersistenceException)except;
                }
                throw new PersistenceException(except.getMessage(), except);
            }
            return false;
        }
        return true;
    }

    public synchronized void update(LockEngine engine, ClassMolder molder, Object object, OID depended) throws DuplicateIdentityException, ObjectModifiedException, ClassNotPersistenceCapableException, PersistenceException {
        this.markUpdate(engine, molder, object, depended);
        this.walkObjectsToBeCreated();
        this.walkObjectsWhichNeedCacheUpdate();
    }

    public synchronized void delete(Object object) throws ObjectNotPersistentException, LockNotGrantedException, PersistenceException {
        if (object == null) {
            throw new PersistenceException("Object to be deleted is null!");
        }
        if (!this._tracker.isTracking(object)) {
            throw new ObjectNotPersistentException(Messages.format("persist.objectNotPersistent", object.getClass().getName()));
        }
        ClassMolder molder = this._tracker.getMolderForObject(object);
        LockEngine engine = this._tracker.getLockEngineForObject(object);
        OID oid = this._tracker.getOIDForObject(object);
        if (this._tracker.isDeleted(object)) {
            throw new ObjectDeletedException(Messages.format("persist.objectDeleted", object.getClass().getName(), oid.getIdentity()));
        }
        try {
            if (this._callback != null) {
                this._callback.removing(object);
            } else if (molder.getCallback() != null) {
                molder.getCallback().removing(object);
            }
        }
        catch (Exception except) {
            throw new PersistenceException(Messages.format("persist.nested", except));
        }
        try {
            this._tracker.markDeleted(object);
            engine.softLock(this, oid, this._lockTimeout);
            engine.markDelete(this, oid, object, this._lockTimeout);
            try {
                if (this._callback != null) {
                    this._callback.removed(object);
                } else if (molder.getCallback() != null) {
                    molder.getCallback().removed(object);
                }
            }
            catch (Exception except) {
                throw new PersistenceException(Messages.format("persist.nested", except));
            }
        }
        catch (ObjectDeletedException except) {
            this._tracker.untrackObject(object);
        }
    }

    public synchronized void writeLock(Object object, int timeout) throws ObjectNotPersistentException, LockNotGrantedException, PersistenceException {
        if (object == null) {
            throw new PersistenceException("Object to acquire lock is null!");
        }
        if (!this._tracker.isTracking(object)) {
            throw new ObjectNotPersistentException(Messages.format("persist.objectNotPersistent", object.getClass().getName()));
        }
        LockEngine engine = this._tracker.getLockEngineForObject(object);
        OID oid = this._tracker.getOIDForObject(object);
        if (this._tracker.isDeleted(object)) {
            throw new ObjectDeletedException(Messages.format("persist.objectDeleted", object.getClass(), oid.getIdentity()));
        }
        try {
            engine.writeLock(this, oid, timeout);
        }
        catch (ObjectDeletedException except) {
            this._tracker.untrackObject(object);
            throw new ObjectNotPersistentException(Messages.format("persist.objectNotPersistent", object.getClass().getName()));
        }
        catch (LockNotGrantedException except) {
            throw except;
        }
    }

    public synchronized void markModified(Object object, boolean updatePersist, boolean updateCache) {
        if (updatePersist) {
            this._tracker.markUpdatePersistNeeded(object);
        }
        if (updateCache) {
            this._tracker.markUpdateCacheNeeded(object);
        }
    }

    public synchronized void softLock(Object object, int timeout) throws LockNotGrantedException, ObjectNotPersistentException {
        if (object == null) {
            throw new ObjectNotPersistentException("Object to acquire lock is null!");
        }
        if (!this._tracker.isTracking(object)) {
            throw new ObjectNotPersistentException(Messages.format("persist.objectNotPersistent", object.getClass().getName()));
        }
        LockEngine engine = this._tracker.getLockEngineForObject(object);
        OID oid = this._tracker.getOIDForObject(object);
        if (this._tracker.isDeleted(object)) {
            throw new ObjectDeletedException(Messages.format("persist.objectDeleted", object.getClass().getName(), oid.getIdentity()));
        }
        try {
            engine.softLock(this, oid, timeout);
        }
        catch (ObjectDeletedWaitingForLockException except) {
            this._tracker.untrackObject(object);
            throw except;
        }
        catch (LockNotGrantedException except) {
            throw except;
        }
    }

    public synchronized void release(Object object) throws ObjectNotPersistentException, PersistenceException {
        if (object == null) {
            throw new PersistenceException("Object to release lock is null!");
        }
        if (!this._tracker.isTracking(object)) {
            throw new ObjectNotPersistentException(Messages.format("persist.objectNotPersistent", object.getClass().getName().getClass()));
        }
        LockEngine engine = this._tracker.getLockEngineForObject(object);
        ClassMolder molder = this._tracker.getMolderForObject(object);
        OID oid = this._tracker.getOIDForObject(object);
        if (this._tracker.isDeleted(object)) {
            throw new ObjectDeletedException(Messages.format("persist.objectDeleted", object.getClass().getName(), oid.getIdentity()));
        }
        engine.releaseLock(this, oid);
        this._tracker.untrackObject(object);
        if (this._callback != null) {
            this._callback.releasing(object, false);
        } else if (molder != null && molder.getCallback() != null) {
            molder.getCallback().releasing(object, false);
        }
        if (engine == null) {
            throw new PersistenceException("Release:  Missing engine during release call; fundamental tracking error.");
        }
        if (molder == null) {
            throw new PersistenceException("Release: Missing molder during release call; fundamental tracking error.");
        }
        if (oid == null) {
            throw new PersistenceException("Release: Missing OID during release call; fundamental tracking error.");
        }
    }

    public synchronized boolean prepare() throws TransactionAbortedException {
        ArrayList todo = new ArrayList();
        ArrayList done = new ArrayList();
        if (this._status == 1) {
            throw new TransactionAbortedException("persist.markedRollback");
        }
        if (this._status != 0) {
            throw new IllegalStateException(Messages.message("persist.noTransaction"));
        }
        try {
            if (this._tracker.readWriteSize() == 0) {
                this._status = 2;
                return false;
            }
            Collection readWriteObjects = this._tracker.getReadWriteObjects();
            while (readWriteObjects.size() != done.size()) {
                todo.clear();
                Iterator rwIterator = readWriteObjects.iterator();
                while (rwIterator.hasNext()) {
                    Object object = rwIterator.next();
                    if (done.contains(object)) continue;
                    todo.add(object);
                }
                Iterator todoIterator = todo.iterator();
                while (todoIterator.hasNext()) {
                    Object object = todoIterator.next();
                    if (!this._tracker.isDeleted(object) && !this._tracker.isCreating(object)) {
                        LockEngine engine = this._tracker.getLockEngineForObject(object);
                        ClassMolder molder = this._tracker.getMolderForObject(object);
                        OID oid = this._tracker.getOIDForObject(object);
                        OID newoid = engine.preStore(this, oid, object, this._lockTimeout);
                        if (newoid != null) {
                            this._tracker.trackOIDChange(object, engine, oid, newoid);
                            this._tracker.markUpdateCacheNeeded(object);
                        }
                    }
                    done.add(object);
                }
            }
            this.walkObjectsToBeCreated();
            this.prepareForCreate();
            this._status = 7;
            this.prepareForDelete();
            this._status = 2;
            return true;
        }
        catch (Exception except) {
            this._status = 1;
            if (except instanceof TransactionAbortedException) {
                throw (TransactionAbortedException)except;
            }
            throw new TransactionAbortedException(Messages.format("persist.nested", except), except);
        }
    }

    private void prepareForCreate() throws PersistenceException {
        Collection allObjects = this._tracker.getReadWriteObjects();
        Iterator it = allObjects.iterator();
        while (it.hasNext()) {
            Object toPrepare = it.next();
            boolean isCreating = this._tracker.isCreating(toPrepare);
            boolean isDeleted = this._tracker.isDeleted(toPrepare);
            boolean needsPersist = this._tracker.isUpdatePersistNeeded(toPrepare);
            boolean needsCache = this._tracker.isUpdateCacheNeeded(toPrepare);
            LockEngine engine = this._tracker.getLockEngineForObject(toPrepare);
            ClassMolder molder = this._tracker.getMolderForObject(toPrepare);
            OID oid = this._tracker.getOIDForObject(toPrepare);
            if (!isDeleted && !isCreating) {
                if (needsPersist) {
                    engine.store(this, oid, toPrepare);
                }
                if (needsCache) {
                    engine.softLock(this, oid, this._lockTimeout);
                }
            }
            if (!isDeleted && this._callback != null) {
                try {
                    this._callback.storing(toPrepare, needsCache);
                    continue;
                }
                catch (Exception except) {
                    throw new TransactionAbortedException(Messages.format("persist.nested", except), except);
                }
            }
            if (isDeleted || molder.getCallback() == null) continue;
            try {
                molder.getCallback().storing(toPrepare, needsCache);
            }
            catch (Exception except) {
                throw new TransactionAbortedException(Messages.format("persist.nested", except), except);
            }
        }
    }

    private void prepareForDelete() throws PersistenceException {
        Collection objectsToDelete = this._tracker.getObjectsWithDeletedStateSortedByHighestMolderPriority();
        Iterator it = objectsToDelete.iterator();
        while (it.hasNext()) {
            Object object = it.next();
            LockEngine engine = this._tracker.getLockEngineForObject(object);
            OID oid = this._tracker.getOIDForObject(object);
            engine.delete(this, oid);
        }
    }

    public synchronized void commit() throws TransactionAbortedException {
        if (this._status == 1) {
            throw new TransactionAbortedException("persist.markedRollback");
        }
        if (this._status != 2) {
            throw new IllegalStateException(Messages.message("persist.missingPrepare"));
        }
        try {
            this._status = 8;
            this.commitConnections();
        }
        catch (Exception except) {
            this._status = 1;
            throw new TransactionAbortedException(Messages.format("persist.nested", except), except);
        }
        Collection readWriteObjects = this._tracker.getReadWriteObjects();
        Iterator it = readWriteObjects.iterator();
        while (it.hasNext()) {
            Object toCommit = it.next();
            LockEngine engine = this._tracker.getLockEngineForObject(toCommit);
            ClassMolder molder = this._tracker.getMolderForObject(toCommit);
            OID oid = this._tracker.getOIDForObject(toCommit);
            if (this._tracker.isDeleted(toCommit)) {
                engine.forgetObject(this, oid);
                molder.setFieldsNull(toCommit);
            } else {
                if (this._tracker.isUpdateCacheNeeded(toCommit)) {
                    engine.updateCache(this, oid, toCommit);
                }
                engine.releaseLock(this, oid);
            }
            if (this._callback != null) {
                this._callback.releasing(toCommit, true);
                continue;
            }
            if (molder.getCallback() == null) continue;
            molder.getCallback().releasing(toCommit, true);
        }
        this.txcommitted();
        this._tracker.clear();
        this._status = 3;
    }

    public Iterator iterateReadWriteObjectsInTransaction() {
        return this._tracker.getReadWriteObjects().iterator();
    }

    public synchronized void rollback() {
        if (this._status != 0 && this._status != 2 && this._status != 1) {
            throw new IllegalStateException(Messages.message("persist.noTransaction"));
        }
        this.rollbackConnections();
        this._tracker.unmarkAllDeleted();
        Collection readWriteObjects = this._tracker.getReadWriteObjects();
        Iterator it = readWriteObjects.iterator();
        while (it.hasNext()) {
            Object object = it.next();
            LockEngine engine = this._tracker.getLockEngineForObject(object);
            ClassMolder molder = this._tracker.getMolderForObject(object);
            OID oid = this._tracker.getOIDForObject(object);
            try {
                if (!this._tracker.isCreating(object)) {
                    if (this._tracker.isCreated(object)) {
                        engine.revertObject(this, oid, object);
                        engine.forgetObject(this, oid);
                    } else {
                        engine.revertObject(this, oid, object);
                        engine.releaseLock(this, oid);
                    }
                }
                if (this._callback != null) {
                    this._callback.releasing(object, false);
                    continue;
                }
                if (molder.getCallback() == null) continue;
                molder.getCallback().releasing(object, false);
            }
            catch (Exception except) {
                _log.error((Object)("Caught exception while rolling back object with OID " + oid), (Throwable)except);
            }
        }
        this._tracker.clear();
        this.txrolledback();
        this._status = 4;
    }

    public synchronized void close() throws TransactionAbortedException {
        if (this._status != 0 && this._status != 1) {
            throw new IllegalStateException(Messages.message("persist.missingEnd"));
        }
        try {
            this.closeConnections();
        }
        catch (Exception except) {
            this._status = 1;
            throw new TransactionAbortedException(Messages.format("persist.nested", except), except);
        }
    }

    public boolean isCreated(Object object) {
        return this._tracker.isCreated(object);
    }

    public boolean isUpdateCacheNeeded(Object object) {
        return this._tracker.isUpdateCacheNeeded(object);
    }

    public boolean isUpdatePersistNeeded(Object object) {
        return this._tracker.isUpdatePersistNeeded(object);
    }

    public boolean isPersistent(Object object) {
        return this._tracker.isTracking(object) && !this._tracker.isDeleted(object);
    }

    public boolean isRecorded(Object object) {
        return this._tracker.isTracking(object);
    }

    public boolean isDepended(OID master, Object dependent) {
        OID oid = this._tracker.getOIDForObject(dependent);
        if (oid == null) {
            return false;
        }
        OID depends = oid.getDepends();
        if (depends == null) {
            return false;
        }
        return depends.equals(master);
    }

    public int getStatus() {
        return this._status;
    }

    public boolean isOpen() {
        return this._status == 0 || this._status == 1;
    }

    protected Xid getXid() {
        return this._xid;
    }

    public void setWaitOnLock(ObjectLock lock) {
        this._waitOnLock = lock;
    }

    public ObjectLock getWaitOnLock() {
        return this._waitOnLock;
    }

    public boolean isDeleted(Object object) {
        return this._tracker.isDeleted(object);
    }

    public boolean isDeletedByOID(OID oid) {
        Object o = this._tracker.getObjectForOID(oid.getLockEngine(), oid, false);
        if (o != null) {
            return this._tracker.isDeleted(o);
        }
        return false;
    }

    public int getObjectState(Object object) {
        if (this._tracker.isReadWrite(object)) {
            boolean created = this._tracker.isCreated(object);
            boolean deleted = this._tracker.isDeleted(object);
            if (created && !deleted) {
                return 4;
            }
            if (created && deleted) {
                return 6;
            }
            if (deleted) {
                return 5;
            }
            return 3;
        }
        if (this._tracker.isReadOnly(object)) {
            return 2;
        }
        return 0;
    }

    public ClassLoader getClassLoader() {
        return this._db.getClassLoader();
    }

    void markDelete(LockEngine engine, Class type, Object identity) throws LockNotGrantedException, PersistenceException {
        OID oid = new OID(engine, engine.getClassMolder(type), identity);
        Object foundInTransaction = this._tracker.getObjectForOID(engine, oid, false);
        ClassMolder molder = this._tracker.getMolderForObject(foundInTransaction);
        oid = this._tracker.getOIDForObject(foundInTransaction);
        if (foundInTransaction != null && !this._tracker.isDeleted(foundInTransaction)) {
            try {
                if (this._callback != null) {
                    this._callback.removing(foundInTransaction);
                } else if (molder.getCallback() != null) {
                    molder.getCallback().removing(foundInTransaction);
                }
            }
            catch (Exception except) {
                throw new PersistenceException(Messages.format("persist.nested", except));
            }
            try {
                this._tracker.markDeleted(foundInTransaction);
                engine.softLock(this, oid, this._lockTimeout);
                engine.markDelete(this, oid, null, this._lockTimeout);
                try {
                    if (this._callback != null) {
                        this._callback.removed(foundInTransaction);
                    } else if (molder.getCallback() != null) {
                        molder.getCallback().removed(foundInTransaction);
                    }
                }
                catch (Exception except) {
                    throw new PersistenceException(Messages.format("persist.nested", except));
                }
            }
            catch (ObjectDeletedException except) {
                this._tracker.untrackObject(foundInTransaction);
            }
        }
    }

    public synchronized void expireCache(LockEngine engine, ClassMolder molder, Object identity) throws PersistenceException, LockNotGrantedException {
        if (identity == null) {
            throw new PersistenceException("Identities can't be null!");
        }
        OID oid = new OID(engine, molder, identity);
        Object trackedObject = this._tracker.getObjectForOID(engine, oid, false);
        if (trackedObject == null) {
            try {
                this._tracker.trackObject(engine, molder, oid, identity);
                if (engine.expireCache(this, oid, this._lockTimeout)) {
                    engine.releaseLock(this, oid);
                }
            }
            catch (LockNotGrantedException except) {
                throw except;
            }
            finally {
                this._tracker.untrackObject(identity);
            }
        }
    }

    public boolean isCached(LockEngine engine, ClassMolder molder, Class cls, Object identity) throws PersistenceException {
        if (identity == null) {
            throw new PersistenceException("Identities can't be null!");
        }
        OID oid = new OID(engine, molder, identity);
        return engine.isCached(cls, oid);
    }

    public boolean isReadOnly(Object object) {
        return this._tracker.isReadOnly(object);
    }

    public Database getDatabase() {
        return this._db;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

