/*
 * Decompiled with CFR 0.152.
 */
package com.mayastudios.ixml.commands.menu;

import com.mayastudios.ixml.commands.base.Command;
import com.mayastudios.ixml.commands.base.IEnablable;
import com.mayastudios.ixml.common.BaseEventManager;
import com.mayastudios.ixml.common.GrayFilter;
import com.mayastudios.ixml.common.LabelCaption;
import com.mayastudios.ixml.common.SystemInfo;
import com.mayastudios.ixml.document.comp.AttributeParser;
import com.mayastudios.ixml.labels.LabelsCore;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import javax.swing.plaf.basic.BasicMenuItemUI;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IXMLMenuItem<EnableType>
extends JMenuItem
implements ActionListener,
IEnablable<EnableType>,
LabelsCore.ILabelsChangeListener {
    private static final ImageIcon EMPTY_ICON = new ImageIcon(new BufferedImage(16, 16, 2));
    private final LabelCaption mf_oCaption;
    private final Command<EnableType> mf_oCommand;
    private final boolean mf_bIsDefaultItem;

    public IXMLMenuItem(Command<EnableType> p_oCommand, boolean p_bHideIcon, boolean p_bIsDefaultItem) {
        this.mf_oCaption = p_oCommand.mf_oCaption;
        this.mf_oCommand = p_oCommand;
        this.mf_bIsDefaultItem = p_bIsDefaultItem;
        this.labelsChanged(false);
        if (SystemInfo.OSTYPE == SystemInfo.EOSType.MacOS) {
            p_bHideIcon = true;
        } else {
            this.setUI(new CLessGapMenuItemUI());
        }
        if (!p_bHideIcon && p_oCommand.mf_oIcon != null) {
            this.setIcon(p_oCommand.mf_oIcon);
            this.setDisabledIcon(GrayFilter.createDisabledIcon((ImageIcon)p_oCommand.mf_oIcon));
        } else {
            this.setIcon(null);
        }
        this.setAccelerator(p_oCommand.mf_oAccelerator);
        this.setEnabled(p_oCommand.getBaseEnableState());
        if (p_bIsDefaultItem) {
            this.highlightDefaultItem();
        }
        LabelsCore.addLabelsChangeListener((LabelsCore.ILabelsChangeListener)this, (BaseEventManager.ERefType)BaseEventManager.ERefType.WEAK);
        this.addActionListener(this);
    }

    protected void highlightDefaultItem() {
        this.setFont(this.getFont().deriveFont(1));
    }

    public boolean isDefaultItem() {
        return this.mf_bIsDefaultItem;
    }

    @Override
    public void updateEnableState(EnableType p_oConstraint) {
        this.setEnabled(this.mf_oCommand.isEnabled(p_oConstraint));
    }

    @Override
    public void actionPerformed(ActionEvent p_oEvent) {
        this.mf_oCommand.invoke();
    }

    public void labelsChanged(boolean p_bLocaleHasChanged) {
        AttributeParser.MnemonicCaption oCaption = new AttributeParser.MnemonicCaption(this.mf_oCaption.toString());
        oCaption.applyTo(this);
    }

    @Override
    public void setIcon(Icon p_oIcon) {
        if (p_oIcon == null && SystemInfo.OSTYPE != SystemInfo.EOSType.MacOS) {
            p_oIcon = EMPTY_ICON;
        }
        super.setIcon(p_oIcon);
    }

    private static class CLessGapMenuItemUI
    extends BasicMenuItemUI {
        protected void paintMenuItem(Graphics p_oGraphics, JComponent p_oComponent, Icon p_oCheckIcon, Icon p_oArrowIcon, Color p_oBackgroundColor, Color p_oForegroundColor, int p_iDefaultTextIconGap) {
            super.paintMenuItem(p_oGraphics, p_oComponent, null, p_oArrowIcon, p_oBackgroundColor, p_oForegroundColor, p_iDefaultTextIconGap);
        }
    }
}

