/*
 * Decompiled with CFR 0.152.
 */
package com.mayastudios.ixml.document;

import com.mayastudios.ixml.common.IXMLError;
import com.mayastudios.ixml.common.IXMLException;
import com.mayastudios.ixml.document.DocumentCompFactory;
import com.mayastudios.ixml.document.IXMLDocument;
import com.mayastudios.ixml.document.IXMLPanel;
import com.mayastudios.ixml.document.comp.base.EIXMLAttrib;
import com.mayastudios.ixml.document.comp.base.IDContainer;
import com.mayastudios.ixml.document.comp.impl.TitledPanel;
import com.mayastudios.ixml.document.parser.IXMLParser;
import java.awt.BorderLayout;
import java.awt.Component;
import java.io.InputStream;
import javax.swing.JDialog;
import javax.swing.JFrame;

public class IXMLDialog
extends JDialog
implements IDContainer.IIDContainer {
    private final IXMLPanel mf_oContentPanel;
    protected final TitledPanel.TitleArea mf_oTitleArea;

    public IXMLDialog(InputStream p_oIXMLStream, DocumentCompFactory p_oComponentFactory, JFrame p_oOwner, boolean p_bIsModal) throws IXMLError, IXMLException {
        this(IXMLParser.parseIXML(p_oIXMLStream), p_oComponentFactory, p_oOwner, p_bIsModal);
    }

    public IXMLDialog(IXMLDocument p_oIXMLDocument, DocumentCompFactory p_oComponentFactory, JFrame p_oOwner, boolean p_bIsModal) throws IXMLError, IXMLException {
        super(p_oOwner, p_oIXMLDocument.getAttributeAsString(EIXMLAttrib.TITLE), p_bIsModal);
        this.getContentPane().setLayout(new BorderLayout());
        IXMLPanel oPanel = p_oIXMLDocument.createPanel(p_oComponentFactory);
        if (oPanel instanceof TitledPanel) {
            TitledPanel oTitledPanel = (TitledPanel)oPanel;
            this.mf_oTitleArea = oTitledPanel.getTitleArea();
            this.mf_oContentPanel = oTitledPanel.getContentPanel();
        } else {
            this.mf_oTitleArea = null;
            this.mf_oContentPanel = oPanel;
        }
        this.getContentPane().add((Component)oPanel, "Center");
    }

    public Component getComponentByID(String p_strID) {
        return this.mf_oContentPanel.getComponentByID(p_strID);
    }

    public Component getComponentByID(String p_strID, boolean p_bCanReturnComponentContainer) {
        return this.mf_oContentPanel.getComponentByID(p_strID, p_bCanReturnComponentContainer);
    }
}

