/*
 * Decompiled with CFR 0.152.
 */
package com.mayastudios.ixml.document.comp;

import com.mayastudios.ixml.common.IXMLError;
import com.mayastudios.ixml.common.SystemInfo;
import com.mayastudios.ixml.labels.LabelsCore;
import java.awt.Toolkit;
import java.net.URL;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.AbstractButton;
import javax.swing.KeyStroke;

public class AttributeParser {
    public static final char LOAD_LABEL_INDICATOR = '^';
    private static final Pattern SEARCH_PATTERN = Pattern.compile("(\\^[^\\^]*\\^)|(\\^[^\\^]*)$");
    private static final int APP_KEY = Toolkit.getDefaultToolkit().getMenuShortcutKeyMask();
    private static final String APP_FILE_NEW_NAME = "APP_FILE_NEW";
    private static final String APP_FILE_OPEN_NAME = "APP_FILE_OPEN";
    private static final String APP_FILE_SAVE_NAME = "APP_FILE_SAVE";
    private static final String APP_FILE_SAVEAS_NAME = "APP_FILE_SAVEAS";
    private static final String APP_PRINT_NAME = "APP_PRINT";
    private static final String APP_QUIT_NAME = "APP_QUIT";
    private static final String APP_HELP_NAME = "APP_HELP";

    public static String parseLabel(String p_strLabel) {
        if (p_strLabel == null) {
            return "";
        }
        if (p_strLabel.length() <= 1 || p_strLabel.charAt(0) != '^') {
            return p_strLabel;
        }
        StringBuilder oLabel = new StringBuilder(128);
        int iOrigIndex = 0;
        Matcher oMatcher = SEARCH_PATTERN.matcher(p_strLabel);
        while (oMatcher.find()) {
            int iStart = oMatcher.start();
            int iEnd = oMatcher.end();
            oLabel.append(p_strLabel, iOrigIndex, iStart);
            if (iStart + 2 == iEnd) {
                oLabel.append('^');
            } else if (p_strLabel.charAt(iEnd - 1) == '^') {
                oLabel.append(LabelsCore.get((String)p_strLabel.substring(iStart + 1, iEnd - 1), (Object[])new Object[0]));
            } else {
                oLabel.append(LabelsCore.get((String)p_strLabel.substring(iStart + 1, iEnd), (Object[])new Object[0]));
            }
            iOrigIndex = iEnd;
        }
        oLabel.append(p_strLabel.substring(iOrigIndex));
        return oLabel.toString();
    }

    public static URL parseResourceURL(String p_strURL) throws IXMLError {
        if (p_strURL == null) {
            return null;
        }
        String[] astrParts = p_strURL.split(":", 2);
        if (astrParts.length != 2) {
            throw new IXMLError("The resource URL \"%s\" is invalid.", new Object[]{p_strURL});
        }
        try {
            Class<?> oBaseClass = Class.forName(astrParts[0]);
            URL oResourceURL = oBaseClass.getResource(astrParts[1]);
            if (oResourceURL == null) {
                throw new IXMLError("The resource specified by the URL \"%s\" could not be found.", new Object[]{p_strURL});
            }
            return oResourceURL;
        }
        catch (ClassNotFoundException oException) {
            throw new IXMLError("The class \"%s\" in the resource URL \"%s\" could not be found.", new Object[]{astrParts[0], p_strURL});
        }
    }

    public static KeyStroke parseAccelerator(String p_strAccelerator) throws InvalidAcceleratorException {
        if (p_strAccelerator == null) {
            return null;
        }
        if (APP_FILE_NEW_NAME.equals(p_strAccelerator)) {
            return KeyStroke.getKeyStroke(78, APP_KEY);
        }
        if (APP_FILE_OPEN_NAME.equals(p_strAccelerator)) {
            return KeyStroke.getKeyStroke(79, APP_KEY);
        }
        if (APP_FILE_SAVE_NAME.equals(p_strAccelerator)) {
            return KeyStroke.getKeyStroke(83, APP_KEY);
        }
        if (APP_FILE_SAVEAS_NAME.equals(p_strAccelerator)) {
            return KeyStroke.getKeyStroke(83, APP_KEY | 1);
        }
        if (APP_PRINT_NAME.equals(p_strAccelerator)) {
            return KeyStroke.getKeyStroke(80, APP_KEY);
        }
        if (APP_QUIT_NAME.equals(p_strAccelerator)) {
            switch (SystemInfo.OSTYPE) {
                case Windows: {
                    return KeyStroke.getKeyStroke(115, 8);
                }
                case Linux: 
                case MacOS: {
                    return KeyStroke.getKeyStroke(87, APP_KEY);
                }
            }
            return null;
        }
        if (APP_HELP_NAME.equals(p_strAccelerator)) {
            switch (SystemInfo.OSTYPE) {
                case Windows: 
                case Linux: {
                    return KeyStroke.getKeyStroke(112, 0);
                }
                case MacOS: {
                    return KeyStroke.getKeyStroke(63, APP_KEY);
                }
            }
            return null;
        }
        String[] astrParts = p_strAccelerator.split("\\+");
        if (astrParts.length < 1) {
            throw new InvalidAcceleratorException(p_strAccelerator);
        }
        int iKeyCode = 0;
        int iModifiers = 0;
        for (int x = 0; x < astrParts.length - 1; ++x) {
            if ("APP".equals(astrParts[x])) {
                iModifiers |= APP_KEY;
                continue;
            }
            if ("SHIFT".equals(astrParts[x])) {
                iModifiers |= 1;
                continue;
            }
            if (!"ALT".equals(astrParts[x])) continue;
            iModifiers |= 8;
        }
        if (astrParts[astrParts.length - 1].length() == 1) {
            char chChar = astrParts[astrParts.length - 1].charAt(0);
            iKeyCode = chChar;
        } else {
            String strKey = astrParts[astrParts.length - 1];
            if ("ENTER".equals(strKey)) {
                iKeyCode = 10;
            } else if ("TAB".equals(strKey)) {
                iKeyCode = 9;
            } else if ("SPACE".equals(strKey)) {
                iKeyCode = 32;
            } else if ("F1".equals(strKey)) {
                iKeyCode = 112;
            } else if ("F2".equals(strKey)) {
                iKeyCode = 113;
            } else if ("F3".equals(strKey)) {
                iKeyCode = 114;
            } else if ("F4".equals(strKey)) {
                iKeyCode = 115;
            } else if ("F5".equals(strKey)) {
                iKeyCode = 116;
            } else if ("F6".equals(strKey)) {
                iKeyCode = 117;
            } else if ("F7".equals(strKey)) {
                iKeyCode = 118;
            } else if ("F8".equals(strKey)) {
                iKeyCode = 119;
            } else if ("F9".equals(strKey)) {
                iKeyCode = 120;
            } else if ("F10".equals(strKey)) {
                iKeyCode = 121;
            } else if ("F11".equals(strKey)) {
                iKeyCode = 122;
            } else if ("F12".equals(strKey)) {
                iKeyCode = 123;
            } else {
                throw new InvalidAcceleratorException(p_strAccelerator);
            }
        }
        return KeyStroke.getKeyStroke(iKeyCode, iModifiers);
    }

    public static class MnemonicCaption {
        public static final int UNDEFINED_KEYCODE = 0;
        public final String mf_strConvertedCaption;
        public final int mf_iMnemonicKeyCode;
        public final int mf_iMnemonicIndex;

        public MnemonicCaption(String p_strCaption) {
            if (p_strCaption == null || p_strCaption.length() == 0) {
                this.mf_strConvertedCaption = "";
                this.mf_iMnemonicIndex = -1;
                this.mf_iMnemonicKeyCode = 0;
                return;
            }
            StringBuilder oNewString = new StringBuilder(p_strCaption);
            int iIndex = 0;
            int iOffset = 0;
            int iMnIndex = -1;
            while ((iIndex = p_strCaption.indexOf(35, iIndex)) != -1) {
                oNewString.deleteCharAt(iIndex - iOffset);
                ++iOffset;
                if (iIndex + 1 == p_strCaption.length()) break;
                if (p_strCaption.charAt(iIndex + 1) != '#') {
                    iMnIndex = iIndex + 1 - iOffset;
                    break;
                }
                iIndex += 2;
            }
            this.mf_strConvertedCaption = oNewString.toString();
            if (iMnIndex == -1) {
                this.mf_iMnemonicKeyCode = 0;
                this.mf_iMnemonicIndex = -1;
            } else {
                char chKey = Character.toUpperCase(this.mf_strConvertedCaption.charAt(iMnIndex));
                KeyStroke oStroke = KeyStroke.getKeyStroke(Character.toString(chKey));
                if (oStroke != null) {
                    this.mf_iMnemonicKeyCode = oStroke.getKeyCode();
                    this.mf_iMnemonicIndex = iMnIndex;
                } else {
                    this.mf_iMnemonicKeyCode = 0;
                    this.mf_iMnemonicIndex = -1;
                }
            }
        }

        public void applyTo(AbstractButton p_oButton) {
            p_oButton.setText(this.mf_strConvertedCaption);
            p_oButton.setMnemonic(this.mf_iMnemonicKeyCode);
            p_oButton.setDisplayedMnemonicIndex(this.mf_iMnemonicIndex);
        }
    }

    public static class InvalidAcceleratorException
    extends Exception {
        public InvalidAcceleratorException(String p_strAcceleratorString) {
            super(p_strAcceleratorString);
        }
    }
}

