/*
 * Decompiled with CFR 0.152.
 */
package com.mayastudios.ixml.document.comp;

import com.mayastudios.ixml.common.IXMLError;
import com.mayastudios.ixml.document.comp.base.EIXMLAttrib;
import com.mayastudios.ixml.document.comp.base.EIXMLType;
import com.mayastudios.ixml.document.comp.base.IXMLBaseElement;
import com.mayastudios.ixml.document.parser.IXMLTagHandler;
import javax.swing.JComboBox;
import org.xml.sax.Attributes;

public class IXMLComboBoxNode
extends IXMLBaseElement {
    private final IXMLBaseElement.NodeCompFactory<JComboBox> mf_oNodeFactory = new IXMLBaseElement.NodeCompFactory<JComboBox>(this, JComboBox.class, "createComboxBox");

    public IXMLComboBoxNode(String p_strID) {
        super(EIXMLType.COMBOBOX, p_strID, true);
    }

    protected JComboBox createComponentImpl(IXMLBaseElement.InfoStack p_oParentComponent, IXMLBaseElement.CreateInfo p_oCreateInfo) throws IXMLError {
        String[] astrItems;
        if (this.getChildElements().size() == 0) {
            astrItems = null;
        } else {
            int iIndex = 0;
            astrItems = new String[this.getChildElements().size()];
            for (IXMLBaseElement oElement : this.getChildElements()) {
                String strValue = oElement.getAttributeAsString(EIXMLAttrib.VALUE);
                astrItems[iIndex] = strValue != null ? strValue : "";
                ++iIndex;
            }
        }
        JComboBox oComboBox = this.mf_oNodeFactory.create(p_oCreateInfo, new Object[]{astrItems});
        oComboBox.setEditable(this.getAttributeAsBoolean(EIXMLAttrib.EDITABLE, false));
        return oComboBox;
    }

    protected boolean allowToAddChildElement(IXMLBaseElement p_oNewChildElement) {
        return p_oNewChildElement.getType() == EIXMLType.ITEM;
    }

    public static void registerTags() {
        IXMLTagHandler.registerTag(new IXMLTagHandler("combobox"){

            public IXMLBaseElement create(Attributes p_oAttributes) {
                return new IXMLComboBoxNode(p_oAttributes.getValue("id"));
            }
        });
    }
}

