/*
 * Decompiled with CFR 0.152.
 */
package com.mayastudios.ixml.document.comp.base;

import com.mayastudios.ixml.document.comp.base.IXMLBaseElement;
import com.mayastudios.ixml.misc.NullLayoutPanel;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Rectangle;
import javax.swing.JComponent;

public class IXMLComponentContainer
extends NullLayoutPanel {
    protected final JComponent mf_oComponent;
    private final Dimension mf_oMaxSize = new Dimension(Short.MAX_VALUE, Short.MAX_VALUE);
    private EAlign m_eHAlign = EAlign.START;
    private EAlign m_eVAlign = EAlign.CENTER;

    public IXMLComponentContainer(JComponent p_oComponent) {
        this.setOpaque(false);
        this.mf_oComponent = p_oComponent;
        this.add(p_oComponent);
    }

    public void setHorzAlign(EAlign p_eAlignment) {
        this.m_eHAlign = p_eAlignment;
    }

    public void setVertAlign(EAlign p_eAlignment) {
        this.m_eVAlign = p_eAlignment;
    }

    public JComponent getComponent() {
        return this.mf_oComponent;
    }

    public void setMaximumSize(Integer p_oMaxWidth, Integer p_oMaxHeight) {
        this.mf_oMaxSize.width = p_oMaxWidth != null ? p_oMaxWidth : Short.MAX_VALUE;
        this.mf_oMaxSize.height = p_oMaxHeight != null ? p_oMaxHeight : Short.MAX_VALUE;
    }

    public Dimension getMinimumSize() {
        return this.mf_oComponent.getMinimumSize();
    }

    public Dimension getPreferredSize() {
        Dimension oSize = this.mf_oComponent.getPreferredSize();
        if (oSize.width > this.mf_oMaxSize.width) {
            oSize.width = this.mf_oMaxSize.width;
        }
        if (oSize.height > this.mf_oMaxSize.height) {
            oSize.height = this.mf_oMaxSize.height;
        }
        return oSize;
    }

    public Dimension getMaximumSize() {
        return new Dimension(Short.MAX_VALUE, Short.MAX_VALUE);
    }

    protected void paintComponent(Graphics p_oDC) {
        super.paintComponent(p_oDC);
        if (IXMLBaseElement.s_oDebugFrameColor != null) {
            Dimension oSize = this.getSize();
            p_oDC.setColor(IXMLBaseElement.s_oDebugFrameColor);
            p_oDC.drawRect(0, 0, oSize.width - 1, oSize.height - 1);
        }
    }

    protected void sizeChanged(int p_iWidth, int p_iHeight) {
        Dimension oContainerSize = this.getSize();
        Dimension oComponentSize = this.mf_oComponent.getPreferredSize();
        Rectangle oBounds = new Rectangle();
        if (this.m_eHAlign == EAlign.STRETCH || oContainerSize.width <= oComponentSize.width) {
            oBounds.x = 0;
            oBounds.width = oContainerSize.width;
        } else {
            boolean bIsLTROrientation = this.mf_oComponent.getComponentOrientation().isLeftToRight();
            oBounds.width = oComponentSize.width;
            switch (this.m_eHAlign) {
                case START: {
                    oBounds.x = bIsLTROrientation ? 0 : oContainerSize.width - oBounds.width;
                    break;
                }
                case CENTER: {
                    oBounds.x = (oContainerSize.width - oBounds.width) / 2;
                    break;
                }
                case END: {
                    int n = oBounds.x = bIsLTROrientation ? oContainerSize.width - oBounds.width : 0;
                }
            }
        }
        if (this.m_eVAlign == EAlign.STRETCH || oContainerSize.height <= oComponentSize.height) {
            oBounds.y = 0;
            oBounds.height = oContainerSize.height;
        } else {
            oBounds.height = oComponentSize.height;
            switch (this.m_eVAlign) {
                case START: {
                    oBounds.y = 0;
                    break;
                }
                case CENTER: {
                    oBounds.y = (oContainerSize.height - oBounds.height) / 2;
                    break;
                }
                case END: {
                    oBounds.y = oContainerSize.height - oBounds.height;
                }
            }
        }
        if (IXMLBaseElement.s_oDebugFrameColor != null) {
            if (oBounds.x == 0) {
                ++oBounds.x;
                --oBounds.width;
            } else {
                --oBounds.x;
            }
            if (oBounds.x + oBounds.width >= oContainerSize.width) {
                --oBounds.width;
            }
            if (oBounds.y == 0) {
                ++oBounds.y;
                --oBounds.height;
            } else {
                --oBounds.y;
            }
            if (oBounds.y + oBounds.height >= oContainerSize.height) {
                --oBounds.height;
            }
        }
        this.mf_oComponent.setBounds(oBounds);
        this.mf_oComponent.validate();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum EAlign {
        START,
        CENTER,
        END,
        STRETCH;

    }
}

