/*
 * Decompiled with CFR 0.152.
 */
package com.mayastudios.mscl;

import java.applet.Applet;
import java.applet.AudioClip;
import java.awt.Graphics2D;
import java.awt.Toolkit;
import java.awt.image.BufferedImage;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.nio.charset.Charset;
import javax.swing.ImageIcon;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ResourceLoader {
    private ResourceLoader() {
    }

    private static void checkPath(Object object, String string) {
        if (string == null) {
            throw new IllegalArgumentException(String.format("The given path (source class: %s) must not be null!", ResourceLoader.getClassFromSource(object).getName()));
        }
        int n = string.indexOf("..");
        if (n != -1 && (string.startsWith("../", n) || string.startsWith("..\\", n))) {
            throw new IllegalArgumentException(String.format("The resource path \"%s\" (source class: %s) must not contain \"../\" or \"..\\\"!", string, ResourceLoader.getClassFromSource(object).getName()));
        }
        if (new File(string).isAbsolute()) {
            throw new IllegalArgumentException(String.format("The resource path \"%s\" (source class: %s) must not be absolute.", string, ResourceLoader.getClassFromSource(object).getName()));
        }
    }

    private static Class<?> getClassFromSource(Object object) {
        if (object == null) {
            throw new IllegalArgumentException("The given source must not be null!");
        }
        if (object instanceof Class) {
            return (Class)object;
        }
        return object.getClass();
    }

    public static InputStream getResourceStreamExcpt(Object object, String string) throws ResourceLoadException {
        ResourceLoader.checkPath(object, string);
        InputStream inputStream = ResourceLoader.getClassFromSource(object).getResourceAsStream(string);
        if (inputStream == null) {
            throw new ResourceLoadException(object, string, InputStream.class);
        }
        return inputStream;
    }

    public static InputStream getResourceStream(Object object, String string) {
        try {
            return ResourceLoader.getResourceStreamExcpt(object, string);
        }
        catch (ResourceLoadException resourceLoadException) {
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String convertToString(InputStream inputStream, String string, boolean bl) throws IOException {
        if (string == null) {
            string = "UTF-8";
        }
        InputStreamReader inputStreamReader = new InputStreamReader(inputStream, Charset.forName(string));
        BufferedReader bufferedReader = new BufferedReader(inputStreamReader);
        StringBuilder stringBuilder = new StringBuilder(4096);
        char[] cArray = new char[4096];
        try {
            int n = 0;
            while ((n = bufferedReader.read(cArray)) != -1) {
                stringBuilder.append(cArray, 0, n);
            }
        }
        finally {
            if (bl) {
                inputStream.close();
            }
        }
        return stringBuilder.toString();
    }

    public static URL getResourceUrlExcpt(Object object, String string) throws ResourceLoadException {
        ResourceLoader.checkPath(object, string);
        URL uRL = ResourceLoader.getClassFromSource(object).getResource(string);
        if (uRL == null) {
            throw new ResourceLoadException(object, string, URL.class);
        }
        return uRL;
    }

    public static URL getResourceUrl(Object object, String string) {
        try {
            return ResourceLoader.getResourceUrlExcpt(object, string);
        }
        catch (ResourceLoadException resourceLoadException) {
            return null;
        }
    }

    public static ImageIcon getIconExcpt(Object object, String string) throws ResourceLoadException {
        ImageIcon imageIcon = new ImageIcon(ResourceLoader.getResourceUrlExcpt(object, string));
        if (!ResourceLoader.preloadImage(imageIcon)) {
            throw new ResourceLoadException(object, string, ImageIcon.class, "Preloading failed!");
        }
        return imageIcon;
    }

    public static ImageIcon getIcon(Object object, String string) {
        try {
            return ResourceLoader.getIconExcpt(object, string);
        }
        catch (ResourceLoadException resourceLoadException) {
            return null;
        }
    }

    public static boolean preloadImage(ImageIcon imageIcon) {
        int n;
        Toolkit.getDefaultToolkit().prepareImage(imageIcon.getImage(), -1, -1, null);
        while (((n = Toolkit.getDefaultToolkit().checkImage(imageIcon.getImage(), -1, -1, null)) & 0x10) == 0 && (n & 0x20) == 0) {
            if ((n & 0x40) != 0 || (n & 0x80) != 0) {
                return false;
            }
            try {
                Thread.sleep(50L);
            }
            catch (InterruptedException interruptedException) {}
        }
        return true;
    }

    public static BufferedImage getBufferedImageExcpt(Object object, String string) throws ResourceLoadException {
        BufferedImage bufferedImage = ResourceLoader.convertIconToBufferedImage(ResourceLoader.getIconExcpt(object, string));
        if (bufferedImage == null) {
            throw new ResourceLoadException(object, string, BufferedImage.class, "Converting from ImageIcon failed!");
        }
        return bufferedImage;
    }

    public static BufferedImage getBufferedImage(Object object, String string) {
        try {
            return ResourceLoader.getBufferedImageExcpt(object, string);
        }
        catch (ResourceLoadException resourceLoadException) {
            return null;
        }
    }

    public static BufferedImage convertIconToBufferedImage(ImageIcon imageIcon) {
        if (!ResourceLoader.preloadImage(imageIcon)) {
            return null;
        }
        BufferedImage bufferedImage = new BufferedImage(imageIcon.getIconWidth(), imageIcon.getIconHeight(), 1);
        Graphics2D graphics2D = bufferedImage.createGraphics();
        imageIcon.paintIcon(null, graphics2D, 0, 0);
        graphics2D.dispose();
        return bufferedImage;
    }

    public static AudioClip getAudioClipExcpt(Object object, String string) throws ResourceLoadException {
        AudioClip audioClip = Applet.newAudioClip(ResourceLoader.getResourceUrlExcpt(object, string));
        if (audioClip == null) {
            throw new ResourceLoadException(object, string, AudioClip.class);
        }
        return audioClip;
    }

    public static AudioClip getAudioClip(Object object, String string) {
        try {
            return ResourceLoader.getAudioClipExcpt(object, string);
        }
        catch (ResourceLoadException resourceLoadException) {
            return null;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ResourceLoadException
    extends Exception {
        public ResourceLoadException(Object object, String string, Class<?> clazz) {
            this(object, string, clazz, null);
        }

        public ResourceLoadException(Object object, String string, Class<?> clazz, String string2) {
            super(String.format("Could not load resource:\n  Type: %s\n  Path: [%s]%s%s", clazz.getName(), ResourceLoader.getClassFromSource(object).getName(), string, string2 != null ? String.format("\n  Reason: %s", string2) : ""));
        }
    }
}

