/*
 * Decompiled with CFR 0.152.
 */
package com.mayastudios.mscl.mwt;

import com.mayastudios.mscl.MSCLResLoader;
import com.mayastudios.mscl.ResourceLoader;
import com.mayastudios.mscl.mwt.GUIHelper;
import com.mayastudios.mscl.mwt.MessageBox;
import com.mayastudios.mscl.mwt.tablelayout.CCellProps;
import com.mayastudios.mscl.mwt.tablelayout.CTableLayout;
import com.mayastudios.mscl.mwt.widgets.ModalFrame;
import com.mayastudios.mscl.mwt.windowcloser.CWindowCloser;
import com.mayastudios.systeminfo.JavaInfo;
import com.mayastudios.systeminfo.SystemInfo;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Image;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;

public class ExceptionDlg {
    public static final int EXIT_CODE_ON_ERROR = 1;
    private static final String CLOSE_BUTTON_TEXT = "Close";
    private static final String COPY_CLIPBOARD_TEXT = "Copy to clipboard";
    private static final String UNHANDLED_TITLE = "Unexpected Error";
    private static final String UNHANDLED_HEADER_TEXT = "<html>During the executing of this application an unexpected error has ocurred.<br><br><b>The application will be closed.</b>";
    private static final ImageIcon EXCEPTION_ICON;
    private static IReportABugListener reportABugListener;
    private static IMainWindowManager mainWindowManager;
    private final Window m_exceptionDlg;

    public ExceptionDlg(String string, String string2, Throwable throwable, Image image) {
        this.m_exceptionDlg = ExceptionDlg.createDialog(null, string2, image);
        this._initDialog(string, string2, throwable);
    }

    public ExceptionDlg(Frame frame, String string, String string2, Throwable throwable) {
        this.m_exceptionDlg = ExceptionDlg.createDialog(frame, string2, null);
        this._initDialog(string, string2, throwable);
    }

    public ExceptionDlg(Dialog dialog, String string, String string2, Throwable throwable) {
        this.m_exceptionDlg = ExceptionDlg.createDialog(dialog, string2, null);
        this._initDialog(string, string2, throwable);
    }

    private ExceptionDlg(IMainWindowManager iMainWindowManager, String string, String string2, Throwable throwable) {
        Window window = null;
        String string3 = string2;
        Image image = null;
        try {
            window = iMainWindowManager.getMainWindow();
            string3 = iMainWindowManager.getMainWindowTitle();
            image = iMainWindowManager.getMainWindowIcon();
        }
        catch (Throwable throwable2) {
            // empty catch block
        }
        this.m_exceptionDlg = ExceptionDlg.createDialog(window, string3, image);
        this._initDialog(string, string2, throwable);
    }

    private static Window createDialog(Window window, String string, Image image) {
        if (window == null) {
            return new ModalFrame(string, image);
        }
        if (window instanceof Dialog) {
            return new JDialog((Dialog)window, true);
        }
        if (window instanceof Frame) {
            return new JDialog((Frame)window, true);
        }
        throw new IllegalStateException();
    }

    private Container getContentPane() {
        if (this.m_exceptionDlg instanceof JDialog) {
            return ((JDialog)this.m_exceptionDlg).getContentPane();
        }
        if (this.m_exceptionDlg instanceof JFrame) {
            return ((JFrame)this.m_exceptionDlg).getContentPane();
        }
        throw new IllegalStateException();
    }

    private void _initDialog(String string, String string2, final Throwable throwable) {
        String string3 = ExceptionDlg.formatExceptionMessage(throwable);
        JLabel jLabel = new JLabel(string, EXCEPTION_ICON, 2);
        jLabel.setIconTextGap(15);
        JTextArea jTextArea = new JTextArea();
        jTextArea.setEditable(false);
        jTextArea.setFont(new Font("Monospaced", 0, 11));
        jTextArea.setText(string3);
        jTextArea.setCaretPosition(0);
        JScrollPane jScrollPane = new JScrollPane(jTextArea, 20, 30);
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.add((Component)jScrollPane, "Center");
        jPanel.setBorder(BorderFactory.createTitledBorder("Exception Details"));
        JButton jButton = new JButton(CLOSE_BUTTON_TEXT);
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                CWindowCloser.closeWindow(ExceptionDlg.this.m_exceptionDlg);
            }
        });
        JButton jButton2 = new JButton(COPY_CLIPBOARD_TEXT);
        jButton2.addActionListener(new CClipboardButtonListener(string3));
        JButton jButton3 = null;
        if (reportABugListener != null) {
            jButton3 = new JButton("Report this bug");
            jButton3.setToolTipText(reportABugListener.getButtonTooltipText());
            jButton3.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    try {
                        reportABugListener.onReportABug(throwable);
                    }
                    catch (Throwable throwable2) {
                        throwable2.printStackTrace();
                        JOptionPane.showMessageDialog(ExceptionDlg.this.m_exceptionDlg, "This error could not be reported.", "Error", 0);
                    }
                }
            });
        }
        Container container = this.getContentPane();
        CTableLayout cTableLayout = CTableLayout.initLayout(container, 10, 10, 10, 10);
        cTableLayout.addRow.AutoHeightRow();
        cTableLayout.mf_oProps.maximizeBothAlignments();
        cTableLayout.addCell.AutoGlueCell(jLabel);
        cTableLayout.addRow.AutoGlueRow();
        cTableLayout.mf_oProps.maximizeBothAlignments();
        cTableLayout.mf_oProps.setMargin(0, 15, 0, 20);
        cTableLayout.addCell.AutoGlueCell(jPanel);
        cTableLayout.addRow.AutoHeightRow();
        cTableLayout.mf_oProps.setMargin(0, 0, 0, 0);
        cTableLayout.addCell.AutoWidthCell(jButton2);
        if (jButton3 != null) {
            cTableLayout.addCell.AutoWidthCell(jButton3);
        }
        cTableLayout.mf_oProps.setAlignment(CCellProps.AX.right, CCellProps.AY.maximized);
        cTableLayout.addCell.AutoGlueCell(jButton);
        GUIHelper.initWindow(this.m_exceptionDlg, string2, 640, 440, true, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void showDefaultUnhandledExceptionDlg(Throwable throwable) {
        String string = null;
        try {
            System.out.flush();
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            string = ExceptionDlg.formatExceptionMessage(throwable);
            System.err.println(string);
            System.err.flush();
            if (mainWindowManager != null) {
                new ExceptionDlg(mainWindowManager, UNHANDLED_HEADER_TEXT, UNHANDLED_TITLE, throwable);
            } else {
                new ExceptionDlg(UNHANDLED_HEADER_TEXT, UNHANDLED_TITLE, throwable, null);
            }
        }
        catch (Throwable throwable2) {
            File file = new File(System.getProperty("user.home"), "error.txt");
            throwable2.printStackTrace();
            try {
                FileWriter fileWriter = new FileWriter(file);
                if (string != null) {
                    fileWriter.write(string);
                    fileWriter.write("\n\n");
                }
                fileWriter.write(ExceptionDlg.stackTraceToString(throwable2));
                fileWriter.close();
                JOptionPane.showMessageDialog(null, "An unexpected error has occured but it could not be displayed due to another error. Both errors\nhave been written to the following file:\n\n" + file.getAbsolutePath() + "\n\n" + "Please inform the developer of this application about this error.", "Error", 0);
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
                JOptionPane.showMessageDialog(null, "An unexpected error has occured but it could not be displayed due to another error.", "Error", 0);
            }
        }
        finally {
            System.exit(1);
        }
    }

    public static void setReportABugListener(IReportABugListener iReportABugListener) {
        reportABugListener = iReportABugListener;
    }

    public static void setMainWindowManager(IMainWindowManager iMainWindowManager) {
        mainWindowManager = iMainWindowManager;
    }

    public static String stackTraceToString(Throwable throwable) {
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stringWriter);
        throwable.printStackTrace(printWriter);
        return stringWriter.toString().replace("\t", "  ");
    }

    public static String formatExceptionMessage(Throwable throwable) {
        String string = "";
        if (throwable instanceof ExceptionInInitializerError) {
            if (throwable.getCause() != null) {
                throwable = throwable.getCause();
            }
            string = string + "Initialization exception (ExceptionInInitializerError)\n\n";
        }
        string = string + String.format("Message: %s\n\n%s", throwable.getMessage(), ExceptionDlg.stackTraceToString(throwable));
        string = string + "\n\nSystem Information:\n" + SystemInfo.INFO.toString() + "\n\n" + JavaInfo.getJavaInfo();
        return string;
    }

    static {
        try {
            EXCEPTION_ICON = MSCLResLoader.LOADER.getIconExcpt("mwt/exception.png");
        }
        catch (ResourceLoader.ResourceLoadException resourceLoadException) {
            throw new ExceptionInInitializerError(resourceLoadException);
        }
        reportABugListener = null;
        mainWindowManager = null;
    }

    public static interface IMainWindowManager {
        public Window getMainWindow();

        public String getMainWindowTitle();

        public Image getMainWindowIcon();
    }

    public static interface IReportABugListener {
        public void onReportABug(Throwable var1);

        public String getButtonTooltipText();
    }

    private class CClipboardButtonListener
    implements ActionListener {
        private String m_strText;

        public CClipboardButtonListener(String string) {
            this.m_strText = string;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            GUIHelper.copyToClipboard(this.m_strText);
            MessageBox.showInfoDlg(ExceptionDlg.this.m_exceptionDlg, "The exception has been copied to your clipboard.", "Information", MessageBox.EIcon.INFORMATION);
        }
    }
}

