/*
 * Decompiled with CFR 0.152.
 */
package com.mayastudios.mscl.mwt.mouse;

import com.mayastudios.mscl.mwt.mouse.IMouseMotionManagerListener;
import java.awt.Component;
import java.awt.Point;
import java.awt.event.MouseEvent;
import javax.swing.event.MouseInputAdapter;

public class CMouseMotionManager
extends MouseInputAdapter {
    public static final int LEFT_MOUSE_BUTTON = 1;
    public static final int MIDDLE_MOUSE_BUTTON = 2;
    public static final int RIGHT_MOUSE_BUTTON = 3;
    private IMouseMotionManagerListener m_oListener;
    private boolean[] m_abIsMouseButtonPressed = new boolean[]{false, false, false};
    private boolean[] m_abIsDragMouseButton = new boolean[]{true, true, true};
    private boolean m_bIsInDragMode = false;
    private Point m_oInitialDragPoint = null;
    private double m_dMinDragDistance;

    public CMouseMotionManager(Component component, IMouseMotionManagerListener iMouseMotionManagerListener) {
        this(component, iMouseMotionManagerListener, 3.0);
    }

    public CMouseMotionManager(Component component, IMouseMotionManagerListener iMouseMotionManagerListener, double d) {
        this.m_oListener = iMouseMotionManagerListener;
        this.m_dMinDragDistance = d;
        component.addMouseListener(this);
        component.addMouseMotionListener(this);
    }

    public void setDragMouseButtons(boolean bl, boolean bl2, boolean bl3) {
        this.m_abIsDragMouseButton[0] = bl;
        this.m_abIsDragMouseButton[1] = bl2;
        this.m_abIsDragMouseButton[2] = bl3;
    }

    public boolean isLeftButtonPressed() {
        return this.m_abIsMouseButtonPressed[0];
    }

    public boolean isMiddleButtonPressed() {
        return this.m_abIsMouseButtonPressed[1];
    }

    public boolean isRightButtonPressed() {
        return this.m_abIsMouseButtonPressed[2];
    }

    public final boolean isInDragMode() {
        return this.m_bIsInDragMode;
    }

    public void mousePressed(MouseEvent mouseEvent) {
        switch (mouseEvent.getButton()) {
            case 1: {
                this.m_abIsMouseButtonPressed[0] = true;
                break;
            }
            case 2: {
                this.m_abIsMouseButtonPressed[1] = true;
                break;
            }
            case 3: {
                this.m_abIsMouseButtonPressed[2] = true;
            }
        }
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        switch (mouseEvent.getButton()) {
            case 1: {
                this.m_abIsMouseButtonPressed[0] = false;
                break;
            }
            case 2: {
                this.m_abIsMouseButtonPressed[1] = false;
                break;
            }
            case 3: {
                this.m_abIsMouseButtonPressed[2] = false;
            }
        }
        if (this.m_oInitialDragPoint != null) {
            boolean bl = true;
            for (int i = 0; i < this.m_abIsDragMouseButton.length; ++i) {
                if (!this.m_abIsDragMouseButton[i] || !this.m_abIsMouseButtonPressed[i]) continue;
                bl = false;
                break;
            }
            if (bl) {
                this.m_oInitialDragPoint = null;
                if (this.m_bIsInDragMode) {
                    this.m_bIsInDragMode = false;
                    this.m_oListener.endDrag();
                }
            }
        }
    }

    public void mouseDragged(MouseEvent mouseEvent) {
        if (!this.m_bIsInDragMode) {
            for (int i = 0; i < this.m_abIsDragMouseButton.length; ++i) {
                if (!this.m_abIsDragMouseButton[i] || !this.m_abIsMouseButtonPressed[i]) continue;
                if (this.m_oInitialDragPoint == null) {
                    this.m_oInitialDragPoint = mouseEvent.getPoint();
                    continue;
                }
                if (!(this.m_oInitialDragPoint.distance(mouseEvent.getPoint()) > this.m_dMinDragDistance)) continue;
                this.m_bIsInDragMode = true;
                this.m_oListener.beginDrag(new Point(this.m_oInitialDragPoint));
            }
        }
        if (this.m_bIsInDragMode) {
            this.m_oListener.mouseDragged(mouseEvent);
        }
    }

    public void mouseMoved(MouseEvent mouseEvent) {
        this.m_oListener.mouseMoved(mouseEvent);
    }
}

