/*
 * Decompiled with CFR 0.152.
 */
package com.mayastudios.mscl.mwt.tablelayout;

import com.mayastudios.mscl.mwt.tablelayout.ABaseRow;
import com.mayastudios.mscl.mwt.tablelayout.APreLayoutElement;
import com.mayastudios.mscl.mwt.tablelayout.CCellProps;
import com.mayastudios.mscl.mwt.tablelayout.CTableLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Rectangle;

abstract class ABaseCell
extends APreLayoutElement
implements CTableLayout.ICell {
    private ABaseRow m_containingRow = null;
    private Component m_attachedElement = null;
    private CCellProps m_properties = null;

    ABaseCell(CCellProps cCellProps) {
        if (cCellProps == null) {
            throw new IllegalArgumentException("The cell properties must not be null!");
        }
        this.m_properties = cCellProps.clone();
    }

    abstract ECellType getType();

    final ABaseRow getContainingRow() {
        return this.m_containingRow;
    }

    final void setContainingRow(ABaseRow aBaseRow) {
        assert (this.m_containingRow == null) : "reusing of cells isn't allowed";
        this.m_containingRow = aBaseRow;
    }

    public final CCellProps.AX getXAlignment() {
        return this.m_properties.getXAlignment();
    }

    public final CCellProps.AY getYAlignment() {
        return this.m_properties.getYAlignment();
    }

    public final CCellProps getCellProperties() {
        return this.m_properties;
    }

    final void setAttachedElement(Component component) {
        this.m_attachedElement = component;
    }

    public final Component getAttachedElement() {
        return this.m_attachedElement;
    }

    final int preCalcBoundaries(int n, int n2) {
        return this.m_containingRow.preLayoutCellBoundaries(n, n2, this);
    }

    final int getMinimumCellWidth(int n, int n2, int n3) {
        Component component = this.getAttachedElement();
        if (component == null || !component.isVisible()) {
            return 0;
        }
        return this._getMinimumCellWidthInternal(n, n2, n3) + this.m_properties.getHorizontalMargin();
    }

    final int getMinimumCellHeight() {
        Component component = this.getAttachedElement();
        if (component == null || !component.isVisible()) {
            return 0;
        }
        return this._getMinimumCellHeightInternal() + this.m_properties.getVerticalMargin();
    }

    final int getPreferredCellWidth(int n, int n2, int n3) {
        Component component = this.getAttachedElement();
        if (component == null || !component.isVisible()) {
            return 0;
        }
        return this._getPreferredCellWidthInternal(n, n2, n3) + this.m_properties.getHorizontalMargin();
    }

    final int getPreferredCellHeight() {
        Component component = this.getAttachedElement();
        if (component == null || !component.isVisible()) {
            return 0;
        }
        return this._getPreferredCellHeightInternal() + this.m_properties.getVerticalMargin();
    }

    final int getMaximumCellWidth(int n, int n2, int n3) {
        if (this.getAttachedElement() == null) {
            return Integer.MAX_VALUE;
        }
        return this._getMaximumCellWidthInternal(n, n2, n3) + this.m_properties.getHorizontalMargin();
    }

    final int getMaximumCellHeight() {
        if (this.getAttachedElement() == null) {
            return this.m_properties.getVerticalMargin();
        }
        return this._getMaximumCellHeightInternal() + this.m_properties.getVerticalMargin();
    }

    int _getMinimumCellWidthInternal(int n, int n2, int n3) {
        if (this.m_properties.m_bPreservePreferredWidth) {
            return this.m_attachedElement.getPreferredSize().width;
        }
        return this.m_attachedElement.getMinimumSize().width;
    }

    int _getMinimumCellHeightInternal() {
        if (this.m_properties.m_bPreservePreferredHeight) {
            return this.m_attachedElement.getPreferredSize().height;
        }
        return this.m_attachedElement.getMinimumSize().height;
    }

    int _getPreferredCellWidthInternal(int n, int n2, int n3) {
        return this.m_attachedElement.getPreferredSize().width;
    }

    int _getPreferredCellHeightInternal() {
        return this.m_attachedElement.getPreferredSize().height;
    }

    int _getMaximumCellWidthInternal(int n, int n2, int n3) {
        return Integer.MAX_VALUE;
    }

    int _getMaximumCellHeightInternal() {
        return Integer.MAX_VALUE;
    }

    final void layoutElement(Rectangle rectangle) {
        if (!this.m_attachedElement.isVisible()) {
            return;
        }
        Dimension dimension = this.m_attachedElement.getPreferredSize();
        Rectangle rectangle2 = new Rectangle(rectangle);
        rectangle2.x += this.m_properties.mf_oMargin.left;
        rectangle2.y += this.m_properties.mf_oMargin.top;
        rectangle2.width -= this.m_properties.getHorizontalMargin();
        rectangle2.height -= this.m_properties.getVerticalMargin();
        if (this.getXAlignment() != CCellProps.AX.maximized && rectangle2.width > dimension.width) {
            switch (this.getXAlignment()) {
                case center: {
                    rectangle2.x += (rectangle2.width - dimension.width) / 2;
                    break;
                }
                case right: {
                    rectangle2.x += rectangle2.width - dimension.width;
                }
            }
            rectangle2.width = dimension.width;
        }
        if (this.getYAlignment() != CCellProps.AY.maximized && rectangle.height > dimension.height) {
            switch (this.getYAlignment()) {
                case center: {
                    rectangle2.y += (rectangle2.height - dimension.height) / 2;
                    break;
                }
                case bottom: {
                    rectangle2.y += rectangle2.height - dimension.height;
                }
            }
            rectangle2.height = dimension.height;
        }
        this.m_attachedElement.setBounds(rectangle2);
        this.m_attachedElement.validate();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum ECellType {
        AUTO_WIDTH_CELL,
        AUTO_GLUE_CELL,
        FIXED_WIDTH_CELL,
        BIND_CELL,
        AUTO_WIDTH_BIND_TARGET_CELL;

    }
}

