/*
 * Decompiled with CFR 0.152.
 */
package com.mayastudios.mscl.mwt.tablelayout;

import com.mayastudios.mscl.mwt.tablelayout.ABaseCell;
import com.mayastudios.mscl.mwt.tablelayout.CCellProps;
import com.mayastudios.mscl.mwt.tablelayout.CInternalCellAutoWidthBindTarget;

class CInternalCellBind
extends ABaseCell {
    private ABaseCell m_oBindTargetCell;
    private boolean m_bIgnoreMinimumWidth = false;

    public CInternalCellBind(ABaseCell aBaseCell, boolean bl, CCellProps cCellProps) {
        super(cCellProps);
        assert (aBaseCell != null) : "must bind to cell; null-cell isn't allowed";
        assert (aBaseCell.getContainingRow() != null) : "the target cell must be inserted already";
        this.m_oBindTargetCell = aBaseCell;
        this.m_bIgnoreMinimumWidth = bl;
        if (this.m_oBindTargetCell.getType() == ABaseCell.ECellType.AUTO_WIDTH_BIND_TARGET_CELL) {
            ((CInternalCellAutoWidthBindTarget)this.m_oBindTargetCell).addToBoundList(this);
        }
    }

    ABaseCell.ECellType getType() {
        return ABaseCell.ECellType.BIND_CELL;
    }

    int _getMinimumCellWidthInternal(int n, int n2, int n3) {
        if (this.getCellProperties().m_bPreservePreferredWidth) {
            return this.getAttachedElement().getPreferredSize().width;
        }
        if (!this.m_bIgnoreMinimumWidth) {
            return this.getAttachedElement().getMinimumSize().width;
        }
        return 0;
    }

    int _getPreferredCellWidthInternal(int n, int n2, int n3) {
        int n4;
        if (!this.m_oBindTargetCell.isPreLayouted()) {
            if (this.m_oBindTargetCell.getType() == ABaseCell.ECellType.AUTO_WIDTH_BIND_TARGET_CELL) {
                return this.getAttachedElement().getPreferredSize().width;
            }
            n4 = this.m_oBindTargetCell.preCalcBoundaries(n2, n3);
        } else {
            n4 = this.m_oBindTargetCell.getPreLayoutPosition() + this.m_oBindTargetCell.getPreLayoutSize();
            n4 -= this.getCellProperties().getHorizontalMargin();
        }
        int n5 = this.getAttachedElement().getMinimumSize().width;
        if ((n4 -= n) < n5) {
            return n5;
        }
        return n4;
    }

    int _getMaximumCellWidthInternal(int n, int n2, int n3) {
        return this._getPreferredCellWidthInternal(n, n2, n3);
    }

    final ABaseCell getBoundCell() {
        return this.m_oBindTargetCell;
    }
}

