/*
 * Decompiled with CFR 0.152.
 */
package com.mayastudios.mscl.mwt.widgets;

import java.awt.Image;
import java.awt.Rectangle;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.ImageIcon;
import javax.swing.JDialog;
import javax.swing.JFrame;

public class ModalFrame
extends JDialog {
    private final ModalFrameFaker m_frameFaker = (ModalFrameFaker)this.getParent();

    public ModalFrame(String string) {
        this(string, (Image)null);
    }

    public ModalFrame(String string, ImageIcon imageIcon) {
        this(string, imageIcon != null ? imageIcon.getImage() : (Image)null);
    }

    public ModalFrame(String string, Image image) {
        super(new ModalFrameFaker(string, image), string, true);
        this.m_frameFaker.completeInitialization(this);
    }

    public void setVisible(boolean bl) {
        if (!bl) {
            this.m_frameFaker.onHiding();
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        super.setVisible(bl);
    }

    public static class ModalFrameFaker
    extends JFrame {
        private JDialog m_childDialog = null;

        public ModalFrameFaker(String string, Image image) {
            super(string);
            if (image != null) {
                this.setIconImage(image);
            }
            this.setVisible(true);
        }

        public void completeInitialization(JDialog jDialog) {
            if (this.m_childDialog != null) {
                throw new IllegalStateException("Has already been initialized.");
            }
            if (jDialog.getOwner() != this) {
                throw new IllegalArgumentException("The given dialog is not a child window of this window.");
            }
            this.m_childDialog = jDialog;
            jDialog.addComponentListener(new ComponentListener(){

                public void componentMoved(ComponentEvent componentEvent) {
                    ModalFrameFaker.this.adaptPosition();
                }

                public void componentResized(ComponentEvent componentEvent) {
                    ModalFrameFaker.this.adaptPosition();
                }

                public void componentHidden(ComponentEvent componentEvent) {
                    ModalFrameFaker.this.setVisible(false);
                }

                public void componentShown(ComponentEvent componentEvent) {
                    ModalFrameFaker.this.setVisible(true);
                }
            });
            jDialog.addWindowListener(new WindowAdapter(){

                public void windowClosing(WindowEvent windowEvent) {
                    ModalFrameFaker.this.onHiding();
                    ModalFrameFaker.this.dispose();
                }
            });
        }

        public void onHiding() {
            this.setVisible(false);
        }

        private void adaptPosition() {
            Rectangle rectangle = this.m_childDialog.getBounds();
            rectangle.x += rectangle.width / 2;
            rectangle.y += rectangle.height / 2;
            rectangle.width = 10;
            rectangle.height = 10;
            this.setBounds(rectangle);
        }
    }
}

