/*
 * Decompiled with CFR 0.152.
 */
package com.mayastudios.mscl.mwt.widgets.button;

import com.mayastudios.ixml.common.BaseEventManager;
import com.mayastudios.mscl.grafics.CGrayFilter;
import com.mayastudios.mscl.mwt.GUIConstants;
import com.mayastudios.mscl.mwt.widgets.button.CButtonEvent;
import com.mayastudios.mscl.mwt.widgets.button.CFlatButtonBorder;
import com.mayastudios.mscl.mwt.widgets.button.IButtonListener;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class CFlatButton
extends JPanel
implements MouseListener {
    private static final Color BUTTON_BACKGROUND = GUIConstants.DEFAULT_PANEL_COLOR;
    private static final Color PRESSED_BUTTON_BACKGROUND = BUTTON_BACKGROUND.brighter();
    private JLabel m_oLabel = new JLabel();
    private CFlatButtonBorder m_oBorder = new CFlatButtonBorder();
    private boolean m_bIsToggleButton = false;
    private boolean m_bIsToggleButtonPressed = false;
    private boolean m_bUseAutoDisabledIcon = true;
    private boolean m_bIsMouseOver = false;
    private boolean m_bIsMouseButtonDown = false;
    private EventManager m_oEventManager = new EventManager();
    private Object m_oButtonAction;

    public CFlatButton(String string) {
        this(string, (Object)string);
    }

    public CFlatButton(String string, Object object) {
        this(string, null, object);
    }

    public CFlatButton(Icon icon) {
        this(icon, (Object)icon);
    }

    public CFlatButton(Icon icon, Object object) {
        this(null, icon, object);
    }

    public CFlatButton(String string, Icon icon) {
        this(string, icon, string);
    }

    public CFlatButton(String string, Icon icon, Object object) {
        this.setLayout(null);
        this.setBackground(BUTTON_BACKGROUND);
        this.add(this.m_oLabel);
        this.setBorder(this.m_oBorder);
        this.m_oButtonAction = object;
        this.addMouseListener(this);
        this.m_oLabel.addMouseListener(this);
        this.setText(string, false);
        this.setIcon(icon);
    }

    public void setText(String string, boolean bl) {
        this.m_oLabel.setText(string);
        if (bl) {
            this.m_oLabel.setHorizontalTextPosition(0);
            this.m_oLabel.setVerticalTextPosition(3);
        } else {
            this.m_oLabel.setHorizontalTextPosition(4);
            this.m_oLabel.setVerticalTextPosition(0);
        }
        this._setPreferredSize();
    }

    public String getText() {
        return this.m_oLabel.getText();
    }

    public void setIcon(Icon icon) {
        this.m_oLabel.setIcon(icon);
        if (this.m_bUseAutoDisabledIcon) {
            this.setDisabledIcon(null);
        }
        this._setPreferredSize();
    }

    public void setDisabledIcon(ImageIcon imageIcon) {
        if (imageIcon == null) {
            Icon icon = this.m_oLabel.getIcon();
            if (icon instanceof ImageIcon) {
                this.m_oLabel.setDisabledIcon(CGrayFilter.createDisabledIcon((ImageIcon)icon));
                this.m_bUseAutoDisabledIcon = true;
            } else {
                this.m_oLabel.setDisabledIcon(null);
            }
        } else {
            this.m_oLabel.setDisabledIcon(imageIcon);
            this.m_bUseAutoDisabledIcon = false;
        }
    }

    private void _setPreferredSize() {
        Dimension dimension = this.m_oLabel.getPreferredSize();
        this.m_oLabel.setSize(dimension);
        dimension.width += 6;
        dimension.height += 6;
        super.setMinimumSize(dimension);
        super.setPreferredSize(dimension);
        super.setMaximumSize(dimension);
        this._refreshVisibleState();
    }

    public void setToggleButton(boolean bl) {
        this.m_bIsToggleButton = bl;
    }

    public void activateToggleButton(boolean bl, boolean bl2) {
        this.m_bIsToggleButtonPressed = bl;
        this._refreshVisibleState();
        if (bl2) {
            this._fireToggleEvent();
        }
    }

    public boolean isToggleButtonActivated() {
        return this.m_bIsToggleButton && this.m_bIsToggleButtonPressed;
    }

    public void setEnabled(boolean bl) {
        this.m_oLabel.setEnabled(bl);
        super.setEnabled(bl);
        this._refreshVisibleState();
    }

    public void addButtonListener(IButtonListener iButtonListener, BaseEventManager.ERefType eRefType) {
        this.m_oEventManager.addListener(iButtonListener, eRefType);
    }

    public void removeButtonListener(IButtonListener iButtonListener) {
        this.m_oEventManager.removeListener(iButtonListener);
    }

    private void _fireToggleEvent() {
        this.m_oEventManager.fireEvent(new CButtonEvent(this, this.m_oButtonAction));
    }

    private void _refreshVisibleState() {
        Point point = new Point(3, 3);
        if (this.isEnabled() && (this.m_bIsToggleButton && this.m_bIsToggleButtonPressed || this.m_bIsMouseButtonDown && this.m_bIsMouseOver)) {
            this.m_oBorder.setState(CFlatButtonBorder.EState.LOWERED);
            this.setBackground(PRESSED_BUTTON_BACKGROUND);
            ++point.x;
            ++point.y;
        } else {
            if (this.m_bIsMouseOver && this.isEnabled()) {
                this.m_oBorder.setState(CFlatButtonBorder.EState.RAISED);
            } else {
                this.m_oBorder.setState(CFlatButtonBorder.EState.NORMAL);
            }
            this.setBackground(BUTTON_BACKGROUND);
        }
        this.m_oLabel.setLocation(point);
        this.repaint();
    }

    public void mousePressed(MouseEvent mouseEvent) {
        if (mouseEvent.getButton() != 1 || !this.isEnabled()) {
            return;
        }
        this.m_bIsMouseButtonDown = true;
        this._refreshVisibleState();
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        if (mouseEvent.getButton() != 1 || !this.m_bIsMouseButtonDown) {
            return;
        }
        this.m_bIsMouseButtonDown = false;
        if (this.m_bIsMouseOver && this.isEnabled()) {
            this.m_bIsToggleButtonPressed = !this.m_bIsToggleButtonPressed;
            this._refreshVisibleState();
            this._fireToggleEvent();
        } else {
            this._refreshVisibleState();
        }
    }

    public void mouseEntered(MouseEvent mouseEvent) {
        this.m_bIsMouseOver = true;
        if (this.isEnabled()) {
            this._refreshVisibleState();
        }
    }

    public void mouseExited(MouseEvent mouseEvent) {
        this.m_bIsMouseOver = false;
        if (this.isEnabled()) {
            this._refreshVisibleState();
        }
    }

    public void mouseClicked(MouseEvent mouseEvent) {
    }

    public void setToolTipText(String string) {
        this.m_oLabel.setToolTipText(string);
        super.setToolTipText(string);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class EventManager
    extends BaseEventManager<IButtonListener, CButtonEvent> {
        private EventManager() {
        }

        public void fireEvent(CButtonEvent cButtonEvent) {
            super.fireEvent((Object)cButtonEvent);
        }

        protected void notifyListener(IButtonListener iButtonListener, CButtonEvent cButtonEvent) {
            iButtonListener.buttonActionPerformed(cButtonEvent);
        }
    }
}

