/*
 * Decompiled with CFR 0.152.
 */
package com.mayastudios.ixml.labels;

import com.mayastudios.ixml.common.SimplifiedSAXParser;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.LinkedList;
import java.util.List;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LabelsLoader {
    private static final String SCHEMA_SOURCE_NAME = "labels.xsd";
    private static final SimplifiedSAXParser SAX_PARSER;

    private LabelsLoader() {
    }

    public static List<RawLabel> loadLabels(InputStream p_oXIMLDataStream) throws SAXException, IOException {
        LabelsHandler oHandler = new LabelsHandler();
        SAX_PARSER.parse(p_oXIMLDataStream, (DefaultHandler)((Object)oHandler));
        return oHandler.mf_oLabelsList;
    }

    static {
        URL oSchemaURL = LabelsLoader.class.getResource(SCHEMA_SOURCE_NAME);
        if (oSchemaURL == null) {
            throw new ExceptionInInitializerError("Could not find labels schema file.");
        }
        SAX_PARSER = new SimplifiedSAXParser(oSchemaURL);
    }

    private static class LabelsHandler
    extends SimplifiedSAXParser.SimplifiedDefaultHandler {
        private static final String ENTRY_TAG = "entry";
        private static final String KEY_ATTRIB = "key";
        private static final int DEFAULT_VALUE_LENGTH = 128;
        public final LinkedList<RawLabel> mf_oLabelsList = new LinkedList();
        private String m_strCurKey;
        private StringBuilder m_oCurValue;

        private LabelsHandler() {
        }

        public void startElement(String p_strTagName, Attributes p_oAttributes) throws SAXException {
            if (!ENTRY_TAG.equals(p_strTagName)) {
                return;
            }
            this.m_strCurKey = p_oAttributes.getValue(KEY_ATTRIB);
            if (this.m_strCurKey.length() == 0) {
                throw new SAXException("Empty key names are not allowed!");
            }
            this.m_oCurValue = new StringBuilder(128);
        }

        public void endElement(String p_strTagName) {
            if (!ENTRY_TAG.equals(p_strTagName)) {
                return;
            }
            String strContent = this.m_oCurValue.toString().replace("\\n", "\n");
            this.mf_oLabelsList.add(new RawLabel(this.m_strCurKey, strContent));
            this.m_oCurValue = null;
        }

        public void characters(char[] p_achText, int p_iStart, int p_iLength) {
            if (this.m_oCurValue == null) {
                return;
            }
            this.m_oCurValue.append(p_achText, p_iStart, p_iLength);
        }
    }

    public static class RawLabel {
        public final String mf_strName;
        public final String mf_strContent;

        public RawLabel(String p_strName, String p_strContent) {
            this.mf_strName = p_strName;
            this.mf_strContent = p_strContent;
        }
    }
}

