/*
 * Decompiled with CFR 0.152.
 */
package net.mayastudios.mscl.mwt.trayicon;

import java.awt.Frame;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import net.mayastudios.mscl.mwt.trayicon.ModalBlockChecker;
import net.mayastudios.mscl.mwt.trayicon.TrayIconAnimation;
import net.mayastudios.mscl.mwt.trayicon.TrayIconInfo;

public class TrayMinimizeHelper {
    private static CWindowListener s_oListener = new CWindowListener();

    public static void minimizeToTray(Frame p_oFrame) {
        if (!TrayIconInfo.isTrayIconAvailable()) {
            return;
        }
        if (ModalBlockChecker.isBlocked(p_oFrame)) {
            return;
        }
        if (TrayIconAnimation.minimizeAnimation(p_oFrame)) {
            return;
        }
        int iState = p_oFrame.getExtendedState();
        if ((iState & 1) != 0) {
            p_oFrame.setVisible(false);
        } else {
            p_oFrame.addWindowListener(s_oListener);
            p_oFrame.setExtendedState(iState | 1);
        }
    }

    public static void restoreFrame(Frame p_oFrame) {
        if (TrayIconAnimation.restoreAnimation(p_oFrame)) {
            return;
        }
        if (!p_oFrame.isVisible()) {
            p_oFrame.addComponentListener(s_oListener);
            p_oFrame.setVisible(true);
        } else {
            s_oListener.restoreWindow(p_oFrame);
        }
    }

    private static class CWindowListener
    extends WindowAdapter
    implements ComponentListener {
        private CWindowListener() {
        }

        public void windowIconified(WindowEvent p_oEvent) {
            Frame oFrame = (Frame)p_oEvent.getWindow();
            oFrame.removeWindowListener(this);
            oFrame.setVisible(false);
        }

        public void windowDeiconified(WindowEvent p_oEvent) {
            Frame oFrame = (Frame)p_oEvent.getWindow();
            oFrame.removeWindowListener(this);
            oFrame.requestFocus();
            oFrame.requestFocusInWindow();
            oFrame.setAlwaysOnTop(false);
        }

        public void componentResized(ComponentEvent p_oEvent) {
        }

        public void componentMoved(ComponentEvent p_oEvent) {
        }

        public void componentShown(ComponentEvent p_oEvent) {
            Frame oFrame = (Frame)p_oEvent.getComponent();
            oFrame.removeComponentListener(this);
            this.restoreWindow(oFrame);
        }

        public void componentHidden(ComponentEvent p_oEvent) {
        }

        void restoreWindow(Frame p_oFrame) {
            p_oFrame.addWindowListener(this);
            p_oFrame.setAlwaysOnTop(true);
            p_oFrame.setExtendedState(p_oFrame.getExtendedState() & 0xFFFFFFFE);
        }
    }
}

